/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.ontology.impl.test;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.ontology.AllValuesFromRestriction;
import com.hp.hpl.jena.ontology.AnnotationProperty;
import com.hp.hpl.jena.ontology.CardinalityRestriction;
import com.hp.hpl.jena.ontology.ComplementClass;
import com.hp.hpl.jena.ontology.DataRange;
import com.hp.hpl.jena.ontology.DatatypeProperty;
import com.hp.hpl.jena.ontology.EnumeratedClass;
import com.hp.hpl.jena.ontology.HasValueRestriction;
import com.hp.hpl.jena.ontology.Individual;
import com.hp.hpl.jena.ontology.IntersectionClass;
import com.hp.hpl.jena.ontology.InverseFunctionalProperty;
import com.hp.hpl.jena.ontology.MaxCardinalityRestriction;
import com.hp.hpl.jena.ontology.MinCardinalityRestriction;
import com.hp.hpl.jena.ontology.ObjectProperty;
import com.hp.hpl.jena.ontology.OntClass;
import com.hp.hpl.jena.ontology.OntDocumentManager;
import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.OntModelSpec;
import com.hp.hpl.jena.ontology.OntProperty;
import com.hp.hpl.jena.ontology.OntResource;
import com.hp.hpl.jena.ontology.Ontology;
import com.hp.hpl.jena.ontology.Restriction;
import com.hp.hpl.jena.ontology.SomeValuesFromRestriction;
import com.hp.hpl.jena.ontology.SymmetricProperty;
import com.hp.hpl.jena.ontology.TransitiveProperty;
import com.hp.hpl.jena.ontology.UnionClass;
import com.hp.hpl.jena.ontology.impl.OWLDLProfile;
import com.hp.hpl.jena.ontology.impl.OWLLiteProfile;
import com.hp.hpl.jena.ontology.impl.OWLProfile;
import com.hp.hpl.jena.ontology.impl.test.TestOntDocumentManager;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFList;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.test.ModelTestBase;
import com.hp.hpl.jena.reasoner.test.TestUtil;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.vocabulary.OWL;
import com.hp.hpl.jena.vocabulary.RDF;
import com.hp.hpl.jena.vocabulary.RDFS;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestOntModel
extends ModelTestBase {
    public static final String BASE = "http://www.hp.com/test";
    public static final String NS = "http://www.hp.com/test#";
    public static final String DOC = "<rdf:RDF   xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\"   xmlns:owl=\"http://www.w3.org/2002/07/owl#\"   xmlns:rdfs=\"http://www.w3.org/2000/01/rdf-schema#\">  <owl:Class rdf:about=\"http://www.hp.com/test#D\">    <rdfs:subClassOf>      <owl:Class rdf:about=\"http://www.hp.com/test#B\"/>    </rdfs:subClassOf>  </owl:Class>  <owl:Class rdf:about=\"http://www.hp.com/test#B\">    <rdfs:subClassOf rdf:resource=\"http://www.hp.com/test#A\"       rdf:type=\"http://www.w3.org/2002/07/owl#Class\"/>  </owl:Class>  <owl:Class rdf:about=\"http://www.hp.com/test#C\">    <rdfs:subClassOf rdf:resource=\"http://www.hp.com/test#B\"/>  </owl:Class>  <owl:ObjectProperty rdf:about=\"http://www.hp.com/test#p\">    <rdfs:domain rdf:resource=\"http://www.hp.com/test#A\"/>    <rdfs:range rdf:resource=\"http://www.hp.com/test#B\"/>    <rdfs:range rdf:resource=\"http://www.hp.com/test#C\"/>  </owl:ObjectProperty></rdf:RDF>";

    public TestOntModel(String name) {
        super(name);
    }

    public void setUp() {
        OntDocumentManager.getInstance().reset(true);
    }

    public void testWriteOutputStream() {
        OntModel m = ModelFactory.createOntologyModel();
        OntClass A = m.createClass("http://www.hp.com/test#A");
        OntClass B = m.createClass("http://www.hp.com/test#B");
        OntClass C = m.createClass("http://www.hp.com/test#C");
        OntClass D = m.createClass("http://www.hp.com/test#D");
        A.addSubClass((Resource)B);
        B.addSubClass((Resource)C);
        B.addSubClass((Resource)D);
        ObjectProperty p = m.createObjectProperty("http://www.hp.com/test#p");
        p.addDomain((Resource)A);
        p.addRange((Resource)B);
        p.addRange((Resource)C);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        m.write((OutputStream)out);
        String s = out.toString();
        ByteArrayInputStream in = new ByteArrayInputStream(s.getBytes());
        Model mIn1 = ModelFactory.createDefaultModel();
        mIn1.read((InputStream)in, BASE);
        Model mIn2 = ModelFactory.createDefaultModel();
        mIn2.read((InputStream)new ByteArrayInputStream(DOC.getBytes()), BASE);
        TestOntModel.assertTrue((String)"InputStream write/read cycle failed (1)", (boolean)mIn1.isIsomorphicWith(m.getBaseModel()));
        TestOntModel.assertTrue((String)"InputStream write/read cycle failed (2)", (boolean)mIn2.isIsomorphicWith(m.getBaseModel()));
    }

    public void testGetBaseModelPrefixes() {
        OntModel om = ModelFactory.createOntologyModel();
        om.setNsPrefix("bill", "http://bill.and.ben/flowerpot#");
        om.setNsPrefix("grue", "ftp://grue.and.bleen/2000#");
        TestOntModel.assertEquals((Object)om.getNsPrefixMap(), (Object)om.getBaseModel().getNsPrefixMap());
    }

    public void testWritesPrefixes() {
        OntModel om = ModelFactory.createOntologyModel();
        om.setNsPrefix("spoo", "http://spoo.spoo.com/spoo#");
        om.add(TestOntModel.statement((Model)om, "ping http://spoo.spoo.com/spoo#pang pilly"));
        om.add(TestOntModel.statement((Model)om, "gg " + OWL.getURI() + "hh ii"));
        StringWriter sw = new StringWriter();
        om.write((Writer)sw);
        String s = sw.getBuffer().toString();
        TestOntModel.assertTrue((s.indexOf("xmlns:spoo=\"http://spoo.spoo.com/spoo#\"") > 0 ? 1 : 0) != 0);
        TestOntModel.assertTrue((s.indexOf("xmlns:owl=\"" + OWL.getURI() + "\"") > 0 ? 1 : 0) != 0);
    }

    public void testWriteWriter() {
        OntModel m = ModelFactory.createOntologyModel();
        OntClass A = m.createClass("http://www.hp.com/test#A");
        OntClass B = m.createClass("http://www.hp.com/test#B");
        OntClass C = m.createClass("http://www.hp.com/test#C");
        OntClass D = m.createClass("http://www.hp.com/test#D");
        A.addSubClass((Resource)B);
        B.addSubClass((Resource)C);
        B.addSubClass((Resource)D);
        ObjectProperty p = m.createObjectProperty("http://www.hp.com/test#p");
        p.addDomain((Resource)A);
        p.addRange((Resource)B);
        p.addRange((Resource)C);
        StringWriter out = new StringWriter();
        m.write((Writer)out);
        String s = out.toString();
        Model mIn1 = ModelFactory.createDefaultModel();
        mIn1.read((Reader)new StringReader(s), BASE);
        Model mIn2 = ModelFactory.createDefaultModel();
        mIn2.read((Reader)new StringReader(DOC), BASE);
        TestOntModel.assertTrue((String)"Writer write/read cycle failed (1)", (boolean)mIn1.isIsomorphicWith(m.getBaseModel()));
        TestOntModel.assertTrue((String)"Writer write/read cycle failed (2)", (boolean)mIn2.isIsomorphicWith(m.getBaseModel()));
    }

    public void testGetOntology() {
        OntModel m = ModelFactory.createOntologyModel();
        Resource r = m.getResource("http://www.hp.com/test#r");
        m.add(r, RDF.type, (RDFNode)r);
        Ontology s = m.createOntology("http://www.hp.com/test#s");
        TestOntModel.assertEquals((String)"Result of get s", (Object)s, (Object)m.getOntology("http://www.hp.com/test#s"));
        TestOntModel.assertNull((String)"result of get q", (Object)m.getOntology("http://www.hp.com/test#q"));
        TestOntModel.assertNull((String)"result of get r", (Object)m.getOntology("http://www.hp.com/test#r"));
    }

    public void testGetIndividual() {
        OntModel m = ModelFactory.createOntologyModel();
        OntClass c = m.createClass("http://www.hp.com/test#c");
        Resource r = m.getResource("http://www.hp.com/test#r");
        m.add(r, RDF.type, (RDFNode)r);
        Individual s = m.createIndividual("http://www.hp.com/test#s", (Resource)c);
        TestOntModel.assertEquals((String)"Result of get s", (Object)s, (Object)m.getIndividual("http://www.hp.com/test#s"));
        TestOntModel.assertNull((String)"result of get q", (Object)m.getIndividual("http://www.hp.com/test#q"));
    }

    public void testCreateIndividual() {
        OntModel m = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_MEM);
        Individual i0 = m.createIndividual(OWL.Thing);
        Individual i1 = m.createIndividual(null);
        Individual i2 = m.createIndividual("http://www.hp.com/test#i2", OWL.Thing);
        Individual i3 = m.createIndividual("http://www.hp.com/test#i3", null);
        Individual i4 = m.createIndividual(null, OWL.Thing);
        Individual i5 = m.createIndividual(null, null);
        TestOntModel.assertNotNull((Object)i0);
        TestOntModel.assertNotNull((Object)i1);
        TestOntModel.assertNotNull((Object)i2);
        TestOntModel.assertNotNull((Object)i3);
        TestOntModel.assertNotNull((Object)i4);
        TestOntModel.assertNotNull((Object)i5);
    }

    public void testGetOntProperty() {
        OntModel m = ModelFactory.createOntologyModel();
        Resource r = m.getResource("http://www.hp.com/test#r");
        m.add(r, RDF.type, (RDFNode)r);
        OntProperty s = m.createOntProperty("http://www.hp.com/test#s");
        TestOntModel.assertEquals((String)"Result of get s", (Object)s, (Object)m.getOntProperty("http://www.hp.com/test#s"));
        TestOntModel.assertNull((String)"result of get q", (Object)m.getOntProperty("http://www.hp.com/test#q"));
        TestOntModel.assertNull((String)"result of get r", (Object)m.getOntProperty("http://www.hp.com/test#r"));
    }

    public void testGetObjectProperty() {
        OntModel m = ModelFactory.createOntologyModel();
        Resource r = m.getResource("http://www.hp.com/test#r");
        m.add(r, RDF.type, (RDFNode)r);
        ObjectProperty s = m.createObjectProperty("http://www.hp.com/test#s");
        TestOntModel.assertEquals((String)"Result of get s", (Object)s, (Object)m.getObjectProperty("http://www.hp.com/test#s"));
        TestOntModel.assertNull((String)"result of get q", (Object)m.getObjectProperty("http://www.hp.com/test#q"));
        TestOntModel.assertNull((String)"result of get r", (Object)m.getObjectProperty("http://www.hp.com/test#r"));
    }

    public void testGetTransitiveProperty() {
        OntModel m = ModelFactory.createOntologyModel();
        Resource r = m.getResource("http://www.hp.com/test#r");
        m.add(r, RDF.type, (RDFNode)r);
        TransitiveProperty s = m.createTransitiveProperty("http://www.hp.com/test#s");
        TestOntModel.assertEquals((String)"Result of get s", (Object)s, (Object)m.getTransitiveProperty("http://www.hp.com/test#s"));
        TestOntModel.assertNull((String)"result of get q", (Object)m.getTransitiveProperty("http://www.hp.com/test#q"));
        TestOntModel.assertNull((String)"result of get r", (Object)m.getTransitiveProperty("http://www.hp.com/test#r"));
    }

    public void testGetSymmetricProperty() {
        OntModel m = ModelFactory.createOntologyModel();
        Resource r = m.getResource("http://www.hp.com/test#r");
        m.add(r, RDF.type, (RDFNode)r);
        SymmetricProperty s = m.createSymmetricProperty("http://www.hp.com/test#s");
        TestOntModel.assertEquals((String)"Result of get s", (Object)s, (Object)m.getSymmetricProperty("http://www.hp.com/test#s"));
        TestOntModel.assertNull((String)"result of get q", (Object)m.getSymmetricProperty("http://www.hp.com/test#q"));
        TestOntModel.assertNull((String)"result of get r", (Object)m.getSymmetricProperty("http://www.hp.com/test#r"));
    }

    public void testGetInverseFunctionalProperty() {
        OntModel m = ModelFactory.createOntologyModel();
        Resource r = m.getResource("http://www.hp.com/test#r");
        m.add(r, RDF.type, (RDFNode)r);
        InverseFunctionalProperty s = m.createInverseFunctionalProperty("http://www.hp.com/test#s");
        TestOntModel.assertEquals((String)"Result of get s", (Object)s, (Object)m.getInverseFunctionalProperty("http://www.hp.com/test#s"));
        TestOntModel.assertNull((String)"result of get q", (Object)m.getInverseFunctionalProperty("http://www.hp.com/test#q"));
        TestOntModel.assertNull((String)"result of get r", (Object)m.getInverseFunctionalProperty("http://www.hp.com/test#r"));
    }

    public void testGetDatatypeProperty() {
        OntModel m = ModelFactory.createOntologyModel();
        Resource r = m.getResource("http://www.hp.com/test#r");
        m.add(r, RDF.type, (RDFNode)r);
        DatatypeProperty s = m.createDatatypeProperty("http://www.hp.com/test#s");
        TestOntModel.assertEquals((String)"Result of get s", (Object)s, (Object)m.getDatatypeProperty("http://www.hp.com/test#s"));
        TestOntModel.assertNull((String)"result of get q", (Object)m.getDatatypeProperty("http://www.hp.com/test#q"));
        TestOntModel.assertNull((String)"result of get r", (Object)m.getDatatypeProperty("http://www.hp.com/test#r"));
    }

    public void testGetAnnotationProperty() {
        OntModel m = ModelFactory.createOntologyModel();
        Resource r = m.getResource("http://www.hp.com/test#r");
        m.add(r, RDF.type, (RDFNode)r);
        AnnotationProperty s = m.createAnnotationProperty("http://www.hp.com/test#s");
        TestOntModel.assertEquals((String)"Result of get s", (Object)s, (Object)m.getAnnotationProperty("http://www.hp.com/test#s"));
        TestOntModel.assertNull((String)"result of get q", (Object)m.getAnnotationProperty("http://www.hp.com/test#q"));
        TestOntModel.assertNull((String)"result of get r", (Object)m.getAnnotationProperty("http://www.hp.com/test#r"));
    }

    public void testGetOntResource() {
        OntModel m = ModelFactory.createOntologyModel();
        OntResource r0 = m.getOntResource("http://www.hp.com/test#a");
        TestOntModel.assertNull((Object)r0);
        OntResource r1 = m.createOntResource("http://www.hp.com/test#aaa");
        TestOntModel.assertInstanceOf(OntResource.class, r1);
        Resource r2a = m.getResource("http://www.hp.com/test#a");
        Resource r2b = m.getResource("http://www.hp.com/test#b");
        Property p = m.getProperty("http://www.hp.com/test#p");
        m.add(r2a, p, (RDFNode)r2b);
        r0 = m.getOntResource("http://www.hp.com/test#a");
        TestOntModel.assertInstanceOf(OntResource.class, r0);
        OntResource r3 = m.getOntResource(r2b);
        TestOntModel.assertInstanceOf(OntResource.class, r3);
    }

    public void testGetOntClass() {
        OntModel m = ModelFactory.createOntologyModel();
        Resource r = m.getResource("http://www.hp.com/test#r");
        Resource r0 = m.getResource("http://www.hp.com/test#r0");
        m.add(r, RDF.type, (RDFNode)r0);
        OntClass s = m.createClass("http://www.hp.com/test#s");
        TestOntModel.assertEquals((String)"Result of get s", (Object)s, (Object)m.getOntClass("http://www.hp.com/test#s"));
        TestOntModel.assertNull((String)"result of get q", (Object)m.getOntClass("http://www.hp.com/test#q"));
        TestOntModel.assertNull((String)"result of get r", (Object)m.getOntClass("http://www.hp.com/test#r"));
    }

    public void testGetComplementClass() {
        OntModel m = ModelFactory.createOntologyModel();
        OntClass c = m.createClass("http://www.hp.com/test#c");
        Resource r = m.getResource("http://www.hp.com/test#r");
        m.add(r, RDF.type, (RDFNode)r);
        ComplementClass s = m.createComplementClass("http://www.hp.com/test#s", (Resource)c);
        TestOntModel.assertEquals((String)"Result of get s", (Object)s, (Object)m.getComplementClass("http://www.hp.com/test#s"));
        TestOntModel.assertNull((String)"result of get q", (Object)m.getComplementClass("http://www.hp.com/test#q"));
        TestOntModel.assertNull((String)"result of get r", (Object)m.getComplementClass("http://www.hp.com/test#r"));
    }

    public void testGetEnumeratedClass() {
        OntModel m = ModelFactory.createOntologyModel();
        RDFList l = m.createList();
        Resource r = m.getResource("http://www.hp.com/test#r");
        m.add(r, RDF.type, (RDFNode)r);
        EnumeratedClass s = m.createEnumeratedClass("http://www.hp.com/test#s", l);
        TestOntModel.assertEquals((String)"Result of get s", (Object)s, (Object)m.getEnumeratedClass("http://www.hp.com/test#s"));
        TestOntModel.assertNull((String)"result of get q", (Object)m.getEnumeratedClass("http://www.hp.com/test#q"));
        TestOntModel.assertNull((String)"result of get r", (Object)m.getEnumeratedClass("http://www.hp.com/test#r"));
    }

    public void testGetUnionClass() {
        OntModel m = ModelFactory.createOntologyModel();
        RDFList l = m.createList();
        Resource r = m.getResource("http://www.hp.com/test#r");
        m.add(r, RDF.type, (RDFNode)r);
        UnionClass s = m.createUnionClass("http://www.hp.com/test#s", l);
        TestOntModel.assertEquals((String)"Result of get s", (Object)s, (Object)m.getUnionClass("http://www.hp.com/test#s"));
        TestOntModel.assertNull((String)"result of get q", (Object)m.getUnionClass("http://www.hp.com/test#q"));
        TestOntModel.assertNull((String)"result of get r", (Object)m.getUnionClass("http://www.hp.com/test#r"));
    }

    public void testGetIntersectionClass() {
        OntModel m = ModelFactory.createOntologyModel();
        RDFList l = m.createList();
        Resource r = m.getResource("http://www.hp.com/test#r");
        m.add(r, RDF.type, (RDFNode)r);
        IntersectionClass s = m.createIntersectionClass("http://www.hp.com/test#s", l);
        TestOntModel.assertEquals((String)"Result of get s", (Object)s, (Object)m.getIntersectionClass("http://www.hp.com/test#s"));
        TestOntModel.assertNull((String)"result of get q", (Object)m.getIntersectionClass("http://www.hp.com/test#q"));
        TestOntModel.assertNull((String)"result of get r", (Object)m.getIntersectionClass("http://www.hp.com/test#r"));
    }

    public void testGetRestriction() {
        OntModel m = ModelFactory.createOntologyModel();
        Property p = m.createProperty("http://www.hp.com/test#p");
        Resource r = m.getResource("http://www.hp.com/test#r");
        m.add(r, RDF.type, (RDFNode)r);
        Restriction s = m.createRestriction("http://www.hp.com/test#s", p);
        TestOntModel.assertEquals((String)"Result of get s", (Object)s, (Object)m.getRestriction("http://www.hp.com/test#s"));
        TestOntModel.assertNull((String)"result of get q", (Object)m.getRestriction("http://www.hp.com/test#q"));
        TestOntModel.assertNull((String)"result of get r", (Object)m.getRestriction("http://www.hp.com/test#r"));
    }

    public void testGetHasValueRestriction() {
        OntModel m = ModelFactory.createOntologyModel();
        Property p = m.createProperty("http://www.hp.com/test#p");
        OntClass c = m.createClass("http://www.hp.com/test#c");
        Resource r = m.getResource("http://www.hp.com/test#r");
        m.add(r, RDF.type, (RDFNode)r);
        HasValueRestriction s = m.createHasValueRestriction("http://www.hp.com/test#s", p, (RDFNode)c);
        TestOntModel.assertEquals((String)"Result of get s", (Object)s, (Object)m.getHasValueRestriction("http://www.hp.com/test#s"));
        TestOntModel.assertNull((String)"result of get q", (Object)m.getHasValueRestriction("http://www.hp.com/test#q"));
        TestOntModel.assertNull((String)"result of get r", (Object)m.getHasValueRestriction("http://www.hp.com/test#r"));
    }

    public void testGetSomeValuesFromRestriction() {
        OntModel m = ModelFactory.createOntologyModel();
        Property p = m.createProperty("http://www.hp.com/test#p");
        OntClass c = m.createClass("http://www.hp.com/test#c");
        Resource r = m.getResource("http://www.hp.com/test#r");
        m.add(r, RDF.type, (RDFNode)r);
        SomeValuesFromRestriction s = m.createSomeValuesFromRestriction("http://www.hp.com/test#s", p, (Resource)c);
        TestOntModel.assertEquals((String)"Result of get s", (Object)s, (Object)m.getSomeValuesFromRestriction("http://www.hp.com/test#s"));
        TestOntModel.assertNull((String)"result of get q", (Object)m.getSomeValuesFromRestriction("http://www.hp.com/test#q"));
        TestOntModel.assertNull((String)"result of get r", (Object)m.getSomeValuesFromRestriction("http://www.hp.com/test#r"));
    }

    public void testGetAllValuesFromRestriction() {
        OntModel m = ModelFactory.createOntologyModel();
        Property p = m.createProperty("http://www.hp.com/test#p");
        OntClass c = m.createClass("http://www.hp.com/test#c");
        Resource r = m.getResource("http://www.hp.com/test#r");
        m.add(r, RDF.type, (RDFNode)r);
        AllValuesFromRestriction s = m.createAllValuesFromRestriction("http://www.hp.com/test#s", p, (Resource)c);
        TestOntModel.assertEquals((String)"Result of get s", (Object)s, (Object)m.getAllValuesFromRestriction("http://www.hp.com/test#s"));
        TestOntModel.assertNull((String)"result of get q", (Object)m.getAllValuesFromRestriction("http://www.hp.com/test#q"));
        TestOntModel.assertNull((String)"result of get r", (Object)m.getAllValuesFromRestriction("http://www.hp.com/test#r"));
    }

    public void testGetCardinalityRestriction() {
        OntModel m = ModelFactory.createOntologyModel();
        Property p = m.createProperty("http://www.hp.com/test#p");
        Resource r = m.getResource("http://www.hp.com/test#r");
        m.add(r, RDF.type, (RDFNode)r);
        CardinalityRestriction s = m.createCardinalityRestriction("http://www.hp.com/test#s", p, 1);
        TestOntModel.assertEquals((String)"Result of get s", (Object)s, (Object)m.getCardinalityRestriction("http://www.hp.com/test#s"));
        TestOntModel.assertNull((String)"result of get q", (Object)m.getCardinalityRestriction("http://www.hp.com/test#q"));
        TestOntModel.assertNull((String)"result of get r", (Object)m.getCardinalityRestriction("http://www.hp.com/test#r"));
    }

    public void testGetMinCardinalityRestriction() {
        OntModel m = ModelFactory.createOntologyModel();
        Property p = m.createProperty("http://www.hp.com/test#p");
        Resource r = m.getResource("http://www.hp.com/test#r");
        m.add(r, RDF.type, (RDFNode)r);
        MinCardinalityRestriction s = m.createMinCardinalityRestriction("http://www.hp.com/test#s", p, 1);
        TestOntModel.assertEquals((String)"Result of get s", (Object)s, (Object)m.getMinCardinalityRestriction("http://www.hp.com/test#s"));
        TestOntModel.assertNull((String)"result of get q", (Object)m.getMinCardinalityRestriction("http://www.hp.com/test#q"));
        TestOntModel.assertNull((String)"result of get r", (Object)m.getMinCardinalityRestriction("http://www.hp.com/test#r"));
    }

    public void testGetMaxCardinalityRestriction() {
        OntModel m = ModelFactory.createOntologyModel();
        Property p = m.createProperty("http://www.hp.com/test#p");
        Resource r = m.getResource("http://www.hp.com/test#r");
        m.add(r, RDF.type, (RDFNode)r);
        MaxCardinalityRestriction s = m.createMaxCardinalityRestriction("http://www.hp.com/test#s", p, 1);
        TestOntModel.assertEquals((String)"Result of get s", (Object)s, (Object)m.getMaxCardinalityRestriction("http://www.hp.com/test#s"));
        TestOntModel.assertNull((String)"result of get q", (Object)m.getMaxCardinalityRestriction("http://www.hp.com/test#q"));
        TestOntModel.assertNull((String)"result of get r", (Object)m.getMaxCardinalityRestriction("http://www.hp.com/test#r"));
    }

    public void testGetSubgraphs() {
        OntModel m = ModelFactory.createOntologyModel();
        m.read("file:testing/ontology/testImport6/a.owl");
        TestOntModel.assertEquals((String)"Marker count not correct", (int)4, (int)TestOntDocumentManager.countMarkers((Model)m));
        List subs = m.getSubGraphs();
        TestOntModel.assertEquals((String)"n subgraphs should be ", (int)3, (int)subs.size());
        boolean isGraph = true;
        for (Object x : subs) {
            if (x instanceof Graph) continue;
            isGraph = false;
        }
        TestOntModel.assertTrue((String)"All sub-graphs should be graphs", (boolean)isGraph);
    }

    public void testListImportURIs() {
        OntModel m = ModelFactory.createOntologyModel();
        m.read("file:testing/ontology/testImport6/a.owl");
        Set c = m.listImportedOntologyURIs();
        TestOntModel.assertEquals((String)"Should be two non-closed import URI's", (int)2, (int)c.size());
        TestOntModel.assertTrue((String)"b should be imported ", (boolean)c.contains("file:testing/ontology/testImport6/b.owl"));
        TestOntModel.assertFalse((String)"c should not be imported ", (boolean)c.contains("file:testing/ontology/testImport6/c.owl"));
        TestOntModel.assertTrue((String)"d should be imported ", (boolean)c.contains("file:testing/ontology/testImport6/d.owl"));
        c = m.listImportedOntologyURIs(true);
        TestOntModel.assertEquals((String)"Should be two non-closed import URI's", (int)3, (int)c.size());
        TestOntModel.assertTrue((String)"b should be imported ", (boolean)c.contains("file:testing/ontology/testImport6/b.owl"));
        TestOntModel.assertTrue((String)"c should be imported ", (boolean)c.contains("file:testing/ontology/testImport6/c.owl"));
        TestOntModel.assertTrue((String)"d should be imported ", (boolean)c.contains("file:testing/ontology/testImport6/d.owl"));
    }

    public void testListOntProperties0() {
        OntModel m = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_MEM);
        ObjectProperty op = m.createObjectProperty("http://www.hp.com/test#op");
        DatatypeProperty dp = m.createDatatypeProperty("http://www.hp.com/test#dp");
        AnnotationProperty ap = m.createAnnotationProperty("http://www.hp.com/test#ap");
        OntProperty ontp = m.createOntProperty("http://www.hp.com/test#ontp");
        Property rdfp = m.createProperty("http://www.hp.com/test#rdfp");
        rdfp.addProperty(RDF.type, (RDFNode)RDF.Property);
        TestOntModel.assertFalse((boolean)this.iteratorContains((Iterator<?>)m.listOntProperties(), op));
        TestOntModel.assertFalse((boolean)this.iteratorContains((Iterator<?>)m.listOntProperties(), dp));
        TestOntModel.assertFalse((boolean)this.iteratorContains((Iterator<?>)m.listOntProperties(), ap));
        TestOntModel.assertTrue((boolean)this.iteratorContains((Iterator<?>)m.listOntProperties(), ontp));
        TestOntModel.assertTrue((boolean)this.iteratorContains((Iterator<?>)m.listOntProperties(), rdfp));
    }

    public void testListOntProperties1() {
        OntModel m = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_MEM_MICRO_RULE_INF);
        ObjectProperty op = m.createObjectProperty("http://www.hp.com/test#op");
        DatatypeProperty dp = m.createDatatypeProperty("http://www.hp.com/test#dp");
        AnnotationProperty ap = m.createAnnotationProperty("http://www.hp.com/test#ap");
        OntProperty ontp = m.createOntProperty("http://www.hp.com/test#ontp");
        Property rdfp = m.createProperty("http://www.hp.com/test#rdfp");
        rdfp.addProperty(RDF.type, (RDFNode)RDF.Property);
        TestOntModel.assertTrue((boolean)this.iteratorContains((Iterator<?>)m.listOntProperties(), op));
        TestOntModel.assertTrue((boolean)this.iteratorContains((Iterator<?>)m.listOntProperties(), dp));
        TestOntModel.assertTrue((boolean)this.iteratorContains((Iterator<?>)m.listOntProperties(), ap));
        TestOntModel.assertTrue((boolean)this.iteratorContains((Iterator<?>)m.listOntProperties(), ontp));
        TestOntModel.assertTrue((boolean)this.iteratorContains((Iterator<?>)m.listOntProperties(), rdfp));
    }

    public void testListOntProperties2() {
        OntModelSpec owlDLReasoner = new OntModelSpec(OntModelSpec.OWL_DL_MEM);
        owlDLReasoner.setReasoner(OntModelSpec.OWL_MEM_MICRO_RULE_INF.getReasoner());
        OntModel m = ModelFactory.createOntologyModel((OntModelSpec)owlDLReasoner);
        ObjectProperty op = m.createObjectProperty("http://www.hp.com/test#op");
        DatatypeProperty dp = m.createDatatypeProperty("http://www.hp.com/test#dp");
        AnnotationProperty ap = m.createAnnotationProperty("http://www.hp.com/test#ap");
        OntProperty ontp = m.createOntProperty("http://www.hp.com/test#ontp");
        Property rdfp = m.createProperty("http://www.hp.com/test#rdfp");
        rdfp.addProperty(RDF.type, (RDFNode)RDF.Property);
        TestOntModel.assertTrue((boolean)this.iteratorContains((Iterator<?>)m.listOntProperties(), op));
        TestOntModel.assertTrue((boolean)this.iteratorContains((Iterator<?>)m.listOntProperties(), dp));
        TestOntModel.assertFalse((boolean)this.iteratorContains((Iterator<?>)m.listOntProperties(), ap));
        TestOntModel.assertTrue((boolean)this.iteratorContains((Iterator<?>)m.listOntProperties(), ontp));
        TestOntModel.assertTrue((boolean)this.iteratorContains((Iterator<?>)m.listOntProperties(), rdfp));
    }

    public void testListAllOntProperties0() {
        OntModel m = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_MEM);
        ObjectProperty op = m.createObjectProperty("http://www.hp.com/test#op");
        DatatypeProperty dp = m.createDatatypeProperty("http://www.hp.com/test#dp");
        AnnotationProperty ap = m.createAnnotationProperty("http://www.hp.com/test#ap");
        OntProperty ontp = m.createOntProperty("http://www.hp.com/test#ontp");
        Property rdfp = m.createProperty("http://www.hp.com/test#rdfp");
        rdfp.addProperty(RDF.type, (RDFNode)RDF.Property);
        TestOntModel.assertTrue((boolean)this.iteratorContains((Iterator<?>)m.listAllOntProperties(), op));
        TestOntModel.assertTrue((boolean)this.iteratorContains((Iterator<?>)m.listAllOntProperties(), dp));
        TestOntModel.assertTrue((boolean)this.iteratorContains((Iterator<?>)m.listAllOntProperties(), ap));
        TestOntModel.assertTrue((boolean)this.iteratorContains((Iterator<?>)m.listAllOntProperties(), ontp));
        TestOntModel.assertTrue((boolean)this.iteratorContains((Iterator<?>)m.listAllOntProperties(), rdfp));
    }

    public void testListObjectProperties0() {
        OntModel m = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_MEM);
        ObjectProperty op = m.createObjectProperty("http://www.hp.com/test#op");
        DatatypeProperty dp = m.createDatatypeProperty("http://www.hp.com/test#dp");
        AnnotationProperty ap = m.createAnnotationProperty("http://www.hp.com/test#ap");
        OntProperty ontp = m.createOntProperty("http://www.hp.com/test#ontp");
        Property rdfp = m.createProperty("http://www.hp.com/test#rdfp");
        rdfp.addProperty(RDF.type, (RDFNode)RDF.Property);
        TestOntModel.assertTrue((boolean)this.iteratorContains((Iterator<?>)m.listObjectProperties(), op));
        TestOntModel.assertFalse((boolean)this.iteratorContains((Iterator<?>)m.listObjectProperties(), dp));
        TestOntModel.assertFalse((boolean)this.iteratorContains((Iterator<?>)m.listObjectProperties(), ap));
        TestOntModel.assertFalse((boolean)this.iteratorContains((Iterator<?>)m.listObjectProperties(), ontp));
        TestOntModel.assertFalse((boolean)this.iteratorContains((Iterator<?>)m.listObjectProperties(), rdfp));
    }

    public void testListDatatypeProperties0() {
        OntModel m = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_MEM);
        ObjectProperty op = m.createObjectProperty("http://www.hp.com/test#op");
        DatatypeProperty dp = m.createDatatypeProperty("http://www.hp.com/test#dp");
        AnnotationProperty ap = m.createAnnotationProperty("http://www.hp.com/test#ap");
        OntProperty ontp = m.createOntProperty("http://www.hp.com/test#ontp");
        Property rdfp = m.createProperty("http://www.hp.com/test#rdfp");
        rdfp.addProperty(RDF.type, (RDFNode)RDF.Property);
        TestOntModel.assertFalse((boolean)this.iteratorContains((Iterator<?>)m.listDatatypeProperties(), op));
        TestOntModel.assertTrue((boolean)this.iteratorContains((Iterator<?>)m.listDatatypeProperties(), dp));
        TestOntModel.assertFalse((boolean)this.iteratorContains((Iterator<?>)m.listDatatypeProperties(), ap));
        TestOntModel.assertFalse((boolean)this.iteratorContains((Iterator<?>)m.listDatatypeProperties(), ontp));
        TestOntModel.assertFalse((boolean)this.iteratorContains((Iterator<?>)m.listDatatypeProperties(), rdfp));
    }

    public void testListAnnotationProperties0() {
        OntModel m = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_MEM);
        ObjectProperty op = m.createObjectProperty("http://www.hp.com/test#op");
        DatatypeProperty dp = m.createDatatypeProperty("http://www.hp.com/test#dp");
        AnnotationProperty ap = m.createAnnotationProperty("http://www.hp.com/test#ap");
        OntProperty ontp = m.createOntProperty("http://www.hp.com/test#ontp");
        Property rdfp = m.createProperty("http://www.hp.com/test#rdfp");
        rdfp.addProperty(RDF.type, (RDFNode)RDF.Property);
        TestOntModel.assertFalse((boolean)this.iteratorContains((Iterator<?>)m.listAnnotationProperties(), op));
        TestOntModel.assertFalse((boolean)this.iteratorContains((Iterator<?>)m.listAnnotationProperties(), dp));
        TestOntModel.assertTrue((boolean)this.iteratorContains((Iterator<?>)m.listAnnotationProperties(), ap));
        TestOntModel.assertFalse((boolean)this.iteratorContains((Iterator<?>)m.listAnnotationProperties(), ontp));
        TestOntModel.assertFalse((boolean)this.iteratorContains((Iterator<?>)m.listAnnotationProperties(), rdfp));
    }

    public void testListSubModels0() {
        OntModel m = ModelFactory.createOntologyModel();
        m.read("file:testing/ontology/testImport6/a.owl");
        TestOntModel.assertEquals((String)"Marker count not correct", (int)4, (int)TestOntDocumentManager.countMarkers((Model)m));
        ArrayList importModels = new ArrayList();
        ExtendedIterator j = m.listSubModels();
        while (j.hasNext()) {
            importModels.add(j.next());
        }
        TestOntModel.assertEquals((String)"n import models should be ", (int)3, (int)importModels.size());
        boolean isOntModel = true;
        int nImports = 0;
        for (Object x : importModels) {
            if (!(x instanceof OntModel)) {
                isOntModel = false;
                continue;
            }
            nImports += ((OntModel)x).countSubModels();
        }
        TestOntModel.assertTrue((String)"All import models should be OntModels", (boolean)isOntModel);
        TestOntModel.assertEquals((String)"Wrong number of sub-model imports", (int)0, (int)nImports);
    }

    public void testListSubModels1() {
        OntModel m = ModelFactory.createOntologyModel();
        m.read("file:testing/ontology/testImport6/a.owl");
        TestOntModel.assertEquals((String)"Marker count not correct", (int)4, (int)TestOntDocumentManager.countMarkers((Model)m));
        ArrayList importModels = new ArrayList();
        ExtendedIterator j = m.listSubModels(true);
        while (j.hasNext()) {
            importModels.add(j.next());
        }
        TestOntModel.assertEquals((String)"n import models should be ", (int)3, (int)importModels.size());
        boolean isOntModel = true;
        int nImports = 0;
        for (Object x : importModels) {
            if (!(x instanceof OntModel)) {
                isOntModel = false;
                continue;
            }
            nImports += ((OntModel)x).countSubModels();
        }
        TestOntModel.assertTrue((String)"All import models should be OntModels", (boolean)isOntModel);
        TestOntModel.assertEquals((String)"Wrong number of sub-model imports", (int)2, (int)nImports);
    }

    public void testGetImportedModel() {
        OntModel m = ModelFactory.createOntologyModel();
        m.read("file:testing/ontology/testImport6/a.owl");
        OntModel m0 = m.getImportedModel("file:testing/ontology/testImport6/b.owl");
        OntModel m1 = m.getImportedModel("file:testing/ontology/testImport6/c.owl");
        OntModel m2 = m.getImportedModel("file:testing/ontology/testImport6/d.owl");
        OntModel m3 = m.getImportedModel("file:testing/ontology/testImport6/b.owl").getImportedModel("file:testing/ontology/testImport6/c.owl");
        OntModel m4 = m.getImportedModel("file:testing/ontology/testImport6/a.owl");
        TestOntModel.assertNotNull((String)"Import model b should not be null", (Object)m0);
        TestOntModel.assertNotNull((String)"Import model c should not be null", (Object)m1);
        TestOntModel.assertNotNull((String)"Import model d should not be null", (Object)m2);
        TestOntModel.assertNotNull((String)"Import model b-c should not be null", (Object)m3);
        TestOntModel.assertNull((String)"Import model a should be null", (Object)m4);
    }

    public void testProfiles() {
        List<Class> notInDL = Arrays.asList(new Class[0]);
        List<Class> notInLite = Arrays.asList(DataRange.class, HasValueRestriction.class);
        Map<?, ?> fullProfileMap = new OWLProfileExt().getSupportsMap();
        Map<?, ?> dlProfileMap = new OWLDLProfileExt().getSupportsMap();
        Map<?, ?> liteProfileMap = new OWLLiteProfileExt().getSupportsMap();
        for (Map.Entry<?, ?> kv : fullProfileMap.entrySet()) {
            Class c = (Class)kv.getKey();
            TestOntModel.assertTrue((String)("Key in OWL DL profile: " + c.getName()), (dlProfileMap.containsKey(c) || notInDL.contains(c) ? 1 : 0) != 0);
            TestOntModel.assertTrue((String)("Key in OWL lite profile: " + c.getName()), (liteProfileMap.containsKey(c) || notInLite.contains(c) ? 1 : 0) != 0);
        }
    }

    public void testBulkAddWorks() {
        OntModel om1 = ModelFactory.createOntologyModel();
        OntModel om2 = ModelFactory.createOntologyModel();
        om1.add((Model)om2);
    }

    public void testRead() {
        String base0 = "http://example.com/test0";
        String ns0 = base0 + "#";
        String base1 = "http://example.com/test1";
        String ns1 = base1 + "#";
        OntModel m = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_MEM);
        m.getDocumentManager().reset();
        m.getDocumentManager().addAltEntry(base0, "file:testing/ontology/relativenames.rdf");
        m.read(base0, "RDF/XML");
        TestOntModel.assertNotNull((String)"Should be a class ns0:A", (Object)m.getOntClass(ns0 + "A"));
        TestOntModel.assertNull((String)"Should not be a class ns1:A", (Object)m.getOntClass(ns1 + "A"));
        m = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_MEM);
        m.getDocumentManager().reset();
        m.getDocumentManager().addAltEntry(base0, "file:testing/ontology/relativenames.rdf");
        m.read(base0, base1, "RDF/XML");
        TestOntModel.assertNull((String)"Should not be a class ns0:A", (Object)m.getOntClass(ns0 + "A"));
        TestOntModel.assertNotNull((String)"Should be a class ns1:A", (Object)m.getOntClass(ns1 + "A"));
    }

    public void testListDataRange() {
        String base = "http://jena.hpl.hp.com/test#";
        String doc = "<?xml version='1.0'?><!DOCTYPE owl [      <!ENTITY rdf  'http://www.w3.org/1999/02/22-rdf-syntax-ns#' >      <!ENTITY rdfs 'http://www.w3.org/2000/01/rdf-schema#' >      <!ENTITY xsd  'http://www.w3.org/2001/XMLSchema#' >      <!ENTITY owl  'http://www.w3.org/2002/07/owl#' >      <!ENTITY dc   'http://purl.org/dc/elements/1.1/' >      <!ENTITY base  'http://jena.hpl.hp.com/test' >    ]><rdf:RDF   xmlns:rdf='http://www.w3.org/1999/02/22-rdf-syntax-ns#'   xmlns:owl='http://www.w3.org/2002/07/owl#'>  <owl:DataRange>    <owl:oneOf>      <rdf:List>        <rdf:first rdf:datatype='&xsd;integer'>0</rdf:first>        <rdf:rest rdf:resource='&rdf;nil' />      </rdf:List>    </owl:oneOf>  </owl:DataRange></rdf:RDF>";
        OntModel m = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_MEM, null);
        m.read((Reader)new StringReader(doc), base);
        ExtendedIterator i = m.listDataRanges();
        TestOntModel.assertTrue((String)"Should be at least one DataRange", (boolean)i.hasNext());
        Object dr = i.next();
        TestOntModel.assertInstanceOf(DataRange.class, dr);
        TestOntModel.assertFalse((String)"Should no more DataRange", (boolean)i.hasNext());
    }

    public void testListHierarchyRoots0() {
        OntModel m = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_MEM);
        TestOntModel.assertFalse((boolean)m.listHierarchyRootClasses().hasNext());
        m = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.RDFS_MEM);
        TestOntModel.assertFalse((boolean)m.listHierarchyRootClasses().hasNext());
    }

    public void testListHierarchyRoots1() {
        String doc = "@prefix rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#>. @prefix rdfs: <http://www.w3.org/2000/01/rdf-schema#>. @prefix xsd: <http://www.w3.org/2001/XMLSchema#>. @prefix owl: <http://www.w3.org/2002/07/owl#>. @prefix : <http://www.hp.com/test#>. :A a owl:Class. ";
        OntModel m = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_MEM, null);
        m.read((Reader)new StringReader(doc), NS, "N3");
        OntClass a = m.getOntClass("http://www.hp.com/test#A");
        TestUtil.assertIteratorValues(this, m.listHierarchyRootClasses(), new Object[]{a});
    }

    public void testListHierarchyRoots2() {
        String doc = "@prefix rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#>. @prefix rdfs: <http://www.w3.org/2000/01/rdf-schema#>. @prefix xsd: <http://www.w3.org/2001/XMLSchema#>. @prefix owl: <http://www.w3.org/2002/07/owl#>. @prefix : <http://www.hp.com/test#>. :A a owl:Class. ";
        OntModel m = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_MEM_RULE_INF, null);
        m.read((Reader)new StringReader(doc), NS, "N3");
        OntClass a = m.getOntClass("http://www.hp.com/test#A");
        TestUtil.assertIteratorValues(this, m.listHierarchyRootClasses(), new Object[]{a});
    }

    public void testListHierarchyRoots3() {
        String doc = "@prefix rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#>. @prefix rdfs: <http://www.w3.org/2000/01/rdf-schema#>. @prefix xsd: <http://www.w3.org/2001/XMLSchema#>. @prefix owl: <http://www.w3.org/2002/07/owl#>. @prefix : <http://www.hp.com/test#>. :A a owl:Class. :B a owl:Class ; rdfs:subClassOf :A . ";
        OntModel m = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_MEM_MINI_RULE_INF, null);
        m.read((Reader)new StringReader(doc), NS, "N3");
        OntClass a = m.getOntClass("http://www.hp.com/test#A");
        TestUtil.assertIteratorValues(this, m.listHierarchyRootClasses(), new Object[]{a});
    }

    public void testListHierarchyRoots4() {
        String doc = "@prefix rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#>. @prefix rdfs: <http://www.w3.org/2000/01/rdf-schema#>. @prefix xsd: <http://www.w3.org/2001/XMLSchema#>. @prefix owl: <http://www.w3.org/2002/07/owl#>. @prefix : <http://www.hp.com/test#>. :A a rdfs:Class. :C a rdfs:Class. :B a rdfs:Class ; rdfs:subClassOf :A . ";
        OntModel m = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.RDFS_MEM_RDFS_INF, null);
        m.read((Reader)new StringReader(doc), NS, "N3");
        OntClass a = m.getOntClass("http://www.hp.com/test#A");
        OntClass c = m.getOntClass("http://www.hp.com/test#C");
        TestUtil.assertIteratorValues(this, m.listHierarchyRootClasses(), new Object[]{a, c});
    }

    public void testLoadImports0() {
        OntModel m = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_MEM);
        Resource a = m.getResource("file:testing/ontology/testImport3/a.owl");
        Resource b = m.getResource("file:testing/ontology/testImport3/b.owl");
        m.add(a, m.getProfile().IMPORTS(), (RDFNode)b);
        TestOntModel.assertEquals((String)"Marker count not correct", (int)0, (int)TestOntDocumentManager.countMarkers((Model)m));
        TestOntModel.assertFalse((String)"c should not be imported", (boolean)m.hasLoadedImport("file:testing/ontology/testImport3/c.owl"));
        TestOntModel.assertFalse((String)"b should not be imported", (boolean)m.hasLoadedImport("file:testing/ontology/testImport3/b.owl"));
        m.loadImports();
        TestOntModel.assertEquals((String)"Marker count not correct", (int)2, (int)TestOntDocumentManager.countMarkers((Model)m));
        TestOntModel.assertTrue((String)"c should be imported", (boolean)m.hasLoadedImport("file:testing/ontology/testImport3/c.owl"));
        TestOntModel.assertTrue((String)"b should be imported", (boolean)m.hasLoadedImport("file:testing/ontology/testImport3/b.owl"));
    }

    public void testLoadImports1() {
        OntModel m = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_MEM);
        Resource a = m.getResource("file:testing/ontology/testImport3/a.owl");
        Resource b = m.getResource("file:testing/ontology/testImport3/b.owl");
        m.setDynamicImports(true);
        m.add(a, m.getProfile().IMPORTS(), (RDFNode)b);
        TestOntModel.assertEquals((String)"Marker count not correct", (int)2, (int)TestOntDocumentManager.countMarkers((Model)m));
        TestOntModel.assertTrue((String)"c should be imported", (boolean)m.hasLoadedImport("file:testing/ontology/testImport3/c.owl"));
        TestOntModel.assertTrue((String)"b should be imported", (boolean)m.hasLoadedImport("file:testing/ontology/testImport3/b.owl"));
        m.loadImports();
        TestOntModel.assertEquals((String)"Marker count not correct", (int)2, (int)TestOntDocumentManager.countMarkers((Model)m));
        TestOntModel.assertTrue((String)"c should be imported", (boolean)m.hasLoadedImport("file:testing/ontology/testImport3/c.owl"));
        TestOntModel.assertTrue((String)"b should be imported", (boolean)m.hasLoadedImport("file:testing/ontology/testImport3/b.owl"));
    }

    public void testAddImports0() {
        OntModel base = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_MEM);
        base.createClass("http://www.hp.com/test#A");
        base.createClass("http://www.hp.com/test#B");
        OntModel m = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_MEM_MICRO_RULE_INF, (Model)base);
        OntClass a = m.getOntClass("http://www.hp.com/test#A");
        OntClass b = m.getOntClass("http://www.hp.com/test#B");
        TestOntModel.assertFalse((boolean)a.hasSubClass((Resource)b));
        OntModel imp = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_MEM);
        imp.add((Resource)b, RDFS.subClassOf, (RDFNode)a);
        m.addSubModel((Model)imp, true);
        TestOntModel.assertTrue((boolean)a.hasSubClass((Resource)b));
    }

    public void testAddImports1() {
        String ns = "http://jena.hpl.hp.com/2003/03/testont";
        OntModel base = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_MEM);
        OntDocumentManager odm = OntDocumentManager.getInstance();
        odm.addAltEntry(ns + "#a", "file:testing/ontology/testImport7/a.owl");
        OntModel m = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_MEM_MICRO_RULE_INF, (Model)base);
        Ontology oo = base.createOntology(ns);
        oo.addImport(base.createResource(ns + "#a"));
        Resource a = m.getResource(ns + "#A");
        Resource c = m.getResource(ns + "#C");
        TestOntModel.assertFalse((boolean)m.contains(c, RDFS.subClassOf, (RDFNode)a));
        m.getDocumentManager().loadImports(m);
        TestOntModel.assertTrue((boolean)m.contains(c, RDFS.subClassOf, (RDFNode)a));
    }

    public void xxtestGetDeductionsModel0() {
        OntModel m = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_MEM_MICRO_RULE_INF);
        OntClass a = m.createClass("http://www.hp.com/test#A");
        OntClass b = m.createClass("http://www.hp.com/test#B");
        OntClass c = m.createClass("http://www.hp.com/test#C");
        b.addSubClass((Resource)c);
        Model dm = m.getDeductionsModel();
        TestOntModel.assertTrue((boolean)dm.contains(OWL.Nothing, RDFS.subClassOf, (RDFNode)a));
        TestOntModel.assertTrue((boolean)dm.contains(OWL.Nothing, RDFS.subClassOf, (RDFNode)c));
        a.addSubClass((Resource)b);
        TestOntModel.assertTrue((boolean)a.hasSubClass((Resource)c));
        dm = m.getDeductionsModel();
        TestOntModel.assertFalse((boolean)dm.contains(OWL.Nothing, RDFS.subClassOf, (RDFNode)a));
        TestOntModel.assertTrue((boolean)dm.contains(OWL.Nothing, RDFS.subClassOf, (RDFNode)c));
    }

    private boolean iteratorContains(Iterator<?> i, Object x) {
        boolean found = false;
        while (i.hasNext()) {
            found = i.next().equals(x) || found;
        }
        return found;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class OWLLiteProfileExt
    extends OWLLiteProfile {
        protected OWLLiteProfileExt() {
        }

        public Map<?, ?> getSupportsMap() {
            return this.getCheckTable();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class OWLDLProfileExt
    extends OWLDLProfile {
        protected OWLDLProfileExt() {
        }

        public Map<?, ?> getSupportsMap() {
            return this.getCheckTable();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class OWLProfileExt
    extends OWLProfile {
        protected OWLProfileExt() {
        }

        public Map<?, ?> getSupportsMap() {
            return this.getCheckTable();
        }
    }
}

