/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.ontology.impl.test;

import com.hp.hpl.jena.ontology.Individual;
import com.hp.hpl.jena.ontology.OntClass;
import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.Profile;
import com.hp.hpl.jena.ontology.impl.test.OntTestBase;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import java.util.Iterator;
import junit.framework.TestSuite;

public class TestIndividual
extends OntTestBase {
    public static TestSuite suite() {
        return new TestIndividual("TestIndividual");
    }

    public TestIndividual(String name) {
        super(name);
    }

    public OntTestBase.OntTestCase[] getTests() {
        return new OntTestBase.OntTestCase[]{new OntTestBase.OntTestCase("Individual.sameAs", true, false, true, false){

            public void ontTest(OntModel m) throws Exception {
                Profile prof = m.getProfile();
                OntClass A = m.createClass("http://jena.hpl.hp.com/testing/ontology#A");
                Individual x = m.createIndividual((Resource)A);
                Individual y = m.createIndividual((Resource)A);
                Individual z = m.createIndividual((Resource)A);
                x.addSameAs((Resource)y);
                1.assertEquals((String)"Cardinality should be 1", (int)1, (int)x.getCardinality(prof.SAME_AS()));
                1.assertEquals((String)"x should be the same as y", (Object)y, (Object)x.getSameAs());
                1.assertTrue((String)"x should be the same as y", (boolean)x.isSameAs((Resource)y));
                x.addSameAs((Resource)z);
                1.assertEquals((String)"Cardinality should be 2", (int)2, (int)x.getCardinality(prof.SAME_AS()));
                this.iteratorTest((Iterator<?>)x.listSameAs(), new Object[]{z, y});
                x.setSameAs((Resource)z);
                1.assertEquals((String)"Cardinality should be 1", (int)1, (int)x.getCardinality(prof.SAME_AS()));
                1.assertEquals((String)"x should be same indiv. as z", (Object)z, (Object)x.getSameAs());
                x.removeSameAs((Resource)y);
                1.assertEquals((String)"Cardinality should be 1", (int)1, (int)x.getCardinality(prof.SAME_AS()));
                x.removeSameAs((Resource)z);
                1.assertEquals((String)"Cardinality should be 0", (int)0, (int)x.getCardinality(prof.SAME_AS()));
            }
        }, new OntTestBase.OntTestCase("Individual.hasOntClass", true, true, true, true){

            protected void ontTest(OntModel m) throws Exception {
                OntClass A = m.createClass("http://jena.hpl.hp.com/testing/ontology#A");
                OntClass B = m.createClass("http://jena.hpl.hp.com/testing/ontology#B");
                Individual x = m.createIndividual((Resource)A);
                2.assertTrue((boolean)x.hasOntClass((Resource)A));
                2.assertFalse((boolean)x.hasOntClass((Resource)B));
            }
        }, new OntTestBase.OntTestCase("Individual.hasOntClass direct", true, true, true, true){

            protected void ontTest(OntModel m) throws Exception {
                OntClass A = m.createClass("http://jena.hpl.hp.com/testing/ontology#A");
                OntClass B = m.createClass("http://jena.hpl.hp.com/testing/ontology#B");
                A.addSubClass((Resource)B);
                Individual x = m.createIndividual((Resource)A);
                x.addRDFType((Resource)B);
                3.assertTrue((boolean)x.hasOntClass((Resource)A, false));
                3.assertTrue((boolean)x.hasOntClass((Resource)B, false));
                3.assertTrue((boolean)x.hasOntClass((Resource)A, false));
                3.assertTrue((boolean)x.hasOntClass((Resource)B, true));
            }
        }, new OntTestBase.OntTestCase("Individual.hasOntClass string", true, true, true, true){

            protected void ontTest(OntModel m) throws Exception {
                OntClass A = m.createClass("http://jena.hpl.hp.com/testing/ontology#A");
                Individual x = m.createIndividual((Resource)A);
                4.assertTrue((boolean)x.hasOntClass("http://jena.hpl.hp.com/testing/ontology#A"));
            }
        }, new OntTestBase.OntTestCase("Individual.getOntClass", true, true, true, true){

            protected void ontTest(OntModel m) throws Exception {
                OntClass A = m.createClass("http://jena.hpl.hp.com/testing/ontology#A");
                Individual x = m.createIndividual((Resource)A);
                5.assertEquals((Object)A, (Object)x.getOntClass());
            }
        }, new OntTestBase.OntTestCase("Individual.getOntClass direct", true, true, true, true){

            protected void ontTest(OntModel m) throws Exception {
                OntClass A = m.createClass("http://jena.hpl.hp.com/testing/ontology#A");
                OntClass B = m.createClass("http://jena.hpl.hp.com/testing/ontology#B");
                A.addSubClass((Resource)B);
                Individual x = m.createIndividual((Resource)A);
                x.addRDFType((Resource)B);
                6.assertEquals((Object)B, (Object)x.getOntClass(true));
            }
        }, new OntTestBase.OntTestCase("Individual.listOntClasses", true, true, true, true){

            protected void ontTest(OntModel m) throws Exception {
                OntClass A = m.createClass("http://jena.hpl.hp.com/testing/ontology#A");
                OntClass B = m.createClass("http://jena.hpl.hp.com/testing/ontology#B");
                A.addSubClass((Resource)B);
                Individual x = m.createIndividual((Resource)A);
                x.addRDFType((Resource)B);
                this.iteratorTest((Iterator<?>)x.listOntClasses(false), new Object[]{A, B});
                ExtendedIterator i = x.listOntClasses(false);
                while (i.hasNext()) {
                    7.assertNotNull(i.next());
                }
            }
        }, new OntTestBase.OntTestCase("Individual.listOntClasses direct", true, true, true, true){

            protected void ontTest(OntModel m) throws Exception {
                OntClass A = m.createClass("http://jena.hpl.hp.com/testing/ontology#A");
                OntClass B = m.createClass("http://jena.hpl.hp.com/testing/ontology#B");
                A.addSubClass((Resource)B);
                Individual x = m.createIndividual((Resource)A);
                x.addRDFType((Resource)B);
                this.iteratorTest((Iterator<?>)x.listOntClasses(true), new Object[]{B});
                ExtendedIterator i = x.listOntClasses(true);
                while (i.hasNext()) {
                    8.assertNotNull(i.next());
                }
            }
        }, new OntTestBase.OntTestCase("Individual.addOntClass", true, true, true, true){

            protected void ontTest(OntModel m) throws Exception {
                OntClass A = m.createClass("http://jena.hpl.hp.com/testing/ontology#A");
                OntClass B = m.createClass("http://jena.hpl.hp.com/testing/ontology#B");
                A.addSubClass((Resource)B);
                Individual x = m.createIndividual((Resource)A);
                this.iteratorTest((Iterator<?>)x.listOntClasses(false), new Object[]{A});
                x.addOntClass((Resource)B);
                this.iteratorTest((Iterator<?>)x.listOntClasses(false), new Object[]{A, B});
                ExtendedIterator i = x.listOntClasses(false);
                while (i.hasNext()) {
                    9.assertNotNull(i.next());
                }
            }
        }, new OntTestBase.OntTestCase("Individual.setOntClass", true, true, true, true){

            protected void ontTest(OntModel m) throws Exception {
                OntClass A = m.createClass("http://jena.hpl.hp.com/testing/ontology#A");
                OntClass B = m.createClass("http://jena.hpl.hp.com/testing/ontology#B");
                A.addSubClass((Resource)B);
                Individual x = m.createIndividual((Resource)A);
                this.iteratorTest((Iterator<?>)x.listOntClasses(false), new Object[]{A});
                x.setOntClass((Resource)B);
                this.iteratorTest((Iterator<?>)x.listOntClasses(false), new Object[]{B});
                ExtendedIterator i = x.listOntClasses(false);
                while (i.hasNext()) {
                    10.assertNotNull(i.next());
                }
            }
        }, new OntTestBase.OntTestCase("Individual.removeOntClass", true, true, true, true){

            protected void ontTest(OntModel m) throws Exception {
                OntClass A = m.createClass("http://jena.hpl.hp.com/testing/ontology#A");
                OntClass B = m.createClass("http://jena.hpl.hp.com/testing/ontology#B");
                Individual x = m.createIndividual((Resource)A);
                x.addOntClass((Resource)B);
                this.iteratorTest((Iterator<?>)x.listOntClasses(false), new Object[]{A, B});
                x.removeOntClass((Resource)A);
                this.iteratorTest((Iterator<?>)x.listOntClasses(false), new Object[]{B});
                x.removeOntClass((Resource)A);
                this.iteratorTest((Iterator<?>)x.listOntClasses(false), new Object[]{B});
                x.removeOntClass((Resource)B);
                this.iteratorTest((Iterator<?>)x.listOntClasses(false), new Object[0]);
            }
        }};
    }
}

