/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.mem.test;

import com.hp.hpl.jena.mem.HashCommon;
import com.hp.hpl.jena.rdf.model.test.ModelTestBase;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestHashCommon
extends ModelTestBase {
    protected static final Item item2X = new Item(2, "X");
    protected static final Item item1Y = new Item(1, "Y");
    protected static final Item item2Z = new Item(2, "Z");

    public TestHashCommon(String name) {
        super(name);
    }

    public void testSanityCheckTestDataConstruction() {
        ProbeHashCommon h = this.probeWith("1:2:x 4:7:y -1:5:z");
        TestHashCommon.assertEquals((Object)new Item(2, "x"), (Object)h.getItemForTestingAt(1));
        TestHashCommon.assertEquals((Object)new Item(7, "y"), (Object)h.getItemForTestingAt(4));
        TestHashCommon.assertEquals((Object)new Item(5, "z"), (Object)h.getItemForTestingAt(h.top()));
    }

    public void testHashcodeUsedAsIndex() {
        ProbeHashCommon htb = new ProbeHashCommon(10);
        int limit = htb.capacity();
        for (int i = 0; i < limit; ++i) {
            Item t = new Item(i, "s p o");
        }
    }

    public void testRemoveNoMove() {
        ProbeHashCommon h = this.probeWith("1:1:Y 2:2:Z");
        Item moved = (Item)h.removeFrom(2);
        TestHashCommon.assertSame(null, (Object)moved);
        this.assertAlike(this.probeWith("1:1:Y"), h);
    }

    public void testRemoveSimpleMove() {
        ProbeHashCommon h = this.probeWith("0:2:X 1:1:Y 2:2:Z");
        TestHashCommon.assertSame(null, (Object)h.removeFrom(1));
        this.assertAlike(this.probeWith("1:2:X 2:2:Z"), h);
    }

    public void testRemoveCircularMove() {
        ProbeHashCommon h = this.probeWith("0:0:X 1:2:Y -1:2:Z");
        Item moved = (Item)h.removeFrom(1);
        this.assertAlike(this.probeWith("0:0:X 1:2:Z"), h);
        TestHashCommon.assertEquals((Object)new Item(2, "Z"), (Object)moved);
    }

    public void testKeyIterator() {
        ProbeHashCommon h = this.probeWith("0:0:X");
        Set elements = h.keyIterator().toSet();
        TestHashCommon.assertEquals(this.itemSet("0:X"), (Object)elements);
    }

    private void assertAlike(ProbeHashCommon desired, ProbeHashCommon got) {
        TestHashCommon.assertEquals((String)"capacities must be equal", (int)desired.capacity(), (int)got.capacity());
        for (int i = 0; i < desired.capacity(); ++i) {
            TestHashCommon.assertEquals((Object)desired.getItemForTestingAt(i), (Object)got.getItemForTestingAt(i));
        }
    }

    protected ProbeHashCommon probeWith(String items) {
        ProbeHashCommon result = new ProbeHashCommon(10);
        StringTokenizer st = new StringTokenizer(items);
        while (st.hasMoreTokens()) {
            String item = st.nextToken();
            StringTokenizer itemElements = new StringTokenizer(item, ":");
            int index = Integer.parseInt(itemElements.nextToken());
            int hash = Integer.parseInt(itemElements.nextToken());
            String w = itemElements.nextToken();
            result.set(index < 0 ? index + result.capacity() : index, new Item(hash, w));
        }
        return result;
    }

    protected Set<Item> itemSet(String items) {
        HashSet<Item> result = new HashSet<Item>();
        StringTokenizer st = new StringTokenizer(items);
        while (st.hasMoreTokens()) {
            this.addItem(result, st.nextToken());
        }
        return result;
    }

    private void addItem(Set<Item> result, String item) {
        StringTokenizer itemElements = new StringTokenizer(item, ":");
        int hash = Integer.parseInt(itemElements.nextToken());
        String w = itemElements.nextToken();
        result.add(new Item(hash, w));
    }

    static class Item {
        protected final int n;
        protected final String s;

        public Item(int n, String s) {
            this.n = n;
            this.s = s;
        }

        public int hashCode() {
            return this.n;
        }

        public boolean equals(Object other) {
            return other instanceof Item && this.s.equals(((Item)other).s);
        }

        public String toString() {
            return this.s + "#" + this.n;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ProbeHashCommon
    extends HashCommon<Object> {
        protected ProbeHashCommon(int initialCapacity) {
            super(initialCapacity);
        }

        protected void set(int index, Item object) {
            this.keys[index] = object;
        }

        public Object removeFrom(int here) {
            return super.removeFrom(here);
        }

        public int top() {
            return this.capacity - 1;
        }

        public int capacity() {
            return this.capacity;
        }

        protected int improveHashCode(int hashCode) {
            return hashCode;
        }

        protected Object[] newKeyArray(int size) {
            return new Object[size];
        }
    }
}

