/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.graph.test;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.impl.LiteralLabel;
import com.hp.hpl.jena.graph.test.GraphTestBase;
import com.hp.hpl.jena.graph.test.NodeCreateUtils;
import com.hp.hpl.jena.rdf.model.AnonId;
import com.hp.hpl.jena.shared.PrefixMapping;
import junit.framework.TestSuite;

public class TestTriple
extends GraphTestBase {
    private static final String U = "http://some.domain.name/magic/spells.incant";
    private static final String N = "Alice";
    private static final LiteralLabel L = new LiteralLabel("ashes are burning", "en", false);

    public TestTriple(String name) {
        super(name);
    }

    public static TestSuite suite() {
        return new TestSuite(TestTriple.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testTripleEquals() {
        try {
            Node.cache((boolean)false);
            AnonId id = AnonId.create();
            LiteralLabel L2 = new LiteralLabel(id.toString(), "", false);
            String U2 = id.toString();
            String N2 = id.toString();
            Node[] nodes = new Node[]{Node.ANY, Node.createAnon((AnonId)id), Node.createAnon(), Node.createLiteral((LiteralLabel)L), Node.createLiteral((LiteralLabel)L2), Node.createURI((String)U), Node.createURI((String)U2), Node.createVariable((String)N), Node.createVariable((String)N2)};
            Triple[] triples = new Triple[nodes.length * nodes.length * nodes.length];
            for (int i = 0; i < nodes.length; ++i) {
                for (int j = 0; j < nodes.length; ++j) {
                    for (int k = 0; k < nodes.length; ++k) {
                        triples[i * nodes.length * nodes.length + j * nodes.length + k] = new Triple(nodes[i], nodes[j], nodes[k]);
                    }
                }
            }
            boolean[][] expected = new boolean[triples.length][triples.length];
            for (int i1 = 0; i1 < nodes.length; ++i1) {
                for (int j1 = 0; j1 < nodes.length; ++j1) {
                    for (int k1 = 0; k1 < nodes.length; ++k1) {
                        for (int i2 = 0; i2 < nodes.length; ++i2) {
                            for (int j2 = 0; j2 < nodes.length; ++j2) {
                                for (int k2 = 0; k2 < nodes.length; ++k2) {
                                    expected[i1 * nodes.length * nodes.length + j1 * nodes.length + k1][i2 * nodes.length * nodes.length + j2 * nodes.length + k2] = nodes[i1].equals((Object)nodes[i2]) && nodes[j1].equals((Object)nodes[j2]) && nodes[k1].equals((Object)nodes[k2]);
                                }
                            }
                        }
                    }
                }
            }
            TestTriple.assertEquals((String)"triple, null", (boolean)triples[0].equals(null), (boolean)false);
            TestTriple.assertDiffer("triple, string", triples[0], "string");
            for (int i = 0; i < triples.length; ++i) {
                for (int j = 0; j < triples.length; ++j) {
                    if (expected[i][j]) {
                        TestTriple.assertEquals((String)("triples " + i + ", " + j), (Object)triples[i], (Object)triples[j]);
                        continue;
                    }
                    TestTriple.assertDiffer("triples" + i + ", " + j, triples[i], triples[j]);
                }
            }
        }
        finally {
            Node.cache((boolean)true);
        }
    }

    public void testTripleCreate() {
        Node S = NodeCreateUtils.create("s");
        Node P = NodeCreateUtils.create("p");
        Node O = NodeCreateUtils.create("o");
        TestTriple.assertEquals((Object)new Triple(S, P, O), (Object)Triple.create((Node)S, (Node)P, (Node)O));
    }

    public void testTripleCreateFromString() {
        Node S = NodeCreateUtils.create("a");
        Node P = NodeCreateUtils.create("_P");
        Node O = NodeCreateUtils.create("?c");
        TestTriple.assertEquals((Object)new Triple(S, P, O), (Object)Triple.create((String)"a _P ?c"));
    }

    public void testTriplePrefixes() {
        Node S = NodeCreateUtils.create("rdf:alpha");
        Node P = NodeCreateUtils.create("dc:creator");
        Node O = NodeCreateUtils.create("spoo:notmapped");
        Triple t = Triple.create((String)"rdf:alpha dc:creator spoo:notmapped");
        TestTriple.assertEquals((Object)new Triple(S, P, O), (Object)t);
    }

    public void testTripleCreationMapped() {
        PrefixMapping pm = PrefixMapping.Factory.create().setNsPrefix("a", "ftp://foo/").setNsPrefix("b", "http://spoo/");
        Triple wanted = Triple.create((String)"ftp://foo/x http://spoo/y c:z");
        Triple got = Triple.create((PrefixMapping)pm, (String)"a:x b:y c:z");
        TestTriple.assertEquals((Object)wanted, (Object)got);
    }

    public void testPlainTripleMatches() {
        this.testMatches("S P O");
        this.testMatches("_S _P _O");
        this.testMatches("1 2 3");
    }

    public void testAnyTripleMatches() {
        this.testMatches("?? P O", "Z P O");
        this.testMatches("S ?? O", "S Q O");
        this.testMatches("S P ??", "S P oh");
        this.testMatches("?? ?? ??", "X Y Z");
        this.testMatches("?? ?? ??", "X Y 1");
        this.testMatches("?? ?? ??", "_X Y Z");
        this.testMatches("?? ?? ??", "X _Y Z");
    }

    private void testMatches(String triple) {
        this.testMatches(triple, triple);
    }

    private void testMatches(String pattern, String triple) {
        TestTriple.assertTrue((boolean)Triple.create((String)pattern).matches(Triple.create((String)triple)));
    }

    public void testPlainTripleDoesntMatch() {
        this.testMatchFails("S P O", "Z P O");
        this.testMatchFails("S P O", "S Q O");
        this.testMatchFails("S P O", "S P oh");
    }

    public void testAnyTripleDoesntMatch() {
        this.testMatchFails("?? P O", "S P oh");
        this.testMatchFails("S ?? O", "Z R O");
        this.testMatchFails("S P ??", "Z P oh");
    }

    public void testMatchFails(String pattern, String triple) {
        TestTriple.assertFalse((boolean)Triple.create((String)pattern).matches(Triple.create((String)triple)));
    }

    public void testMatchesNodes() {
        TestTriple.assertTrue((boolean)Triple.create((String)"S P O").matches(TestTriple.node("S"), TestTriple.node("P"), TestTriple.node("O")));
        TestTriple.assertTrue((boolean)Triple.create((String)"?? P O").matches(TestTriple.node("Z"), TestTriple.node("P"), TestTriple.node("O")));
        TestTriple.assertTrue((boolean)Triple.create((String)"S ?? O").matches(TestTriple.node("S"), TestTriple.node("Q"), TestTriple.node("O")));
        TestTriple.assertTrue((boolean)Triple.create((String)"S P ??").matches(TestTriple.node("S"), TestTriple.node("P"), TestTriple.node("I")));
        TestTriple.assertFalse((boolean)Triple.create((String)"S P O").matches(TestTriple.node("Z"), TestTriple.node("P"), TestTriple.node("O")));
        TestTriple.assertFalse((boolean)Triple.create((String)"S P O").matches(TestTriple.node("S"), TestTriple.node("Q"), TestTriple.node("O")));
        TestTriple.assertFalse((boolean)Triple.create((String)"S P O").matches(TestTriple.node("Z"), TestTriple.node("P"), TestTriple.node("I")));
    }

    public void testElementMatches() {
        TestTriple.assertTrue((boolean)Triple.create((String)"S P O").subjectMatches(TestTriple.node("S")));
        TestTriple.assertTrue((boolean)Triple.create((String)"S P O").predicateMatches(TestTriple.node("P")));
        TestTriple.assertTrue((boolean)Triple.create((String)"S P O").objectMatches(TestTriple.node("O")));
        TestTriple.assertFalse((boolean)Triple.create((String)"S P O").subjectMatches(TestTriple.node("Z")));
        TestTriple.assertFalse((boolean)Triple.create((String)"S P O").predicateMatches(TestTriple.node("Q")));
        TestTriple.assertFalse((boolean)Triple.create((String)"S P O").objectMatches(TestTriple.node("I")));
        TestTriple.assertTrue((boolean)Triple.create((String)"?? P O").subjectMatches(TestTriple.node("SUB")));
        TestTriple.assertTrue((boolean)Triple.create((String)"S ?? O").predicateMatches(TestTriple.node("PRED")));
        TestTriple.assertTrue((boolean)Triple.create((String)"S P ??").objectMatches(TestTriple.node("OBJ")));
    }

    public void testConcrete() {
        TestTriple.assertTrue((boolean)Triple.create((String)"S P O").isConcrete());
        TestTriple.assertTrue((boolean)Triple.create((String)"S P 11").isConcrete());
        TestTriple.assertTrue((boolean)Triple.create((String)"S P _X").isConcrete());
        TestTriple.assertTrue((boolean)Triple.create((String)"S _P 11").isConcrete());
        TestTriple.assertTrue((boolean)Triple.create((String)"_S _P _O").isConcrete());
        TestTriple.assertTrue((boolean)Triple.create((String)"10 11 12").isConcrete());
        TestTriple.assertTrue((boolean)Triple.create((String)"S P 11").isConcrete());
        TestTriple.assertFalse((boolean)Triple.create((String)"?? P 11").isConcrete());
        TestTriple.assertFalse((boolean)Triple.create((String)"S ?? 11").isConcrete());
        TestTriple.assertFalse((boolean)Triple.create((String)"S P ??").isConcrete());
        TestTriple.assertFalse((boolean)Triple.create((String)"?S P 11").isConcrete());
        TestTriple.assertFalse((boolean)Triple.create((String)"S ?P 11").isConcrete());
        TestTriple.assertFalse((boolean)Triple.create((String)"S P ?O").isConcrete());
    }

    public void testTripleToStringOrdering() {
        Triple t1 = Triple.create((String)"subject predicate object");
        TestTriple.assertTrue((String)"subject must be present", (t1.toString().indexOf("subject") >= 0 ? 1 : 0) != 0);
        TestTriple.assertTrue((String)"subject must preceed predicate", (t1.toString().indexOf("subject") < t1.toString().indexOf("predicate") ? 1 : 0) != 0);
        TestTriple.assertTrue((String)"predicate must preceed object", (t1.toString().indexOf("predicate") < t1.toString().indexOf("object") ? 1 : 0) != 0);
    }

    public void testTripleToStringQuoting() {
        Triple t1 = Triple.create((String)"subject predicate 'object'");
        TestTriple.assertTrue((t1.toString().indexOf("\"object\"") > 0 ? 1 : 0) != 0);
    }

    public void testTripleToStringWithPrefixing() {
        PrefixMapping pm = PrefixMapping.Factory.create();
        pm.setNsPrefix("spoo", "eg://domain.dom/spoo#");
        Triple t1 = Triple.create((String)"eg://domain.dom/spoo#a b c");
        TestTriple.assertEquals((String)"spoo:a @eh:/b eh:/c", (String)t1.toString(pm));
    }

    public void testTripleMaps() {
        TestTriple.assertEquals((Object)TestTriple.node("x"), (Object)Triple.getSubject.map1((Object)Triple.create((String)"x P z")));
        TestTriple.assertEquals((Object)TestTriple.node("P"), (Object)Triple.getPredicate.map1((Object)Triple.create((String)"x P z")));
        TestTriple.assertEquals((Object)TestTriple.node("z"), (Object)Triple.getObject.map1((Object)Triple.create((String)"x P z")));
    }
}

