/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.graph.test;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.test.GraphTestBase;
import com.hp.hpl.jena.mem.NodeToTriplesMap;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import java.util.HashSet;
import java.util.Set;
import junit.framework.TestSuite;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestNodeToTriplesMap
extends GraphTestBase {
    protected NodeToTriplesMap ntS = new NodeToTriplesMap(Triple.Field.fieldSubject, Triple.Field.fieldPredicate, Triple.Field.fieldObject);
    protected NodeToTriplesMap ntP = new NodeToTriplesMap(Triple.Field.fieldPredicate, Triple.Field.fieldObject, Triple.Field.fieldSubject);
    protected NodeToTriplesMap ntO = new NodeToTriplesMap(Triple.Field.fieldObject, Triple.Field.fieldPredicate, Triple.Field.fieldSubject);
    protected static final Node x = TestNodeToTriplesMap.node("x");
    protected static final Node y = TestNodeToTriplesMap.node("y");

    public TestNodeToTriplesMap(String name) {
        super(name);
    }

    public static TestSuite suite() {
        return new TestSuite(TestNodeToTriplesMap.class);
    }

    public void testZeroSize() {
        this.testZeroSize("fresh NTM", this.ntS);
    }

    protected void testZeroSize(String title, NodeToTriplesMap nt) {
        TestNodeToTriplesMap.assertEquals((String)(title + " should have size 0"), (int)0, (int)nt.size());
        TestNodeToTriplesMap.assertEquals((String)(title + " should be isEmpty()"), (boolean)true, (boolean)nt.isEmpty());
        TestNodeToTriplesMap.assertEquals((String)(title + " should have empty domain"), (boolean)false, (boolean)nt.domain().hasNext());
    }

    public void testAddOne() {
        this.ntS.add(TestNodeToTriplesMap.triple("x P y"));
        this.testJustOne(x, this.ntS);
    }

    public void testAddOneTwice() {
        this.addTriples(this.ntS, "x P y; x P y");
        this.testJustOne(x, this.ntS);
    }

    protected void testJustOne(Node x, NodeToTriplesMap nt) {
        TestNodeToTriplesMap.assertEquals((int)1, (int)nt.size());
        TestNodeToTriplesMap.assertEquals((boolean)false, (boolean)nt.isEmpty());
        TestNodeToTriplesMap.assertEquals(TestNodeToTriplesMap.just(x), TestNodeToTriplesMap.iteratorToSet(nt.domain()));
    }

    public void testAddTwoUnshared() {
        this.addTriples(this.ntS, "x P a; y Q b");
        TestNodeToTriplesMap.assertEquals((int)2, (int)this.ntS.size());
        TestNodeToTriplesMap.assertEquals((boolean)false, (boolean)this.ntS.isEmpty());
        TestNodeToTriplesMap.assertEquals(TestNodeToTriplesMap.both(x, y), TestNodeToTriplesMap.iteratorToSet(this.ntS.domain()));
    }

    public void testAddTwoShared() {
        this.addTriples(this.ntS, "x P a; x Q b");
        TestNodeToTriplesMap.assertEquals((int)2, (int)this.ntS.size());
        TestNodeToTriplesMap.assertEquals((boolean)false, (boolean)this.ntS.isEmpty());
        TestNodeToTriplesMap.assertEquals(TestNodeToTriplesMap.just(x), TestNodeToTriplesMap.iteratorToSet(this.ntS.domain()));
    }

    public void testClear() {
        this.addTriples(this.ntS, "x P a; x Q b; y R z");
        this.ntS.clear();
        this.testZeroSize("cleared NTM", this.ntS);
    }

    public void testAllIterator() {
        String triples = "x P b; y P d; y P f";
        this.addTriples(this.ntS, triples);
        TestNodeToTriplesMap.assertEquals(TestNodeToTriplesMap.tripleSet(triples), TestNodeToTriplesMap.iteratorToSet(this.ntS.iterateAll()));
    }

    public void testOneIterator() {
        this.addTriples(this.ntS, "x P b; y P d; y P f");
        TestNodeToTriplesMap.assertEquals(TestNodeToTriplesMap.tripleSet("x P b"), (Object)this.ntS.iterator((Object)x, null).toSet());
        TestNodeToTriplesMap.assertEquals(TestNodeToTriplesMap.tripleSet("y P d; y P f"), (Object)this.ntS.iterator((Object)y, null).toSet());
    }

    public void testRemove() {
        this.addTriples(this.ntS, "x P b; y P d; y R f");
        this.ntS.remove(TestNodeToTriplesMap.triple("y P d"));
        TestNodeToTriplesMap.assertEquals((int)2, (int)this.ntS.size());
        TestNodeToTriplesMap.assertEquals(TestNodeToTriplesMap.tripleSet("x P b; y R f"), (Object)this.ntS.iterateAll().toSet());
    }

    public void testRemoveByIterator() {
        this.addTriples(this.ntS, "x nice a; a nasty b; x nice c");
        this.addTriples(this.ntS, "y nice d; y nasty e; y nice f");
        ExtendedIterator it = this.ntS.iterateAll();
        while (it.hasNext()) {
            Triple t = (Triple)it.next();
            if (!t.getPredicate().equals((Object)TestNodeToTriplesMap.node("nasty"))) continue;
            it.remove();
        }
        TestNodeToTriplesMap.assertEquals(TestNodeToTriplesMap.tripleSet("x nice a; x nice c; y nice d; y nice f"), (Object)this.ntS.iterateAll().toSet());
    }

    public void testIteratorWIthPatternOnEmpty() {
        TestNodeToTriplesMap.assertEquals(TestNodeToTriplesMap.tripleSet(""), (Object)this.ntS.iterateAll(TestNodeToTriplesMap.triple("a P b")).toSet());
    }

    public void testIteratorWIthPatternOnSomething() {
        this.addTriples(this.ntS, "x P a; y P b; y R c");
        TestNodeToTriplesMap.assertEquals(TestNodeToTriplesMap.tripleSet("x P a"), (Object)this.ntS.iterateAll(TestNodeToTriplesMap.triple("x P ??")).toSet());
        TestNodeToTriplesMap.assertEquals(TestNodeToTriplesMap.tripleSet("y P b; y R c"), (Object)this.ntS.iterateAll(TestNodeToTriplesMap.triple("y ?? ??")).toSet());
        TestNodeToTriplesMap.assertEquals(TestNodeToTriplesMap.tripleSet("x P a; y P b"), (Object)this.ntS.iterateAll(TestNodeToTriplesMap.triple("?? P ??")).toSet());
        TestNodeToTriplesMap.assertEquals(TestNodeToTriplesMap.tripleSet("y R c"), (Object)this.ntS.iterateAll(TestNodeToTriplesMap.triple("?? ?? c")).toSet());
    }

    public void testUnspecificRemoveS() {
        this.addTriples(this.ntS, "x P a; y Q b; z R c");
        this.ntS.remove(TestNodeToTriplesMap.triple("x P a"));
        TestNodeToTriplesMap.assertEquals(TestNodeToTriplesMap.tripleSet("y Q b; z R c"), (Object)this.ntS.iterateAll().toSet());
    }

    public void testUnspecificRemoveP() {
        this.addTriples(this.ntP, "x P a; y Q b; z R c");
        this.ntP.remove(TestNodeToTriplesMap.triple("y Q b"));
        TestNodeToTriplesMap.assertEquals(TestNodeToTriplesMap.tripleSet("x P a; z R c"), (Object)this.ntP.iterateAll().toSet());
    }

    public void testUnspecificRemoveO() {
        this.addTriples(this.ntO, "x P a; y Q b; z R c");
        this.ntO.remove(TestNodeToTriplesMap.triple("z R c"));
        TestNodeToTriplesMap.assertEquals(TestNodeToTriplesMap.tripleSet("x P a; y Q b"), (Object)this.ntO.iterateAll().toSet());
    }

    public void testAddBooleanResult() {
        TestNodeToTriplesMap.assertEquals((boolean)true, (boolean)this.ntS.add(TestNodeToTriplesMap.triple("x P y")));
        TestNodeToTriplesMap.assertEquals((boolean)false, (boolean)this.ntS.add(TestNodeToTriplesMap.triple("x P y")));
        TestNodeToTriplesMap.assertEquals((boolean)true, (boolean)this.ntS.add(TestNodeToTriplesMap.triple("y Q z")));
        TestNodeToTriplesMap.assertEquals((boolean)false, (boolean)this.ntS.add(TestNodeToTriplesMap.triple("y Q z")));
        TestNodeToTriplesMap.assertEquals((boolean)true, (boolean)this.ntS.add(TestNodeToTriplesMap.triple("y R s")));
        TestNodeToTriplesMap.assertEquals((boolean)false, (boolean)this.ntS.add(TestNodeToTriplesMap.triple("y R s")));
    }

    public void testRemoveBooleanResult() {
        TestNodeToTriplesMap.assertEquals((boolean)false, (boolean)this.ntS.remove(TestNodeToTriplesMap.triple("x P y")));
        this.ntS.add(TestNodeToTriplesMap.triple("x P y"));
        TestNodeToTriplesMap.assertEquals((boolean)false, (boolean)this.ntS.remove(TestNodeToTriplesMap.triple("x Q y")));
        TestNodeToTriplesMap.assertEquals((boolean)true, (boolean)this.ntS.remove(TestNodeToTriplesMap.triple("x P y")));
        TestNodeToTriplesMap.assertEquals((boolean)false, (boolean)this.ntS.remove(TestNodeToTriplesMap.triple("x P y")));
    }

    public void testContains() {
        this.addTriples(this.ntS, "x P y; a P b");
        TestNodeToTriplesMap.assertTrue((boolean)this.ntS.contains(TestNodeToTriplesMap.triple("x P y")));
        TestNodeToTriplesMap.assertTrue((boolean)this.ntS.contains(TestNodeToTriplesMap.triple("a P b")));
        TestNodeToTriplesMap.assertFalse((boolean)this.ntS.contains(TestNodeToTriplesMap.triple("x P z")));
        TestNodeToTriplesMap.assertFalse((boolean)this.ntS.contains(TestNodeToTriplesMap.triple("y P y")));
        TestNodeToTriplesMap.assertFalse((boolean)this.ntS.contains(TestNodeToTriplesMap.triple("x R y")));
        TestNodeToTriplesMap.assertFalse((boolean)this.ntS.contains(TestNodeToTriplesMap.triple("e T f")));
        TestNodeToTriplesMap.assertFalse((boolean)this.ntS.contains(TestNodeToTriplesMap.triple("_x F 17")));
    }

    protected void addTriples(NodeToTriplesMap nt, String facts) {
        Triple[] t = TestNodeToTriplesMap.tripleArray(facts);
        for (int i = 0; i < t.length; ++i) {
            nt.add(t[i]);
        }
    }

    protected static <T> Set<T> just(T x) {
        HashSet<T> result = new HashSet<T>();
        result.add(x);
        return result;
    }

    protected static Set<Object> both(Object x, Object y) {
        Set<Object> result = TestNodeToTriplesMap.just(x);
        result.add(y);
        return result;
    }
}

