/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.graph.query.test;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.TripleMatch;
import com.hp.hpl.jena.graph.impl.WrappedGraph;
import com.hp.hpl.jena.graph.query.Query;
import com.hp.hpl.jena.graph.query.QueryHandler;
import com.hp.hpl.jena.graph.query.SimpleQueryHandler;
import com.hp.hpl.jena.graph.query.test.QueryTestBase;
import com.hp.hpl.jena.graph.test.GraphTestBase;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import java.util.Set;
import junit.framework.TestSuite;

public class TestEarlyConstraints
extends QueryTestBase {
    public TestEarlyConstraints(String name) {
        super(name);
    }

    public static TestSuite suite() {
        return new TestSuite(TestEarlyConstraints.class);
    }

    public void testEarlyConstraint() {
        final int[] count = new int[]{0};
        Query q = new Query().addMatch(Query.S, TestEarlyConstraints.node("eg:p1"), Query.O).addMatch(Query.X, TestEarlyConstraints.node("eg:p2"), Query.Y).addConstraint(this.notEqual(Query.S, Query.O));
        Graph gBase = TestEarlyConstraints.graphWith("a eg:p1 a; c eg:p1 d; x eg:p2 y");
        WrappedGraph g = new WrappedGraph(gBase){

            public QueryHandler queryHandler() {
                return new SimpleQueryHandler((Graph)this);
            }

            public ExtendedIterator<Triple> find(Node S, Node P, Node O) {
                if (P.equals((Object)GraphTestBase.node("eg:p2"))) {
                    count[0] = count[0] + 1;
                }
                return super.find(S, P, O);
            }

            public ExtendedIterator<Triple> find(TripleMatch tm) {
                if (tm.getMatchPredicate().equals((Object)GraphTestBase.node("eg:p2"))) {
                    count[0] = count[0] + 1;
                }
                return super.find(tm);
            }
        };
        Set s = q.executeBindings((Graph)g, new Node[]{Query.S}).mapWith(getFirst).toSet();
        TestEarlyConstraints.assertEquals(this.nodeSet("c"), (Object)s);
        TestEarlyConstraints.assertEquals((int)1, (int)count[0]);
    }
}

