/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.db.test;

import com.hp.hpl.jena.db.GraphRDB;
import com.hp.hpl.jena.db.IDBConnection;
import com.hp.hpl.jena.db.test.TestConnection;
import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.TripleMatch;
import com.hp.hpl.jena.graph.test.MetaTestGraph;
import com.hp.hpl.jena.shared.JenaException;
import com.hp.hpl.jena.shared.ReificationStyle;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import java.sql.SQLException;
import junit.framework.TestSuite;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestGraphRDB
extends MetaTestGraph {
    private IDBConnection con;
    private int count = 0;
    private Graph properties;

    public TestGraphRDB(String name) {
        super(name);
    }

    public TestGraphRDB(Class<? extends Graph> graphClass, String name, ReificationStyle style) {
        super(graphClass, name, style);
    }

    public static TestSuite suite() {
        return MetaTestGraph.suite(TestGraphRDB.class, LocalGraphRDB.class);
    }

    public void setUp() {
        this.con = TestConnection.makeAndCleanTestConnection();
        this.properties = this.con.getDefaultModelProperties().getGraph();
    }

    public void tearDown() throws SQLException {
        this.con.close();
    }

    public void testRemoveAllUsesClearNotDelete() {
        GraphRDBWithoutFind g = new GraphRDBWithoutFind();
        TestGraphRDB.graphAdd((Graph)g, "a P b; c Q d");
        g.getBulkUpdateHandler().removeAll();
        TestGraphRDB.assertEquals((int)0, (int)g.size());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected final class GraphRDBWithoutFind
    extends GraphRDB {
        public GraphRDBWithoutFind() {
            super(TestGraphRDB.this.con, "testGraph-" + TestGraphRDB.this.count++, TestGraphRDB.this.properties, GraphRDBWithoutFind.styleRDB((ReificationStyle)ReificationStyle.Minimal), true);
        }

        public ExtendedIterator<Triple> graphBaseFind(TripleMatch t) {
            throw new JenaException("find is Not Allowed");
        }

        public void performDelete(Triple t) {
            throw new JenaException("delete is Not Allowed");
        }
    }

    public class LocalGraphRDB
    extends GraphRDB {
        public LocalGraphRDB(ReificationStyle style) {
            super(TestGraphRDB.this.con, "testGraph-" + TestGraphRDB.this.count++, TestGraphRDB.this.properties, LocalGraphRDB.styleRDB((ReificationStyle)style), true);
        }
    }
}

