/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdf.model.test;

import com.hp.hpl.jena.graph.test.GraphTestBase;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelChangedListener;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import junit.framework.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RecordingModelListener
implements ModelChangedListener {
    List<Object> history = new ArrayList<Object>();

    public void addedStatement(Statement s) {
        this.record("add", s);
    }

    public void addedStatements(Statement[] statements) {
        this.record("add[]", Arrays.asList(statements));
    }

    public void addedStatements(List<Statement> statements) {
        this.record("addList", statements);
    }

    public void addedStatements(StmtIterator statements) {
        this.record("addIterator", GraphTestBase.iteratorToList(statements));
    }

    public void addedStatements(Model m) {
        this.record("addModel", m);
    }

    public void removedStatements(Statement[] statements) {
        this.record("remove[]", Arrays.asList(statements));
    }

    public void removedStatement(Statement s) {
        this.record("remove", s);
    }

    public void removedStatements(List<Statement> statements) {
        this.record("removeList", statements);
    }

    public void removedStatements(StmtIterator statements) {
        this.record("removeIterator", GraphTestBase.iteratorToList(statements));
    }

    public void removedStatements(Model m) {
        this.record("removeModel", m);
    }

    public void notifyEvent(Model m, Object event) {
        this.record("someEvent", m, event);
    }

    protected void record(String tag, Object x, Object y) {
        this.history.add(tag);
        this.history.add(x);
        this.history.add(y);
    }

    protected void record(String tag, Object info) {
        this.history.add(tag);
        this.history.add(info);
    }

    public boolean has(Object[] things) {
        return ((Object)this.history).equals(Arrays.asList(things));
    }

    public void assertHas(Object[] things) {
        if (!this.has(things)) {
            Assert.fail((String)("expected " + Arrays.asList(things) + " but got " + this.history));
        }
    }

    public boolean has(List<?> things) {
        return ((Object)this.history).equals(things);
    }

    public boolean hasStart(List<Object> L) {
        return L.size() <= this.history.size() && ((Object)L).equals(this.history.subList(0, L.size()));
    }

    public boolean hasEnd(List<Object> L) {
        return L.size() <= this.history.size() && ((Object)L).equals(this.history.subList(this.history.size() - L.size(), this.history.size()));
    }

    public void assertHas(List<?> things) {
        if (!this.has(things)) {
            Assert.fail((String)("expected " + things + " but got " + this.history));
        }
    }

    public void assertHasStart(Object[] start) {
        List<Object> L = Arrays.asList(start);
        if (!this.hasStart(L)) {
            Assert.fail((String)("expected " + L + " at the beginning of " + this.history));
        }
    }

    public void assertHasEnd(Object[] end) {
        List<Object> L = Arrays.asList(end);
        if (!this.hasEnd(L)) {
            Assert.fail((String)("expected " + L + " at the end of " + this.history));
        }
    }

    public void clear() {
        this.history.clear();
    }
}

