/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.ontology.impl.test;

import com.hp.hpl.jena.ontology.DatatypeProperty;
import com.hp.hpl.jena.ontology.Individual;
import com.hp.hpl.jena.ontology.ObjectProperty;
import com.hp.hpl.jena.ontology.OntClass;
import com.hp.hpl.jena.ontology.OntDocumentManager;
import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.OntModelSpec;
import com.hp.hpl.jena.ontology.ProfileRegistry;
import com.hp.hpl.jena.ontology.Restriction;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import java.util.ArrayList;
import java.util.Iterator;
import junit.framework.TestCase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestOntReasoning
extends TestCase {
    public static final String BASE = "http://jena.hpl.hp.com/testing/ontology";
    public static final String NS = "http://jena.hpl.hp.com/testing/ontology#";

    public TestOntReasoning(String name) {
        super(name);
    }

    public void setUp() {
        OntDocumentManager.getInstance().reset(true);
    }

    public void testSubClassDirectTransInf1a() {
        OntModel m = ModelFactory.createOntologyModel((String)ProfileRegistry.OWL_LITE_LANG);
        OntClass A = m.createClass("http://jena.hpl.hp.com/testing/ontology#A");
        OntClass B = m.createClass("http://jena.hpl.hp.com/testing/ontology#B");
        OntClass C = m.createClass("http://jena.hpl.hp.com/testing/ontology#C");
        OntClass D = m.createClass("http://jena.hpl.hp.com/testing/ontology#D");
        A.addSubClass((Resource)B);
        A.addSubClass((Resource)C);
        C.addSubClass((Resource)D);
        this.iteratorTest((Iterator<?>)A.listSubClasses(), new Object[]{B, C, D});
        this.iteratorTest((Iterator<?>)A.listSubClasses(true), new Object[]{B, C});
    }

    public void testSubClassDirectTransInf1b() {
        OntModel m = ModelFactory.createOntologyModel((String)ProfileRegistry.OWL_LITE_LANG);
        OntClass A = m.createClass("http://jena.hpl.hp.com/testing/ontology#A");
        OntClass B = m.createClass("http://jena.hpl.hp.com/testing/ontology#B");
        OntClass C = m.createClass("http://jena.hpl.hp.com/testing/ontology#C");
        OntClass D = m.createClass("http://jena.hpl.hp.com/testing/ontology#D");
        A.addSubClass((Resource)B);
        A.addSubClass((Resource)C);
        C.addSubClass((Resource)D);
        A.addSubClass((Resource)D);
        this.iteratorTest((Iterator<?>)A.listSubClasses(), new Object[]{B, C, D});
        this.iteratorTest((Iterator<?>)A.listSubClasses(true), new Object[]{B, C});
    }

    public void testSubClassDirectTransInf2a() {
        OntModelSpec spec = new OntModelSpec(OntModelSpec.OWL_LITE_MEM);
        spec.setReasonerFactory(null);
        OntModel m = ModelFactory.createOntologyModel((OntModelSpec)spec, null);
        OntClass A = m.createClass("http://jena.hpl.hp.com/testing/ontology#A");
        OntClass B = m.createClass("http://jena.hpl.hp.com/testing/ontology#B");
        OntClass C = m.createClass("http://jena.hpl.hp.com/testing/ontology#C");
        OntClass D = m.createClass("http://jena.hpl.hp.com/testing/ontology#D");
        A.addSubClass((Resource)B);
        A.addSubClass((Resource)C);
        C.addSubClass((Resource)D);
        this.iteratorTest((Iterator<?>)A.listSubClasses(), new Object[]{B, C});
        this.iteratorTest((Iterator<?>)A.listSubClasses(true), new Object[]{B, C});
    }

    public void testSubClassDirectTransInf2b() {
        OntModelSpec spec = new OntModelSpec(OntModelSpec.OWL_LITE_MEM);
        spec.setReasonerFactory(null);
        OntModel m = ModelFactory.createOntologyModel((OntModelSpec)spec, null);
        OntClass A = m.createClass("http://jena.hpl.hp.com/testing/ontology#A");
        OntClass B = m.createClass("http://jena.hpl.hp.com/testing/ontology#B");
        OntClass C = m.createClass("http://jena.hpl.hp.com/testing/ontology#C");
        OntClass D = m.createClass("http://jena.hpl.hp.com/testing/ontology#D");
        A.addSubClass((Resource)B);
        A.addSubClass((Resource)C);
        C.addSubClass((Resource)D);
        A.addSubClass((Resource)D);
        this.iteratorTest((Iterator<?>)A.listSubClasses(), new Object[]{B, C, D});
        this.iteratorTest((Iterator<?>)A.listSubClasses(true), new Object[]{B, C});
    }

    public void testSubPropertyDirectTransInf1a() {
        OntModel m = ModelFactory.createOntologyModel((String)ProfileRegistry.OWL_LITE_LANG);
        ObjectProperty p = m.createObjectProperty("http://jena.hpl.hp.com/testing/ontology#p");
        ObjectProperty q = m.createObjectProperty("http://jena.hpl.hp.com/testing/ontology#q");
        ObjectProperty r = m.createObjectProperty("http://jena.hpl.hp.com/testing/ontology#r");
        ObjectProperty s = m.createObjectProperty("http://jena.hpl.hp.com/testing/ontology#s");
        p.addSubProperty((Property)q);
        p.addSubProperty((Property)r);
        r.addSubProperty((Property)s);
        this.iteratorTest((Iterator<?>)p.listSubProperties(), new Object[]{p, q, r, s});
        this.iteratorTest((Iterator<?>)p.listSubProperties(true), new Object[]{q, r});
    }

    public void testSubPropertyDirectTransInf1b() {
        OntModel m = ModelFactory.createOntologyModel((String)ProfileRegistry.OWL_LITE_LANG);
        ObjectProperty p = m.createObjectProperty("http://jena.hpl.hp.com/testing/ontology#p");
        ObjectProperty q = m.createObjectProperty("http://jena.hpl.hp.com/testing/ontology#q");
        ObjectProperty r = m.createObjectProperty("http://jena.hpl.hp.com/testing/ontology#r");
        ObjectProperty s = m.createObjectProperty("http://jena.hpl.hp.com/testing/ontology#s");
        p.addSubProperty((Property)q);
        p.addSubProperty((Property)r);
        r.addSubProperty((Property)s);
        p.addSubProperty((Property)s);
        this.iteratorTest((Iterator<?>)p.listSubProperties(), new Object[]{p, q, r, s});
        this.iteratorTest((Iterator<?>)p.listSubProperties(true), new Object[]{q, r});
    }

    public void testSubPropertyDirectTransInf2a() {
        OntModelSpec spec = new OntModelSpec(OntModelSpec.OWL_LITE_MEM);
        spec.setReasonerFactory(null);
        OntModel m = ModelFactory.createOntologyModel((OntModelSpec)spec, null);
        ObjectProperty p = m.createObjectProperty("http://jena.hpl.hp.com/testing/ontology#p");
        ObjectProperty q = m.createObjectProperty("http://jena.hpl.hp.com/testing/ontology#q");
        ObjectProperty r = m.createObjectProperty("http://jena.hpl.hp.com/testing/ontology#r");
        ObjectProperty s = m.createObjectProperty("http://jena.hpl.hp.com/testing/ontology#s");
        p.addSubProperty((Property)q);
        p.addSubProperty((Property)r);
        r.addSubProperty((Property)s);
        this.iteratorTest((Iterator<?>)p.listSubProperties(), new Object[]{q, r});
        this.iteratorTest((Iterator<?>)p.listSubProperties(true), new Object[]{q, r});
    }

    public void testSubPropertyDirectTransInf2b() {
        OntModelSpec spec = new OntModelSpec(OntModelSpec.OWL_LITE_MEM);
        spec.setReasonerFactory(null);
        OntModel m = ModelFactory.createOntologyModel((OntModelSpec)spec, null);
        ObjectProperty p = m.createObjectProperty("http://jena.hpl.hp.com/testing/ontology#p");
        ObjectProperty q = m.createObjectProperty("http://jena.hpl.hp.com/testing/ontology#q");
        ObjectProperty r = m.createObjectProperty("http://jena.hpl.hp.com/testing/ontology#r");
        ObjectProperty s = m.createObjectProperty("http://jena.hpl.hp.com/testing/ontology#s");
        p.addSubProperty((Property)q);
        p.addSubProperty((Property)r);
        r.addSubProperty((Property)s);
        p.addSubProperty((Property)s);
        this.iteratorTest((Iterator<?>)p.listSubProperties(), new Object[]{q, r, s});
        this.iteratorTest((Iterator<?>)p.listSubProperties(true), new Object[]{q, r});
    }

    public void testListDefinedProperties() {
        OntModel m = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_MEM_RULE_INF, null);
        OntClass organism = m.createClass("http://jena.hpl.hp.com/testing/ontology#Organism");
        OntClass vertebrate = m.createClass("http://jena.hpl.hp.com/testing/ontology#Vertebrate");
        OntClass mammal = m.createClass("http://jena.hpl.hp.com/testing/ontology#Mammal");
        OntClass dog = m.createClass("http://jena.hpl.hp.com/testing/ontology#Dog");
        organism.addSubClass((Resource)vertebrate);
        vertebrate.addSubClass((Resource)mammal);
        mammal.addSubClass((Resource)dog);
        OntClass covering = m.createClass("http://jena.hpl.hp.com/testing/ontology#Covering");
        Individual hair = m.createIndividual("http://jena.hpl.hp.com/testing/ontology#hair", (Resource)covering);
        DatatypeProperty limbsCount = m.createDatatypeProperty("http://jena.hpl.hp.com/testing/ontology#limbsCount");
        DatatypeProperty hasCovering = m.createDatatypeProperty("http://jena.hpl.hp.com/testing/ontology#hasCovering");
        DatatypeProperty numYoung = m.createDatatypeProperty("http://jena.hpl.hp.com/testing/ontology#numYoung");
        limbsCount.addDomain((Resource)vertebrate);
        numYoung.addDomain((Resource)mammal);
        Restriction r = m.createRestriction((Property)hasCovering);
        r.convertToHasValueRestriction((RDFNode)hair);
        mammal.addSuperClass((Resource)r);
        this.iteratorTest((Iterator<?>)organism.listDeclaredProperties(), new Object[]{hasCovering});
        this.iteratorTest((Iterator<?>)vertebrate.listDeclaredProperties(), new Object[]{limbsCount, hasCovering});
        this.iteratorTest((Iterator<?>)mammal.listDeclaredProperties(), new Object[]{limbsCount, hasCovering, numYoung});
        this.iteratorTest((Iterator<?>)dog.listDeclaredProperties(), new Object[]{limbsCount, hasCovering, numYoung});
        this.iteratorTest((Iterator<?>)r.listDeclaredProperties(), new Object[]{hasCovering});
        this.iteratorTest((Iterator<?>)organism.listDeclaredProperties(true), new Object[]{hasCovering});
        this.iteratorTest((Iterator<?>)vertebrate.listDeclaredProperties(true), new Object[]{limbsCount});
        this.iteratorTest((Iterator<?>)mammal.listDeclaredProperties(true), new Object[]{numYoung});
        this.iteratorTest((Iterator<?>)dog.listDeclaredProperties(true), new Object[0]);
        this.iteratorTest((Iterator<?>)r.listDeclaredProperties(true), new Object[]{hasCovering});
        this.iteratorTest((Iterator<?>)organism.listDeclaredProperties(false), new Object[]{hasCovering});
        this.iteratorTest((Iterator<?>)vertebrate.listDeclaredProperties(false), new Object[]{hasCovering, limbsCount});
        this.iteratorTest((Iterator<?>)mammal.listDeclaredProperties(false), new Object[]{hasCovering, numYoung, limbsCount});
        this.iteratorTest((Iterator<?>)dog.listDeclaredProperties(false), new Object[]{hasCovering, numYoung, limbsCount});
        this.iteratorTest((Iterator<?>)r.listDeclaredProperties(false), new Object[]{hasCovering});
    }

    protected void iteratorTest(Iterator<?> i, Object[] expected) {
        Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
        ArrayList<Object> expList = new ArrayList<Object>();
        for (int j = 0; j < expected.length; ++j) {
            expList.add(expected[j]);
        }
        while (i.hasNext()) {
            Object next = i.next();
            if (!expList.contains(next)) {
                logger.debug(this.getName() + " - Unexpected iterator result: " + next);
            }
            TestOntReasoning.assertTrue((String)("Value " + next + " was not expected as a result from this iterator "), (boolean)expList.contains(next));
            TestOntReasoning.assertTrue((String)("Value " + next + " was not removed from the list "), (boolean)expList.remove(next));
        }
        if (expList.size() != 0) {
            logger.debug(this.getName() + " Expected iterator results not found");
            Iterator j = expList.iterator();
            while (j.hasNext()) {
                logger.debug(this.getName() + " - missing: " + j.next());
            }
        }
        TestOntReasoning.assertEquals((String)"There were expected elements from the iterator that were not found", (int)0, (int)expList.size());
    }
}

