/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.ontology.impl.test;

import com.hp.hpl.jena.ontology.OntDocumentManager;
import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.OntModelSpec;
import com.hp.hpl.jena.ontology.ProfileException;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.reasoner.test.TestUtil;
import java.util.Iterator;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public abstract class OntTestBase
extends TestSuite {
    public static final String BASE = "http://jena.hpl.hp.com/testing/ontology";
    public static final String NS = "http://jena.hpl.hp.com/testing/ontology#";

    public OntTestBase(String name) {
        super(name);
        OntTestCase[] tc = this.getTests();
        for (int i = 0; i < tc.length; ++i) {
            this.addTest((Test)tc[i]);
        }
    }

    protected OntTestCase[] getTests() {
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected abstract class OntTestCase
    extends TestCase {
        protected boolean m_inOWL;
        protected boolean m_inOWLLite;
        protected boolean m_inDAML;
        protected boolean m_inRDFS;
        protected String m_langElement;
        protected boolean m_owlLang;
        protected boolean m_owlLiteLang;
        protected boolean m_rdfsLang;
        protected boolean m_damlLang;

        public OntTestCase(String langElement, boolean inOWL, boolean inOWLLite, boolean inDAML, boolean inRDFS) {
            super("Ontology API test " + langElement);
            this.m_owlLang = true;
            this.m_owlLiteLang = false;
            this.m_rdfsLang = false;
            this.m_damlLang = false;
            this.m_langElement = langElement;
            this.m_inOWL = inOWL;
            this.m_inOWLLite = inOWLLite;
            this.m_inDAML = inDAML;
            this.m_inRDFS = inRDFS;
        }

        public void runTest() throws Exception {
            this.runTest(this.getOntModel(OntModelSpec.OWL_MEM), this.m_inOWL);
            this.m_owlLiteLang = true;
            this.runTest(this.getOntModel(OntModelSpec.OWL_LITE_MEM), this.m_inOWLLite);
            this.m_owlLang = false;
            this.m_owlLiteLang = false;
            this.m_damlLang = true;
            this.runTest(this.getOntModel(OntModelSpec.DAML_MEM), this.m_inDAML);
            this.m_rdfsLang = true;
            this.m_damlLang = false;
            this.runTest(this.getOntModel(OntModelSpec.RDFS_MEM), this.m_inRDFS);
        }

        protected void runTest(OntModel m, boolean inModel) throws Exception {
            boolean profileEx = false;
            try {
                this.ontTest(m);
            }
            catch (ProfileException e) {
                profileEx = true;
            }
            OntTestCase.assertEquals((String)("language element " + this.m_langElement + " was " + (inModel ? "" : "not") + " expected in model " + m.getProfile().getLabel()), (boolean)inModel, (!profileEx ? 1 : 0) != 0);
        }

        protected abstract void ontTest(OntModel var1) throws Exception;

        protected void iteratorTest(Iterator<?> i, Object[] expected) {
            TestUtil.assertIteratorValues(this, i, expected);
        }

        public void setUp() {
            OntDocumentManager.getInstance().reset(true);
        }

        protected boolean owlFull() {
            return this.m_owlLang && !this.m_owlLiteLang;
        }

        protected boolean iteratorContains(Iterator<?> i, Object target) {
            boolean found = false;
            while (i.hasNext()) {
                found = i.next().equals(target) || found;
            }
            return found;
        }

        protected OntModel getOntModel(OntModelSpec spec) {
            OntModel m = ModelFactory.createOntologyModel((OntModelSpec)spec);
            this.addAxioms(m);
            return m;
        }

        protected void addAxioms(OntModel m) {
        }
    }
}

