/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.graph.test;

import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.test.GraphTestBase;
import junit.framework.TestSuite;

public class TestTripleField
extends GraphTestBase {
    public TestTripleField(String name) {
        super(name);
    }

    public static TestSuite suite() {
        return new TestSuite(TestTripleField.class);
    }

    public void testFieldsExistAndAreTyped() {
        TestTripleField.assertInstanceOf(Triple.Field.class, Triple.Field.fieldSubject);
        TestTripleField.assertInstanceOf(Triple.Field.class, Triple.Field.fieldObject);
        TestTripleField.assertInstanceOf(Triple.Field.class, Triple.Field.fieldPredicate);
    }

    public void testGetSubject() {
        TestTripleField.assertEquals((Object)TestTripleField.node("s"), (Object)Triple.Field.fieldSubject.getField(TestTripleField.triple("s p o")));
    }

    public void testGetObject() {
        TestTripleField.assertEquals((Object)TestTripleField.node("o"), (Object)Triple.Field.fieldObject.getField(TestTripleField.triple("s p o")));
    }

    public void testGetPredicate() {
        TestTripleField.assertEquals((Object)TestTripleField.node("p"), (Object)Triple.Field.fieldPredicate.getField(TestTripleField.triple("s p o")));
    }

    public void testFilterSubject() {
        TestTripleField.assertTrue((boolean)Triple.Field.fieldSubject.filterOn(TestTripleField.node("a")).accept((Object)TestTripleField.triple("a P b")));
        TestTripleField.assertFalse((boolean)Triple.Field.fieldSubject.filterOn(TestTripleField.node("x")).accept((Object)TestTripleField.triple("a P b")));
    }

    public void testFilterObject() {
        TestTripleField.assertTrue((boolean)Triple.Field.fieldObject.filterOn(TestTripleField.node("b")).accept((Object)TestTripleField.triple("a P b")));
        TestTripleField.assertFalse((boolean)Triple.Field.fieldObject.filterOn(TestTripleField.node("c")).accept((Object)TestTripleField.triple("a P b")));
    }

    public void testFilterPredicate() {
        TestTripleField.assertTrue((boolean)Triple.Field.fieldPredicate.filterOn(TestTripleField.node("P")).accept((Object)TestTripleField.triple("a P b")));
        TestTripleField.assertFalse((boolean)Triple.Field.fieldPredicate.filterOn(TestTripleField.node("Q")).accept((Object)TestTripleField.triple("a P b")));
    }

    public void testFilterByTriple() {
        TestTripleField.assertTrue((boolean)Triple.Field.fieldSubject.filterOn(TestTripleField.triple("s P o")).accept((Object)TestTripleField.triple("s Q p")));
        TestTripleField.assertFalse((boolean)Triple.Field.fieldSubject.filterOn(TestTripleField.triple("s P o")).accept((Object)TestTripleField.triple("x Q p")));
    }

    public void testWildcardFilterIsAny() {
        TestTripleField.assertTrue((boolean)Triple.Field.fieldSubject.filterOn(TestTripleField.triple("?x R s")).isAny());
        TestTripleField.assertTrue((boolean)Triple.Field.fieldObject.filterOn(TestTripleField.triple("x R ?s")).isAny());
        TestTripleField.assertTrue((boolean)Triple.Field.fieldPredicate.filterOn(TestTripleField.triple("x ?R s")).isAny());
    }
}

