/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.graph.test;

import com.hp.hpl.jena.graph.TripleMatch;
import com.hp.hpl.jena.graph.impl.TripleStore;
import com.hp.hpl.jena.graph.test.GraphTestBase;

public abstract class AbstractTestTripleStore
extends GraphTestBase {
    protected TripleStore store;

    public AbstractTestTripleStore(String name) {
        super(name);
    }

    public abstract TripleStore getTripleStore();

    public void setUp() {
        this.store = this.getTripleStore();
    }

    public void testEmpty() {
        this.testEmpty(this.store);
    }

    public void testAddOne() {
        this.store.add(AbstractTestTripleStore.triple("x P y"));
        AbstractTestTripleStore.assertEquals((boolean)false, (boolean)this.store.isEmpty());
        AbstractTestTripleStore.assertEquals((int)1, (int)this.store.size());
        AbstractTestTripleStore.assertEquals((boolean)true, (boolean)this.store.contains(AbstractTestTripleStore.triple("x P y")));
        AbstractTestTripleStore.assertEquals(this.nodeSet("x"), AbstractTestTripleStore.iteratorToSet(this.store.listSubjects()));
        AbstractTestTripleStore.assertEquals(this.nodeSet("y"), AbstractTestTripleStore.iteratorToSet(this.store.listObjects()));
        AbstractTestTripleStore.assertEquals(AbstractTestTripleStore.tripleSet("x P y"), AbstractTestTripleStore.iteratorToSet(this.store.find((TripleMatch)AbstractTestTripleStore.triple("?? ?? ??"))));
    }

    public void testListSubjects() {
        this.someStatements(this.store);
        AbstractTestTripleStore.assertEquals(this.nodeSet("a x _z r q"), AbstractTestTripleStore.iteratorToSet(this.store.listSubjects()));
    }

    public void testListObjects() {
        this.someStatements(this.store);
        AbstractTestTripleStore.assertEquals(this.nodeSet("b y i _j _t 17"), AbstractTestTripleStore.iteratorToSet(this.store.listObjects()));
    }

    public void testContains() {
        this.someStatements(this.store);
        AbstractTestTripleStore.assertEquals((boolean)true, (boolean)this.store.contains(AbstractTestTripleStore.triple("a P b")));
        AbstractTestTripleStore.assertEquals((boolean)true, (boolean)this.store.contains(AbstractTestTripleStore.triple("x P y")));
        AbstractTestTripleStore.assertEquals((boolean)true, (boolean)this.store.contains(AbstractTestTripleStore.triple("a P i")));
        AbstractTestTripleStore.assertEquals((boolean)true, (boolean)this.store.contains(AbstractTestTripleStore.triple("_z Q _j")));
        AbstractTestTripleStore.assertEquals((boolean)true, (boolean)this.store.contains(AbstractTestTripleStore.triple("x R y")));
        AbstractTestTripleStore.assertEquals((boolean)true, (boolean)this.store.contains(AbstractTestTripleStore.triple("r S _t")));
        AbstractTestTripleStore.assertEquals((boolean)true, (boolean)this.store.contains(AbstractTestTripleStore.triple("q R 17")));
        AbstractTestTripleStore.assertEquals((boolean)false, (boolean)this.store.contains(AbstractTestTripleStore.triple("a P x")));
        AbstractTestTripleStore.assertEquals((boolean)false, (boolean)this.store.contains(AbstractTestTripleStore.triple("a P _j")));
        AbstractTestTripleStore.assertEquals((boolean)false, (boolean)this.store.contains(AbstractTestTripleStore.triple("b Z r")));
        AbstractTestTripleStore.assertEquals((boolean)false, (boolean)this.store.contains(AbstractTestTripleStore.triple("_a P x")));
    }

    public void testFind() {
        this.someStatements(this.store);
        AbstractTestTripleStore.assertEquals(AbstractTestTripleStore.tripleSet(""), AbstractTestTripleStore.iteratorToSet(this.store.find((TripleMatch)AbstractTestTripleStore.triple("no such thing"))));
        AbstractTestTripleStore.assertEquals(AbstractTestTripleStore.tripleSet("a P b; a P i"), AbstractTestTripleStore.iteratorToSet(this.store.find((TripleMatch)AbstractTestTripleStore.triple("a P ??"))));
        AbstractTestTripleStore.assertEquals(AbstractTestTripleStore.tripleSet("a P b; x P y; a P i"), AbstractTestTripleStore.iteratorToSet(this.store.find((TripleMatch)AbstractTestTripleStore.triple("?? P ??"))));
        AbstractTestTripleStore.assertEquals(AbstractTestTripleStore.tripleSet("x P y; x R y"), AbstractTestTripleStore.iteratorToSet(this.store.find((TripleMatch)AbstractTestTripleStore.triple("x ?? y"))));
        AbstractTestTripleStore.assertEquals(AbstractTestTripleStore.tripleSet("_z Q _j"), AbstractTestTripleStore.iteratorToSet(this.store.find((TripleMatch)AbstractTestTripleStore.triple("?? ?? _j"))));
        AbstractTestTripleStore.assertEquals(AbstractTestTripleStore.tripleSet("q R 17"), AbstractTestTripleStore.iteratorToSet(this.store.find((TripleMatch)AbstractTestTripleStore.triple("?? ?? 17"))));
    }

    public void testRemove() {
        this.store.add(AbstractTestTripleStore.triple("nothing before ace"));
        this.store.add(AbstractTestTripleStore.triple("ace before king"));
        this.store.add(AbstractTestTripleStore.triple("king before queen"));
        this.store.delete(AbstractTestTripleStore.triple("ace before king"));
        AbstractTestTripleStore.assertEquals(AbstractTestTripleStore.tripleSet("king before queen; nothing before ace"), AbstractTestTripleStore.iteratorToSet(this.store.find((TripleMatch)AbstractTestTripleStore.triple("?? ?? ??"))));
        this.store.delete(AbstractTestTripleStore.triple("king before queen"));
        AbstractTestTripleStore.assertEquals(AbstractTestTripleStore.tripleSet("nothing before ace"), AbstractTestTripleStore.iteratorToSet(this.store.find((TripleMatch)AbstractTestTripleStore.triple("?? ?? ??"))));
    }

    public void someStatements(TripleStore ts) {
        ts.add(AbstractTestTripleStore.triple("a P b"));
        ts.add(AbstractTestTripleStore.triple("x P y"));
        ts.add(AbstractTestTripleStore.triple("a P i"));
        ts.add(AbstractTestTripleStore.triple("_z Q _j"));
        ts.add(AbstractTestTripleStore.triple("x R y"));
        ts.add(AbstractTestTripleStore.triple("r S _t"));
        ts.add(AbstractTestTripleStore.triple("q R 17"));
    }

    public void testEmpty(TripleStore ts) {
        AbstractTestTripleStore.assertEquals((boolean)true, (boolean)ts.isEmpty());
        AbstractTestTripleStore.assertEquals((int)0, (int)ts.size());
        AbstractTestTripleStore.assertEquals((boolean)false, (boolean)ts.find((TripleMatch)AbstractTestTripleStore.triple("?? ?? ??")).hasNext());
        AbstractTestTripleStore.assertEquals((boolean)false, (boolean)ts.listObjects().hasNext());
        AbstractTestTripleStore.assertEquals((boolean)false, (boolean)ts.listSubjects().hasNext());
        AbstractTestTripleStore.assertFalse((boolean)ts.contains(AbstractTestTripleStore.triple("x P y")));
    }
}

