/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.db.test;

import com.hp.hpl.jena.db.IDBConnection;
import com.hp.hpl.jena.db.ModelRDB;
import com.hp.hpl.jena.db.test.TestConnection;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestCompareToMem
extends TestCase {
    static Logger logger = LoggerFactory.getLogger(TestCompareToMem.class);
    Model modelrdf = null;
    Model modelmem = null;
    IDBConnection conn = null;

    public TestCompareToMem(String name) {
        super(name);
    }

    public static TestSuite suite() {
        return new TestSuite(TestCompareToMem.class);
    }

    protected void setUp() throws Exception {
        this.conn = TestConnection.makeAndCleanTestConnection();
        this.modelrdf = ModelRDB.createModel((IDBConnection)this.conn);
        this.modelmem = ModelFactory.createDefaultModel();
    }

    protected void tearDown() throws Exception {
        this.modelrdf.close();
        this.modelrdf = null;
        this.conn.cleanDB();
        this.conn.close();
        this.conn = null;
    }

    private void addRemove(Statement stmt) {
        this.modelrdf.add(stmt);
        this.modelmem.add(stmt);
        TestCompareToMem.assertTrue((this.modelmem.size() == 1L ? 1 : 0) != 0);
        TestCompareToMem.assertTrue((this.modelrdf.size() == 1L ? 1 : 0) != 0);
        this.compareModels();
        this.modelrdf.remove(stmt);
        this.modelmem.remove(stmt);
        TestCompareToMem.assertTrue((this.modelmem.size() == 0L ? 1 : 0) != 0);
        TestCompareToMem.assertTrue((this.modelrdf.size() == 0L ? 1 : 0) != 0);
        this.compareModels();
    }

    private void compareModels() {
        Statement s;
        StmtIterator it = this.modelmem.listStatements();
        while (it.hasNext()) {
            s = (Statement)it.next();
            if (!this.modelrdf.contains(s)) {
                logger.error("Statment:" + s + " is in mem but not rdf");
                this.logModel(this.modelmem, "Mem");
                this.logModel(this.modelrdf, "RDF");
            }
            TestCompareToMem.assertTrue((boolean)this.modelrdf.contains(s));
        }
        it = this.modelrdf.listStatements();
        while (it.hasNext()) {
            s = (Statement)it.next();
            if (!this.modelmem.contains(s)) {
                logger.error("Statment:" + s + " is in rdf but not memory");
                this.logModel(this.modelmem, "Mem");
                this.logModel(this.modelrdf, "RDF");
            }
            TestCompareToMem.assertTrue((boolean)this.modelmem.contains(s));
        }
    }

    private void logModel(Model m, String name) {
        logger.debug("Model");
        StmtIterator it = m.listStatements();
        while (it.hasNext()) {
            Statement s = (Statement)it.next();
            RDFNode object = s.getObject();
            if (object instanceof Literal) {
                logger.debug(name + ": " + s.getSubject() + s.getPredicate() + ((Literal)object).getValue() + " " + ((Literal)object).getDatatype() + " " + ((Literal)object).getLanguage());
                continue;
            }
            logger.debug(name + ": " + it.next());
        }
    }

    public void testAddRemoveURI() {
        Resource s = this.modelrdf.createResource("test#subject");
        Property p = this.modelrdf.createProperty("test#predicate");
        Resource o = this.modelrdf.createResource("test#object");
        this.addRemove(this.modelrdf.createStatement(s, p, (RDFNode)o));
    }

    public void testAddRemoveLiteral() {
        Resource s = this.modelrdf.createResource("test#subject");
        Property p = this.modelrdf.createProperty("test#predicate");
        Literal l = this.modelrdf.createLiteral("testLiteral");
        this.addRemove(this.modelrdf.createStatement(s, p, (RDFNode)l));
    }

    public void testAddRemoveHugeLiteral() {
        String base = "This is a huge string that repeats. \u00ce\u00b1\u00ce\u00b2\u00ce\u00b3\u00ce\u00b4\u00ce\u00b5 \u00ef\u00bf\u00bd \u00d7\u2018\u00d7\u2019\u00d7\u201c\u00d7\u201d \u00d8\u00a7\u00d8\u00a8\u00d8\u00a9\u00d8\u00aa\u00d8\u00ab";
        StringBuffer buffer = new StringBuffer(4096);
        while (buffer.length() < 4000) {
            buffer.append(base);
        }
        Resource s = this.modelrdf.createResource("test#subject");
        Property p = this.modelrdf.createProperty("test#predicate");
        Literal l = this.modelrdf.createLiteral(buffer.toString());
        this.addRemove(this.modelrdf.createStatement(s, p, (RDFNode)l));
    }

    public void testAddRemoveDatatype() {
        Resource s = this.modelrdf.createResource("test#subject");
        Property p = this.modelrdf.createProperty("test#predicate");
        Literal l = this.modelrdf.createTypedLiteral("stringType");
        this.addRemove(this.modelrdf.createStatement(s, p, (RDFNode)l));
    }

    public void testAddRemoveHugeDatatype() {
        String base = "This is a huge string that repeats. \u00ce\u00b1\u00ce\u00b2\u00ce\u00b3\u00ce\u00b4\u00ce\u00b5 \u00ef\u00bf\u00bd \u00d7\u2018\u00d7\u2019\u00d7\u201c\u00d7\u201d \u00d8\u00a7\u00d8\u00a8\u00d8\u00a9\u00d8\u00aa\u00d8\u00ab";
        StringBuffer buffer = new StringBuffer(4096);
        while (buffer.length() < 4000) {
            buffer.append(base);
        }
        Resource s = this.modelrdf.createResource("test#subject");
        Property p = this.modelrdf.createProperty("test#predicate");
        Literal l2 = this.modelrdf.createTypedLiteral(buffer.toString());
        this.addRemove(this.modelrdf.createStatement(s, p, (RDFNode)l2));
    }

    public void testAddRemoveHugeLiteral2() {
        String base = "This is a huge string that repeats. \u00ce\u00b1\u00ce\u00b2\u00ce\u00b3\u00ce\u00b4\u00ce\u00b5 \u00ef\u00bf\u00bd \u00d7\u2018\u00d7\u2019\u00d7\u201c\u00d7\u201d \u00d8\u00a7\u00d8\u00a8\u00d8\u00a9\u00d8\u00aa\u00d8\u00ab";
        StringBuffer buffer = new StringBuffer(4096);
        while (buffer.length() < 4000) {
            buffer.append(base);
        }
        Resource s = this.modelmem.createResource("test#subject");
        Property p = this.modelmem.createProperty("test#predicate");
        Literal l2 = this.modelmem.createLiteral(buffer.toString());
        Literal l3 = this.modelmem.createLiteral(buffer.toString() + ".");
        Statement st1 = this.modelmem.createStatement(s, p, (RDFNode)l2);
        Statement st2 = this.modelmem.createStatement(s, p, (RDFNode)l3);
        this.modelrdf.add(st1);
        this.modelmem.add(st1);
        this.compareModels();
        this.modelrdf.add(st2);
        this.modelmem.add(st2);
        this.compareModels();
        this.modelrdf.remove(st2);
        this.modelmem.remove(st2);
        this.compareModels();
        this.modelrdf.remove(st1);
        this.modelmem.remove(st1);
    }
}

