/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.assembler.test;

import com.hp.hpl.jena.assembler.Assembler;
import com.hp.hpl.jena.assembler.BadObjectException;
import com.hp.hpl.jena.assembler.JA;
import com.hp.hpl.jena.assembler.assemblers.DocumentManagerAssembler;
import com.hp.hpl.jena.assembler.test.AssemblerTestBase;
import com.hp.hpl.jena.ontology.OntDocumentManager;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.test.ModelTestBase;
import com.hp.hpl.jena.util.FileManager;
import java.util.ArrayList;
import junit.framework.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestDocumentManagerAssembler
extends AssemblerTestBase {
    public TestDocumentManagerAssembler(String name) {
        super(name);
    }

    @Override
    protected Class<? extends Assembler> getAssemblerClass() {
        return DocumentManagerAssembler.class;
    }

    public void testDocumentManagerAssemblerType() {
        this.testDemandsMinimalType((Assembler)new DocumentManagerAssembler(), JA.DocumentManager);
    }

    public void testDocumentManagerVocabulary() {
        this.assertSubclassOf(JA.DocumentManager, JA.Object);
        this.assertSubclassOf(JA.DocumentManager, JA.HasFileManager);
        this.assertRange(JA.FileManager, JA.fileManager);
        this.assertDomain(JA.DocumentManager, JA.policyPath);
    }

    public void testCreatesDocumentManager() {
        Resource root = this.resourceInModel("x rdf:type ja:DocumentManager");
        DocumentManagerAssembler a = new DocumentManagerAssembler();
        Object x = a.open(root);
        TestDocumentManagerAssembler.assertInstanceOf(OntDocumentManager.class, x);
    }

    public void testUsesFileManager() {
        Resource root = this.resourceInModel("x rdf:type ja:DocumentManager; x ja:fileManager f");
        DocumentManagerAssembler a = new DocumentManagerAssembler();
        FileManager fm = new FileManager();
        AssemblerTestBase.NamedObjectAssembler mock = new AssemblerTestBase.NamedObjectAssembler(TestDocumentManagerAssembler.resource("f"), fm);
        Object x = a.open((Assembler)mock, root);
        TestDocumentManagerAssembler.assertInstanceOf(OntDocumentManager.class, x);
        TestDocumentManagerAssembler.assertSame((Object)fm, (Object)((OntDocumentManager)x).getFileManager());
    }

    public void testSetsPolicyPath() {
        Resource root = this.resourceInModel("x rdf:type ja:DocumentManager; x ja:policyPath 'somePath'");
        final ArrayList history = new ArrayList();
        DocumentManagerAssembler a = new DocumentManagerAssembler(){

            protected OntDocumentManager createDocumentManager() {
                return new OntDocumentManager(""){

                    public void setMetadataSearchPath(String path, boolean replace) {
                        Assert.assertEquals((boolean)false, (boolean)replace);
                        history.add(path);
                        super.setMetadataSearchPath(path, replace);
                    }
                };
            }
        };
        OntDocumentManager d = (OntDocumentManager)a.open(root);
        TestDocumentManagerAssembler.assertEquals(TestDocumentManagerAssembler.listOfOne("somePath"), history);
    }

    public void testTrapsPolicyPathNotString() {
        this.testTrapsBadPolicyPath("aResource");
        this.testTrapsBadPolicyPath("17");
        this.testTrapsBadPolicyPath("'char'en");
        this.testTrapsBadPolicyPath("'cafe'xsd:integer");
    }

    private void testTrapsBadPolicyPath(String path) {
        Resource root = this.resourceInModel("x rdf:type ja:DocumentManager; x ja:policyPath <policy>".replaceAll("<policy>", path));
        DocumentManagerAssembler a = new DocumentManagerAssembler();
        try {
            a.open(root);
            TestDocumentManagerAssembler.fail((String)("should trap illegal policy path object " + path));
        }
        catch (BadObjectException e) {
            TestDocumentManagerAssembler.assertEquals((Object)TestDocumentManagerAssembler.resource("x"), (Object)e.getRoot());
            TestDocumentManagerAssembler.assertEquals((Object)TestDocumentManagerAssembler.rdfNode(root.getModel(), path), (Object)e.getObject());
        }
    }

    public void testSetsMetadata() {
        Resource root = this.resourceInModel("x rdf:type ja:DocumentManager; x ja:policyPath ''; x P a; a Q b; y R z");
        final Model expected = this.model("x rdf:type ja:DocumentManager; x ja:policyPath ''; x P a; a Q b");
        final ArrayList history = new ArrayList();
        DocumentManagerAssembler a = new DocumentManagerAssembler(){

            protected OntDocumentManager createDocumentManager() {
                return new OntDocumentManager(""){

                    public void processMetadata(Model m) {
                        ModelTestBase.assertIsoModels(expected, m);
                        history.add("called");
                        super.processMetadata(m);
                    }
                };
            }
        };
        OntDocumentManager d = (OntDocumentManager)a.open(root);
        TestDocumentManagerAssembler.assertEquals(TestDocumentManagerAssembler.listOfOne("called"), history);
    }
}

