/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.essentials.internal.queryframework;

import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Vector;
import oracle.toplink.essentials.descriptors.ClassDescriptor;
import oracle.toplink.essentials.exceptions.QueryException;
import oracle.toplink.essentials.internal.helper.IdentityHashtable;
import oracle.toplink.essentials.internal.queryframework.ListContainerPolicy;
import oracle.toplink.essentials.internal.sessions.AbstractSession;
import oracle.toplink.essentials.internal.sessions.CollectionChangeRecord;
import oracle.toplink.essentials.internal.sessions.MergeManager;
import oracle.toplink.essentials.internal.sessions.ObjectChangeSet;
import oracle.toplink.essentials.internal.sessions.UnitOfWorkChangeSet;

public class OrderedListContainerPolicy
extends ListContainerPolicy {
    public OrderedListContainerPolicy() {
    }

    public OrderedListContainerPolicy(Class containerClass) {
        super(containerClass);
    }

    public OrderedListContainerPolicy(String containerClassName) {
        super(containerClassName);
    }

    protected void addIntoAtIndex(Integer index, Object object, Object container, AbstractSession session) {
        if (this.hasElementDescriptor()) {
            object = this.getElementDescriptor().getObjectBuilder().wrapObject(object, session);
        }
        try {
            if (index == null || index > this.sizeFor(container)) {
                ((List)container).add(object);
            } else {
                ((List)container).add(index, object);
            }
        }
        catch (ClassCastException ex1) {
            throw QueryException.cannotAddElement(object, container, ex1);
        }
        catch (IllegalArgumentException ex2) {
            throw QueryException.cannotAddElement(object, container, ex2);
        }
        catch (UnsupportedOperationException ex3) {
            throw QueryException.cannotAddElement(object, container, ex3);
        }
    }

    public void compareCollectionsForChange(Object oldList, Object newList, CollectionChangeRecord changeRecord, AbstractSession session, ClassDescriptor referenceDescriptor) {
        ListIterator iterator;
        Vector orderedObjectsToAdd = new Vector();
        Hashtable<Integer, Integer> indicesToRemove = new Hashtable<Integer, Integer>();
        Hashtable oldListIndexValue = new Hashtable();
        IdentityHashMap oldListValueIndex = new IdentityHashMap();
        IdentityHashMap objectsToAdd = new IdentityHashMap();
        IdentityHashtable newListValueIndex = new IdentityHashtable();
        if (oldList != null) {
            iterator = this.iteratorFor(oldList);
            while (iterator.hasNext()) {
                Integer index = new Integer(iterator.nextIndex());
                Object value = iterator.next();
                oldListValueIndex.put(value, index);
                oldListIndexValue.put(index, value);
                indicesToRemove.put(index, index);
            }
        }
        if (newList != null) {
            iterator = this.iteratorFor(newList);
            while (iterator.hasNext()) {
                newListValueIndex.put(iterator.next(), new Integer(iterator.previousIndex()));
            }
            int index = 0;
            int offset = 0;
            iterator = this.iteratorFor(newList);
            while (iterator.hasNext()) {
                index = iterator.nextIndex();
                Object currentObject = iterator.next();
                if (currentObject != null) {
                    if (oldListValueIndex.containsKey(currentObject)) {
                        int oldIndex = (Integer)oldListValueIndex.get(currentObject);
                        oldListValueIndex.remove(currentObject);
                        if (index == oldIndex) {
                            indicesToRemove.remove(new Integer(oldIndex));
                            offset = 0;
                            continue;
                        }
                        if (index == oldIndex + offset) {
                            indicesToRemove.remove(new Integer(oldIndex));
                            continue;
                        }
                        int movedObjects = 0;
                        int deletedObjects = 0;
                        boolean moved = true;
                        if (oldIndex < index) {
                            ++offset;
                        } else {
                            for (int i = oldIndex - 1; i >= index; --i) {
                                Object oldObject = oldListIndexValue.get(new Integer(i));
                                if (newListValueIndex.containsKey(oldObject)) {
                                    ++movedObjects;
                                    continue;
                                }
                                ++deletedObjects;
                            }
                            if (index == oldIndex + offset - deletedObjects) {
                                offset -= deletedObjects;
                                moved = false;
                            } else if (movedObjects > 1) {
                                ++offset;
                            } else {
                                Object oldObject = oldListIndexValue.get(new Integer(index));
                                if (newListValueIndex.containsKey(oldObject) && (Integer)newListValueIndex.get(oldObject) - index > 1) {
                                    moved = false;
                                    --offset;
                                }
                            }
                        }
                        if (moved) {
                            orderedObjectsToAdd.add(currentObject);
                            continue;
                        }
                        indicesToRemove.remove(new Integer(oldIndex));
                        continue;
                    }
                    ++offset;
                    objectsToAdd.put(currentObject, currentObject);
                    orderedObjectsToAdd.add(currentObject);
                    continue;
                }
                --offset;
            }
        }
        Vector orderedIndicesToRemove = new Vector(indicesToRemove.values());
        Collections.sort(orderedIndicesToRemove);
        changeRecord.addAdditionChange(objectsToAdd, (UnitOfWorkChangeSet)changeRecord.getOwner().getUOWChangeSet(), session);
        changeRecord.addRemoveChange(oldListValueIndex, (UnitOfWorkChangeSet)changeRecord.getOwner().getUOWChangeSet(), session);
        changeRecord.addOrderedAdditionChange(orderedObjectsToAdd, newListValueIndex, (UnitOfWorkChangeSet)changeRecord.getOwner().getUOWChangeSet(), session);
        changeRecord.addOrderedRemoveChange(orderedIndicesToRemove, oldListIndexValue, (UnitOfWorkChangeSet)changeRecord.getOwner().getUOWChangeSet(), session);
    }

    public ListIterator iteratorFor(Object container) {
        return ((List)container).listIterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mergeChanges(CollectionChangeRecord changeRecord, Object valueOfTarget, boolean shouldMergeCascadeParts, MergeManager mergeManager, AbstractSession parentSession) {
        Object object = valueOfTarget;
        synchronized (object) {
            ObjectChangeSet objectChanges;
            Vector removedIndices = changeRecord.getOrderedRemoveObjectIndices();
            if (removedIndices.isEmpty()) {
                Enumeration removedObjects = changeRecord.getRemoveObjectList().keys();
                while (removedObjects.hasMoreElements()) {
                    objectChanges = (ObjectChangeSet)removedObjects.nextElement();
                    this.removeFrom(objectChanges.getOldKey(), objectChanges.getTargetVersionOfSourceObject(mergeManager.getSession()), valueOfTarget, parentSession);
                    this.registerRemoveNewObjectIfRequired(objectChanges, mergeManager);
                }
            } else {
                for (int i = removedIndices.size() - 1; i >= 0; --i) {
                    Integer index = (int)((Integer)removedIndices.elementAt(i));
                    objectChanges = (ObjectChangeSet)changeRecord.getOrderedRemoveObject(index);
                    this.removeFromAtIndex(index, valueOfTarget);
                    if (!changeRecord.getRemoveObjectList().containsKey(objectChanges)) continue;
                    this.registerRemoveNewObjectIfRequired(objectChanges, mergeManager);
                }
            }
            Enumeration addObjects = changeRecord.getOrderedAddObjects().elements();
            while (addObjects.hasMoreElements()) {
                objectChanges = (ObjectChangeSet)addObjects.nextElement();
                boolean objectAdded = changeRecord.getAddObjectList().containsKey(objectChanges);
                Object object2 = null;
                if (objectAdded && shouldMergeCascadeParts) {
                    object2 = this.mergeCascadeParts(objectChanges, mergeManager, parentSession);
                }
                if (object2 == null) {
                    object2 = objectChanges.getTargetVersionOfSourceObject(mergeManager.getSession());
                }
                if (objectAdded && mergeManager.shouldMergeChangesIntoDistributedCache()) {
                    if (this.contains(object2, valueOfTarget, mergeManager.getSession())) continue;
                    this.addIntoAtIndex(changeRecord.getOrderedAddObjectIndex(objectChanges), object2, valueOfTarget, mergeManager.getSession());
                    continue;
                }
                this.addIntoAtIndex(changeRecord.getOrderedAddObjectIndex(objectChanges), object2, valueOfTarget, mergeManager.getSession());
            }
        }
    }

    protected void registerRemoveNewObjectIfRequired(ObjectChangeSet objectChanges, MergeManager mergeManager) {
        if (!mergeManager.shouldMergeChangesIntoDistributedCache()) {
            mergeManager.registerRemovedNewObjectIfRequired(objectChanges.getUnitOfWorkClone());
        }
    }

    protected void removeFromAtIndex(int index, Object container) {
        try {
            ((List)container).remove(index);
        }
        catch (ClassCastException ex1) {
            throw QueryException.cannotRemoveFromContainer(new Integer(index), container, this);
        }
        catch (IllegalArgumentException ex2) {
            throw QueryException.cannotRemoveFromContainer(new Integer(index), container, this);
        }
        catch (UnsupportedOperationException ex3) {
            throw QueryException.cannotRemoveFromContainer(new Integer(index), container, this);
        }
    }
}

