/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.essentials.exceptions;

import java.util.List;
import oracle.toplink.essentials.exceptions.TopLinkException;
import oracle.toplink.essentials.exceptions.i18n.ExceptionMessageGenerator;

public class DefaultMappingException
extends TopLinkException {
    public static final int FINDER_PARAMETER_TYPE_NOT_FOUND = 20001;
    public static final int FINDER_NOT_DEFINED_IN_HOME = 20002;
    public static final int EJB_SELECT_NOT_DEFINED_IN_BEAN = 20003;
    public static final int FINDER_NOT_START_WITH_FIND_OR_EJBSELECT = 20004;
    public static final int GETTER_NOT_FOUND = 20005;
    public static final int FIELD_NOT_FOUND = 20006;

    public DefaultMappingException(String message) {
        super(message);
    }

    protected DefaultMappingException(String message, Exception internalException) {
        super(message, internalException);
    }

    public static DefaultMappingException finderParameterTypeNotFound(String beanName, String finderName, String finderParameterTypeString) {
        Object[] args = new Object[]{beanName, finderName, finderParameterTypeString};
        DefaultMappingException exception = new DefaultMappingException(ExceptionMessageGenerator.buildMessage(DefaultMappingException.class, 20001, args));
        exception.setErrorCode(20001);
        return exception;
    }

    public static DefaultMappingException finderNotDefinedInHome(String beanName, String finderName, List finderParameters) {
        Object[] args = new Object[]{beanName, finderName, finderParameters.toArray()};
        DefaultMappingException exception = new DefaultMappingException(ExceptionMessageGenerator.buildMessage(DefaultMappingException.class, 20002, args));
        exception.setErrorCode(20002);
        return exception;
    }

    public static DefaultMappingException finderNotStartWithFindOrEjbSelect(String beanName, String finderName) {
        Object[] args = new Object[]{beanName, finderName};
        DefaultMappingException exception = new DefaultMappingException(ExceptionMessageGenerator.buildMessage(DefaultMappingException.class, 20004, args));
        exception.setErrorCode(20004);
        return exception;
    }

    public static DefaultMappingException ejbSelectNotDefinedInBean(String beanName, String ejbSelectName, List ejbSelectParameters) {
        Object[] args = new Object[]{beanName, ejbSelectName, ejbSelectParameters.toArray()};
        DefaultMappingException exception = new DefaultMappingException(ExceptionMessageGenerator.buildMessage(DefaultMappingException.class, 20003, args));
        exception.setErrorCode(20003);
        return exception;
    }

    public static DefaultMappingException getterNotFound(String getter, String beanName) {
        Object[] args = new Object[]{getter, beanName};
        DefaultMappingException exception = new DefaultMappingException(ExceptionMessageGenerator.buildMessage(DefaultMappingException.class, 20005, args));
        exception.setErrorCode(20005);
        return exception;
    }

    public static DefaultMappingException fieldNotFound(String field, String beanName) {
        Object[] args = new Object[]{field, beanName};
        DefaultMappingException exception = new DefaultMappingException(ExceptionMessageGenerator.buildMessage(DefaultMappingException.class, 20006, args));
        exception.setErrorCode(20006);
        return exception;
    }
}

