/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.util;

import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryException;
import com.hp.hpl.jena.query.QueryFactory;
import com.hp.hpl.jena.sparql.algebra.Algebra;
import com.hp.hpl.jena.sparql.algebra.Op;
import com.hp.hpl.jena.sparql.core.Prologue;
import com.hp.hpl.jena.sparql.core.QueryCheckException;
import com.hp.hpl.jena.sparql.lang.ParserRegistry;
import com.hp.hpl.jena.sparql.sse.SSE;
import com.hp.hpl.jena.sparql.sse.SSEParseException;
import com.hp.hpl.jena.sparql.sse.WriterSSE;
import com.hp.hpl.jena.sparql.sse.builders.BuildException;
import com.hp.hpl.jena.sparql.util.IndentedLineBuffer;

public class QueryUtils {
    public static void checkQuery(Query query, boolean optimizeAlgebra) {
        QueryUtils.checkParse(query);
        QueryUtils.checkOp(query, optimizeAlgebra);
    }

    public static void checkOp(Query query, boolean optimizeAlgebra) {
        IndentedLineBuffer buff = new IndentedLineBuffer();
        Op op = Algebra.compile(query);
        if (optimizeAlgebra) {
            op = Algebra.optimize(op);
        }
        WriterSSE.out(buff.getIndentedWriter(), op, (Prologue)query);
        String str2 = buff.getBuffer().toString();
        try {
            Op op2 = SSE.parseOp(str2);
            if (op.hashCode() != op2.hashCode()) {
                throw new QueryCheckException("reparsed algebra expression hashCode does not equal algebra from query");
            }
            if (!op.equals(op2)) {
                throw new QueryCheckException("reparsed algebra expression does not equal query algebra");
            }
        }
        catch (SSEParseException ex) {
            System.err.println(str2);
            throw ex;
        }
        catch (BuildException ex) {
            System.err.println(str2);
            throw ex;
        }
    }

    public static void checkParse(Query query) {
        if (!ParserRegistry.get().containsFactory(query.getSyntax())) {
            return;
        }
        IndentedLineBuffer buff = new IndentedLineBuffer();
        query.serialize(buff, query.getSyntax());
        String tmp = buff.toString();
        Query query2 = null;
        try {
            String baseURI = null;
            if (!query.explicitlySetBaseURI()) {
                baseURI = query.getBaseURI();
            }
            if ((query2 = QueryFactory.create(tmp, baseURI, query.getSyntax())) == null) {
                return;
            }
        }
        catch (UnsupportedOperationException ex) {
            return;
        }
        catch (QueryException ex) {
            System.err.println(tmp);
            throw new QueryCheckException("could not parse output query", (Throwable)((Object)ex));
        }
        if (query.hashCode() != query2.hashCode()) {
            throw new QueryCheckException("reparsed query hashCode does not equal parsed input query");
        }
        if (!query.equals(query2)) {
            throw new QueryCheckException("reparsed output does not equal parsed input");
        }
    }
}

