/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.lib.iterator;

import com.hp.hpl.jena.sparql.lib.iterator.ClosableIterator;
import com.hp.hpl.jena.sparql.util.Utils;
import java.util.Iterator;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RepeatApplyIterator<T>
implements Iterator<T>,
ClosableIterator {
    private Iterator<T> input;
    private boolean finished = false;
    private Iterator<T> currentStage = null;

    protected RepeatApplyIterator(Iterator<T> input) {
        this.input = input;
    }

    @Override
    public boolean hasNext() {
        if (this.finished) {
            return false;
        }
        while (true) {
            if (this.currentStage == null && this.input.hasNext()) {
                T nextItem = this.input.next();
                this.currentStage = this.makeNextStage(nextItem);
            }
            if (this.currentStage == null) {
                this.finished = true;
                return false;
            }
            if (this.currentStage.hasNext()) {
                return true;
            }
            this.currentStage = null;
        }
    }

    protected abstract Iterator<T> makeNextStage(T var1);

    @Override
    public T next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException(Utils.className(this) + ".next()/finished");
        }
        return this.currentStage.next();
    }

    @Override
    public final void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void close() {
        if (this.input instanceof ClosableIterator) {
            ((ClosableIterator)((Object)this.input)).close();
        }
    }
}

