/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.lib;

import com.hp.hpl.jena.sparql.ARQException;
import com.hp.hpl.jena.sparql.lib.SystemUtils;
import com.hp.hpl.jena.sparql.util.ALog;
import java.io.IOException;
import java.io.InputStream;
import java.util.InvalidPropertiesFormatException;
import java.util.Properties;

public class Metadata {
    static boolean initialized = false;
    static Properties properties = null;
    static String resource = null;

    private Metadata() {
    }

    public static void setMetadata(String resourceName) {
        resource = resourceName;
    }

    private static void init() {
        if (!initialized) {
            initialized = true;
            properties = new Properties();
            ClassLoader classLoader = SystemUtils.chooseClassLoader();
            if (classLoader == null) {
                classLoader = Metadata.class.getClassLoader();
            }
            if (classLoader == null) {
                ALog.fatal(Metadata.class, "No classloader");
                return;
            }
            InputStream in = classLoader.getResourceAsStream(resource);
            if (in == null) {
                return;
            }
            try {
                properties.loadFromXML(in);
            }
            catch (InvalidPropertiesFormatException ex) {
                throw new ARQException("Invalid properties file", ex);
            }
            catch (IOException ex) {
                throw new ARQException("Metadata ==> IOException", ex);
            }
        }
    }

    public static String get(String name) {
        return Metadata.get(name, null);
    }

    public static String get(String name, String defaultValue) {
        Metadata.init();
        return properties.getProperty(name, defaultValue);
    }
}

