/*
 * Decompiled with CFR 0.152.
 */
package zold.proc.tagging;

import data.base.Database;
import data.base.connectors.ThesaurusDatabase;
import data.structures.tagging.LemmaInfos;
import data.structures.tagging.LemmaVector;
import data.structures.thema.ThemaItem;
import java.util.LinkedHashMap;
import java.util.Set;
import java.util.Vector;
import proc.tagging.TreeTagger;
import proc.text.XMLCleaner;

public class _ThemaLemmatizer {
    private Database theDB;

    public _ThemaLemmatizer(Database db) {
        this.theDB = db;
    }

    public void lemmatizeThema() {
        ThesaurusDatabase td = new ThesaurusDatabase(this.theDB);
        TreeTagger tt = new TreeTagger();
        System.out.println("Lemmatization des thematiques");
        try {
            Set<ThemaItem> items = td.getAllClasses();
            for (ThemaItem item : items) {
                LemmaVector lemmasTitle = tt.processText(XMLCleaner.xmlToText(item.getConceptName()));
                LemmaVector lemmasDesc = tt.processText(XMLCleaner.xmlToText(item.getConceptDesc()));
                item.setTitleLemmas(lemmasTitle.toLemmas());
                item.setDescLemmas(lemmasDesc.toLemmas());
                this.addLemme(item.getConceptID(), lemmasTitle, lemmasDesc);
            }
        }
        catch (Exception ex) {
            System.out.println(String.format("Lemme desc insert problem :" + ex.getMessage(), new Object[0]));
        }
    }

    public void addLemme(int idThema, LemmaVector title, LemmaVector desc) {
        String lex;
        String lemma;
        int i;
        ThesaurusDatabase td = new ThesaurusDatabase(this.theDB);
        LinkedHashMap<LemmaInfos, Integer> lemmasCountTitle = title.toLemmasCount();
        LinkedHashMap<LemmaInfos, Integer> lemmasCountDesc = desc.toLemmasCount();
        Vector<LemmaInfos> liste = title.getLemmas();
        for (i = 0; i < liste.size(); ++i) {
            lemma = liste.elementAt(i).get_lemma();
            lex = liste.elementAt(i).get_lex();
            if (!lemmasCountDesc.containsKey(liste.elementAt(i))) continue;
        }
        liste = desc.getLemmas();
        for (i = 0; i < liste.size(); ++i) {
            lemma = liste.elementAt(i).get_lemma();
            lex = liste.elementAt(i).get_lex();
            if (lemmasCountTitle.containsKey(liste.elementAt(i))) continue;
        }
    }
}

