/*
 * Decompiled with CFR 0.152.
 */
package zold.proc.tagging;

import data.base.Database;
import data.base.connectors.DBPediaDatabase;
import data.structures.resources.RessourceItem;
import data.structures.tagging.LemmaInfos;
import data.structures.tagging.LemmaVector;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Set;
import proc.tagging.TreeTagger;
import proc.text.XMLCleaner;

public class _RessourceLemmatizer {
    private Database theDB;

    public _RessourceLemmatizer(Database db) {
        this.theDB = db;
    }

    public void lemmatizeRessources() {
        DBPediaDatabase td = new DBPediaDatabase(this.theDB);
        TreeTagger tt = new TreeTagger();
        System.out.println("Lemmatization des ressources");
        try {
            Set<RessourceItem> items = td.getAllRessourcesItems();
            for (RessourceItem item : items) {
                LemmaVector lemmasDesc = tt.processText(XMLCleaner.xmlToText(item.getDesc()));
                item.setDescLemmas(lemmasDesc.toLemmas());
                td.UpdateLemmas(item);
            }
        }
        catch (Exception ex) {
            System.out.println(String.format("Lemme desc insert problem :" + ex.getMessage(), new Object[0]));
        }
    }

    public void addLemme(int idRessource, LemmaVector desc) {
        DBPediaDatabase td = new DBPediaDatabase(this.theDB);
        LinkedHashMap<LemmaInfos, Integer> lemmasCountDesc = desc.toLemmasCount();
        for (String lemma : ((HashMap)lemmasCountDesc).keySet()) {
            if (lemmasCountDesc.containsKey(lemma)) continue;
            try {
                td.InsertLemma(idRessource, lemma, 0, (Integer)((HashMap)lemmasCountDesc).get(lemma));
            }
            catch (Exception ex) {
                System.out.println(String.format("Lemme desc insert problem :" + ex.getMessage(), new Object[0]));
            }
        }
    }
}

