/*
 * Decompiled with CFR 0.152.
 */
package proc.thema;

import data.base.Database;
import data.base.NoBaseException;
import data.base.connectors.ThesaurusDatabase;
import data.structures.corpus.CorpusGraph;
import data.structures.corpus.CorpusGraphLemmaItem;
import data.structures.tagging.GraphLemmaItem;
import data.structures.tagging.LemmaItem;
import data.structures.thema.ThemaItem;
import java.util.Set;
import java.util.Vector;
import proc.thema.OntologyLinker;

public class ThemaIdentifier {
    private Database myDB;
    private int currentState = 0;

    public ThemaIdentifier(Database db) {
        this.myDB = db;
    }

    public String[] processCorpus() throws NoBaseException {
        this.currentState = 0;
        CorpusGraphLemmaItem[] corpusGraphItems = new CorpusGraph(this.myDB).getItems();
        String[] thematiques = new String[corpusGraphItems.length];
        for (int i = 0; i < corpusGraphItems.length; ++i) {
            ++this.currentState;
            String[] nouveauxLemmes = this.addSemanticEnrichment(corpusGraphItems[i], 3);
            thematiques[i] = this.evalueThematique(corpusGraphItems[i], nouveauxLemmes);
        }
        return thematiques;
    }

    public int getCurrentState() {
        return this.currentState;
    }

    private String evalueThematique(GraphLemmaItem g, String[] nouveauxLemmes) {
        String[] lemmes = g.getLemmasAsStrings();
        return "";
    }

    public String[] calculDirect() throws NoBaseException {
        this.currentState = 0;
        String[] resultat = new String[]{};
        ThesaurusDatabase base = new ThesaurusDatabase(this.myDB);
        Set<ThemaItem> thematiques0 = base.getTopClasses();
        ThemaItem[] thematiques = new ThemaItem[thematiques0.size()];
        thematiques0.toArray(thematiques);
        Vector[] lemmesThema0 = new Vector[thematiques.length];
        for (int i = 0; i < thematiques.length; ++i) {
            lemmesThema0[i] = new Vector<LemmaItem>(base.getLemmas(thematiques[i].getConceptID()));
        }
        CorpusGraphLemmaItem[] corpusGraphItems = new CorpusGraph(this.myDB).getItems();
        resultat = new String[corpusGraphItems.length];
        for (int i = 0; i < corpusGraphItems.length; ++i) {
            ++this.currentState;
            int[] scores = new int[thematiques.length];
            String[] lemmes = corpusGraphItems[i].getLemmasAsStrings();
            for (int j = 0; j < scores.length; ++j) {
                String[] lemmesThema = new String[lemmesThema0[j].size()];
                for (int k = 0; k < lemmesThema.length; ++k) {
                    lemmesThema[k] = ((LemmaItem)lemmesThema0[j].elementAt(k)).getLemmaName();
                }
                scores[j] = 0;
                for (int a = 0; a < lemmes.length; ++a) {
                    for (int b = 0; b < lemmesThema.length; ++b) {
                        double sim = this.calculSimilarite(lemmes[a], lemmesThema[b]);
                        int n = j;
                        scores[n] = scores[n] + (int)(10000.0 * sim / (double)(lemmesThema.length + 10));
                    }
                }
            }
            int scoreMax = 0;
            ThemaItem themaMax = null;
            for (int j = 0; j < scores.length; ++j) {
                if (scores[j] <= scoreMax) continue;
                scoreMax = scores[j];
                themaMax = thematiques[j];
            }
            resultat[i] = scoreMax > 0 ? themaMax.getConceptName() : "";
        }
        return resultat;
    }

    private double calculSimilarite(String a, String b) {
        return a.equalsIgnoreCase(b) ? 1.0 : 0.0;
    }

    public String[] calculDirect2() throws NoBaseException {
        this.currentState = 0;
        String[] resultat = new String[]{};
        ThesaurusDatabase base = new ThesaurusDatabase(this.myDB);
        Set<ThemaItem> thematiques0 = base.getTopClasses();
        ThemaItem[] thematiques = new ThemaItem[thematiques0.size()];
        thematiques0.toArray(thematiques);
        Vector[] lemmesThema0 = new Vector[thematiques.length];
        for (int i = 0; i < thematiques.length; ++i) {
            lemmesThema0[i] = new Vector<LemmaItem>(base.getExtendedLemmas(thematiques[i].getConceptID()));
        }
        CorpusGraphLemmaItem[] corpusGraphItems = new CorpusGraph(this.myDB).getItems();
        resultat = new String[corpusGraphItems.length];
        for (int i = 0; i < corpusGraphItems.length; ++i) {
            ++this.currentState;
            int[] scores = new int[thematiques.length];
            String[] lemmes = corpusGraphItems[i].getLemmasAsStrings();
            for (int j = 0; j < scores.length; ++j) {
                String[] lemmesThema = new String[lemmesThema0[j].size()];
                for (int k = 0; k < lemmesThema.length; ++k) {
                    lemmesThema[k] = ((LemmaItem)lemmesThema0[j].elementAt(k)).getLemmaName();
                }
                scores[j] = 0;
                for (int a = 0; a < lemmes.length; ++a) {
                    for (int b = 0; b < lemmesThema.length; ++b) {
                        if (!lemmes[a].equalsIgnoreCase(lemmesThema[b])) continue;
                        double sim = this.calculSimilarite(lemmes[a], lemmesThema[b]);
                        int n = j;
                        scores[n] = scores[n] + (int)(10000.0 * sim / (double)(lemmesThema.length + 10));
                    }
                }
            }
            int scoreMax = 0;
            ThemaItem themaMax = null;
            for (int j = 0; j < scores.length; ++j) {
                if (scores[j] <= scoreMax) continue;
                scoreMax = scores[j];
                themaMax = thematiques[j];
            }
            resultat[i] = scoreMax > 0 ? themaMax.getConceptName() : "";
        }
        return resultat;
    }

    private String[] addSemanticEnrichment(GraphLemmaItem myItem, int steps) throws NoBaseException {
        Set<LemmaItem> myLemmas = myItem.getLemmas();
        OntologyLinker ol = new OntologyLinker(this.myDB);
        Set<String> resultat = ol.getGeneralisation(myLemmas, steps);
        String[] s = new String[resultat.size()];
        resultat.toArray(s);
        return s;
    }
}

