/*
 * Decompiled with CFR 0.152.
 */
package proc.thema;

import data.base.Database;
import data.base.NoBaseException;
import data.base.connectors.LocalSemanticDatabase;
import data.structures.corpus.CorpusGraph;
import data.structures.tagging.LemmaItem;
import java.util.LinkedHashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OntologyLinker {
    private Database myDB;
    private LocalSemanticDatabase lrq;

    public OntologyLinker(Database db) {
        this.myDB = db;
        this.lrq = new LocalSemanticDatabase(this.myDB);
    }

    private CorpusGraph getCorpusGraph() {
        return new CorpusGraph(this.myDB);
    }

    public Set<String> getGeneralisation(Set<LemmaItem> lemmas, int steps) throws NoBaseException {
        LemmaItem[] liste = new LemmaItem[lemmas.size()];
        lemmas.toArray(liste);
        LinkedHashSet<String> resultat = new LinkedHashSet<String>();
        for (int i = 0; i < liste.length; ++i) {
            String nom = liste[i].getLemmaName();
            String[] newLemmes = this.lrq.getGeneralisationStricte(nom, steps);
            for (int k = 0; k < newLemmes.length; ++k) {
                resultat.add(newLemmes[k]);
            }
        }
        return resultat;
    }
}

