/*
 * Decompiled with CFR 0.152.
 */
package proc.tagging;

import data.base.Config;
import data.structures.tagging.LemmaVector;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import proc.tagging.StreamGobbler;
import proc.text.Codecs;

public class TreeTagger {
    public static final int FR = 0;
    public static final int EN = 1;
    private String treeTaggerDir = Config.getTreeTaggerDirectory();
    private String program = new String(this.treeTaggerDir + "bin\\tag-french.bat");
    private String tpsFile = new String(this.treeTaggerDir + "tps");
    private String tpsExecDir = new String(this.treeTaggerDir + "bin\\");
    private static int nbInstances = 0;

    public TreeTagger() {
        this(0);
    }

    public TreeTagger(int lng) {
        switch (lng) {
            case 0: {
                this.program = new String(this.treeTaggerDir + "bin\\tag-french.bat");
                break;
            }
            case 1: {
                this.program = new String(this.treeTaggerDir + "bin\\tag-english.bat");
                break;
            }
        }
        this.tpsFile = this.treeTaggerDir + "tps" + nbInstances;
        try {
            new File(this.tpsFile).createNewFile();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        ++nbInstances;
    }

    public TreeTagger(String tt, String f) {
        this.treeTaggerDir = tt;
        this.program = new String(this.treeTaggerDir + "bin\\tag-french.bat");
        this.tpsExecDir = new String(this.treeTaggerDir + "bin\\");
        this.tpsFile = f;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public LemmaVector processText(String text) {
        text = Codecs.nettoieAvantLemmatisation(text);
        Object s = null;
        LemmaVector lemmas = new LemmaVector();
        String[] commandTT = new String[]{this.program, this.tpsFile};
        File workingDirectory = new File(this.tpsExecDir);
        try {
            PrintWriter fileWriter = new PrintWriter(new BufferedWriter(new FileWriter(this.tpsFile)));
            fileWriter.println(text);
            fileWriter.close();
            Process p = Runtime.getRuntime().exec(commandTT, null, workingDirectory);
            StreamGobbler errorGobbler = new StreamGobbler(p.getErrorStream(), "ERROR");
            StreamGobbler outputGobbler = new StreamGobbler(p.getInputStream(), "OUTPUT");
            errorGobbler.start();
            lemmas = outputGobbler.tolemmas();
            int exitVal = p.waitFor();
            if (exitVal == 0) return lemmas;
        }
        catch (IOException e) {
            return lemmas;
        }
        catch (Exception e) {
            // empty catch block
        }
        return lemmas;
    }
}

