/*
 * Decompiled with CFR 0.152.
 */
package proc.rss;

import com.sun.syndication.feed.synd.SyndEntryImpl;
import data.base.Config;
import data.base.Database;
import data.base.NoBaseException;
import data.base.connectors.RSSFeedDatabase;
import data.structures.rss.BaseRSSItem;
import data.structures.rss.RSSFeedInfoExtended;
import data.structures.rss.RSSItem;
import data.structures.tagging.LemmaVector;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import javax.swing.Timer;
import proc.rss.Entree;
import proc.rss.EntreeBase;
import proc.rss.NoDateException;
import proc.rss.RSSLemmatizer;
import proc.rss.RSSParser;
import proc.rss.RSSParsingException;
import proc.rss.TrieurDisponibiliteFlux;
import proc.tagging.TreeTagger;
import proc.text.Codecs;
import proc.text.Out;
import proc.text.XMLCleaner;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RSSSaver {
    private Database theDB;
    private int totalItemCount = 0;
    private Traitement traitements;
    private boolean lemmatisation = true;
    private Timer verifTraitement = new Timer(1000, new ActionListener(){

        public void actionPerformed(ActionEvent ae) {
            if (RSSSaver.this.traitements.getMillisExecution() > 60000L) {
                RSSSaver.this.traitements.stoppe();
                RSSSaver.this.traitements = new Traitement();
                RSSSaver.this.traitements.setPriority(10);
            }
        }
    });
    private String readErrorMessage = "";
    private String readSuccessMessage = "";
    private Set<Entree> entrees = new HashSet<Entree>();
    private final Object lock = new Object();

    public RSSSaver(Database db) {
        this.theDB = db;
        this.traitements = new Traitement();
        this.traitements.setPriority(10);
    }

    public void reLemmatise(RSSItem item) throws NoBaseException {
        RSSLemmatizer rrs_lem = new RSSLemmatizer(this.theDB);
        TreeTagger tt = new TreeTagger();
        LemmaVector lemmasTitle = tt.processText(item.getTitle());
        LemmaVector lemmasDesc = tt.processText(item.getDescription());
        item.setTitleLemmes(lemmasTitle.toLemmas());
        item.setDescLemmes(lemmasDesc.toLemmas());
        RSSFeedDatabase rfb = new RSSFeedDatabase(this.theDB);
        rfb.UpdateLemmas(item);
        rrs_lem.addLemme(item.getId(), lemmasTitle, lemmasDesc);
    }

    public void activeLemmatisation() {
        this.lemmatisation = true;
    }

    public void desactiveLemmatisation() {
        this.lemmatisation = false;
    }

    public boolean getStatutLemmatisation() {
        return this.lemmatisation;
    }

    public RSSFeedInfoExtended[] getFeedsList() throws NoBaseException {
        RSSFeedDatabase rS = new RSSFeedDatabase(this.theDB);
        Vector<RSSFeedInfoExtended> theFeeds = rS.GetExtendedRSSFeedList();
        RSSFeedInfoExtended[] result = new RSSFeedInfoExtended[theFeeds.size()];
        theFeeds.toArray(result);
        Arrays.sort(result, new TrieurDisponibiliteFlux());
        return result;
    }

    public RSSFeedInfoExtended[] getFeedsList(Vector<RSSFeedInfoExtended> preListe) {
        Vector<RSSFeedInfoExtended> theFeeds = preListe;
        RSSFeedInfoExtended[] result = new RSSFeedInfoExtended[theFeeds.size()];
        theFeeds.toArray(result);
        Arrays.sort(result, new TrieurDisponibiliteFlux());
        return result;
    }

    public int readFeed(RSSFeedInfoExtended feed) throws NoBaseException {
        RSSFeedDatabase rS = new RSSFeedDatabase(this.theDB);
        int newItemCount = 0;
        try {
            BaseRSSItem[] entryList = RSSParser.lectureFlux(feed);
            Vector<BaseRSSItem> entries = new Vector<BaseRSSItem>();
            int ifeedid = Integer.valueOf(feed.ID);
            Date lastDate = rS.GetFeedLastEntryDate(ifeedid);
            Date d1 = new Date(Long.MAX_VALUE);
            Date d2 = new Date(0L);
            for (int i = 0; i < entryList.length; ++i) {
                if (this.isToInsert(entryList[i], lastDate)) {
                    entries.addElement(entryList[i]);
                    ++newItemCount;
                    ++this.totalItemCount;
                }
                if (entryList[i].getPubDate().getTime() <= d1.getTime()) {
                    d1.setTime(entryList[i].getPubDate().getTime());
                }
                if (entryList[i].getPubDate().getTime() >= d2.getTime()) {
                    d2.setTime(entryList[i].getPubDate().getTime());
                }
                BaseRSSItem[] liste = new BaseRSSItem[entries.size()];
                entries.toArray(liste);
                this.insert(liste);
            }
            SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yy HH:mm");
            this.readSuccessMessage = entryList.length == 0 ? "aucune entr\u00e9e trouv\u00e9e" : entryList.length + " entr\u00e9e" + (entryList.length > 1 ? "s" : "") + " du " + sdf.format(d1) + " au " + sdf.format(d2) + ", dernier enregistrement du " + sdf.format(lastDate);
            this.readErrorMessage = "";
        }
        catch (RSSParsingException e) {
            newItemCount = -1;
            this.readErrorMessage = e.getMessage();
            this.readSuccessMessage = "";
        }
        this.logRead(Integer.parseInt(feed.ID), System.currentTimeMillis(), newItemCount, this.readErrorMessage + this.readSuccessMessage);
        return newItemCount;
    }

    public String getReadErrorMessage() {
        return this.readErrorMessage;
    }

    public String getReadSuccessMessage() {
        return this.readSuccessMessage;
    }

    public void logRead(int idFlux, long date, int newItems, String error) throws NoBaseException {
        RSSFeedDatabase db = new RSSFeedDatabase(this.theDB);
        db.logRead(idFlux, date, newItems, error);
    }

    public void start() {
        this.traitements.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void insert(BaseRSSItem[] entries) {
        Object object = this.lock;
        synchronized (object) {
            for (int i = 0; i < entries.length; ++i) {
                this.entrees.add(new Entree(entries[i]));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Entree pioche() {
        Object object = this.lock;
        synchronized (object) {
            Iterator<Entree> i = this.entrees.iterator();
            Entree e = i.next();
            while (i.hasNext()) {
                Entree ee = i.next();
                if (!ee.getDate().before(e.getDate())) continue;
                e = ee;
            }
            this.entrees.remove(e);
            return e;
        }
    }

    public int getEntreesEnReserve() {
        return this.entrees.size();
    }

    boolean isToInsert(SyndEntryImpl entry, Date lastDate) throws NoDateException {
        return this.isToInsert(entry.getPublishedDate(), lastDate);
    }

    boolean isToInsert(BaseRSSItem entry, Date lastDate) {
        boolean b = false;
        try {
            b = this.isToInsert(entry.getPubDate(), lastDate);
        }
        catch (NoDateException nde) {
            // empty catch block
        }
        return b;
    }

    boolean isToInsert(Date entryPubDate, Date lastDate) throws NoDateException {
        Date limite = new Date(Config.getDateDepartCorpus());
        boolean result = false;
        if (entryPubDate != null) {
            if (entryPubDate.getTime() - lastDate.getTime() >= 1000L && entryPubDate.getTime() - limite.getTime() >= 1000L && entryPubDate.getTime() < System.currentTimeMillis()) {
                result = true;
            }
        } else {
            throw new NoDateException();
        }
        return result;
    }

    public int getEntryCount() {
        return this.totalItemCount;
    }

    class Traitement
    extends Thread {
        private boolean enCours = false;
        private boolean stoppe = false;
        private long dernierDepart = System.currentTimeMillis();

        Traitement() {
        }

        public long getMillisExecution() {
            return System.currentTimeMillis() - this.dernierDepart;
        }

        public void stoppe() {
            this.stoppe = true;
        }

        public void run() {
            try {
                this.dernierDepart = System.currentTimeMillis();
                RSSFeedDatabase rS = new RSSFeedDatabase(RSSSaver.this.theDB);
                RSSLemmatizer rrs_lem = new RSSLemmatizer(RSSSaver.this.theDB);
                TreeTagger tt = new TreeTagger();
                try {
                    while (!this.stoppe) {
                        if (RSSSaver.this.entrees.size() > 0) {
                            int ifeedid;
                            Date lastDate;
                            Entree e = RSSSaver.this.pioche();
                            this.enCours = true;
                            boolean lemmatisationActive = RSSSaver.this.lemmatisation;
                            BaseRSSItem item = e.getEntree();
                            if (RSSSaver.this.isToInsert(item, lastDate = rS.GetFeedLastEntryDate(ifeedid = e.getIdFlux()))) {
                                EntreeBase e2;
                                String desc = item.getDescription();
                                String titre = Codecs.deHTMLize(XMLCleaner.xmlToText(item.getTitle()));
                                desc = Codecs.deHTMLize(XMLCleaner.xmlToText(desc));
                                String url = item.getLink();
                                if (url == null) {
                                    url = "";
                                }
                                if (url.equals("")) {
                                    Out.printErreur("Pas d'URL dans l'article " + Codecs.desEscapeHTML(titre) + " (flux " + rS.getFeedURL(e.getIdFlux()) + ")");
                                }
                                if (lemmatisationActive) {
                                    LemmaVector lemmasTitle = tt.processText(titre);
                                    LemmaVector lemmasDesc = tt.processText(desc);
                                    e2 = new EntreeBase(ifeedid, titre, desc, url, item.getPubDate(), lemmasTitle, lemmasDesc);
                                } else {
                                    e2 = new EntreeBase(ifeedid, titre, desc, url, item.getPubDate(), null, null);
                                }
                                if (!this.stoppe) {
                                    if (lemmatisationActive) {
                                        Out.printInfo("Stockage de l'article : " + Codecs.desEscapeHTML(Codecs.escapeHTML(e2.getTitle())) + " (flux " + rS.getFeedName(e2.getId()) + ", " + (e2.getLemmaTitle().getLemmas().size() + e2.getLemmaDesc().getLemmas().size()) + " lemmes, dat\u00e9 du " + e2.getPubDate() + ")...");
                                        rS.InsertEntry(e2.getId(), e2.getTitle(), e2.getDesc(), e2.getLink(), e2.getPubDate(), e2.getLemmaTitle().toLemmas(), e2.getLemmaDesc().toLemmas());
                                        int itemId = rS.getLastInsertEntry();
                                        rrs_lem.addLemme(itemId, e2.getLemmaTitle(), e2.getLemmaDesc());
                                    } else {
                                        Out.printInfo("Stockage de l'article : " + Codecs.desEscapeHTML(Codecs.escapeHTML(e2.getTitle())) + " (flux " + rS.getFeedName(e2.getId()) + ", " + " non lemmatis\u00e9, dat\u00e9 du " + e2.getPubDate() + ")...");
                                        rS.InsertEntry(e2.getId(), e2.getTitle(), e2.getDesc(), e2.getLink(), e2.getPubDate());
                                    }
                                } else {
                                    RSSSaver.this.entrees.add(e);
                                    Out.printErreur("Temps de traitement trop long : " + e.getEntree().toString());
                                }
                            }
                            this.enCours = false;
                            continue;
                        }
                        this.enCours = false;
                        try {
                            Thread.sleep(5000L);
                        }
                        catch (InterruptedException ie) {}
                    }
                }
                catch (Exception ex) {
                }
            }
            catch (NoBaseException noBaseException) {
                // empty catch block
            }
        }

        public String toString() {
            return "" + this.enCours;
        }
    }
}

