/*
 * Decompiled with CFR 0.152.
 */
package proc.rss;

import data.base.NoBaseException;
import proc.rss.NewsSaver;

public class CollecteurSujets
extends Thread {
    private String etat = "pas de lecture en cours";
    private String erreur = "";
    private boolean enCours = false;
    private int derniereCollecte = 0;
    private long dernierDepart = 0L;
    private boolean running = false;
    private boolean stop = false;
    private NewsSaver collecteur;

    public CollecteurSujets(NewsSaver collecteur) {
        this.collecteur = collecteur;
    }

    public void run() {
        while (this.running) {
            this.dernierDepart = System.currentTimeMillis();
            try {
                this.etat = "lecture en cours ";
                this.enCours = true;
                this.derniereCollecte = this.collecteur.readNews();
                if (this.derniereCollecte == -1) {
                    this.erreur = this.collecteur.getReadErrorMessage();
                }
                this.etat = "<i>lecture termin\u00e9e </i>";
                this.enCours = false;
            }
            catch (NoBaseException nbe) {
                this.erreur = "Base indisponible.";
                this.enCours = false;
            }
            try {
                Thread.sleep(60000L);
            }
            catch (InterruptedException interruptedException) {}
        }
        this.stop = true;
    }

    public void start() {
        this.running = true;
        super.start();
    }

    public void fin() {
        this.running = false;
    }

    public boolean isRunning() {
        return this.running;
    }

    public boolean isStopped() {
        return this.stop;
    }

    public long getTemps() {
        long elapsed = System.currentTimeMillis() - this.dernierDepart;
        return elapsed;
    }

    public NewsSaver getCollecteur() {
        return this.collecteur;
    }

    public String toString() {
        if (this.stop) {
            return "<html><i>Arr\u00eat\u00e9 pour cause de lecture trop longue.</i>";
        }
        if (this.enCours) {
            String s;
            String mn;
            long elapsed = System.currentTimeMillis() - this.dernierDepart;
            String hr = "" + elapsed / 3600000L;
            if (hr.length() < 2) {
                hr = "0" + hr;
            }
            if ((mn = "" + elapsed % 3600000L / 60000L).length() < 2) {
                mn = "0" + mn;
            }
            if ((s = "" + elapsed % 60000L / 1000L).length() < 2) {
                s = "0" + s;
            }
            String ss = "";
            if (this.derniereCollecte == -1) {
                ss = "<b>erreur de collecte</b> (<i>" + this.erreur + "</i>).";
            } else if (this.derniereCollecte != 0) {
                ss = "<b>" + this.derniereCollecte + " entr\u00e9e" + (this.derniereCollecte > 1 ? "s" : "") + " \u00e0 traiter.</b></i>";
            }
            if (elapsed < 300000L) {
                return "<html>" + ss + " - " + this.etat + " - " + hr + ":" + mn + ":" + s + ".";
            }
            return "<html><font color=\"#800000\">" + ss + " - " + this.etat + " - " + hr + ":" + mn + ":" + s + ".";
        }
        if (this.derniereCollecte == -1) {
            return "<html><b>erreur de collecte</b> (<i>" + this.erreur + "</i>).";
        }
        if (this.derniereCollecte == 0) {
            return "<html>" + this.etat + ".";
        }
        return "<html><b>" + this.derniereCollecte + " entr\u00e9e" + (this.derniereCollecte > 1 ? "s" : "") + " \u00e0 traiter.</b></i>";
    }
}

