/*
 * Decompiled with CFR 0.152.
 */
package proc.rss;

import data.base.NoBaseException;
import data.structures.rss.RSSFeedInfoExtended;
import javax.swing.JTextField;
import proc.rss.RSSSaver;

public class Collecteur
extends Thread {
    private String etat = "pas de lecture en cours";
    private String erreur = "";
    private String reussite = "";
    private boolean enCours = false;
    private int derniereCollecte = 0;
    private long dernierDepart = 0L;
    private boolean running = false;
    private boolean stop = false;
    private boolean plante = false;
    private RSSSaver collecteur;
    private RSSFeedInfoExtended flux;
    private JTextField delai;

    public Collecteur(RSSSaver collecteur, RSSFeedInfoExtended flux, JTextField delai) {
        this.collecteur = collecteur;
        this.flux = flux;
        this.delai = delai;
    }

    public void run() {
        while (this.running) {
            try {
                this.dernierDepart = System.currentTimeMillis();
                this.etat = "lecture en cours ";
                this.enCours = true;
                this.derniereCollecte = this.collecteur.readFeed(this.flux);
                if (this.derniereCollecte == -1) {
                    this.erreur = this.collecteur.getReadErrorMessage();
                    this.reussite = "";
                } else {
                    this.reussite = this.collecteur.getReadSuccessMessage();
                    this.erreur = "";
                }
                this.etat = "<i>lecture termin\u00e9e </i>";
                this.enCours = false;
                Thread.sleep(60000 * Integer.parseInt(this.delai.getText()));
            }
            catch (InterruptedException ie) {
            }
            catch (NoBaseException nbe) {
                try {
                    Thread.sleep(60000 * Integer.parseInt(this.delai.getText()));
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        this.stop = true;
    }

    public void start() {
        this.running = true;
        super.start();
    }

    public void fin() {
        this.running = false;
        this.interrupt();
    }

    public void setPlante(boolean plante) {
        this.plante = plante;
    }

    public boolean isRunning() {
        return this.running;
    }

    public boolean isEnTrainDeLire() {
        return this.enCours;
    }

    public boolean isStopped() {
        return this.stop;
    }

    public long getTemps() {
        long elapsed = this.enCours ? System.currentTimeMillis() - this.dernierDepart : 0L;
        return elapsed;
    }

    public RSSSaver getCollecteur() {
        return this.collecteur;
    }

    public RSSFeedInfoExtended getFlux() {
        return this.flux;
    }

    public String toString() {
        String s;
        String mn;
        long elapsed = System.currentTimeMillis() - this.dernierDepart;
        String hr = "" + elapsed / 3600000L;
        if (hr.length() < 2) {
            hr = "0" + hr;
        }
        if ((mn = "" + elapsed % 3600000L / 60000L).length() < 2) {
            mn = "0" + mn;
        }
        if ((s = "" + elapsed % 60000L / 1000L).length() < 2) {
            s = "0" + s;
        }
        if (this.stop || this.plante) {
            return "<html>" + this.flux.name + " : <i>arr\u00eat\u00e9 pour cause de lecture trop longue</i> - " + hr + ":" + mn + ":" + s + ".";
        }
        if (this.enCours) {
            String ss = "";
            ss = this.derniereCollecte == -1 ? "<b>erreur de collecte</b> (<i>" + this.erreur + "</i>)." : (this.derniereCollecte == 0 ? "rien de nouveau (<i>" + this.reussite + "</i>)." : "<b>" + this.derniereCollecte + " entr\u00e9e" + (this.derniereCollecte > 1 ? "s" : "") + " \u00e0 traiter</b> (<i>" + this.reussite + "</i>).");
            if (elapsed < 300000L) {
                return "<html>" + this.flux.name + " : " + ss + " - " + this.etat + " - " + hr + ":" + mn + ":" + s + ".";
            }
            return "<html><font color=\"#800000\">" + this.flux.name + " : " + ss + " - " + this.etat + " - " + hr + ":" + mn + ":" + s + ".";
        }
        if (this.derniereCollecte == -1) {
            return "<html>" + this.flux.name + " : <font color=\"#800000\"><b>erreur de collecte</b></font> (<i>" + this.erreur + "</i>).";
        }
        if (this.derniereCollecte == 0) {
            return "<html>" + this.flux.name + " : rien de nouveau (<i>" + this.reussite + "</i>).";
        }
        return "<html>" + this.flux.name + " : <b>" + this.derniereCollecte + " entr\u00e9e" + (this.derniereCollecte > 1 ? "s" : "") + " \u00e0 traiter.</b> (<i>" + this.reussite + "</i>)";
    }
}

