/*
 * Decompiled with CFR 0.152.
 */
package proc.cluster;

import data.base.Database;
import data.base.NoBaseException;
import data.base.connectors.LocalSemanticDatabase;
import data.structures.classification.Cluster;
import data.structures.classification.ClusterPart;
import data.structures.classification.Corpus;
import data.structures.classification.LemmePondere;
import data.structures.classification.NuagePondere;
import data.structures.classification.Operation;
import data.structures.corpus.ClusteringCorpusGraph;
import data.structures.corpus.CorpusGraphLemmaItem;
import data.structures.tagging.LemmaItem;
import java.io.File;
import java.io.FileWriter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import proc.text.Horloge;

public class Experience
implements Runnable {
    public static final int VECTEUR_PRODUIT_SCALAIRE = 1;
    public static final int VECTEUR_DISTANCE_EUCLIDIENNE = 2;
    public static final int VECTEUR_DISTANCE_DE_MANHATTAN = 3;
    public static final int VECTEUR_MINORANT_SCALAIRE = 4;
    private Database base;
    private String titre;
    private String desc;
    private ClusteringCorpusGraph corpus;
    private String statut;
    private boolean enrichArticleBase = false;
    private boolean enrichArticleGen = false;
    private boolean enrichArticleCat = false;
    private boolean enrichArticleSem = false;
    private boolean normalisationTaille = false;
    private Map<Operation, Double> poidsOrigines = new HashMap<Operation, Double>();
    private Map<String, Double> poidsCategories = new HashMap<String, Double>();
    private double poidsCategoriesNonSpecifie = 1.0;
    private int algoCalcul = 1;
    private Corpus cor = new Corpus();
    private ClusterPart resultat = null;
    private boolean demarree = false;
    private boolean termine = true;
    private long depart;
    private long fin;

    public void setBase(Database base) {
        this.base = base;
    }

    public void setCorpus(ClusteringCorpusGraph corpus) {
        this.corpus = corpus;
    }

    public String getDesc() {
        return this.desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public String getTitre() {
        return this.titre;
    }

    public void setTitre(String titre) {
        this.titre = titre;
    }

    public boolean isEnrichArticleCat() {
        return this.enrichArticleCat;
    }

    public void setEnrichArticleCat(boolean enrichArticleCat) {
        this.enrichArticleCat = enrichArticleCat;
    }

    public boolean isEnrichArticleBase() {
        return this.enrichArticleBase;
    }

    public void setEnrichArticleBase(boolean enrichArticleBase) {
        this.enrichArticleBase = enrichArticleBase;
    }

    public boolean isEnrichArticleGen() {
        return this.enrichArticleGen;
    }

    public void setEnrichArticleGen(boolean enrichArticleGen) {
        this.enrichArticleGen = enrichArticleGen;
    }

    public void setPoidsOrigine(Operation origine, double poids) {
        this.poidsOrigines.put(origine, new Double(poids));
    }

    public void annulePoidsCategories() {
        this.poidsCategoriesNonSpecifie = 0.0;
    }

    public void setPoidsCategorie(String categorie, double poids) {
        this.poidsCategories.put(categorie, new Double(poids));
    }

    public boolean isEnrichArticleSem() {
        return this.enrichArticleSem;
    }

    public void setEnrichArticleSem(boolean enrichArticleSem) {
        this.enrichArticleSem = enrichArticleSem;
    }

    public boolean isNormalisationTaille() {
        return this.normalisationTaille;
    }

    public void setNormalisationTaille(boolean normalisationTaille) {
        this.normalisationTaille = normalisationTaille;
    }

    public int getAlgoCalcul() {
        return this.algoCalcul;
    }

    public void setAlgoCalcul(int algoCalcul) {
        this.algoCalcul = algoCalcul;
    }

    public int getNbLemmes() {
        if (this.corpus == null) {
            return 0;
        }
        int nb = 0;
        for (int i = 0; i < this.cor.getArticles().length; ++i) {
            nb += this.cor.getArticles()[i].getAllLemmes().length;
        }
        return nb;
    }

    private void creeNuage() throws NoBaseException {
        LemmePondere lp;
        String categorie;
        Vector orig;
        int quotite;
        String nom;
        int a;
        LemmaItem[] enrichissement;
        Set<LemmaItem> enrichissement0;
        LocalSemanticDatabase lsdb;
        LemmePondere lemme;
        int j;
        Vector<LemmePondere> newLemmes;
        int i;
        System.out.println(Horloge.getHMS() + "  Articles");
        CorpusGraphLemmaItem[] lCor = this.corpus.getItems();
        for (i = 0; i < lCor.length; ++i) {
            this.statut = "Enrichissement article de base (" + (i + 1) + "/" + lCor.length + ");";
            this.cor.addArticle(lCor[i]);
        }
        if (this.isEnrichArticleSem()) {
            for (i = 0; i < this.cor.getArticles().length; ++i) {
                this.statut = "Enrichissement article par champ s\u00e9mantique (" + (i + 1) + "/" + this.cor.getArticles().length + ")";
                System.out.println(Horloge.getHMS() + "   Article " + (i + 1) + "/" + this.cor.getArticles().length + " : " + this.cor.getArticles()[i].getId());
                newLemmes = new Vector<LemmePondere>();
                for (j = 0; j < this.cor.getArticles()[i].getAllLemmes().length; ++j) {
                    lemme = this.cor.getArticles()[i].getAllLemmes()[j];
                    System.out.println(Horloge.getHMS() + "    Lemme " + (j + 1) + "/" + this.cor.getArticles()[i].getAllLemmes().length + " : " + lemme.getLemme());
                    if (this.base == null) continue;
                    lsdb = new LocalSemanticDatabase(this.base);
                    enrichissement0 = lsdb.getChampSemantique(lemme.toLemmaItem());
                    enrichissement = new LemmaItem[enrichissement0.size()];
                    enrichissement0.toArray(enrichissement);
                    for (a = 0; a < enrichissement.length; ++a) {
                        nom = enrichissement[a].getLemmaName();
                        quotite = lemme.getNbOccurences();
                        orig = (Vector)lemme.getOrigine().clone();
                        orig.addElement(Operation.CHAMP_SEMANTIQUE);
                        categorie = enrichissement[a].getLemmaLex();
                        lp = new LemmePondere(nom, orig, categorie, quotite);
                        newLemmes.add(lp);
                    }
                }
                for (j = 0; j < newLemmes.size(); ++j) {
                    this.cor.getArticles()[i].addLemme((LemmePondere)newLemmes.elementAt(j));
                }
            }
        }
        if (this.isEnrichArticleCat()) {
            for (i = 0; i < this.cor.getArticles().length; ++i) {
                this.statut = "Enrichissement article par cat\u00e9gorisation (" + (i + 1) + "/" + this.cor.getArticles().length + ")";
                System.out.println(Horloge.getHMS() + "   Article " + (i + 1) + "/" + this.cor.getArticles().length + " : " + this.cor.getArticles()[i].getId());
                newLemmes = new Vector();
                for (j = 0; j < this.cor.getArticles()[i].getAllLemmes().length; ++j) {
                    lemme = this.cor.getArticles()[i].getAllLemmes()[j];
                    System.out.println(Horloge.getHMS() + "    Lemme " + (j + 1) + "/" + this.cor.getArticles()[i].getAllLemmes().length + " : " + lemme.getLemme());
                    if (this.base == null) continue;
                    lsdb = new LocalSemanticDatabase(this.base);
                    enrichissement0 = lsdb.getGeneralisationWiki(lemme.toLemmaItem());
                    enrichissement = new LemmaItem[enrichissement0.size()];
                    enrichissement0.toArray(enrichissement);
                    for (a = 0; a < enrichissement.length; ++a) {
                        nom = enrichissement[a].getLemmaName();
                        quotite = lemme.getNbOccurences();
                        orig = (Vector)lemme.getOrigine().clone();
                        orig.addElement(Operation.CATEGORISATION);
                        categorie = enrichissement[a].getLemmaLex();
                        lp = new LemmePondere(nom, orig, categorie, quotite);
                        newLemmes.add(lp);
                    }
                }
                for (j = 0; j < newLemmes.size(); ++j) {
                    this.cor.getArticles()[i].addLemme((LemmePondere)newLemmes.elementAt(j));
                }
            }
        }
        if (this.isEnrichArticleGen()) {
            for (i = 0; i < this.cor.getArticles().length; ++i) {
                this.statut = "Enrichissement article par g\u00e9n\u00e9ralisation (" + (i + 1) + "/" + this.cor.getArticles().length + ")";
                System.out.println(Horloge.getHMS() + "   Article " + (i + 1) + "/" + this.cor.getArticles().length + " : " + this.cor.getArticles()[i].getId());
                newLemmes = new Vector();
                for (j = 0; j < this.cor.getArticles()[i].getAllLemmes().length; ++j) {
                    lemme = this.cor.getArticles()[i].getAllLemmes()[j];
                    System.out.println(Horloge.getHMS() + "    Lemme " + (j + 1) + "/" + this.cor.getArticles()[i].getAllLemmes().length + " : " + lemme.getLemme());
                    if (this.base == null) continue;
                    lsdb = new LocalSemanticDatabase(this.base);
                    enrichissement0 = lsdb.getGeneralisationOnto(lemme.toLemmaItem());
                    enrichissement = new LemmaItem[enrichissement0.size()];
                    enrichissement0.toArray(enrichissement);
                    for (a = 0; a < enrichissement.length; ++a) {
                        nom = enrichissement[a].getLemmaName();
                        quotite = lemme.getNbOccurences();
                        orig = (Vector)lemme.getOrigine().clone();
                        orig.addElement(Operation.GENERALISATION);
                        categorie = enrichissement[a].getLemmaLex();
                        lp = new LemmePondere(nom, orig, categorie, quotite);
                        newLemmes.add(lp);
                    }
                }
                for (j = 0; j < newLemmes.size(); ++j) {
                    this.cor.getArticles()[i].addLemme((LemmePondere)newLemmes.elementAt(j));
                }
            }
        }
    }

    private void creeNuages() throws NoBaseException {
        int i;
        Vector<Object> v;
        System.out.println(Horloge.getHMS() + " Constitution des nuages.");
        if (this.cor != null) {
            this.creeNuage();
        }
        this.statut = "Pond\u00e9ration en cours";
        System.out.println(Horloge.getHMS() + " Pond\u00e9ration");
        if (!this.poidsOrigines.isEmpty()) {
            v = new Vector<Operation>(this.poidsOrigines.keySet());
            for (i = 0; i < v.size(); ++i) {
                this.cor.pondereOrigine(v.elementAt(i), this.poidsOrigines.get(v.elementAt(i)));
            }
        }
        this.cor.pondereAllCategories(this.poidsCategoriesNonSpecifie);
        if (!this.poidsCategories.isEmpty()) {
            v = new Vector<String>(this.poidsCategories.keySet());
            for (i = 0; i < v.size(); ++i) {
                this.cor.pondereCategorie((String)v.elementAt(i), this.poidsCategories.get(v.elementAt(i)));
            }
        }
    }

    private String[] creeVecteur(NuagePondere[] nuage) {
        HashSet<String> listeLemmes = new HashSet<String>();
        for (int i = 0; i < nuage.length; ++i) {
            for (int j = 0; j < nuage[i].getAllLemmes().length; ++j) {
                LemmePondere aAjouter = nuage[i].getAllLemmes()[j];
                if (!(aAjouter.getPoidsCategorie() > 0.0)) continue;
                listeLemmes.add(aAjouter.getLemme() + ":" + aAjouter.getCategorie());
            }
        }
        String[] vecteur = new String[listeLemmes.size()];
        listeLemmes.toArray(vecteur);
        return vecteur;
    }

    public void run() {
        int clusterPart1;
        int j;
        this.demarree = true;
        this.resultat = null;
        System.out.println(Horloge.getHMS() + this.titre + " : exp\u00e9rience lanc\u00e9e.");
        if (!this.termine) {
            System.out.println(Horloge.getHMS() + " Erreur : Pr\u00e9c\u00e9dente exp\u00e9rience en cours.");
            return;
        }
        this.termine = false;
        this.depart = System.currentTimeMillis();
        if (this.corpus == null) {
            this.termine = true;
            this.fin = System.currentTimeMillis();
            System.out.println(Horloge.getHMS() + " Erreur : Pas d'article.");
            return;
        }
        if (!this.isEnrichArticleBase()) {
            this.termine = true;
            this.fin = System.currentTimeMillis();
            System.out.println(Horloge.getHMS() + " Erreur : Pas d'enrichissement de base.");
            return;
        }
        try {
            this.creeNuages();
        }
        catch (NoBaseException nbe) {
            // empty catch block
        }
        this.statut = "Clustering en cours";
        NuagePondere[] articles = this.cor.getArticles();
        String[] vecteur = this.creeVecteur(articles);
        Vector<ClusterPart> clusters = new Vector<ClusterPart>();
        Vector<double[]> matriceClusters = new Vector<double[]>();
        System.out.println(Horloge.getHMS() + " Clustering : " + articles.length + " articles.");
        for (int i = 0; i < articles.length; ++i) {
            this.statut = "Vectorisation initiale en cours (article " + (i + 1) + "/" + articles.length + ")";
            LemmePondere[] lemmes = articles[i].getAllLemmes();
            double[] vecteurArticle = new double[vecteur.length];
            for (j = 0; j < lemmes.length; ++j) {
                if (!(lemmes[j].getPoidsCategorie() > 0.0)) continue;
                String lemme = lemmes[j].getLemme() + ":" + lemmes[j].getCategorie();
                int index = 0;
                for (int a = 0; a < vecteur.length; ++a) {
                    if (!vecteur[a].equals(lemme)) continue;
                    index = a;
                    break;
                }
                vecteurArticle[index] = lemmes[j].getPoidsOrigine() * lemmes[j].getPoidsCategorie() * (double)lemmes[j].getNbOccurences();
            }
            matriceClusters.addElement(vecteurArticle);
            clusters.addElement(articles[i]);
        }
        this.statut = "Sauvegarde fichier en cours.";
        File f = new File("tableArticles.tsv");
        try {
            FileWriter w = new FileWriter(f);
            String s = "Titre\t";
            for (int i = 0; i < vecteur.length; ++i) {
                s = s + vecteur[i];
                if (i >= vecteur.length - 1) continue;
                s = s + "\t";
            }
            s = s + "\r\n";
            w.write(s);
            w.flush();
            for (j = 0; j < articles.length; ++j) {
                this.statut = "Sauvegarde fichier en cours (article " + (j + 1) + "/" + articles.length + ")";
                s = articles[j].getId() + "-" + articles[j].getTitre() + "\t";
                for (int i = 0; i < vecteur.length; ++i) {
                    s = s + ((double[])matriceClusters.elementAt(j))[i];
                    if (i >= vecteur.length - 1) continue;
                    s = s + "\t";
                }
                s = s + "\r\n";
                w.write(s);
                w.flush();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (this.algoCalcul == 1) {
            while (clusters.size() > 1) {
                this.statut = "Clustering en cours (encore " + (clusters.size() - 1) + " op\u00e9rations)";
                double scoreMax = -1.7976931348623157E308;
                clusterPart1 = -1;
                int clusterPart2 = -1;
                for (int i = 0; i < clusters.size(); ++i) {
                    for (int j2 = i + 1; j2 < clusters.size(); ++j2) {
                        double score = 0.0;
                        for (int a = 0; a < vecteur.length; ++a) {
                            score += ((double[])matriceClusters.elementAt(i))[a] * ((double[])matriceClusters.elementAt(j2))[a];
                        }
                        if (!(score > scoreMax)) continue;
                        scoreMax = score;
                        clusterPart1 = i;
                        clusterPart2 = j2;
                    }
                }
                Cluster nouveauCluster = new Cluster(new ClusterPart[]{(ClusterPart)clusters.elementAt(clusterPart1), (ClusterPart)clusters.elementAt(clusterPart2)}, scoreMax);
                double[] nouveauxPoids = new double[vecteur.length];
                LemmePondere[] lemmes = nouveauCluster.getAllLemmes();
                for (int j3 = 0; j3 < lemmes.length; ++j3) {
                    if (!(lemmes[j3].getPoidsCategorie() > 0.0)) continue;
                    String lemme = lemmes[j3].getLemme() + ":" + lemmes[j3].getCategorie();
                    int index = 0;
                    for (int a = 0; a < vecteur.length; ++a) {
                        if (!vecteur[a].equals(lemme)) continue;
                        index = a;
                        break;
                    }
                    nouveauxPoids[index] = lemmes[j3].getPoidsOrigine() * lemmes[j3].getPoidsCategorie() * (double)lemmes[j3].getNbOccurences();
                }
                ClusterPart partie1 = (ClusterPart)clusters.elementAt(clusterPart1);
                ClusterPart partie2 = (ClusterPart)clusters.elementAt(clusterPart2);
                clusters.removeElement(partie1);
                clusters.removeElement(partie2);
                double[] poids1 = (double[])matriceClusters.elementAt(clusterPart1);
                double[] poids2 = (double[])matriceClusters.elementAt(clusterPart2);
                matriceClusters.removeElement(poids1);
                matriceClusters.removeElement(poids2);
                clusters.addElement(nouveauCluster);
                matriceClusters.addElement(nouveauxPoids);
            }
        } else if (this.algoCalcul == 2) {
            while (clusters.size() > 1) {
                this.statut = "Clustering en cours (encore " + (clusters.size() - 1) + " op\u00e9rations)";
                double scoreMax = -1.7976931348623157E308;
                clusterPart1 = -1;
                int clusterPart2 = -1;
                for (int i = 0; i < clusters.size(); ++i) {
                    for (int j4 = i + 1; j4 < clusters.size(); ++j4) {
                        double score = 0.0;
                        for (int a = 0; a < vecteur.length; ++a) {
                            score -= (((double[])matriceClusters.elementAt(i))[a] - ((double[])matriceClusters.elementAt(j4))[a]) * (((double[])matriceClusters.elementAt(i))[a] - ((double[])matriceClusters.elementAt(j4))[a]);
                        }
                        if (!(score > scoreMax)) continue;
                        scoreMax = score;
                        clusterPart1 = i;
                        clusterPart2 = j4;
                    }
                }
                Cluster nouveauCluster = new Cluster(new ClusterPart[]{(ClusterPart)clusters.elementAt(clusterPart1), (ClusterPart)clusters.elementAt(clusterPart2)}, scoreMax);
                double[] nouveauxPoids = new double[vecteur.length];
                LemmePondere[] lemmes = nouveauCluster.getAllLemmes();
                for (int j5 = 0; j5 < lemmes.length; ++j5) {
                    if (!(lemmes[j5].getPoidsCategorie() > 0.0)) continue;
                    String lemme = lemmes[j5].getLemme() + ":" + lemmes[j5].getCategorie();
                    int index = 0;
                    for (int a = 0; a < vecteur.length; ++a) {
                        if (!vecteur[a].equals(lemme)) continue;
                        index = a;
                        break;
                    }
                    nouveauxPoids[index] = lemmes[j5].getPoidsOrigine() * lemmes[j5].getPoidsCategorie() * (double)lemmes[j5].getNbOccurences();
                }
                ClusterPart partie1 = (ClusterPart)clusters.elementAt(clusterPart1);
                ClusterPart partie2 = (ClusterPart)clusters.elementAt(clusterPart2);
                clusters.removeElement(partie1);
                clusters.removeElement(partie2);
                double[] poids1 = (double[])matriceClusters.elementAt(clusterPart1);
                double[] poids2 = (double[])matriceClusters.elementAt(clusterPart2);
                matriceClusters.removeElement(poids1);
                matriceClusters.removeElement(poids2);
                clusters.addElement(nouveauCluster);
                matriceClusters.addElement(nouveauxPoids);
            }
        } else if (this.algoCalcul == 3) {
            while (clusters.size() > 1) {
                this.statut = "Clustering en cours (encore " + (clusters.size() - 1) + " op\u00e9rations)";
                double scoreMax = -1.7976931348623157E308;
                clusterPart1 = -1;
                int clusterPart2 = -1;
                for (int i = 0; i < clusters.size(); ++i) {
                    for (int j6 = i + 1; j6 < clusters.size(); ++j6) {
                        double score = 0.0;
                        for (int a = 0; a < vecteur.length; ++a) {
                            score -= Math.abs(((double[])matriceClusters.elementAt(i))[a] - ((double[])matriceClusters.elementAt(j6))[a]);
                        }
                        if (!(score > scoreMax)) continue;
                        scoreMax = score;
                        clusterPart1 = i;
                        clusterPart2 = j6;
                    }
                }
                Cluster nouveauCluster = new Cluster(new ClusterPart[]{(ClusterPart)clusters.elementAt(clusterPart1), (ClusterPart)clusters.elementAt(clusterPart2)}, scoreMax);
                double[] nouveauxPoids = new double[vecteur.length];
                LemmePondere[] lemmes = nouveauCluster.getAllLemmes();
                for (int j7 = 0; j7 < lemmes.length; ++j7) {
                    if (!(lemmes[j7].getPoidsCategorie() > 0.0)) continue;
                    String lemme = lemmes[j7].getLemme() + ":" + lemmes[j7].getCategorie();
                    int index = 0;
                    for (int a = 0; a < vecteur.length; ++a) {
                        if (!vecteur[a].equals(lemme)) continue;
                        index = a;
                        break;
                    }
                    nouveauxPoids[index] = lemmes[j7].getPoidsOrigine() * lemmes[j7].getPoidsCategorie() * (double)lemmes[j7].getNbOccurences();
                }
                ClusterPart partie1 = (ClusterPart)clusters.elementAt(clusterPart1);
                ClusterPart partie2 = (ClusterPart)clusters.elementAt(clusterPart2);
                clusters.removeElement(partie1);
                clusters.removeElement(partie2);
                double[] poids1 = (double[])matriceClusters.elementAt(clusterPart1);
                double[] poids2 = (double[])matriceClusters.elementAt(clusterPart2);
                matriceClusters.removeElement(poids1);
                matriceClusters.removeElement(poids2);
                clusters.addElement(nouveauCluster);
                matriceClusters.addElement(nouveauxPoids);
            }
        } else if (this.algoCalcul == 4) {
            int i;
            float[][] similarites = new float[articles.length][articles.length];
            for (i = 0; i < articles.length; ++i) {
                similarites[i][i] = Float.MAX_VALUE;
            }
            for (i = 0; i < articles.length; ++i) {
                this.statut = "Calcul des similarit\u00e9s en cours (encore " + (articles.length - i - 1) + " op\u00e9rations)";
                for (j = 0; j < articles.length; ++j) {
                    double[] vecteuri = (double[])matriceClusters.elementAt(i);
                    double[] vecteurj = (double[])matriceClusters.elementAt(j);
                    float sim = 0.0f;
                    int divi = 0;
                    int divj = 0;
                    for (int a = 0; a < vecteuri.length; ++a) {
                        sim = (float)((double)sim + Math.min(vecteuri[a], vecteurj[a]));
                        divi = (int)((double)divi + vecteuri[a]);
                        divj = (int)((double)divj + vecteurj[a]);
                    }
                    similarites[i][j] = sim /= (float)Math.min(divi, divj);
                    similarites[j][i] = sim;
                }
            }
            ClusterPart[] liste = new ClusterPart[clusters.size()];
            clusters.toArray(liste);
            Cluster pointDeDepart = new Cluster(liste, 0.0);
        }
        this.resultat = (ClusterPart)clusters.elementAt(0);
        System.out.println(Horloge.getHMS() + " Exp\u00e9rience termin\u00e9e.");
        this.termine = true;
        this.fin = System.currentTimeMillis();
    }

    public int getSecondesExecution() {
        if (this.termine) {
            return (int)((this.fin - this.depart) / 1000L);
        }
        return (int)((System.currentTimeMillis() - this.depart) / 1000L);
    }

    public String getStatut() {
        if (!this.demarree) {
            return "Lancer l'exp\u00e9rience";
        }
        if (this.termine) {
            return "Exp\u00e9rience termin\u00e9e";
        }
        return this.statut;
    }

    public boolean isTermine() {
        return this.termine;
    }

    public ClusterPart getResultat() {
        return this.resultat;
    }
}

