/*
 * Decompiled with CFR 0.152.
 */
package data.structures.rss;

import data.structures.rss.BaseRSSItem;
import data.structures.rss.Sujet;
import java.util.HashSet;

public class SujetBrut
extends Sujet {
    private BaseRSSItem[] urls = new BaseRSSItem[0];

    public SujetBrut(int id, String titre) {
        super(id, titre);
    }

    public BaseRSSItem[] getArticles() {
        return this.urls;
    }

    public void setArticles(BaseRSSItem[] urls) {
        this.urls = urls;
    }

    public int hashCode() {
        int n = 0;
        for (int i = 0; i < this.urls.length; ++i) {
            n += this.urls[i].hashCode();
        }
        return n;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (!(o instanceof SujetBrut)) {
            return false;
        }
        SujetBrut s = (SujetBrut)o;
        boolean result = false;
        int idem = 0;
        for (int i = 0; i < this.urls.length; ++i) {
            for (int j = 0; j < s.urls.length; ++j) {
                if (!this.urls[i].getLink().equals(s.urls[j].getLink())) continue;
                ++idem;
            }
        }
        if (idem >= Math.min(this.urls.length, s.urls.length) * 5 / 10) {
            result = true;
        }
        return result;
    }

    public void fusionne(SujetBrut s) {
        int i;
        HashSet<BaseRSSItem> liste = new HashSet<BaseRSSItem>();
        for (i = 0; i < this.urls.length; ++i) {
            liste.add(this.urls[i]);
        }
        for (i = 0; i < s.urls.length; ++i) {
            liste.add(s.urls[i]);
        }
        BaseRSSItem[] x = new BaseRSSItem[liste.size()];
        liste.toArray(x);
        this.urls = x;
    }

    public String toString() {
        String s = this.getTitre();
        if (s.contains(" - ")) {
            String[] ss = s.split(" - ");
            s = "";
            for (int i = 0; i < ss.length - 1; ++i) {
                s = s + ss[i];
            }
        }
        return "[" + this.urls.length + " articles] " + s;
    }
}

