/*
 * Decompiled with CFR 0.152.
 */
package data.structures.rss;

import data.base.Database;
import data.base.NoBaseException;
import data.base.connectors.RSSFeedDatabase;
import data.structures.rss.RSSItem;
import data.structures.tagging.GraphLemmaItem;
import data.structures.tagging.LemmaItem;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.Vector;

public class RSSGraph {
    private Database theDB;
    private GraphLemmaItem node;

    public RSSGraph(Database db) {
        this.theDB = db;
    }

    public void setNode(int id) {
        GraphLemmaItem graph_item = new GraphLemmaItem();
        try {
            RSSFeedDatabase rss_db = new RSSFeedDatabase(this.theDB);
            RSSItem rss_item = rss_db.getRssItem(id);
            graph_item.setNodeID(id);
            graph_item.setNodeName(rss_item.getTitle());
            Set<LemmaItem> lemmas = rss_db.getLemmas(id);
            Vector<LemmaItem> lemmes = new Vector<LemmaItem>(lemmas);
            for (int i = 0; i < lemmes.size(); ++i) {
                String type = lemmes.elementAt(i).getLemmaLex();
                if (type.equalsIgnoreCase("NOM") && !type.equalsIgnoreCase("NAM")) continue;
                lemmes.removeElementAt(i);
                --i;
            }
            graph_item.setLemmas(new LinkedHashSet<LemmaItem>(lemmes));
            this.node = graph_item;
        }
        catch (NoBaseException noBaseException) {
            // empty catch block
        }
    }

    public GraphLemmaItem getNode() {
        return this.node;
    }
}

