/*
 * Decompiled with CFR 0.152.
 */
package data.structures.corpus;

import data.base.Database;
import data.base.NoBaseException;
import data.base.connectors.CorpusDatabase;
import data.base.connectors.RSSFeedDatabase;
import data.structures.corpus.CorpusGraphLemmaItem;
import data.structures.corpus.CorpusItem;
import java.util.Vector;

public class ClusteringCorpusGraph {
    private CorpusGraphLemmaItem[] gitems;

    public ClusteringCorpusGraph(Database db, int taille) {
        CorpusDatabase cDB = new CorpusDatabase(db);
        try {
            RSSFeedDatabase fDB = new RSSFeedDatabase(db);
            Vector<CorpusItem> items = cDB.createClusteringCorpus(taille);
            this.gitems = new CorpusGraphLemmaItem[items.size()];
            for (int i = 0; i < this.gitems.length; ++i) {
                this.gitems[i] = new CorpusGraphLemmaItem();
                this.gitems[i].setNodeID(i);
                this.gitems[i].setNodeName(items.elementAt(i).getRSSItemTitle());
                this.gitems[i].setLemmas(fDB.getNameLemmas(items.elementAt(i).getIdItem()));
                this.gitems[i].setThematique("");
                this.gitems[i].setIdThematique(0);
            }
        }
        catch (NoBaseException nbe) {
            this.gitems = new CorpusGraphLemmaItem[0];
        }
    }

    public CorpusGraphLemmaItem[] getItems() {
        return this.gitems;
    }
}

