/*
 * Decompiled with CFR 0.152.
 */
package data.structures.classification;

import data.structures.classification.LemmePondere;
import data.structures.classification.NuagePondere;
import data.structures.classification.Operation;
import data.structures.tagging.GraphLemmaItem;
import data.structures.tagging.LemmaItem;
import java.util.Vector;

public class Taxonomie {
    public Vector<NuagePondere> themas = new Vector();

    public void addThematique(NuagePondere thema) {
        this.themas.add(thema);
    }

    public void addThematique(GraphLemmaItem thema) {
        NuagePondere nuage = new NuagePondere(thema.getNodeID(), thema.getNodeName());
        Vector<LemmaItem> v = new Vector<LemmaItem>(thema.getLemmas());
        for (int i = 0; i < v.size(); ++i) {
            Vector<Operation> orig;
            LemmaItem l = v.elementAt(i);
            if (l.getCountTitle() > 0) {
                orig = new Vector<Operation>();
                orig.addElement(Operation.ACCES_TITRE);
                nuage.addLemme(new LemmePondere(l.getLemmaName(), orig, l.getLemmaLex(), l.getCountTitle()));
            }
            if (l.getCountDesc() <= 0) continue;
            orig = new Vector();
            orig.addElement(Operation.ACCES_DESC);
            nuage.addLemme(new LemmePondere(l.getLemmaName(), orig, l.getLemmaLex(), l.getCountDesc()));
        }
        this.themas.add(nuage);
    }

    public void addInThematique(GraphLemmaItem article) {
        NuagePondere nuage = this.findThematique(article.getNodeID());
        if (nuage == null) {
            return;
        }
        Vector<LemmaItem> v = new Vector<LemmaItem>(article.getLemmas());
        for (int i = 0; i < v.size(); ++i) {
            Vector<Operation> orig;
            LemmaItem l = v.elementAt(i);
            if (l.getCountTitle() > 0) {
                orig = new Vector<Operation>();
                orig.addElement(Operation.SPECIALISATION);
                orig.addElement(Operation.ACCES_TITRE);
                nuage.addLemme(new LemmePondere(l.getLemmaName(), orig, l.getLemmaLex(), l.getCountTitle()));
            }
            if (l.getCountDesc() <= 0) continue;
            orig = new Vector();
            orig.addElement(Operation.SPECIALISATION);
            orig.addElement(Operation.ACCES_DESC);
            nuage.addLemme(new LemmePondere(l.getLemmaName(), orig, l.getLemmaLex(), l.getCountDesc()));
        }
    }

    public NuagePondere[] getThematiques() {
        NuagePondere[] result = new NuagePondere[this.themas.size()];
        this.themas.toArray(result);
        return result;
    }

    public void pondereOrigine(Operation origine, double poids) {
        for (int i = 0; i < this.themas.size(); ++i) {
            this.themas.elementAt(i).pondereOrigine(origine, poids);
        }
    }

    public void normaliseParTaille() {
        for (int i = 0; i < this.themas.size(); ++i) {
            this.themas.elementAt(i).pondereTaille();
        }
    }

    public void pondereCategorie(String categorie, double poids) {
        for (int i = 0; i < this.themas.size(); ++i) {
            this.themas.elementAt(i).pondereCategorie(categorie, poids);
        }
    }

    public void pondereAllCategories(double poids) {
        for (int i = 0; i < this.themas.size(); ++i) {
            this.themas.elementAt(i).pondereAllCategories(poids);
        }
    }

    private NuagePondere findThematique(int id) {
        NuagePondere result = null;
        for (int i = 0; i < this.themas.size(); ++i) {
            if (this.themas.elementAt(i).getId() != id) continue;
            result = this.themas.elementAt(i);
            break;
        }
        return result;
    }
}

