/*
 * Decompiled with CFR 0.152.
 */
package data.structures.classification;

import data.structures.classification.ClusterPart;
import data.structures.classification.LemmePondere;
import data.structures.classification.Operation;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NuagePondere
implements ClusterPart {
    private int id;
    private Vector<LemmePondere> lemmes = new Vector();
    private String titre;

    public NuagePondere(int id, String titre) {
        this.id = id;
        this.titre = titre;
    }

    @Override
    public String getTitre() {
        return this.titre;
    }

    @Override
    public ClusterPart[] getSousClusters() {
        return new ClusterPart[0];
    }

    @Override
    public int getTotalClusters() {
        return 0;
    }

    @Override
    public Map<String, String[]> aplanis(int nbClustersConserves) {
        HashMap<String, String[]> res = new HashMap<String, String[]>();
        res.put(this.titre, new String[]{this.titre});
        return res;
    }

    @Override
    public String[] getFeuilles() {
        return new String[]{this.titre};
    }

    @Override
    public double getSimilarite() {
        return Double.MAX_VALUE;
    }

    public void addLemme(LemmePondere lemme) {
        this.lemmes.add(lemme);
    }

    public LemmePondere[] getLemmes(String origine) {
        Vector<LemmePondere> result = new Vector<LemmePondere>();
        for (int i = 0; i < this.lemmes.size(); ++i) {
            if (!this.lemmes.elementAt(i).getOrigine().equals(origine)) continue;
            result.add(this.lemmes.elementAt(i));
        }
        LemmePondere[] result2 = new LemmePondere[result.size()];
        result.toArray(result2);
        return result2;
    }

    @Override
    public LemmePondere[] getAllLemmes() {
        LemmePondere[] result = new LemmePondere[this.lemmes.size()];
        this.lemmes.toArray(result);
        return result;
    }

    public Vector<LemmePondere> getAllLemmesAsVector() {
        return this.lemmes;
    }

    public int getId() {
        return this.id;
    }

    public void pondereOrigine(Operation origine, double poids) {
        for (int i = 0; i < this.lemmes.size(); ++i) {
            this.lemmes.elementAt(i).pondereOrigine(origine, poids);
        }
    }

    public void pondereCategorie(String categorie, double poids) {
        for (int i = 0; i < this.lemmes.size(); ++i) {
            if (this.lemmes.elementAt(i).getCategorie() == null || !this.lemmes.elementAt(i).getCategorie().equals(categorie)) continue;
            this.lemmes.elementAt(i).pondereCategorie(poids);
        }
    }

    public void pondereAllCategories(double poids) {
        for (int i = 0; i < this.lemmes.size(); ++i) {
            if (this.lemmes.elementAt(i).getCategorie() == null) continue;
            this.lemmes.elementAt(i).pondereCategorie(poids);
        }
    }

    public void pondereTaille() {
        for (int i = 0; i < this.lemmes.size(); ++i) {
            this.lemmes.elementAt(i).pondereTaille(this.lemmes.size());
        }
    }

    public String toString() {
        return ">" + this.getTitre();
    }
}

