/*
 * Decompiled with CFR 0.152.
 */
package data.structures.classification;

import data.structures.classification.Operation;
import data.structures.tagging.LemmaItem;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LemmePondere {
    private String lemme;
    private Vector<Operation> origine;
    private Vector<Double> poidsOrigine;
    private String categorie;
    private int diviseurTaille = 1;
    private double poidsCategorie = 1.0;
    private int nbOccurences;

    public LemmePondere(String lemme, Vector<Operation> origine, String categorie, int nbOccurences) {
        this.lemme = lemme;
        this.origine = origine;
        this.poidsOrigine = new Vector(origine.size());
        for (int i = 0; i < this.poidsOrigine.size(); ++i) {
            this.poidsOrigine.setElementAt(new Double(1.0), i);
        }
        this.categorie = categorie;
        this.nbOccurences = nbOccurences;
    }

    public String getCategorie() {
        return this.categorie;
    }

    public double getPoidsCategorie() {
        return this.poidsCategorie;
    }

    public Vector<Operation> getOrigine() {
        return this.origine;
    }

    public double getPoidsOrigine() {
        double po = 1.0;
        for (int i = 0; i < this.poidsOrigine.size(); ++i) {
            po *= this.poidsOrigine.elementAt(i).doubleValue();
        }
        return po / (double)this.diviseurTaille;
    }

    public String getLemme() {
        return this.lemme;
    }

    public void pondereOrigine(Operation orig, double poids) {
        for (int i = 0; i < this.poidsOrigine.size(); ++i) {
            if (!this.origine.elementAt(i).equals(orig)) continue;
            this.poidsOrigine.setElementAt(new Double(poids), i);
        }
    }

    public void pondereCategorie(double poids) {
        this.poidsCategorie = poids;
    }

    public void pondereTaille(int taille) {
        this.diviseurTaille = taille;
    }

    public int getNbOccurences() {
        return this.nbOccurences;
    }

    public void addNbOccurences(int nb) {
        this.nbOccurences += nb;
    }

    public LemmaItem toLemmaItem() {
        LemmaItem l = new LemmaItem();
        l.setCountTitle(0);
        l.setCountDesc(0);
        l.setLemmaName(this.lemme);
        l.setLemmaLex(this.categorie);
        l.setNodeID(0);
        return l;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LemmePondere other = (LemmePondere)obj;
        if (this.lemme == null ? other.lemme != null : !this.lemme.equalsIgnoreCase(other.lemme)) {
            return false;
        }
        if (this.categorie == null || other.categorie == null) {
            return true;
        }
        return this.categorie.equalsIgnoreCase(other.categorie);
    }

    public int hashCode() {
        return this.lemme.hashCode();
    }
}

