/*
 * Decompiled with CFR 0.152.
 */
package data.structures.analyse;

import data.structures.analyse.Article;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;

public class SacArticles {
    private Map<Integer, Article> listeArticles;
    private String titre;
    private Vector<String> ressources;

    public SacArticles(String titre) {
        this.titre = titre;
        this.listeArticles = new HashMap<Integer, Article>();
        this.ressources = new Vector();
        this.addRessource(titre);
    }

    public String getTitre() {
        return this.titre;
    }

    public void setTitre(String titre) {
        this.titre = titre;
    }

    public void addArticle(Article a) {
        this.listeArticles.put(new Integer(a.getId()), a);
    }

    public Article getArticle(int id) {
        return this.listeArticles.get(new Integer(id));
    }

    public void addRessource(String ressource) {
        this.ressources.addElement(ressource);
    }

    public String[] getRessources() {
        String[] res = new String[this.ressources.size()];
        this.ressources.toArray(res);
        return res;
    }

    public String[] recycleEnRessources() {
        Vector res0 = (Vector)this.ressources.clone();
        for (int i = 0; i < this.getArticles().length; ++i) {
            String ressource = this.getArticles()[i].getTitre();
            res0.addElement(ressource);
            ressource = this.getArticles()[i].getDescription();
            res0.addElement(ressource);
        }
        String[] res = new String[res0.size()];
        res0.toArray(res);
        return res;
    }

    public Article[] getArticles() {
        Article[] res = new Article[this.listeArticles.values().size()];
        this.listeArticles.values().toArray(res);
        return res;
    }

    public boolean contientArticle(Article a) {
        Article[] liste = this.getArticles();
        boolean res = false;
        for (int i = 0; i < liste.length; ++i) {
            if (!a.equals(liste[i])) continue;
            res = true;
            break;
        }
        return res;
    }

    public void removeArticle(Article a) {
        this.listeArticles.remove(new Integer(a.getId()));
    }

    public void addAll(SacArticles a) {
        int i;
        Article[] liste = a.getArticles();
        for (i = 0; i < liste.length; ++i) {
            this.addArticle(liste[i]);
        }
        this.addRessource(a.titre);
        for (i = 0; i < a.getRessources().length; ++i) {
            this.addRessource(a.getRessources()[i]);
        }
    }

    public SacArticles clone() {
        SacArticles clone = new SacArticles(this.titre);
        Article[] aCopier = this.getArticles();
        for (int i = 0; i < aCopier.length; ++i) {
            clone.addArticle(aCopier[i].clone());
        }
        return clone;
    }

    String getSauvegarde() {
        String s = "<Titre>" + this.getTitre() + "</Titre>\n";
        Article[] aCopier = this.getArticles();
        for (int i = 0; i < aCopier.length; ++i) {
            s = s + "<Article>\n" + aCopier[i].getSauvegarde() + "</Article>\n";
        }
        String[] aCopier2 = this.getRessources();
        for (int i = 0; i < aCopier2.length; ++i) {
            s = s + "<Ressource>\n" + aCopier2[i] + "</Ressource>\n";
        }
        return s;
    }

    void sauvegarde(FileWriter out) throws IOException {
        out.write("<Titre>" + this.getTitre() + "</Titre>\n");
        Article[] aCopier = this.getArticles();
        for (int i = 0; i < aCopier.length; ++i) {
            out.write("<Article>\n");
            aCopier[i].sauvegarde(out);
            out.write("</Article>\n");
        }
        String[] aCopier2 = this.getRessources();
        for (int i = 0; i < aCopier2.length; ++i) {
            out.write("<Ressource>\n" + aCopier2[i] + "</Ressource>\n");
        }
    }

    static SacArticles charge(String sauvegarde) {
        String s0 = sauvegarde.split("</Titre>")[0];
        s0 = s0.replaceAll("<Titre>", "");
        SacArticles res = new SacArticles(s0);
        String[] s = sauvegarde.split("<Article>");
        for (int i = 1; i < s.length; ++i) {
            String save = s[i].substring(0, s[i].indexOf("</Article>")).trim();
            res.addArticle(Article.charge(save));
        }
        String[] s2 = sauvegarde.split("<Ressource>");
        for (int i = 1; i < s2.length; ++i) {
            String save = s2[i].substring(0, s2[i].indexOf("</Ressource>")).trim();
            res.addRessource(save);
        }
        return res;
    }

    public String toString() {
        int g = 0;
        int o = 0;
        int r = 0;
        Article[] a = this.getArticles();
        for (int i = 0; i < a.length; ++i) {
            if (a[i].getStatut() == 0) {
                ++g;
                continue;
            }
            if (a[i].getStatut() == 1) {
                ++r;
                continue;
            }
            ++o;
        }
        String s = "";
        if (g > 0) {
            s = s + "<span style=\"color:#00C000\">" + g + "</span>";
        }
        if (g > 0 && (o > 0 || r > 0)) {
            s = s + ", ";
        }
        if (o > 0) {
            s = s + "<span style=\"color:#C08000\">" + o + "</span>";
        }
        if (o > 0 && r > 0) {
            s = s + ", ";
        }
        if (r > 0) {
            s = s + "<span style=\"color:#C00000\">" + r + "</span>";
        }
        return "<html>[" + s + "] " + this.titre;
    }
}

