/*
 * Decompiled with CFR 0.152.
 */
package data.structures.analyse;

import java.io.FileWriter;
import java.io.IOException;

public class Article {
    private int id;
    private String titre;
    private String description;
    private String[] lemmesTitre;
    private String[] lemmesDescription;
    private String url;
    private String source;
    private String datePubli;
    private int statut;
    public static final int VALIDE = 0;
    public static final int SUGGERE = 1;
    public static final int INITIAL = 2;

    public Article(int id, String titre, String description, String[] lemmesTitre, String[] lemmesDescription, String url, String source, String datePubli, int statut) {
        this.id = id;
        this.titre = titre;
        this.description = description;
        this.lemmesTitre = lemmesTitre;
        this.lemmesDescription = lemmesDescription;
        this.url = url;
        this.source = source;
        this.datePubli = datePubli;
        this.statut = statut;
        if (statut != 0 && statut != 2) {
            statut = 1;
        }
    }

    public int getStatut() {
        return this.statut;
    }

    public void setStatut(int statut) {
        this.statut = statut;
        if (statut != 0 && statut != 2) {
            statut = 1;
        }
    }

    public int getId() {
        return this.id;
    }

    public String getDescription() {
        return this.description;
    }

    public String[] getLemmesDescription() {
        return this.lemmesDescription;
    }

    public String[] getLemmesTitre() {
        return this.lemmesTitre;
    }

    public String getSource() {
        return this.source;
    }

    public String getTitre() {
        return this.titre;
    }

    public String getDatePubli() {
        return this.datePubli;
    }

    public String getUrl() {
        return this.url;
    }

    public boolean equals(Object obj) {
        return this.id == ((Article)obj).id;
    }

    public int hashCode() {
        return this.id + this.titre.hashCode() + this.description.hashCode() + this.url.hashCode();
    }

    public Article clone() {
        return new Article(this.id, this.titre, this.description, this.lemmesTitre, this.lemmesDescription, this.url, this.source, this.datePubli, this.statut);
    }

    String getSauvegarde() {
        int i;
        String s = "<Id>" + this.id + "</Id>";
        s = s + "<Titre>" + this.titre + "</Titre>";
        s = s + "<Description>" + this.description + "</Description>";
        s = s + "<LemmesTitre>";
        for (i = 0; i < this.lemmesTitre.length; ++i) {
            s = s + this.lemmesTitre[i];
            if (i >= this.lemmesTitre.length - 1) continue;
            s = s + "|";
        }
        s = s + "</LemmesTitre>";
        s = s + "<LemmesDescription>";
        for (i = 0; i < this.lemmesDescription.length; ++i) {
            s = s + this.lemmesDescription[i];
            if (i >= this.lemmesDescription.length - 1) continue;
            s = s + "|";
        }
        s = s + "</LemmesDescription>";
        s = s + "<Url>" + this.url + "</Url>";
        s = s + "<Source>" + this.source + "</Source>";
        s = s + "<DatePubli>" + this.datePubli + "</DatePubli>";
        s = s + "<Statut>" + this.statut + "</Statut>";
        return s;
    }

    void sauvegarde(FileWriter out) throws IOException {
        int i;
        out.write("<Id>" + this.id + "</Id>");
        out.write("<Titre>" + this.titre + "</Titre>");
        out.write("<Description>" + this.description + "</Description>");
        out.write("<LemmesTitre>");
        for (i = 0; i < this.lemmesTitre.length; ++i) {
            out.write(this.lemmesTitre[i]);
            if (i >= this.lemmesTitre.length - 1) continue;
            out.write("|");
        }
        out.write("</LemmesTitre>");
        out.write("<LemmesDescription>");
        for (i = 0; i < this.lemmesDescription.length; ++i) {
            out.write(this.lemmesDescription[i]);
            if (i >= this.lemmesDescription.length - 1) continue;
            out.write("|");
        }
        out.write("</LemmesDescription>");
        out.write("<Url>" + this.url + "</Url>");
        out.write("<Source>" + this.source + "</Source>");
        out.write("<DatePubli>" + this.datePubli + "</DatePubli>");
        out.write("<Statut>" + this.statut + "</Statut>");
    }

    static Article charge(String sauvegarde) {
        int id = Integer.parseInt(sauvegarde.split("<Id>")[1].split("</Id>")[0].trim());
        String titre = sauvegarde.split("<Titre>")[1].split("</Titre>")[0].trim();
        String description = sauvegarde.split("<Description>")[1].split("</Description>")[0].trim();
        String url = sauvegarde.split("<Url>")[1].split("</Url>")[0].trim();
        String source = sauvegarde.split("<Source>")[1].split("</Source>")[0].trim();
        String datePubli = sauvegarde.split("<DatePubli>")[1].split("</DatePubli>")[0].trim();
        int statut = Integer.parseInt(sauvegarde.split("<Statut>")[1].split("</Statut>")[0].trim());
        Article res = new Article(id, titre, description, new String[0], new String[0], url, source, datePubli, statut);
        return res;
    }

    public String toString() {
        return "<html><b>[" + this.source + "]</b> - " + this.datePubli + "<br>" + this.titre + "<br><i><font size=\"-1\">" + this.description + "</font><i></html>";
    }
}

