/*
 * Decompiled with CFR 0.152.
 */
package data.base.connectors;

import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.QueryExecutionFactory;
import com.hp.hpl.jena.query.QueryFactory;
import com.hp.hpl.jena.query.QuerySolution;
import com.hp.hpl.jena.query.ResultSet;
import data.base.Database;
import data.base.NoBaseException;
import data.base.connectors.CacheDatabase;
import data.base.connectors.OntologieDatabase;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Vector;

public class SemanticDatabase {
    private String remoteService;
    private String foaf;
    private String rdfs;
    private String rdf;
    private Database myDB;

    public SemanticDatabase(Database db) {
        this.myDB = db;
        this.remoteService = "http://dbpedia.org/sparql";
        this.rdfs = "PREFIX rdfs: <http://www.w3.org/2000/01/rdf-schema#>";
        this.foaf = "PREFIX foaf: <http://xmlns.com/foaf/0.1/>";
        this.rdf = "PREFIX rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#>";
    }

    public String sendQuery(String query) {
        String result = "";
        try {
            String myQuery = this.foaf + " " + this.rdfs + " " + this.rdf + " " + query;
            Query yourSparqlQuery = QueryFactory.create((String)myQuery);
            QueryExecution qehttp = QueryExecutionFactory.sparqlService((String)this.remoteService, (Query)yourSparqlQuery);
            ResultSet rs = qehttp.execSelect();
            while (rs.hasNext()) {
                result = result + rs.next().toString();
            }
            qehttp.close();
        }
        catch (Exception e) {
            result = "Echec de l'interrogation : " + e.getMessage();
        }
        return result;
    }

    public ArrayList getCandidatesURI(String unknown, String ressource) {
        ArrayList<String> result = new ArrayList<String>();
        try {
            String myQuery = this.foaf + " " + this.rdfs + " " + this.rdf + " SELECT * WHERE { ?x rdfs:label ?label." + " FILTER (lang(?label) = 'fr') " + " ?x rdf:type <" + ressource + ">." + " FILTER (regex(?label, '" + unknown + "', 'i'))" + " } LIMIT 40";
            Query yourSparqlQuery = QueryFactory.create((String)myQuery);
            QueryExecution qehttp = QueryExecutionFactory.sparqlService((String)this.remoteService, (Query)yourSparqlQuery);
            ResultSet rs = qehttp.execSelect();
            while (rs.hasNext()) {
                QuerySolution soln = rs.next();
                result.add(soln.get("x").toString());
            }
            qehttp.close();
        }
        catch (Exception e) {
            System.out.println("echec " + e.getMessage());
        }
        return result;
    }

    public boolean isCategorieDe(String categorie, String concept) {
        String myQuery = this.foaf + " " + this.rdfs + " " + this.rdf + " SELECT * WHERE { ?x rdfs:label ?label." + " FILTER (lang(?label) = 'fr') " + " ?x rdf:type <" + categorie + ">." + " FILTER (regex(?label, '" + concept + "', 'i'))" + " } LIMIT 40";
        System.out.println(myQuery);
        Query yourSparqlQuery = QueryFactory.create((String)myQuery);
        QueryExecution qehttp = QueryExecutionFactory.sparqlService((String)this.remoteService, (Query)yourSparqlQuery);
        ResultSet rs = qehttp.execSelect();
        boolean result = rs.hasNext();
        System.out.println(categorie + " est-il une cat\u00e9gorie de " + concept + " ? " + result);
        qehttp.close();
        return result;
    }

    public String[] getGeneralisation(String concept) throws NoBaseException {
        CacheDatabase cdb = new CacheDatabase(this.myDB);
        String[] ontos = this.getHigherLevels();
        System.out.println("!!Traitement du concept : " + concept);
        System.out.println("*Concept absent de la base");
        HashSet<String> result = new HashSet<String>();
        for (int i = 0; i < ontos.length; ++i) {
            String query = this.foaf + " " + this.rdfs + " " + this.rdf + " SELECT DISTINCT ?cat WHERE {" + " ?x rdfs:label ?label. FILTER (lang(?label) = 'fr')" + " ?x rdf:type <" + ontos[i] + ">. FILTER (regex(?label, '" + concept + "', 'i'))" + " ?x rdf:type ?cat." + " } ";
            Query yourSparqlQuery = QueryFactory.create((String)query);
            QueryExecution qehttp = QueryExecutionFactory.sparqlService((String)this.remoteService, (Query)yourSparqlQuery);
            ResultSet rs = qehttp.execSelect();
            while (rs.hasNext()) {
                QuerySolution soln = rs.next();
                result.add(soln.get("cat").toString().trim());
            }
            qehttp.close();
        }
        System.out.println("*" + concept + " : " + result.size() + " cat\u00e9gories.");
        System.out.println("*Suppression des cat\u00e9gories Yago (r\u00e9sultat pertinent peu probable)");
        Vector v = new Vector(result);
        for (int i = 0; i < v.size(); ++i) {
            String s = (String)v.elementAt(i);
            if (s.indexOf("class/yago") <= -1) continue;
            result.remove(s);
        }
        System.out.println("*" + concept + " : " + result.size() + " cat\u00e9gories conserv\u00e9es.");
        String[] res = new String[result.size()];
        result.toArray(res);
        for (int i = 0; i < res.length; ++i) {
            res[i] = res[i].split("@")[0];
        }
        return res;
    }

    public String[] getSubGeneralisation(String concept) throws NoBaseException {
        CacheDatabase cdb = new CacheDatabase(this.myDB);
        String[] ontos = this.getHigherLevels();
        System.out.println("##Traitement du concept : " + concept);
        HashSet<String> result = new HashSet<String>();
        for (int i = 0; i < ontos.length; ++i) {
            String query = this.foaf + " " + this.rdfs + " " + this.rdf + " SELECT DISTINCT ?cat WHERE {" + " <" + concept + "> rdfs:subClassOf ?cat. " + " } ";
            Query yourSparqlQuery = QueryFactory.create((String)query);
            QueryExecution qehttp = QueryExecutionFactory.sparqlService((String)this.remoteService, (Query)yourSparqlQuery);
            ResultSet rs = qehttp.execSelect();
            while (rs.hasNext()) {
                QuerySolution soln = rs.next();
                result.add(soln.get("cat").toString().trim());
            }
            qehttp.close();
        }
        HashSet<String> result2 = new HashSet<String>();
        for (String s : result) {
            String[] ss = this.getSubSubGeneralisation(s);
            for (int j = 0; j < ss.length; ++j) {
                result2.add(ss[j]);
            }
        }
        result.addAll(result2);
        result.remove(concept);
        System.out.println("***" + concept + " : " + result.size() + " cat\u00e9gories conserv\u00e9es.");
        String[] res = new String[result.size()];
        result.toArray(res);
        for (int i = 0; i < res.length; ++i) {
            res[i] = res[i].split("@")[0];
        }
        return res;
    }

    public String[] getSubSubGeneralisation(String concept) throws NoBaseException {
        CacheDatabase cdb = new CacheDatabase(this.myDB);
        String[] ontos = this.getHigherLevels();
        HashSet<String> result = new HashSet<String>();
        for (int i = 0; i < ontos.length; ++i) {
            String query = this.foaf + " " + this.rdfs + " " + this.rdf + " SELECT DISTINCT ?cat WHERE {" + " <" + concept + "> rdfs:subClassOf ?cat. " + " } ";
            Query yourSparqlQuery = QueryFactory.create((String)query);
            QueryExecution qehttp = QueryExecutionFactory.sparqlService((String)this.remoteService, (Query)yourSparqlQuery);
            ResultSet rs = qehttp.execSelect();
            while (rs.hasNext()) {
                QuerySolution soln = rs.next();
                result.add(soln.get("cat").toString().trim());
            }
            qehttp.close();
        }
        HashSet<String> result2 = new HashSet<String>();
        for (String s : result) {
            String[] ss = this.getSubSubGeneralisation(s);
            for (int j = 0; j < ss.length; ++j) {
                result2.add(ss[j]);
            }
        }
        result.addAll(result2);
        result.remove(concept);
        String[] res = new String[result.size()];
        result.toArray(res);
        for (int i = 0; i < res.length; ++i) {
            res[i] = res[i].split("@")[0];
        }
        return res;
    }

    public String[] getGeneralisationStricte(String concept, int niveaux) throws NoBaseException {
        int i;
        String[] premierResultat = this.getGeneralisation(concept);
        System.out.println("*" + premierResultat.length + " cat\u00e9gories trouv\u00e9es en premier examen.");
        System.out.print("*");
        for (int i2 = 0; i2 < premierResultat.length; ++i2) {
            System.out.print(this.f(premierResultat[i2]) + " ; ");
        }
        System.out.println("");
        HashSet<String> aVerifier = new HashSet<String>();
        for (int i3 = 0; i3 < premierResultat.length; ++i3) {
            aVerifier.add(premierResultat[i3]);
        }
        System.out.println("*" + aVerifier.size() + " cat\u00e9gories uniques.");
        if (aVerifier.size() >= 100) {
            System.out.println("*Trop de cat\u00e9gories. Mot vide.");
            aVerifier.clear();
        } else {
            Vector liste = new Vector(aVerifier);
            for (i = 0; i < liste.size(); ++i) {
                String[] gene;
                String s = (String)liste.elementAt(i);
                if (!aVerifier.contains(s) || (gene = this.getSubGeneralisation(s)).length <= 0) continue;
                boolean removed = false;
                for (int j = 0; j < gene.length; ++j) {
                    if (!aVerifier.contains(gene[j])) continue;
                    if (!removed) {
                        System.out.print("***Nettoyage de la liste des cat\u00e9gories : suppression de ");
                        removed = true;
                    }
                    aVerifier.remove(gene[j]);
                    System.out.print(gene[j] + " ; ");
                }
                if (!removed) continue;
                System.out.println("");
            }
        }
        String[] resultat = new String[aVerifier.size()];
        aVerifier.toArray(resultat);
        System.out.println("*" + resultat.length + " cat\u00e9gories retenues.");
        System.out.print("*");
        for (i = 0; i < resultat.length; ++i) {
            resultat[i] = this.f(resultat[i]);
            System.out.print(resultat[i] + " ; ");
        }
        System.out.println("");
        return resultat;
    }

    private String f(String url) {
        String[] s = url.split("\\/");
        return s[s.length - 1];
    }

    public String[] getHigherLevels() throws NoBaseException {
        ArrayList ontologiesIDs = new ArrayList();
        Vector<String> ontologies = new Vector<String>();
        OntologieDatabase odb = new OntologieDatabase(this.myDB);
        ontologiesIDs = odb.getHigherNodes();
        for (int i = 0; i < ontologiesIDs.size(); ++i) {
            int id = Integer.parseInt(ontologiesIDs.get(i).toString());
            ontologies.add(odb.getRessource(id));
        }
        String[] result = new String[ontologies.size()];
        ontologies.toArray(result);
        return result;
    }

    public ArrayList getlowerLevels() throws NoBaseException {
        ArrayList ontologiesIDs = new ArrayList();
        ArrayList<String> ontologies = new ArrayList<String>();
        OntologieDatabase odb = new OntologieDatabase(this.myDB);
        ontologiesIDs = odb.getLowerNodes();
        for (int i = 0; i < ontologiesIDs.size(); ++i) {
            int id = Integer.parseInt(ontologiesIDs.get(i).toString());
            ontologies.add(odb.getRessource(id));
        }
        return ontologies;
    }
}

