/*
 * Decompiled with CFR 0.152.
 */
package data.base.connectors;

import data.base.Config;
import data.base.Database;
import data.base.NoBaseException;
import data.structures.analyse.SousCorpus;
import data.structures.rss.BaseRSSItem;
import data.structures.rss.RSSFeedInfo;
import data.structures.rss.RSSFeedInfoExtended;
import data.structures.rss.RSSItem;
import data.structures.rss.RSSItemCount;
import data.structures.rss.SujetBrut;
import data.structures.rss.SujetTraite;
import data.structures.rss.Tag;
import data.structures.tagging.LemmaItem;
import java.io.File;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import proc.text.Codecs;
import proc.text.Out;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RSSFeedDatabase {
    public static final int TAGS_CATEGORIE = 100;
    public static final int TAGS_PAYS = 200;
    public static final int TAGS_COUVERTURE = 300;
    public static final int TAGS_INFORMATION = 400;
    public static final int TAGS_EXTERNE = 900;
    private Database theDB;
    private static Date[] lastFeedDates;
    private static Date lastNewsDates;
    private Map<Integer, String> feedNames = new HashMap<Integer, String>();
    private Map<String, Integer> feedIds = new HashMap<String, Integer>();
    private Map<Integer, String> feedUrls = new HashMap<Integer, String>();

    public RSSFeedDatabase(Database db) throws NoBaseException {
        this.theDB = db;
        if (lastFeedDates == null) {
            Vector<RSSFeedInfo> feedList = this.GetRSSFeedList();
            int max = 0;
            for (int i = 0; i < feedList.size(); ++i) {
                int id = Integer.parseInt(feedList.elementAt((int)i).ID);
                if (id <= max) continue;
                max = id;
            }
            lastFeedDates = new Date[max + 1];
        }
    }

    public Tag[] getTags(int type) throws NoBaseException {
        String query = "SELECT id, tag FROM rss_tags WHERE id BETWEEN " + type + " AND " + (type + 99) + ";";
        ResultSet tags = this.theDB.executeSelection(query);
        Vector<Tag> res = new Vector<Tag>();
        if (tags != null) {
            try {
                while (tags.next()) {
                    int id = tags.getInt("id");
                    String tag = Codecs.desEscapeHTML(tags.getString("tag"));
                    res.addElement(new Tag(id, tag));
                }
                tags.close();
            }
            catch (Exception e) {
                return new Tag[0];
            }
        }
        Tag[] res2 = new Tag[res.size()];
        res.toArray(res2);
        return res2;
    }

    public Tag[] getTagsOfFeed(int feedId, int type) throws NoBaseException {
        String query = "SELECT t.id, t.tag FROM rss_tags t, rss_tagflux f WHERE f.flux=" + feedId + " AND f.tag=t.id " + "AND t.id BETWEEN " + type + " AND " + (type + 99) + ";";
        ResultSet tags = this.theDB.executeSelection(query);
        Vector<Tag> res = new Vector<Tag>();
        if (tags != null) {
            try {
                while (tags.next()) {
                    int id = tags.getInt("id");
                    String tag = Codecs.desEscapeHTML(tags.getString("tag"));
                    res.addElement(new Tag(id, tag));
                }
                tags.close();
            }
            catch (Exception e) {
                return new Tag[0];
            }
        }
        Tag[] res2 = new Tag[res.size()];
        res.toArray(res2);
        return res2;
    }

    public String getFeedName(int feedId) throws NoBaseException {
        String query;
        ResultSet feedName;
        String res = this.feedNames.get(new Integer(feedId));
        if (res == null && (feedName = this.theDB.executeSelection(query = "SELECT nom FROM rss_flux WHERE id=" + feedId + ";")) != null) {
            try {
                while (feedName.next()) {
                    String nom;
                    res = nom = Codecs.desEscapeHTML(feedName.getString("nom"));
                }
                feedName.close();
            }
            catch (Exception e) {
                res = "";
            }
            this.feedNames.put(new Integer(feedId), res);
        }
        return res;
    }

    public int findFeedId(String feedName) throws NoBaseException {
        String query;
        ResultSet feedId;
        Integer res = this.feedIds.get(feedName);
        if (res == null && (feedId = this.theDB.executeSelection(query = "SELECT id FROM rss_flux WHERE nom=\"" + feedName + "\" LIMIT 1;")) != null) {
            try {
                while (feedId.next()) {
                    int id = feedId.getInt("id");
                    res = new Integer(id);
                }
                feedId.close();
            }
            catch (Exception e) {
                // empty catch block
            }
            if (res == null) {
                res = new Integer(-1);
            }
            this.feedIds.put(feedName, res);
        }
        return res;
    }

    public String getFeedURL(int feedId) throws NoBaseException {
        String query;
        ResultSet feedName;
        String res = this.feedUrls.get(new Integer(feedId));
        if (res == null && (feedName = this.theDB.executeSelection(query = "SELECT url FROM rss_flux WHERE id=" + feedId + ";")) != null) {
            try {
                while (feedName.next()) {
                    String url;
                    res = url = Codecs.desEscapeHTML(feedName.getString("url"));
                }
                feedName.close();
            }
            catch (Exception e) {
                res = "";
            }
            this.feedUrls.put(new Integer(feedId), res);
        }
        return res;
    }

    public Vector<RSSFeedInfo> GetRSSFeedList() throws NoBaseException {
        Vector<RSSFeedInfo> laListe = new Vector<RSSFeedInfo>();
        ResultSet feeds = this.theDB.executeSelection("SELECT * from rss_flux;");
        if (feeds != null) {
            try {
                while (feeds.next()) {
                    String id = Codecs.desEscapeHTML(feeds.getString("id"));
                    String url = Codecs.desEscapeHTML(feeds.getString("url"));
                    RSSFeedInfo inf = new RSSFeedInfo();
                    inf.ID = id;
                    inf.URL = url;
                    laListe.add(inf);
                }
                feeds.close();
            }
            catch (Exception e) {
                laListe = null;
            }
        }
        return laListe;
    }

    public Vector<RSSFeedInfoExtended> GetExtendedRSSFeedList() throws NoBaseException {
        Vector<RSSFeedInfoExtended> laListe = new Vector<RSSFeedInfoExtended>();
        ResultSet feeds = this.theDB.executeSelection("SELECT id, url, nom from rss_flux;");
        if (feeds != null) {
            try {
                while (feeds.next()) {
                    String id = Codecs.desEscapeHTML(feeds.getString(1));
                    String url = Codecs.desEscapeHTML(feeds.getString(2));
                    String name = Codecs.desEscapeHTML(feeds.getString(3));
                    RSSFeedInfoExtended inf = new RSSFeedInfoExtended();
                    inf.ID = id;
                    inf.URL = url;
                    inf.name = name;
                    laListe.add(inf);
                }
                feeds.close();
            }
            catch (Exception e) {
                return null;
            }
        }
        return laListe;
    }

    public Vector<RSSFeedInfoExtended> getExtendedRSSFeedList(Tag[] tagsAcceptes) throws NoBaseException {
        int i;
        Vector<Tag> listeCategories = new Vector<Tag>();
        Vector<Tag> listePays = new Vector<Tag>();
        Vector<Tag> listeCouvertures = new Vector<Tag>();
        Vector<Tag> listeInformations = new Vector<Tag>();
        Vector<Tag> listeExterne = new Vector<Tag>();
        for (int i2 = 0; i2 < tagsAcceptes.length; ++i2) {
            if (tagsAcceptes[i2].getId() >= 100 && tagsAcceptes[i2].getId() < 200) {
                listeCategories.addElement(tagsAcceptes[i2]);
                continue;
            }
            if (tagsAcceptes[i2].getId() >= 200 && tagsAcceptes[i2].getId() < 300) {
                listePays.addElement(tagsAcceptes[i2]);
                continue;
            }
            if (tagsAcceptes[i2].getId() >= 300 && tagsAcceptes[i2].getId() < 400) {
                listeCouvertures.addElement(tagsAcceptes[i2]);
                continue;
            }
            if (tagsAcceptes[i2].getId() >= 400 && tagsAcceptes[i2].getId() < 900) {
                listeInformations.addElement(tagsAcceptes[i2]);
                continue;
            }
            listeExterne.addElement(tagsAcceptes[i2]);
        }
        String s = "SELECT id, url, nom FROM rss_flux f, rss_tagflux t WHERE t.flux=f.id AND (t.tag=";
        for (i = 0; i < listeCategories.size(); ++i) {
            s = s + "" + ((Tag)listeCategories.elementAt(i)).getId();
            if (i >= listeCategories.size() - 1) continue;
            s = s + " OR t.tag=";
        }
        s = s + ") AND f.id IN (SELECT id FROM rss_flux f, rss_tagflux t WHERE t.flux=f.id AND (t.tag=";
        for (i = 0; i < listePays.size(); ++i) {
            s = s + "" + ((Tag)listePays.elementAt(i)).getId();
            if (i >= listePays.size() - 1) continue;
            s = s + " OR t.tag=";
        }
        s = s + ") AND f.id IN (SELECT id FROM rss_flux f, rss_tagflux t WHERE t.flux=f.id AND (t.tag=";
        for (i = 0; i < listeCouvertures.size(); ++i) {
            s = s + "" + ((Tag)listeCouvertures.elementAt(i)).getId();
            if (i >= listeCouvertures.size() - 1) continue;
            s = s + " OR t.tag=";
        }
        s = s + ") AND f.id IN (SELECT id FROM rss_flux f, rss_tagflux t WHERE t.flux=f.id AND (t.tag=";
        for (i = 0; i < listeInformations.size(); ++i) {
            s = s + "" + ((Tag)listeInformations.elementAt(i)).getId();
            if (i >= listeInformations.size() - 1) continue;
            s = s + " OR t.tag=";
        }
        s = s + "))));";
        Vector<RSSFeedInfoExtended> laListe = new Vector<RSSFeedInfoExtended>();
        ResultSet feeds = this.theDB.executeSelection(s);
        if (feeds != null) {
            try {
                while (feeds.next()) {
                    String id = Codecs.desEscapeHTML(feeds.getString(1));
                    String url = Codecs.desEscapeHTML(feeds.getString(2));
                    String name = Codecs.desEscapeHTML(feeds.getString(3));
                    RSSFeedInfoExtended inf = new RSSFeedInfoExtended();
                    inf.ID = id;
                    inf.URL = url;
                    inf.name = name;
                    laListe.add(inf);
                }
                feeds.close();
            }
            catch (Exception e) {
                return null;
            }
        }
        return laListe;
    }

    public Date GetFeedLastEntryDate(int feedID) throws NoBaseException {
        if (lastFeedDates[feedID] == null) {
            Date theDate = new Date(Config.getDateDepartCorpus());
            String query = "SELECT MAX(datePubli) FROM rss_articles WHERE flux = " + feedID;
            String queryCount = "SELECT COUNT(datePubli) FROM rss_articles  WHERE flux = " + feedID;
            ResultSet dateCount = this.theDB.executeSelection(queryCount);
            boolean areDates = false;
            try {
                areDates = dateCount.next();
                areDates = dateCount.getInt(1) > 0;
                dateCount.close();
            }
            catch (Exception e) {
                return theDate;
            }
            ResultSet dateRes = this.theDB.executeSelection(query);
            if (areDates) {
                try {
                    while (dateRes.next()) {
                        theDate = dateRes.getTimestamp(1);
                    }
                    dateRes.close();
                }
                catch (Exception e) {
                    return theDate;
                }
            }
            RSSFeedDatabase.lastFeedDates[feedID] = theDate;
            return theDate;
        }
        return lastFeedDates[feedID];
    }

    public RSSItem[] listeArticlesRSS(Date debut, Date fin, SousCorpus tagsAcceptes) throws NoBaseException {
        int i;
        Vector<Tag> listeCategories = new Vector<Tag>();
        Vector<Tag> listePays = new Vector<Tag>();
        Vector<Tag> listeCouvertures = new Vector<Tag>();
        Vector<Tag> listeInformations = new Vector<Tag>();
        for (int i2 = 0; i2 < tagsAcceptes.listeTagsAcceptes().length; ++i2) {
            if (tagsAcceptes.listeTagsAcceptes()[i2] >= 100 && tagsAcceptes.listeTagsAcceptes()[i2] < 200) {
                listeCategories.addElement(new Tag(tagsAcceptes.listeTagsAcceptes()[i2], ""));
                continue;
            }
            if (tagsAcceptes.listeTagsAcceptes()[i2] >= 200 && tagsAcceptes.listeTagsAcceptes()[i2] < 300) {
                listePays.addElement(new Tag(tagsAcceptes.listeTagsAcceptes()[i2], ""));
                continue;
            }
            if (tagsAcceptes.listeTagsAcceptes()[i2] >= 300 && tagsAcceptes.listeTagsAcceptes()[i2] < 400) {
                listeCouvertures.addElement(new Tag(tagsAcceptes.listeTagsAcceptes()[i2], ""));
                continue;
            }
            if (tagsAcceptes.listeTagsAcceptes()[i2] < 400 || tagsAcceptes.listeTagsAcceptes()[i2] >= 900) continue;
            listeInformations.addElement(new Tag(tagsAcceptes.listeTagsAcceptes()[i2], ""));
        }
        String s = String.format("SELECT * FROM rss_articles WHERE datePubli >= '%tY-%tm-%td 00:00:00' AND datePubli < '%tY-%tm-%td 00:00:00' AND flux IN (SELECT id FROM rss_flux f, rss_tagflux t WHERE t.flux=f.id AND ", debut, debut, debut, fin, fin, fin);
        s = s + "(t.tag=";
        for (i = 0; i < listeCategories.size(); ++i) {
            s = s + "" + ((Tag)listeCategories.elementAt(i)).getId();
            if (i >= listeCategories.size() - 1) continue;
            s = s + " OR t.tag=";
        }
        s = s + ") AND f.id IN (SELECT id FROM rss_flux f, rss_tagflux t WHERE t.flux=f.id AND (t.tag=";
        for (i = 0; i < listePays.size(); ++i) {
            s = s + "" + ((Tag)listePays.elementAt(i)).getId();
            if (i >= listePays.size() - 1) continue;
            s = s + " OR t.tag=";
        }
        s = s + ") AND f.id IN (SELECT id FROM rss_flux f, rss_tagflux t WHERE t.flux=f.id AND (t.tag=";
        for (i = 0; i < listeCouvertures.size(); ++i) {
            s = s + "" + ((Tag)listeCouvertures.elementAt(i)).getId();
            if (i >= listeCouvertures.size() - 1) continue;
            s = s + " OR t.tag=";
        }
        s = s + ") AND f.id IN (SELECT id FROM rss_flux f, rss_tagflux t WHERE t.flux=f.id AND (t.tag=";
        for (i = 0; i < listeInformations.size(); ++i) {
            s = s + "" + ((Tag)listeInformations.elementAt(i)).getId();
            if (i >= listeInformations.size() - 1) continue;
            s = s + " OR t.tag=";
        }
        s = s + ")))));";
        Vector<RSSItem> res = new Vector<RSSItem>();
        ResultSet articles = this.theDB.executeSelection(s);
        try {
            while (articles.next()) {
                RSSItem article = new RSSItem();
                article.setId(new Integer(articles.getInt("id")));
                article.setIdFluxRSS(new Integer(articles.getInt("flux")));
                article.setPubDate(articles.getTimestamp("datePubli"));
                article.setPubTime(articles.getTime("datePubli"));
                article.setTitle(Codecs.desEscapeHTML(articles.getString("titre")));
                article.setDescription(Codecs.desEscapeHTML(articles.getString("description")));
                article.setLink(Codecs.desEscapeURL(articles.getString("url")));
                article.setTitleLemmes(Codecs.desEscapeHTML(articles.getString("titreLemma")));
                article.setDescLemmes(Codecs.desEscapeHTML(articles.getString("descLemma")));
                res.addElement(article);
            }
            articles.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        RSSItem[] res2 = new RSSItem[res.size()];
        res.toArray(res2);
        for (int i3 = 0; i3 < res2.length; ++i3) {
            res2[i3].setNomFluxRSS(this.getFeedName(res2[i3].getIdFluxRSS()));
        }
        return res2;
    }

    public void insereSujet(String titre, BaseRSSItem[] news, Date datePubli) throws NoBaseException {
        String query = "SELECT MAX(id) FROM rss_sujets;";
        ResultSet rsIdMax = this.theDB.executeSelection(query);
        int idMax = 0;
        try {
            if (rsIdMax.next()) {
                idMax = rsIdMax.getInt(1);
            }
            rsIdMax.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        String query2 = String.format("INSERT INTO rss_sujets (id, titre, datePubli) VALUES (%d, '%s', '%tY-%tm-%td %tH:%tM:%tS');", ++idMax, Codecs.escapeHTML(titre), datePubli, datePubli, datePubli, datePubli, datePubli, datePubli);
        this.theDB.executeInsertOrUpdate(query2);
        lastNewsDates = null;
        for (int i = 0; i < news.length; ++i) {
            if (!news[i].getLink().trim().equals("")) {
                String queryArticle = "INSERT INTO rss_articlessujets (sujet, titre, description, url) VALUES(" + idMax + ", '" + Codecs.escapeHTML(news[i].getTitle()) + "', '" + Codecs.escapeHTML(news[i].getDescription()) + "', '" + Codecs.echappeSQL(Codecs.desEscapeURL(news[i].getLink())) + "');";
                this.theDB.executeInsertOrUpdate(queryArticle);
                continue;
            }
            System.err.println("Erreur : r\u00e9cup\u00e9ration d'url de sujets inefficace");
        }
    }

    public Date getNewsLastEntryDate() throws NoBaseException {
        if (lastNewsDates == null) {
            Date theDate = new Date(Config.getDateDepartCorpus());
            String query = "SELECT MAX(datePubli) FROM rss_sujets;";
            String queryCount = "SELECT COUNT(datePubli) FROM rss_sujets;";
            ResultSet dateCount = this.theDB.executeSelection(queryCount);
            boolean areDates = false;
            try {
                areDates = dateCount.next();
                areDates = dateCount.getInt(1) > 0;
                dateCount.close();
            }
            catch (Exception e) {
                return theDate;
            }
            ResultSet dateRes = this.theDB.executeSelection(query);
            if (areDates) {
                try {
                    while (dateRes.next()) {
                        theDate = dateRes.getTimestamp(1);
                    }
                    dateRes.close();
                }
                catch (Exception e) {
                    return theDate;
                }
            }
            lastNewsDates = theDate;
            return theDate;
        }
        return lastNewsDates;
    }

    public int InsertEntry(int feedID, String title, String description, String link, Date pubDate, String titleLemmas, String descLemmas) throws NoBaseException {
        String s;
        String t = s = title + description + link;
        s = Codecs.escapeHTML(s);
        if (!(s = Codecs.flushNormalText(s)).equals("")) {
            Out.printErreur("Dans : " + t);
            String att = " Attention nouveau(x) caract\u00e8re(s) \u00e0 \u00e9chapper : ";
            for (int j = 0; j < s.length(); ++j) {
                att = att + "'" + s.charAt(j) + "' [" + new Integer(s.charAt(j)).toString() + "] ";
            }
            Out.printErreur(att);
        }
        RSSFeedDatabase.lastFeedDates[feedID] = null;
        String query = String.format("INSERT INTO rss_articles (flux, datePubli, titre, description, url, aEteLemmatise, aEteCapture, capture, titreLemma, descLemma) VALUES (%d, '%tY-%tm-%td %tH:%tM:%tS' , '%s', '%s', '%s', 1, 0, '%s', '%s', '%s');", feedID, pubDate, pubDate, pubDate, pubDate, pubDate, pubDate, Codecs.escapeHTML(title), Codecs.escapeHTML(description), Codecs.echappeSQL(Codecs.desEscapeURL(link)), "", Codecs.escapeHTML(titleLemmas), Codecs.escapeHTML(descLemmas));
        return this.theDB.executeInsertOrUpdate(query);
    }

    public int InsertEntry(int feedID, String title, String description, String link, Date pubDate) throws NoBaseException {
        String s;
        String t = s = title + description + link;
        s = Codecs.escapeHTML(s);
        if (!(s = Codecs.flushNormalText(s)).equals("")) {
            String att = " Attention nouveau(x) caract\u00e8re(s) \u00e0 \u00e9chapper : ";
            for (int j = 0; j < s.length(); ++j) {
                att = att + "'" + s.charAt(j) + "' [" + new Integer(s.charAt(j)).toString() + "] ";
            }
            att = att + " dans " + t;
            Out.printErreur(att);
        }
        RSSFeedDatabase.lastFeedDates[feedID] = null;
        String query = String.format("INSERT INTO rss_articles (flux, datePubli, titre, description, url, aEteLemmatise, aEteCapture, capture, titreLemma, descLemma) VALUES (%d, '%tY-%tm-%td %tH:%tM:%tS' , '%s', '%s', '%s', 0, 0, '%s', '%s', '%s');", feedID, pubDate, pubDate, pubDate, pubDate, pubDate, pubDate, Codecs.escapeHTML(title), Codecs.escapeHTML(description), Codecs.echappeSQL(Codecs.desEscapeURL(link)), "", "", "");
        return this.theDB.executeInsertOrUpdate(query);
    }

    public synchronized int UpdateLemmas(RSSItem item) throws NoBaseException {
        String query = String.format("UPDATE rss_articles SET aEteLemmatise=1, titreLemma = '%s', descLemma = '%s' WHERE id = %d LIMIT 1;", Codecs.escapeHTML(item.getTitleLemmes()), Codecs.escapeHTML(item.getDescLemmes()), item.getId());
        return this.theDB.executeInsertOrUpdate(query);
    }

    public Set<RSSItem> getAllRssItem() throws NoBaseException {
        String query = String.format("SELECT * FROM rss_articles ORDER BY datePubli DESC", new Object[0]);
        ResultSet rs = this.theDB.executeSelection(query);
        HashSet<RSSItem> items = new HashSet<RSSItem>();
        try {
            while (rs.next()) {
                RSSItem ri = new RSSItem();
                ri.setId(rs.getInt("id"));
                ri.setIdFluxRSS(rs.getInt("flux"));
                ri.setPubDate(rs.getTimestamp("datePubli"));
                ri.setTitle(Codecs.desEscapeHTML(rs.getString("titre")));
                ri.setDescription(Codecs.desEscapeHTML(rs.getString("description")));
                ri.setLink(Codecs.desEscapeHTML(rs.getString("url")));
                ri.setDescLemmes(Codecs.desEscapeHTML(rs.getString("descLemma")));
                ri.setTitleLemmes(Codecs.desEscapeHTML(rs.getString("titreLemma")));
                items.add(ri);
            }
            rs.close();
        }
        catch (SQLException e) {
            System.out.println("error on get idRSSitem last key " + e.toString());
        }
        return items;
    }

    public Set<RSSItem> getAnAmountOfRssItem(int amount) throws NoBaseException {
        String query = String.format("SELECT * FROM rss_articles ORDER BY datePubli DESC LIMIT " + amount, new Object[0]);
        ResultSet rs = this.theDB.executeSelection(query);
        HashSet<RSSItem> items = new HashSet<RSSItem>();
        try {
            while (rs.next()) {
                RSSItem ri = new RSSItem();
                ri.setId(rs.getInt("id"));
                ri.setIdFluxRSS(rs.getInt("flux"));
                ri.setPubDate(rs.getTimestamp("datePubli"));
                ri.setTitle(Codecs.desEscapeHTML(rs.getString("titre")));
                ri.setDescription(Codecs.desEscapeHTML(rs.getString("description")));
                ri.setLink(Codecs.desEscapeHTML(rs.getString("url")));
                ri.setDescLemmes(Codecs.desEscapeHTML(rs.getString("descLemma")));
                ri.setTitleLemmes(Codecs.desEscapeHTML(rs.getString("titreLemma")));
                items.add(ri);
            }
            rs.close();
        }
        catch (SQLException e) {
            System.out.println("error on get idRSSitem last key " + e.toString());
        }
        return items;
    }

    public int[] getNbArticlesSurUnMois(int feedId) throws NoBaseException {
        int[] res = new int[30];
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTimeInMillis(System.currentTimeMillis() - 2592000000L);
        String a = "" + cal.get(1);
        a = (a.length() < 2 ? "000" : (a.length() < 3 ? "00" : (a.length() < 4 ? "0" : ""))) + a;
        String m = "" + (cal.get(2) + 1);
        m = (m.length() < 2 ? "0" : "") + m;
        String j = "" + cal.get(5);
        j = (j.length() < 2 ? "0" : "") + j;
        cal.setTimeInMillis(System.currentTimeMillis());
        String a2 = "" + cal.get(1);
        a2 = (a2.length() < 2 ? "000" : (a2.length() < 3 ? "00" : (a2.length() < 4 ? "0" : ""))) + a2;
        String m2 = "" + (cal.get(2) + 1);
        m2 = (m2.length() < 2 ? "0" : "") + m2;
        String j2 = "" + cal.get(5);
        j2 = (j2.length() < 2 ? "0" : "") + j2;
        String query = String.format("SELECT DAYOFMONTH(datePubli), COUNT(id) FROM rss_articles WHERE flux=" + feedId + " AND datePubli BETWEEN '" + a + "-" + m + "-" + j + "' AND '" + a2 + "-" + m2 + "-" + j2 + "' GROUP BY TO_DAYS(datePubli) ORDER BY TO_DAYS(datePubli) DESC;", new Object[0]);
        ResultSet rs = this.theDB.executeSelection(query);
        int depart = cal.get(5);
        cal.setTimeInMillis(System.currentTimeMillis() - 2592000000L);
        int nbJours = cal.getActualMaximum(5);
        try {
            while (rs.next()) {
                int date = rs.getInt(1);
                int index = -(date - depart);
                if (index < 0) {
                    index = -(date - nbJours - depart);
                }
                if (index >= 30) continue;
                res[index] = rs.getInt(2);
            }
            rs.close();
        }
        catch (SQLException e) {
            System.out.println("sql error : " + e.getMessage() + "\n" + e.getStackTrace());
        }
        return res;
    }

    public int[] getNbCollectesSurUnMois(int feedId) throws NoBaseException {
        int[] res = new int[30];
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTimeInMillis(System.currentTimeMillis() - 2592000000L);
        String a = "" + cal.get(1);
        a = (a.length() < 2 ? "000" : (a.length() < 3 ? "00" : (a.length() < 4 ? "0" : ""))) + a;
        String m = "" + (cal.get(2) + 1);
        m = (m.length() < 2 ? "0" : "") + m;
        String j = "" + cal.get(5);
        j = (j.length() < 2 ? "0" : "") + j;
        cal.setTimeInMillis(System.currentTimeMillis());
        String a2 = "" + cal.get(1);
        a2 = (a2.length() < 2 ? "000" : (a2.length() < 3 ? "00" : (a2.length() < 4 ? "0" : ""))) + a2;
        String m2 = "" + (cal.get(2) + 1);
        m2 = (m2.length() < 2 ? "0" : "") + m2;
        String j2 = "" + cal.get(5);
        j2 = (j2.length() < 2 ? "0" : "") + j2;
        String query = String.format("SELECT DAYOFMONTH(date), COUNT(id) FROM rss_log WHERE flux=" + feedId + " AND date BETWEEN '" + a + "-" + m + "-" + j + "' AND '" + a2 + "-" + m2 + "-" + j2 + "' GROUP BY TO_DAYS(date) ORDER BY TO_DAYS(date) DESC;", new Object[0]);
        ResultSet rs = this.theDB.executeSelection(query);
        int depart = cal.get(5);
        cal.setTimeInMillis(System.currentTimeMillis() - 2592000000L);
        int nbJours = cal.getActualMaximum(5);
        try {
            while (rs.next()) {
                int date = rs.getInt(1);
                int index = -(date - depart);
                if (index < 0) {
                    index = -(date - nbJours - depart);
                }
                if (index >= 30) continue;
                res[index] = rs.getInt(2);
            }
            rs.close();
        }
        catch (SQLException e) {
            System.out.println("sql error : " + e.getMessage() + "\n" + e.getStackTrace());
        }
        return res;
    }

    public int[] getNbCollectesSur24h(int feedId) throws NoBaseException {
        int[] res = new int[24];
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTimeInMillis(System.currentTimeMillis() - 172800000L);
        String a = "" + cal.get(1);
        a = (a.length() < 2 ? "000" : (a.length() < 3 ? "00" : (a.length() < 4 ? "0" : ""))) + a;
        String m = "" + (cal.get(2) + 1);
        m = (m.length() < 2 ? "0" : "") + m;
        String j = "" + cal.get(5);
        j = (j.length() < 2 ? "0" : "") + j;
        String h = "" + cal.get(11);
        h = (h.length() < 2 ? "0" : "") + h;
        cal.setTimeInMillis(System.currentTimeMillis());
        String a2 = "" + cal.get(1);
        a2 = (a2.length() < 2 ? "000" : (a2.length() < 3 ? "00" : (a2.length() < 4 ? "0" : ""))) + a2;
        String m2 = "" + (cal.get(2) + 1);
        m2 = (m2.length() < 2 ? "0" : "") + m2;
        String j2 = "" + cal.get(5);
        j2 = (j2.length() < 2 ? "0" : "") + j2;
        String h2 = "" + cal.get(11);
        h2 = (h2.length() < 2 ? "0" : "") + h2;
        String query = String.format("SELECT HOUR(date), COUNT(id) FROM rss_log WHERE flux=" + feedId + " AND date BETWEEN '" + a + "-" + m + "-" + j + " " + h + ":00:00' AND '" + a2 + "-" + m2 + "-" + j2 + " " + h2 + ":00:00' GROUP BY HOUR(date);", new Object[0]);
        ResultSet rs = this.theDB.executeSelection(query);
        int depart = cal.get(10);
        try {
            while (rs.next()) {
                int date = rs.getInt(1);
                int index = -(date - depart);
                if (index < 0) {
                    index = -(date - 24 - depart);
                }
                if (index >= 24) continue;
                res[index] = rs.getInt(2);
            }
            rs.close();
        }
        catch (SQLException e) {
            System.out.println("sql error : " + e.getMessage() + "\n" + e.getStackTrace());
        }
        return res;
    }

    public Set<RSSItem> getAllRssItemsOfDate(int jj, int mm, int aaaa) throws NoBaseException {
        GregorianCalendar cal = new GregorianCalendar();
        cal.set(aaaa, mm, jj);
        cal.setTimeInMillis(cal.getTimeInMillis() + 86400000L);
        String a = "" + cal.get(1);
        a = (a.length() < 2 ? "000" : (a.length() < 3 ? "00" : (a.length() < 4 ? "0" : ""))) + a;
        String m = "" + cal.get(2);
        m = (m.length() < 2 ? "0" : "") + m;
        String j = "" + cal.get(5);
        j = (j.length() < 2 ? "0" : "") + j;
        String query = String.format("SELECT * FROM rss_articles WHERE datePubli BETWEEN '" + aaaa + "-" + mm + "-" + jj + "' AND '" + a + "-" + m + "-" + j + "';", new Object[0]);
        ResultSet rs = this.theDB.executeSelection(query);
        HashSet<RSSItem> items = new HashSet<RSSItem>();
        try {
            while (rs.next()) {
                RSSItem ri = new RSSItem();
                ri.setId(rs.getInt("id"));
                ri.setIdFluxRSS(rs.getInt("flux"));
                ri.setPubDate(rs.getTimestamp("datePubli"));
                ri.setTitle(Codecs.desEscapeHTML(rs.getString("titre")));
                ri.setDescription(Codecs.desEscapeHTML(rs.getString("description")));
                ri.setLink(Codecs.desEscapeHTML(rs.getString("url")));
                ri.setDescLemmes(Codecs.desEscapeHTML(rs.getString("descLemma")));
                ri.setTitleLemmes(Codecs.desEscapeHTML(rs.getString("titreLemma")));
                items.add(ri);
            }
            rs.close();
        }
        catch (SQLException e) {
            System.out.println("error on get idRSSitem last key " + e.toString());
        }
        return items;
    }

    public Set<RSSItem> getAllRssItemsBetween(int jj1, int mm1, int aaaa1, int jj2, int mm2, int aaaa2) throws NoBaseException {
        GregorianCalendar cal = new GregorianCalendar();
        cal.set(aaaa2, mm2, jj2);
        cal.setTimeInMillis(cal.getTimeInMillis() + 86400000L);
        String a = "" + cal.get(1);
        a = (a.length() < 2 ? "000" : (a.length() < 3 ? "00" : (a.length() < 4 ? "0" : ""))) + a;
        String m = "" + cal.get(2);
        m = (m.length() < 2 ? "0" : "") + m;
        String j = "" + cal.get(5);
        j = (j.length() < 2 ? "0" : "") + j;
        String query = String.format("SELECT * FROM rss_articles WHERE datePubli BETWEEN '" + aaaa1 + "-" + mm1 + "-" + jj1 + "' AND '" + a + "-" + m + "-" + j + "';", new Object[0]);
        ResultSet rs = this.theDB.executeSelection(query);
        HashSet<RSSItem> items = new HashSet<RSSItem>();
        try {
            while (rs.next()) {
                RSSItem ri = new RSSItem();
                ri.setId(rs.getInt("id"));
                ri.setIdFluxRSS(rs.getInt("flux"));
                ri.setPubDate(rs.getTimestamp("datePubli"));
                ri.setTitle(Codecs.desEscapeHTML(rs.getString("titre")));
                ri.setDescription(Codecs.desEscapeHTML(rs.getString("description")));
                ri.setLink(Codecs.desEscapeHTML(rs.getString("url")));
                ri.setDescLemmes(Codecs.desEscapeHTML(rs.getString("descLemma")));
                ri.setTitleLemmes(Codecs.desEscapeHTML(rs.getString("titreLemma")));
                items.add(ri);
            }
            rs.close();
        }
        catch (SQLException e) {
            System.out.println("error on get idRSSitem last key " + e.toString());
        }
        return items;
    }

    public int getNbSujetsEntre(Date d1, Date d2) throws NoBaseException {
        String query = String.format("SELECT COUNT(id) FROM rss_sujets WHERE datePubli BETWEEN '%tY-%tm-%td' AND '%tY-%tm-%td';", d1, d1, d1, d2, d2, d2);
        ResultSet rs = this.theDB.executeSelection(query);
        int result = 0;
        try {
            while (rs.next()) {
                result = rs.getInt(1);
            }
            rs.close();
        }
        catch (SQLException e) {
            System.out.println(e.toString());
        }
        return result;
    }

    public SujetBrut[] getSujetsEntre(Date d1, Date d2) throws NoBaseException {
        Vector<SujetBrut> result = new Vector<SujetBrut>();
        String query = String.format("SELECT id, titre FROM rss_sujets WHERE datePubli BETWEEN '%tY-%tm-%td' AND '%tY-%tm-%td';", d1, d1, d1, d2, d2, d2);
        ResultSet rs = this.theDB.executeSelection(query);
        try {
            while (rs.next()) {
                int id = rs.getInt("id");
                String titre = Codecs.desEscapeHTML(rs.getString("titre"));
                result.addElement(new SujetBrut(id, titre));
            }
            rs.close();
        }
        catch (SQLException e) {
            System.out.println(e.toString());
        }
        for (int i = 0; i < result.size(); ++i) {
            ((SujetBrut)result.elementAt(i)).setArticles(this.getArticlesDuSujet(((SujetBrut)result.elementAt(i)).getId()));
        }
        int fusions = 1;
        while (fusions > 0) {
            fusions = 0;
            Vector result2 = new Vector();
            for (int i = 0; i < result.size(); ++i) {
                boolean deja = false;
                for (int j = 0; j < result2.size(); ++j) {
                    if (!((SujetBrut)result.elementAt(i)).equals(result2.elementAt(j))) continue;
                    deja = true;
                    ((SujetBrut)result2.elementAt(j)).fusionne((SujetBrut)result.elementAt(i));
                    ++fusions;
                    break;
                }
                if (deja || ((SujetBrut)result.elementAt(i)).getArticles().length <= 0) continue;
                result2.addElement(result.elementAt(i));
            }
            result = result2;
        }
        SujetBrut[] result0 = new SujetBrut[result.size()];
        result.toArray(result0);
        return result0;
    }

    private BaseRSSItem[] getArticlesDuSujet(int idSujet) throws NoBaseException {
        Vector<BaseRSSItem> result = new Vector<BaseRSSItem>();
        String query = "SELECT titre, description, url FROM rss_articlessujets WHERE sujet=" + idSujet + ";";
        ResultSet rs = this.theDB.executeSelection(query);
        try {
            while (rs.next()) {
                BaseRSSItem item = new BaseRSSItem();
                item.setTitle(Codecs.desEscapeHTML(rs.getString("titre")));
                item.setDescription(Codecs.desEscapeHTML(rs.getString("description")));
                item.setLink(Codecs.desEscapeURL(rs.getString("url")));
                result.addElement(item);
            }
            rs.close();
        }
        catch (SQLException e) {
            System.out.println(e.toString());
        }
        BaseRSSItem[] result2 = new BaseRSSItem[result.size()];
        result.toArray(result2);
        return result2;
    }

    public SujetTraite trouveArticlesDesSujets(SujetBrut sujets) throws NoBaseException {
        SujetTraite nouveau = new SujetTraite(sujets);
        Vector<RSSItem> articles = new Vector<RSSItem>();
        for (int j = 0; j < sujets.getArticles().length; ++j) {
            String query = "SELECT id, flux, titre, description, url, datePubli FROM rss_articles WHERE url='" + Codecs.echappeSQL(Codecs.desEscapeURL(sujets.getArticles()[j].getLink())) + "';";
            ResultSet rs = this.theDB.executeSelection(query);
            try {
                while (rs.next()) {
                    RSSItem art = new RSSItem();
                    art.setId(rs.getInt("id"));
                    art.setIdFluxRSS(rs.getInt("flux"));
                    art.setTitle(Codecs.desEscapeHTML(rs.getString("titre")));
                    art.setDescription(Codecs.desEscapeHTML(rs.getString("description")));
                    art.setLink(Codecs.desEscapeHTML(rs.getString("url")));
                    art.setPubDate(rs.getTimestamp("datePubli"));
                    articles.addElement(art);
                }
                rs.close();
                continue;
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        RSSItem[] articles2 = new RSSItem[articles.size()];
        articles.toArray(articles2);
        for (int j = 0; j < articles2.length; ++j) {
            articles2[j].setNomFluxRSS(this.getFeedName(articles2[j].getIdFluxRSS()));
        }
        nouveau.setArticles(articles2);
        return nouveau;
    }

    public int getRssItemCount() throws NoBaseException {
        String query = String.format("SELECT COUNT(id) FROM rss_articles", new Object[0]);
        ResultSet rs = this.theDB.executeSelection(query);
        int result = 0;
        try {
            while (rs.next()) {
                result = rs.getInt(1);
            }
            rs.close();
        }
        catch (SQLException e) {
            System.out.println("error on get idRSSitem last key " + e.toString());
        }
        return result;
    }

    public int getRssItemMaxID() throws NoBaseException {
        String query = String.format("SELECT MAX(id) FROM rss_articles", new Object[0]);
        ResultSet rs = this.theDB.executeSelection(query);
        int result = 0;
        try {
            while (rs.next()) {
                result = rs.getInt(1);
            }
            rs.close();
        }
        catch (SQLException e) {
            System.out.println("error on get idRSSitem last key " + e.toString());
        }
        return result;
    }

    public Vector<RSSItemCount> getRssItemCountByFeed() throws NoBaseException {
        RSSItemCount ri;
        System.out.println(" Flux avec publication");
        String query = String.format("SELECT f.nom, COUNT(a.id), MAX(a.datePubli) FROM rss_articles a, rss_flux f WHERE f.id = a.flux GROUP BY f.id ORDER BY f.id ASC;", new Object[0]);
        System.out.println("  Interrogation de la base");
        ResultSet rs = this.theDB.executeSelection(query);
        System.out.println("  Interrogation de la base termin\u00e9e");
        Vector<RSSItemCount> items = new Vector<RSSItemCount>();
        try {
            while (rs.next()) {
                ri = new RSSItemCount(1, rs.getString(1), rs.getString(3), rs.getInt(2));
                items.add(ri);
            }
            rs.close();
        }
        catch (SQLException e) {
            System.out.println("error on get idRSSitem last key " + e.toString());
        }
        System.out.println(" Flux sans publication");
        query = String.format("SELECT f.nom FROM rss_flux f WHERE f.id NOT IN (SELECT f.id FROM rss_articles a, rss_flux f WHERE f.id = a.flux);", new Object[0]);
        System.out.println("  Interrogation de la base");
        rs = this.theDB.executeSelection(query);
        System.out.println("  Interrogation de la base termin\u00e9e");
        try {
            while (rs.next()) {
                ri = new RSSItemCount(1, rs.getString(1), "", 0);
                items.add(ri);
            }
            rs.close();
        }
        catch (SQLException e) {
            System.out.println("error on get idRSSitem last key " + e.toString());
        }
        return items;
    }

    public Vector<RSSItemCount> getRssItemCountByDay() throws NoBaseException {
        String query = String.format("SELECT datePubli, COUNT(id) FROM rss_articles GROUP BY DAYOFYEAR(datePubli) ORDER BY datePubli DESC;", new Object[0]);
        ResultSet rs = this.theDB.executeSelection(query);
        Vector<RSSItemCount> items = new Vector<RSSItemCount>();
        try {
            while (rs.next()) {
                RSSItemCount ri = new RSSItemCount(1, "", rs.getString(1), rs.getInt(2));
                items.add(ri);
            }
            rs.close();
        }
        catch (SQLException e) {
            System.out.println("error on get idRSSitem last key " + e.toString());
        }
        return items;
    }

    public Vector<RSSItemCount> getRssItemCountByHour() throws NoBaseException {
        String query = String.format("SELECT datePubli, COUNT(id) FROM rss_articles GROUP BY HOUR(datePubli);", new Object[0]);
        ResultSet rs = this.theDB.executeSelection(query);
        Vector<RSSItemCount> items = new Vector<RSSItemCount>();
        try {
            while (rs.next()) {
                RSSItemCount ri = new RSSItemCount(2, "", rs.getString(1), rs.getInt(2));
                items.add(ri);
            }
            rs.close();
        }
        catch (SQLException e) {
            System.out.println("error on get idRSSitem last key " + e.toString());
        }
        return items;
    }

    public Set<RSSItem> getRssDate(String id) throws NoBaseException {
        String query = String.format("SELECT f.nom, i.datePubli, i.id FROM rss_articles i, rss_flux f WHERE i.flux = f.id AND f.id = " + id + "", new Object[0]);
        ResultSet rs = this.theDB.executeSelection(query);
        HashSet<RSSItem> items = new HashSet<RSSItem>();
        try {
            while (rs.next()) {
                RSSItem ri = new RSSItem();
                ri.setId(rs.getInt("id"));
                ri.setPubDate(rs.getTimestamp("datePubli"));
                ri.setTitle(Codecs.desEscapeHTML(rs.getString("nom")));
                items.add(ri);
            }
            rs.close();
        }
        catch (SQLException e) {
            System.out.println("error on get idRSSitem last key " + e.toString());
        }
        return items;
    }

    public RSSItem getRssItem(int id) throws NoBaseException {
        String query = String.format("SELECT titre, datePubli, id, description, titreLemma, descLemma FROM rss_articles WHERE id = " + id + "", new Object[0]);
        ResultSet rs = this.theDB.executeSelection(query);
        RSSItem item = new RSSItem();
        try {
            while (rs.next()) {
                item.setId(rs.getInt("id"));
                item.setPubDate(rs.getTimestamp("datePubli"));
                item.setTitle(Codecs.desEscapeHTML(rs.getString("titre")));
                item.setDescription(Codecs.desEscapeHTML(rs.getString("description")));
                item.setTitleLemmes(Codecs.desEscapeHTML(rs.getString("titreLemma")));
                item.setDescLemmes(Codecs.desEscapeHTML(rs.getString("descLemma")));
            }
            rs.close();
        }
        catch (SQLException e) {
            System.out.println("error on get idRSSitem last key " + e.toString());
        }
        return item;
    }

    public RSSItem getEscapedRssItem(int id) throws NoBaseException {
        String query = String.format("SELECT titre, datePubli, id, description, titreLemma, descLemma FROM rss_articles WHERE id = " + id + ";", new Object[0]);
        ResultSet rs = this.theDB.executeSelection(query);
        RSSItem item = new RSSItem();
        try {
            while (rs.next()) {
                item.setId(rs.getInt("id"));
                item.setPubDate(rs.getTimestamp("datePubli"));
                item.setTitle(rs.getString("titre"));
                item.setDescription(rs.getString("description"));
                item.setTitleLemmes(rs.getString("titreLemma"));
                item.setDescLemmes(rs.getString("descLemma"));
            }
            rs.close();
        }
        catch (SQLException e) {
            System.out.println("error on get idRSSitem last key " + e.toString());
        }
        return item;
    }

    public Set<LemmaItem> getLemmas(int idArticle) throws NoBaseException {
        this.flush();
        LinkedHashSet<LemmaItem> lemmas = new LinkedHashSet<LemmaItem>();
        String query = String.format("SELECT * FROM rss_lemmes WHERE article = " + idArticle + ";", new Object[0]);
        ResultSet lemmasRS = this.theDB.executeSelection(query);
        try {
            while (lemmasRS.next()) {
                LemmaItem li = new LemmaItem();
                li.setLemmaName(Codecs.desEscapeHTML(lemmasRS.getString("lemme")));
                li.setNodeID(lemmasRS.getInt("article"));
                li.setCountTitle(lemmasRS.getInt("occuTitre"));
                li.setCountDesc(lemmasRS.getInt("occuDesc"));
                li.setLemmaLex(Codecs.desEscapeHTML(lemmasRS.getString("nature")));
                lemmas.add(li);
            }
            lemmasRS.close();
        }
        catch (SQLException e) {
            System.out.println("error " + e.toString());
        }
        return lemmas;
    }

    public Set<LemmaItem> getNameLemmas(int idArticle) throws NoBaseException {
        this.flush();
        LinkedHashSet<LemmaItem> lemmas = new LinkedHashSet<LemmaItem>();
        String query = String.format("SELECT * FROM rss_lemmes WHERE article = " + idArticle + ";", new Object[0]);
        ResultSet lemmasRS = this.theDB.executeSelection(query);
        try {
            while (lemmasRS.next()) {
                LemmaItem li = new LemmaItem();
                li.setLemmaName(Codecs.desEscapeHTML(lemmasRS.getString("lemme")));
                li.setNodeID(lemmasRS.getInt("article"));
                li.setCountTitle(lemmasRS.getInt("occuTitre"));
                li.setCountDesc(lemmasRS.getInt("occuDesc"));
                li.setLemmaLex(Codecs.desEscapeHTML(lemmasRS.getString("nature")));
                if (!li.getLemmaLex().equalsIgnoreCase("NOM") && !li.getLemmaLex().equalsIgnoreCase("NAM")) continue;
                lemmas.add(li);
            }
            lemmasRS.close();
        }
        catch (SQLException e) {
            System.out.println("error " + e.toString());
        }
        return lemmas;
    }

    public RSSItem[] getAllArticlesNonLemmatises() throws NoBaseException {
        String query = "SELECT DISTINCT id, titre, description FROM rss_articles WHERE aEteLemmatise = 0 ORDER BY id DESC;";
        ResultSet aLemmatiser = this.theDB.executeSelection(query);
        Vector<RSSItem> res = new Vector<RSSItem>();
        try {
            while (aLemmatiser.next()) {
                RSSItem bri = new RSSItem();
                bri.setId(aLemmatiser.getInt("id"));
                bri.setTitle(Codecs.desEscapeHTML(aLemmatiser.getString("titre")));
                bri.setDescription(Codecs.desEscapeHTML(aLemmatiser.getString("description")));
                res.addElement(bri);
            }
            aLemmatiser.close();
        }
        catch (SQLException e) {
            System.out.println("error " + e.toString());
        }
        RSSItem[] res2 = new RSSItem[res.size()];
        res.toArray(res2);
        return res2;
    }

    public RSSItem[] getAllArticlesNonLemmatisesAPartirDe(Date date) throws NoBaseException {
        String query = String.format("SELECT DISTINCT id, titre, description FROM rss_articles WHERE aEteLemmatise = 0 AND datePubli >= '%tY-%tm-%td' ORDER BY id ASC;", date, date, date);
        ResultSet aLemmatiser = this.theDB.executeSelection(query);
        Vector<RSSItem> res = new Vector<RSSItem>();
        try {
            while (aLemmatiser.next()) {
                RSSItem bri = new RSSItem();
                bri.setId(aLemmatiser.getInt("id"));
                bri.setTitle(Codecs.desEscapeHTML(aLemmatiser.getString("titre")));
                bri.setDescription(Codecs.desEscapeHTML(aLemmatiser.getString("description")));
                res.addElement(bri);
            }
            aLemmatiser.close();
        }
        catch (SQLException e) {
            System.out.println("error " + e.toString());
        }
        RSSItem[] res2 = new RSSItem[res.size()];
        res.toArray(res2);
        return res2;
    }

    public RSSItem[] getAllArticlesNonLemmatisesDu(Date date) throws NoBaseException {
        Date date2 = new Date();
        date2.setTime(date.getTime() + 86400000L);
        String query = String.format("SELECT DISTINCT id, titre, description FROM rss_articles WHERE aEteLemmatise = 0 AND datePubli BETWEEN '%tY-%tm-%td' AND '%tY-%tm-%td' ORDER BY id ASC;", date, date, date, date2, date2, date2);
        ResultSet aLemmatiser = this.theDB.executeSelection(query);
        Vector<RSSItem> res = new Vector<RSSItem>();
        try {
            while (aLemmatiser.next()) {
                RSSItem bri = new RSSItem();
                bri.setId(aLemmatiser.getInt("id"));
                bri.setTitle(Codecs.desEscapeHTML(aLemmatiser.getString("titre")));
                bri.setDescription(Codecs.desEscapeHTML(aLemmatiser.getString("description")));
                res.addElement(bri);
            }
            aLemmatiser.close();
        }
        catch (SQLException e) {
            System.out.println("error " + e.toString());
        }
        RSSItem[] res2 = new RSSItem[res.size()];
        res.toArray(res2);
        return res2;
    }

    public RSSItem[] getAllLiensSansCapture(SousCorpus tagsAcceptes) throws NoBaseException {
        int i;
        Vector<Tag> listeCategories = new Vector<Tag>();
        Vector<Tag> listePays = new Vector<Tag>();
        Vector<Tag> listeCouvertures = new Vector<Tag>();
        Vector<Tag> listeInformations = new Vector<Tag>();
        for (int i2 = 0; i2 < tagsAcceptes.listeTagsAcceptes().length; ++i2) {
            if (tagsAcceptes.listeTagsAcceptes()[i2] >= 100 && tagsAcceptes.listeTagsAcceptes()[i2] < 200) {
                listeCategories.addElement(new Tag(tagsAcceptes.listeTagsAcceptes()[i2], ""));
                continue;
            }
            if (tagsAcceptes.listeTagsAcceptes()[i2] >= 200 && tagsAcceptes.listeTagsAcceptes()[i2] < 300) {
                listePays.addElement(new Tag(tagsAcceptes.listeTagsAcceptes()[i2], ""));
                continue;
            }
            if (tagsAcceptes.listeTagsAcceptes()[i2] >= 300 && tagsAcceptes.listeTagsAcceptes()[i2] < 400) {
                listeCouvertures.addElement(new Tag(tagsAcceptes.listeTagsAcceptes()[i2], ""));
                continue;
            }
            if (tagsAcceptes.listeTagsAcceptes()[i2] < 400 || tagsAcceptes.listeTagsAcceptes()[i2] >= 900) continue;
            listeInformations.addElement(new Tag(tagsAcceptes.listeTagsAcceptes()[i2], ""));
        }
        String s = "SELECT DISTINCT url, id FROM rss_articles WHERE aEteCapture = 0 AND flux IN (SELECT id FROM rss_flux f, rss_tagflux t WHERE t.flux=f.id AND ";
        s = s + "(t.tag=";
        for (i = 0; i < listeCategories.size(); ++i) {
            s = s + "" + ((Tag)listeCategories.elementAt(i)).getId();
            if (i >= listeCategories.size() - 1) continue;
            s = s + " OR t.tag=";
        }
        s = s + ") AND f.id IN (SELECT id FROM rss_flux f, rss_tagflux t WHERE t.flux=f.id AND (t.tag=";
        for (i = 0; i < listePays.size(); ++i) {
            s = s + "" + ((Tag)listePays.elementAt(i)).getId();
            if (i >= listePays.size() - 1) continue;
            s = s + " OR t.tag=";
        }
        s = s + ") AND f.id IN (SELECT id FROM rss_flux f, rss_tagflux t WHERE t.flux=f.id AND (t.tag=";
        for (i = 0; i < listeCouvertures.size(); ++i) {
            s = s + "" + ((Tag)listeCouvertures.elementAt(i)).getId();
            if (i >= listeCouvertures.size() - 1) continue;
            s = s + " OR t.tag=";
        }
        s = s + ") AND f.id IN (SELECT id FROM rss_flux f, rss_tagflux t WHERE t.flux=f.id AND (t.tag=";
        for (i = 0; i < listeInformations.size(); ++i) {
            s = s + "" + ((Tag)listeInformations.elementAt(i)).getId();
            if (i >= listeInformations.size() - 1) continue;
            s = s + " OR t.tag=";
        }
        s = s + "))))) ORDER BY id DESC;";
        ResultSet liens = this.theDB.executeSelection(s);
        Vector<RSSItem> res = new Vector<RSSItem>();
        try {
            while (liens.next()) {
                RSSItem item = new RSSItem();
                item.setLink(liens.getString("url").trim());
                item.setId(liens.getInt("id"));
                res.addElement(item);
            }
            liens.close();
        }
        catch (SQLException e) {
            System.out.println("error " + e.toString());
        }
        RSSItem[] res2 = new RSSItem[res.size()];
        res.toArray(res2);
        return res2;
    }

    public RSSItem[] getAllLiensSansCaptureAPartirDe(Date date, SousCorpus tagsAcceptes) throws NoBaseException {
        int i;
        Vector<Tag> listeCategories = new Vector<Tag>();
        Vector<Tag> listePays = new Vector<Tag>();
        Vector<Tag> listeCouvertures = new Vector<Tag>();
        Vector<Tag> listeInformations = new Vector<Tag>();
        for (int i2 = 0; i2 < tagsAcceptes.listeTagsAcceptes().length; ++i2) {
            if (tagsAcceptes.listeTagsAcceptes()[i2] >= 100 && tagsAcceptes.listeTagsAcceptes()[i2] < 200) {
                listeCategories.addElement(new Tag(tagsAcceptes.listeTagsAcceptes()[i2], ""));
                continue;
            }
            if (tagsAcceptes.listeTagsAcceptes()[i2] >= 200 && tagsAcceptes.listeTagsAcceptes()[i2] < 300) {
                listePays.addElement(new Tag(tagsAcceptes.listeTagsAcceptes()[i2], ""));
                continue;
            }
            if (tagsAcceptes.listeTagsAcceptes()[i2] >= 300 && tagsAcceptes.listeTagsAcceptes()[i2] < 400) {
                listeCouvertures.addElement(new Tag(tagsAcceptes.listeTagsAcceptes()[i2], ""));
                continue;
            }
            if (tagsAcceptes.listeTagsAcceptes()[i2] < 400 || tagsAcceptes.listeTagsAcceptes()[i2] >= 900) continue;
            listeInformations.addElement(new Tag(tagsAcceptes.listeTagsAcceptes()[i2], ""));
        }
        String s = String.format("SELECT DISTINCT url, id FROM rss_articles WHERE aEteCapture = 0 AND datePubli >= '%tY-%tm-%td' AND flux IN (SELECT id FROM rss_flux f, rss_tagflux t WHERE t.flux=f.id AND ", date, date, date);
        s = s + "(t.tag=";
        for (i = 0; i < listeCategories.size(); ++i) {
            s = s + "" + ((Tag)listeCategories.elementAt(i)).getId();
            if (i >= listeCategories.size() - 1) continue;
            s = s + " OR t.tag=";
        }
        s = s + ") AND f.id IN (SELECT id FROM rss_flux f, rss_tagflux t WHERE t.flux=f.id AND (t.tag=";
        for (i = 0; i < listePays.size(); ++i) {
            s = s + "" + ((Tag)listePays.elementAt(i)).getId();
            if (i >= listePays.size() - 1) continue;
            s = s + " OR t.tag=";
        }
        s = s + ") AND f.id IN (SELECT id FROM rss_flux f, rss_tagflux t WHERE t.flux=f.id AND (t.tag=";
        for (i = 0; i < listeCouvertures.size(); ++i) {
            s = s + "" + ((Tag)listeCouvertures.elementAt(i)).getId();
            if (i >= listeCouvertures.size() - 1) continue;
            s = s + " OR t.tag=";
        }
        s = s + ") AND f.id IN (SELECT id FROM rss_flux f, rss_tagflux t WHERE t.flux=f.id AND (t.tag=";
        for (i = 0; i < listeInformations.size(); ++i) {
            s = s + "" + ((Tag)listeInformations.elementAt(i)).getId();
            if (i >= listeInformations.size() - 1) continue;
            s = s + " OR t.tag=";
        }
        s = s + "))))) ORDER BY id ASC;";
        ResultSet liens = this.theDB.executeSelection(s);
        Vector<RSSItem> res = new Vector<RSSItem>();
        try {
            while (liens.next()) {
                RSSItem item = new RSSItem();
                item.setLink(liens.getString("url").trim());
                item.setId(liens.getInt("id"));
                res.addElement(item);
            }
            liens.close();
        }
        catch (SQLException e) {
            System.out.println("error " + e.toString());
        }
        RSSItem[] res2 = new RSSItem[res.size()];
        res.toArray(res2);
        return res2;
    }

    public RSSItem[] getAllLiensSansCaptureDu(Date date, SousCorpus tagsAcceptes) throws NoBaseException {
        int i;
        Date date2 = new Date();
        date2.setTime(date.getTime() + 86400000L);
        Vector<Tag> listeCategories = new Vector<Tag>();
        Vector<Tag> listePays = new Vector<Tag>();
        Vector<Tag> listeCouvertures = new Vector<Tag>();
        Vector<Tag> listeInformations = new Vector<Tag>();
        for (int i2 = 0; i2 < tagsAcceptes.listeTagsAcceptes().length; ++i2) {
            if (tagsAcceptes.listeTagsAcceptes()[i2] >= 100 && tagsAcceptes.listeTagsAcceptes()[i2] < 200) {
                listeCategories.addElement(new Tag(tagsAcceptes.listeTagsAcceptes()[i2], ""));
                continue;
            }
            if (tagsAcceptes.listeTagsAcceptes()[i2] >= 200 && tagsAcceptes.listeTagsAcceptes()[i2] < 300) {
                listePays.addElement(new Tag(tagsAcceptes.listeTagsAcceptes()[i2], ""));
                continue;
            }
            if (tagsAcceptes.listeTagsAcceptes()[i2] >= 300 && tagsAcceptes.listeTagsAcceptes()[i2] < 400) {
                listeCouvertures.addElement(new Tag(tagsAcceptes.listeTagsAcceptes()[i2], ""));
                continue;
            }
            if (tagsAcceptes.listeTagsAcceptes()[i2] < 400 || tagsAcceptes.listeTagsAcceptes()[i2] >= 900) continue;
            listeInformations.addElement(new Tag(tagsAcceptes.listeTagsAcceptes()[i2], ""));
        }
        String s = String.format("SELECT DISTINCT url, id FROM rss_articles WHERE aEteCapture = 0 AND datePubli BETWEEN '%tY-%tm-%td' AND '%tY-%tm-%td' AND flux IN (SELECT id FROM rss_flux f, rss_tagflux t WHERE t.flux=f.id AND ", date, date, date, date2, date2, date2);
        s = s + "(t.tag=";
        for (i = 0; i < listeCategories.size(); ++i) {
            s = s + "" + ((Tag)listeCategories.elementAt(i)).getId();
            if (i >= listeCategories.size() - 1) continue;
            s = s + " OR t.tag=";
        }
        s = s + ") AND f.id IN (SELECT id FROM rss_flux f, rss_tagflux t WHERE t.flux=f.id AND (t.tag=";
        for (i = 0; i < listePays.size(); ++i) {
            s = s + "" + ((Tag)listePays.elementAt(i)).getId();
            if (i >= listePays.size() - 1) continue;
            s = s + " OR t.tag=";
        }
        s = s + ") AND f.id IN (SELECT id FROM rss_flux f, rss_tagflux t WHERE t.flux=f.id AND (t.tag=";
        for (i = 0; i < listeCouvertures.size(); ++i) {
            s = s + "" + ((Tag)listeCouvertures.elementAt(i)).getId();
            if (i >= listeCouvertures.size() - 1) continue;
            s = s + " OR t.tag=";
        }
        s = s + ") AND f.id IN (SELECT id FROM rss_flux f, rss_tagflux t WHERE t.flux=f.id AND (t.tag=";
        for (i = 0; i < listeInformations.size(); ++i) {
            s = s + "" + ((Tag)listeInformations.elementAt(i)).getId();
            if (i >= listeInformations.size() - 1) continue;
            s = s + " OR t.tag=";
        }
        s = s + "))))) ORDER BY id ASC;";
        ResultSet liens = this.theDB.executeSelection(s);
        Vector<RSSItem> res = new Vector<RSSItem>();
        try {
            while (liens.next()) {
                RSSItem item = new RSSItem();
                item.setLink(liens.getString("url").trim());
                item.setId(liens.getInt("id"));
                res.addElement(item);
            }
            liens.close();
        }
        catch (SQLException e) {
            System.out.println("error " + e.toString());
        }
        RSSItem[] res2 = new RSSItem[res.size()];
        res.toArray(res2);
        return res2;
    }

    public void saveImageOfAllArticlesDe(Date debut, Date fin, SousCorpus tagsAcceptes) throws NoBaseException {
        int i;
        String query = "TRUNCATE TABLE image_rss_articles;";
        this.theDB.executeDeletion(query);
        Vector<Tag> listeCategories = new Vector<Tag>();
        Vector<Tag> listePays = new Vector<Tag>();
        Vector<Tag> listeCouvertures = new Vector<Tag>();
        Vector<Tag> listeInformations = new Vector<Tag>();
        for (int i2 = 0; i2 < tagsAcceptes.listeTagsAcceptes().length; ++i2) {
            if (tagsAcceptes.listeTagsAcceptes()[i2] >= 100 && tagsAcceptes.listeTagsAcceptes()[i2] < 200) {
                listeCategories.addElement(new Tag(tagsAcceptes.listeTagsAcceptes()[i2], ""));
                continue;
            }
            if (tagsAcceptes.listeTagsAcceptes()[i2] >= 200 && tagsAcceptes.listeTagsAcceptes()[i2] < 300) {
                listePays.addElement(new Tag(tagsAcceptes.listeTagsAcceptes()[i2], ""));
                continue;
            }
            if (tagsAcceptes.listeTagsAcceptes()[i2] >= 300 && tagsAcceptes.listeTagsAcceptes()[i2] < 400) {
                listeCouvertures.addElement(new Tag(tagsAcceptes.listeTagsAcceptes()[i2], ""));
                continue;
            }
            if (tagsAcceptes.listeTagsAcceptes()[i2] < 400 || tagsAcceptes.listeTagsAcceptes()[i2] >= 900) continue;
            listeInformations.addElement(new Tag(tagsAcceptes.listeTagsAcceptes()[i2], ""));
        }
        String s = String.format("SELECT a.id, f.nom, a.datePubli, a.titre, a.description, a.url FROM rss_articles a, rss_flux f WHERE a.flux=f.id AND a.datePubli BETWEEN '%tY-%tm-%td 00:00:00' AND '%tY-%tm-%td 00:00:00' AND a.flux IN (SELECT id FROM rss_flux f, rss_tagflux t WHERE t.flux=f.id AND ", debut, debut, debut, fin, fin, fin);
        s = s + "(t.tag=";
        for (i = 0; i < listeCategories.size(); ++i) {
            s = s + "" + ((Tag)listeCategories.elementAt(i)).getId();
            if (i >= listeCategories.size() - 1) continue;
            s = s + " OR t.tag=";
        }
        s = s + ") AND f.id IN (SELECT id FROM rss_flux f, rss_tagflux t WHERE t.flux=f.id AND (t.tag=";
        for (i = 0; i < listePays.size(); ++i) {
            s = s + "" + ((Tag)listePays.elementAt(i)).getId();
            if (i >= listePays.size() - 1) continue;
            s = s + " OR t.tag=";
        }
        s = s + ") AND f.id IN (SELECT id FROM rss_flux f, rss_tagflux t WHERE t.flux=f.id AND (t.tag=";
        for (i = 0; i < listeCouvertures.size(); ++i) {
            s = s + "" + ((Tag)listeCouvertures.elementAt(i)).getId();
            if (i >= listeCouvertures.size() - 1) continue;
            s = s + " OR t.tag=";
        }
        s = s + ") AND f.id IN (SELECT id FROM rss_flux f, rss_tagflux t WHERE t.flux=f.id AND (t.tag=";
        for (i = 0; i < listeInformations.size(); ++i) {
            s = s + "" + ((Tag)listeInformations.elementAt(i)).getId();
            if (i >= listeInformations.size() - 1) continue;
            s = s + " OR t.tag=";
        }
        s = s + "))))) ORDER BY id ASC;";
        ResultSet liens = this.theDB.executeSelection(s);
        Vector<RSSItem> res = new Vector<RSSItem>();
        try {
            while (liens.next()) {
                RSSItem item = new RSSItem();
                item.setId(liens.getInt(1));
                item.setNomFluxRSS(Codecs.desEscapeHTML(liens.getString(2)));
                item.setPubDate(liens.getTimestamp(3));
                item.setTitle(Codecs.desEscapeHTML(liens.getString(4)));
                item.setDescription(Codecs.desEscapeHTML(liens.getString(5)));
                item.setLink(Codecs.desEscapeURL(liens.getString(6)));
                res.addElement(item);
            }
            liens.close();
        }
        catch (SQLException e) {
            System.out.println("error " + e.toString());
        }
        RSSItem[] res2 = new RSSItem[res.size()];
        res.toArray(res2);
        for (int i3 = 0; i3 < res2.length; ++i3) {
            String query2 = "INSERT INTO image_rss_articles (id, nomFlux, datePubli, titre, description, url) VALUES (" + res2[i3].getId() + ", '" + Codecs.echappeSQL(res2[i3].getNomFluxRSS()) + "', " + String.format("'%tY-%tm-%td %tH:%tM:%tS'", res2[i3].getPubDate(), res2[i3].getPubDate(), res2[i3].getPubDate(), res2[i3].getPubDate(), res2[i3].getPubDate(), res2[i3].getPubDate()) + ", '" + Codecs.echappeSQL(res2[i3].getTitle()) + "', '" + Codecs.echappeSQL(res2[i3].getDescription()) + "', '" + Codecs.echappeSQL(res2[i3].getLink()) + "');";
            this.theDB.executeInsertOrUpdate(query2);
        }
    }

    public void captureLien(int id, String lien) {
        String captFile = "" + id;
        File f = Config.getCaptureProgram();
        final Thread t = Thread.currentThread();
        Thread t2 = new Thread(){

            public void run() {
                try {
                    Thread.sleep(40000L);
                    t.interrupt();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        };
        try {
            Process p = Runtime.getRuntime().exec(f.getAbsolutePath() + " --url=\"" + lien + "\" --out=\"" + Config.getCaptureDirectory() + "\\" + captFile + ".png\" --silent --max-wait=30000");
            Out.printInfo("Capture n\u00b0" + captFile + " lanc\u00e9e : " + lien);
            long time = System.currentTimeMillis();
            int exitValue = 0;
            Thread.currentThread();
            Thread.interrupted();
            try {
                t2.start();
                exitValue = p.waitFor();
                t2.interrupt();
            }
            catch (InterruptedException ie) {
                t2.interrupt();
                p.destroy();
                throw new Exception("capture trop longue (" + (System.currentTimeMillis() - time) / 1000L + " secondes).");
            }
            if (exitValue != 0) {
                throw new Exception(f.getAbsolutePath() + ", " + "erreur " + exitValue);
            }
            if (!new File(Config.getCaptureDirectory() + "\\" + captFile + ".png").exists()) {
                throw new Exception("pas d'image g\u00e9n\u00e9r\u00e9e.");
            }
            String query = "UPDATE rss_articles SET aEteCapture=1, capture='" + captFile + "' " + "WHERE id=" + id + ";";
            this.theDB.executeInsertOrUpdate(query);
        }
        catch (IOException ioe) {
            Out.printErreur("Capture n\u00b0" + captFile + " impossible : " + ioe.getMessage());
        }
        catch (Exception e) {
            Out.printErreur("Le programme utilis\u00e9 pour la capture n\u00b0" + captFile + " a \u00e9chou\u00e9 : " + e.getMessage());
        }
    }

    public int getLastInsertEntry() throws SQLException, NoBaseException {
        String query = String.format("SELECT MAX(id) FROM rss_articles", new Object[0]);
        ResultSet rs = this.theDB.executeSelection(query);
        int res = 0;
        try {
            rs.next();
            res = rs.getInt(1);
            rs.close();
            return res;
        }
        catch (SQLException e) {
            System.out.println("error on get idRSSitem last key " + e.toString());
            throw e;
        }
    }

    public synchronized int InsertLemma(int ifeedid, String lemma, int nbTitle, int nbDesc, String lex) throws NoBaseException {
        this.flushConditionnel();
        if (!this.unwantedLemma(lemma)) {
            String query = String.format("INSERT INTO temp_rss_lemmes(article, lemme, occuTitre, occuDesc, nature)  VALUES (%d,'%s',%d,%d, '%s')", ifeedid, Codecs.escapeHTML(lemma), nbTitle, nbDesc, lex);
            return this.theDB.executeInsertOrUpdate(query);
        }
        return 0;
    }

    public synchronized int logRead(int feedID, long date, int newItems, String error) throws NoBaseException {
        this.flushConditionnel();
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTimeInMillis(date);
        int annee = cal.get(1);
        int mois = cal.get(2) + 1;
        int jour = cal.get(5);
        int heure = cal.get(11);
        int minute = cal.get(12);
        int seconde = cal.get(13);
        String dateTime = annee + "-" + mois + "-" + jour + " " + heure + ":" + minute + ":" + seconde;
        String query = "INSERT INTO temp_rss_log(flux, date, nouveaux, erreur) VALUES(" + feedID + ", '" + dateTime + "', " + newItems + ", '" + Codecs.echappeSQL(error) + "');";
        return this.theDB.executeInsertOrUpdate(query);
    }

    private void flush() throws NoBaseException {
        String query = String.format("INSERT INTO rss_log SELECT * FROM temp_rss_log;", new Object[0]);
        this.theDB.executeInsertOrUpdate(query);
        query = String.format("TRUNCATE temp_rss_log;", new Object[0]);
        this.theDB.executeInsertOrUpdate(query);
        query = String.format("INSERT INTO rss_lemmes SELECT * FROM temp_rss_lemmes;", new Object[0]);
        this.theDB.executeInsertOrUpdate(query);
        query = String.format("TRUNCATE temp_rss_lemmes;", new Object[0]);
        this.theDB.executeInsertOrUpdate(query);
    }

    private void flushConditionnel() throws NoBaseException {
        String query = "SELECT COUNT(lemme) FROM temp_rss_lemmes;";
        ResultSet rs = this.theDB.executeSelection(query);
        int nb = 0;
        try {
            rs.next();
            nb = rs.getInt(1);
            rs.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        if (nb >= 5000) {
            query = String.format("INSERT INTO rss_lemmes SELECT * FROM temp_rss_lemmes;", new Object[0]);
            this.theDB.executeInsertOrUpdate(query);
            query = String.format("TRUNCATE temp_rss_lemmes;", new Object[0]);
            this.theDB.executeInsertOrUpdate(query);
        }
        query = "SELECT COUNT(date) FROM temp_rss_log;";
        rs = this.theDB.executeSelection(query);
        nb = 0;
        try {
            rs.next();
            nb = rs.getInt(1);
            rs.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        if (nb >= 5000) {
            query = String.format("INSERT INTO rss_log SELECT * FROM temp_rss_log;", new Object[0]);
            this.theDB.executeInsertOrUpdate(query);
            query = String.format("TRUNCATE temp_rss_log;", new Object[0]);
            this.theDB.executeInsertOrUpdate(query);
        }
    }

    public void nettoieURLs() throws NoBaseException {
        String query2;
        String t;
        String s;
        String query = "SELECT DISTINCT url FROM rss_articlessujets;";
        ResultSet rs = this.theDB.executeSelection(query);
        Vector<String> listeURLs = new Vector<String>();
        try {
            while (rs.next()) {
                listeURLs.addElement(rs.getString(1).trim());
            }
            rs.close();
        }
        catch (SQLException e) {
            System.out.println("error " + e.toString());
        }
        for (int i = 0; i < listeURLs.size(); ++i) {
            Out.printInfo("Nettoyage Google : " + (i + 1) + "/" + listeURLs.size());
            s = (String)listeURLs.elementAt(i);
            t = (String)listeURLs.elementAt(i);
            t = Codecs.echappeSQL(Codecs.desEscapeURL(t));
            query2 = "UPDATE rss_articlessujets SET url='" + t + "' " + "WHERE url='" + s + "';";
            this.theDB.executeInsertOrUpdate(query2);
        }
        query = "SELECT DISTINCT url FROM rss_articles;";
        rs = this.theDB.executeSelection(query);
        listeURLs = new Vector();
        try {
            while (rs.next()) {
                listeURLs.addElement(rs.getString(1).trim());
            }
            rs.close();
        }
        catch (SQLException e) {
            System.out.println("error " + e.toString());
        }
        for (int i = 0; i < listeURLs.size(); ++i) {
            Out.printInfo("Nettoyage Base : " + (i + 1) + "/" + listeURLs.size());
            s = (String)listeURLs.elementAt(i);
            t = (String)listeURLs.elementAt(i);
            t = Codecs.echappeSQL(Codecs.desEscapeURL(t));
            query2 = "UPDATE rss_articles SET url='" + t + "' " + "WHERE url='" + s + "';";
            this.theDB.executeInsertOrUpdate(query2);
        }
    }

    private boolean unwantedLemma(String lemma) {
        return false;
    }
}

