/*
 * Decompiled with CFR 0.152.
 */
package data.base.connectors;

import data.base.Database;
import data.base.NoBaseException;
import data.structures.base.Flux;
import data.structures.base.Source;
import data.structures.base.Tag;
import java.sql.ResultSet;
import java.util.Vector;
import proc.text.Codecs;

public class ManagementDatabase {
    public static final int TAGS_CATEGORIE = 100;
    public static final int TAGS_PAYS = 200;
    public static final int TAGS_COUVERTURE = 300;
    public static final int TAGS_INFORMATION = 400;
    public static final int TAGS_EXTERNE = 900;
    private Database theDB;

    public ManagementDatabase(Database db) throws NoBaseException {
        this.theDB = db;
    }

    public Tag[] getTags() throws NoBaseException {
        String query = "SELECT id, tag FROM rss_tags;";
        ResultSet tags = this.theDB.executeSelection(query);
        Vector<Tag> res = new Vector<Tag>();
        if (tags != null) {
            try {
                while (tags.next()) {
                    int id = tags.getInt("id");
                    String tag = Codecs.desEscapeHTML(tags.getString("tag"));
                    res.addElement(new Tag(id, tag));
                }
                tags.close();
            }
            catch (Exception e) {
                return new Tag[0];
            }
        }
        Tag[] res2 = new Tag[res.size()];
        res.toArray(res2);
        return res2;
    }

    public void supprimeTag(int id) throws NoBaseException {
        String query = "DELETE FROM rss_tags WHERE id=" + id + ";";
        this.theDB.executeDeletion(query);
        this.assureCoherence();
    }

    public void ajouteTag(int id, String nom) throws NoBaseException {
        String query = "INSERT INTO rss_tags(id, tag) VALUES(" + id + ", '" + Codecs.escapeHTML(nom) + "');";
        this.theDB.executeInsertOrUpdate(query);
    }

    public void modifieTag(int ancienId, int nouvelId, String nouveauNom) throws NoBaseException {
        String query = "UPDATE rss_tags SET id=" + nouvelId + ", tag='" + Codecs.escapeHTML(nouveauNom) + "' WHERE id=" + ancienId + ";";
        this.theDB.executeInsertOrUpdate(query);
    }

    public Source[] getSources() throws NoBaseException {
        String query = "SELECT id, nom, homePage FROM rss_sources;";
        ResultSet tags = this.theDB.executeSelection(query);
        Vector<Source> res = new Vector<Source>();
        if (tags != null) {
            try {
                while (tags.next()) {
                    int id = tags.getInt("id");
                    String nom = Codecs.desEscapeHTML(tags.getString("nom"));
                    String homePage = Codecs.desEscapeURL(tags.getString("homePage"));
                    res.addElement(new Source(id, nom, homePage));
                }
                tags.close();
            }
            catch (Exception e) {
                return new Source[0];
            }
        }
        Source[] res2 = new Source[res.size()];
        res.toArray(res2);
        return res2;
    }

    public void supprimeSource(int id) throws NoBaseException {
        String query = "DELETE FROM rss_sources WHERE id=" + id + ";";
        this.theDB.executeDeletion(query);
        this.assureCoherence();
    }

    public void ajouteSource(String nom, String homePage) throws NoBaseException {
        String query = "INSERT INTO rss_sources(nom, homePage) VALUES('" + Codecs.escapeHTML(nom) + "', '" + homePage + "');";
        this.theDB.executeInsertOrUpdate(query);
    }

    public void modifieSource(int id, String nouveauNom, String nouvellePage) throws NoBaseException {
        String query = "UPDATE rss_sources SET nom='" + Codecs.escapeHTML(nouveauNom) + "', homePage='" + nouvellePage + "' WHERE id=" + id + ";";
        this.theDB.executeInsertOrUpdate(query);
    }

    public Flux[] getFlux() throws NoBaseException {
        String query = "SELECT id, nom, url FROM rss_flux;";
        ResultSet tags = this.theDB.executeSelection(query);
        Vector<Flux> res = new Vector<Flux>();
        if (tags != null) {
            try {
                while (tags.next()) {
                    int id = tags.getInt("id");
                    String nom = Codecs.desEscapeHTML(tags.getString("nom"));
                    String url = Codecs.desEscapeURL(tags.getString("url"));
                    res.addElement(new Flux(id, nom, url));
                }
                tags.close();
            }
            catch (Exception e) {
                return new Flux[0];
            }
        }
        Flux[] res2 = new Flux[res.size()];
        res.toArray(res2);
        return res2;
    }

    public void ajouteFlux(String nom, String url, Source source) throws NoBaseException {
        String query = "INSERT INTO rss_flux(nom, url, source) VALUES('" + Codecs.escapeHTML(nom) + "', '" + url + "', " + source.getId() + ");";
        this.theDB.executeInsertOrUpdate(query);
    }

    public void modifieFlux(int id, String nouveauNom, String nouvellePage, Source nouvelleSource) throws NoBaseException {
        String query = "UPDATE rss_flux SET nom='" + Codecs.escapeHTML(nouveauNom) + "', url='" + nouvellePage + "', source=" + nouvelleSource.getId() + " WHERE id=" + id + ";";
        this.theDB.executeInsertOrUpdate(query);
    }

    public void supprimeFlux(int id) throws NoBaseException {
        String query = "DELETE FROM rss_flux WHERE id=" + id + ";";
        this.theDB.executeDeletion(query);
        this.assureCoherence();
    }

    public Tag[] getTagsDuFlux(Flux flux) throws NoBaseException {
        String query = "SELECT t.id, t.tag FROM rss_tags t, rss_tagflux f WHERE f.flux=" + flux.getId() + " AND f.tag=t.id;";
        ResultSet tags = this.theDB.executeSelection(query);
        Vector<Tag> res = new Vector<Tag>();
        if (tags != null) {
            try {
                while (tags.next()) {
                    int id = tags.getInt("id");
                    String tag = Codecs.desEscapeHTML(tags.getString("tag"));
                    res.addElement(new Tag(id, tag));
                }
                tags.close();
            }
            catch (Exception e) {
                return new Tag[0];
            }
        }
        Tag[] res2 = new Tag[res.size()];
        res.toArray(res2);
        return res2;
    }

    public Source getSourceDuFlux(Flux flux) throws NoBaseException {
        String query = "SELECT s.id, s.nom, s.homePage FROM rss_sources s, rss_flux f WHERE f.id=" + flux.getId() + " AND f.source=s.id;";
        ResultSet tags = this.theDB.executeSelection(query);
        Source res = null;
        if (tags != null) {
            try {
                while (tags.next()) {
                    int id = tags.getInt("id");
                    String nom = Codecs.desEscapeHTML(tags.getString("nom"));
                    String homePage = Codecs.desEscapeURL(tags.getString("homePage"));
                    res = new Source(id, nom, homePage);
                }
                tags.close();
            }
            catch (Exception e) {
                return null;
            }
        }
        return res;
    }

    public void ajouteTagAuFlux(Tag tag, Flux flux) throws NoBaseException {
        String query = "INSERT INTO rss_tagflux(flux, tag) VALUES(" + flux.getId() + ", " + tag.getId() + ");";
        this.theDB.executeInsertOrUpdate(query);
    }

    public void supprimeTagDuFlux(Tag tag, Flux flux) throws NoBaseException {
        String query = "DELETE FROM rss_tagflux WHERE flux=" + flux.getId() + " AND tag=" + tag.getId() + ";";
        this.theDB.executeDeletion(query);
    }

    private void assureCoherence() throws NoBaseException {
        String query = "DELETE FROM rss_flux WHERE source NOT IN (SELECT id FROM rss_source);";
        this.theDB.executeDeletion(query);
        query = "DELETE FROM rss_tagflux WHERE tag NOT IN (SELECT id FROM rss_tags);";
        this.theDB.executeDeletion(query);
        query = "DELETE FROM rss_tagflux WHERE flux NOT IN (SELECT id FROM rss_flux);";
        this.theDB.executeDeletion(query);
    }
}

