/*
 * Decompiled with CFR 0.152.
 */
package data.base.connectors;

import data.base.Database;
import data.base.NoBaseException;
import data.structures.resources.RessourceItem;
import data.structures.tagging.LemmaInfos;
import data.structures.tagging.LemmaVector;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.Vector;
import proc.tagging.TreeTagger;
import proc.text.Codecs;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DBPediaDatabase {
    private Database theDB;
    private TreeTagger tt = new TreeTagger();
    private TreeTagger tt2 = new TreeTagger(1);
    private TreeTagger tte = new TreeTagger(1);

    public DBPediaDatabase(Database db) {
        this.theDB = db;
    }

    private HashMap getAllRessources() throws NoBaseException {
        LinkedHashMap<Integer, String> result = new LinkedHashMap<Integer, String>();
        String query = String.format("SELECT id, uri FROM onto_concepts", new Object[0]);
        ResultSet rs = this.theDB.executeSelection(query);
        try {
            while (rs.next()) {
                String url = Codecs.desEscapeHTML(rs.getString("uri"));
                int id = rs.getInt("id");
                result.put(id, url);
            }
        }
        catch (SQLException e) {
            System.out.println("error on " + e.toString());
        }
        return result;
    }

    public Set<RessourceItem> getAllRessourcesItems() throws NoBaseException {
        String query = String.format("SELECT * FROM ipri_ressource", new Object[0]);
        ResultSet rs = this.theDB.executeSelection(query);
        LinkedHashSet<RessourceItem> items = new LinkedHashSet<RessourceItem>();
        try {
            while (rs.next()) {
                RessourceItem ri = new RessourceItem();
                ri.setRessourceID(rs.getInt("id_ressource"));
                ri.setUrl(Codecs.desEscapeHTML(rs.getString("url")));
                ri.setNom(Codecs.desEscapeHTML(rs.getString("nom")));
                ri.setDesc(Codecs.desEscapeHTML(rs.getString("desc")));
                items.add(ri);
            }
        }
        catch (SQLException e) {
            System.out.println("error on get ressource last key " + e.toString());
        }
        return items;
    }

    public int UpdateLemmas(RessourceItem item) throws NoBaseException {
        String query = String.format("UPDATE ipri_ressource SET desc_lemmes = '%s' WHERE id_ressource = %d LIMIT 1", Codecs.escapeHTML(item.getDescLemmas()), item.getRessourceID());
        return this.theDB.executeInsertOrUpdate(query);
    }

    public Set<RessourceItem> getRelatedItems(int rssID) throws NoBaseException {
        String query = String.format("SELECT id_ressource FROM ipri_ressource_item WHERE id_rssitem = " + rssID + "", new Object[0]);
        ResultSet rs = this.theDB.executeSelection(query);
        LinkedHashSet<RessourceItem> keys = new LinkedHashSet<RessourceItem>();
        LinkedHashSet<RessourceItem> items = new LinkedHashSet<RessourceItem>();
        try {
            while (rs.next()) {
                RessourceItem ri = new RessourceItem();
                ri.setRessourceID(rs.getInt("id_ressource"));
                keys.add(ri);
            }
        }
        catch (SQLException e) {
            System.out.println("error on get ressource last key " + e.toString());
        }
        for (RessourceItem ri : keys) {
            ri = this.getRessourceItem(ri.getRessourceID());
            items.add(ri);
        }
        return items;
    }

    public RessourceItem getRessourceItem(int ressource_id) throws NoBaseException {
        RessourceItem myItem = new RessourceItem();
        String query = String.format("SELECT * FROM ipri_ressource WHERE id_ressource=" + ressource_id + " LIMIT 1", new Object[0]);
        ResultSet rs = this.theDB.executeSelection(query);
        try {
            while (rs.next()) {
                myItem.setRessourceID(rs.getInt("id_ressource"));
                myItem.setUrl(Codecs.desEscapeHTML(rs.getString("url")));
                myItem.setNom(Codecs.desEscapeHTML(rs.getString("nom")));
                myItem.setDesc(Codecs.desEscapeHTML(rs.getString("desc")));
                myItem.setDescLemmas(Codecs.desEscapeHTML(rs.getString("desc_lemmes")));
            }
        }
        catch (SQLException e) {
            System.out.println("error on get ressource last key " + e.toString());
        }
        return myItem;
    }

    public int InsertLemma(int idThema, String lemma, int nbTitle, int nbDesc) throws NoBaseException {
        String query = String.format("INSERT INTO ipri_ressource(idThema,lemme,countTitle,countDesc)  VALUES (" + idThema + ",'%s',%d,%d)", Codecs.escapeHTML(lemma), nbTitle, nbDesc);
        return this.theDB.executeInsertOrUpdate(query);
    }

    public void resetPages() throws NoBaseException {
        System.err.print("bouh");
        String query = "DELETE FROM onto_lemmesfr WHERE concept IN {SELECT id FROM onto_concepts WHERE ontologie=1};";
        this.theDB.executeDeletion(query);
        String query2 = "DELETE FROM onto_lemmesen WHERE concept IN {SELECT id FROM onto_concepts WHERE ontologie=1};";
        this.theDB.executeDeletion(query2);
        String query3 = "DELETE FROM onto_relations WHERE ontologie=1;";
        this.theDB.executeDeletion(query3);
        String query4 = "DELETE FROM onto_concepts WHERE ontologie=1;";
        this.theDB.executeDeletion(query4);
        System.err.print("bouh");
    }

    public int storeLabelPage(String label, String concept) throws NoBaseException {
        String query = "INSERT INTO onto_concepts(ontologie, uri, titreFR, descriptionFR, titreEN, descriptionEN,titreLemmaFR, descLemmaFR, titreLemmaEN, descLemmaEN) VALUES (1, '" + Codecs.escapeHTML(concept) + "', '" + Codecs.escapeHTML(label) + "'," + " '', '', '', '', '', '', '');";
        return this.theDB.executeInsertOrUpdate(query);
    }

    public int storeDescriptionPage(String desc, String concept) throws NoBaseException {
        String query = "UPDATE onto_concepts SET descriptionFR='" + Codecs.escapeHTML(desc) + "' WHERE uri='" + Codecs.escapeHTML(concept) + "' AND ontologie=1;";
        return this.theDB.executeInsertOrUpdate(query);
    }

    public int getConceptsCount() throws NoBaseException {
        String query = String.format("SELECT MAX(id) FROM onto_concepts WHERE ontologie=1", new Object[0]);
        ResultSet rs = this.theDB.executeSelection(query);
        int res = 0;
        try {
            if (rs.next()) {
                res = rs.getInt(1);
            }
        }
        catch (SQLException e) {
            System.out.println("error on get count " + e.toString());
        }
        return res;
    }

    public void lieConceptOntologie(int id) throws NoBaseException {
        String query = "SELECT ConceptName FROM ipri_onto_concepts WHERE ResourceID=2";
        ResultSet rs = this.theDB.executeSelection(query);
        String res = null;
        try {
            if (rs.next()) {
                res = rs.getString(1);
            }
        }
        catch (SQLException e) {
            System.out.println("error on get count " + e.toString());
        }
        if (res == null) {
            return;
        }
        String query2 = "SELECT CategorieName FROM ipri_onto_categories WHERE ConceptName='" + Codecs.escapeHTML(res) + "';";
        ResultSet rs2 = this.theDB.executeSelection(query2);
        Vector<String> res2 = new Vector<String>();
        try {
            while (rs2.next()) {
                res2.addElement(rs2.getString(1));
            }
        }
        catch (SQLException e) {
            System.out.println("error on get count " + e.toString());
        }
        for (int i = 0; i < res2.size(); ++i) {
            String query3 = "SELECT id FROM ipri_ontologie WHERE ressource='" + Codecs.escapeHTML((String)res2.elementAt(i)) + "' AND ressourceId=2;";
            ResultSet rs3 = this.theDB.executeSelection(query3);
            int res3 = 0;
            try {
                if (rs3.next()) {
                    res3 = rs3.getInt(1);
                }
            }
            catch (SQLException e) {
                System.out.println("error on get count " + e.toString());
            }
            String query4 = "INSERT INTO ipri_onto_con_cate_onto(idConcept, idCateOnto, idRessource) VALUES (" + id + ", " + res3 + ", 2);";
            this.theDB.executeInsertOrUpdate(query4);
        }
    }

    public void lieConceptWikipedia(int id) throws NoBaseException {
        String query = "SELECT ConceptName FROM ipri_onto_concepts WHERE ResourceID=2";
        ResultSet rs = this.theDB.executeSelection(query);
        String res = null;
        try {
            if (rs.next()) {
                res = rs.getString(1);
            }
        }
        catch (SQLException e) {
            System.out.println("error on get count " + e.toString());
        }
        if (res == null) {
            return;
        }
        String query2 = "SELECT CategorieName FROM ipri_onto_categories2 WHERE ConceptName='" + Codecs.escapeHTML(res) + "';";
        ResultSet rs2 = this.theDB.executeSelection(query2);
        Vector<String> res2 = new Vector<String>();
        try {
            while (rs2.next()) {
                res2.addElement(rs2.getString(1));
            }
        }
        catch (SQLException e) {
            System.out.println("error on get count " + e.toString());
        }
        for (int i = 0; i < res2.size(); ++i) {
            String query3 = "SELECT idCategorie FROM ipri_onto_cate_labels WHERE CategorieName='" + Codecs.escapeHTML((String)res2.elementAt(i)) + "' AND idRessource=2;";
            ResultSet rs3 = this.theDB.executeSelection(query3);
            int res3 = 0;
            try {
                if (rs3.next()) {
                    res3 = rs3.getInt(1);
                }
            }
            catch (SQLException e) {
                System.out.println("error on get count " + e.toString());
            }
            String query4 = "INSERT INTO ipri_onto_con_cate_wiki(idConcept, idCateWiki, idRessource) VALUES (" + id + ", " + res3 + ", 2);";
            this.theDB.executeInsertOrUpdate(query4);
        }
    }

    public int getLastConceptLieOnto() throws NoBaseException {
        String query = String.format("SELECT MAX(idConcept) FROM ipri_onto_con_cate_onto WHERE idRessource=2;", new Object[0]);
        ResultSet rs = this.theDB.executeSelection(query);
        int res = 0;
        try {
            if (rs.next()) {
                res = rs.getInt(1);
            }
        }
        catch (SQLException e) {
            System.out.println("error on get last linked concept " + e.toString());
        }
        catch (NullPointerException npe) {
            // empty catch block
        }
        return res;
    }

    public int getLastConceptLieWiki() throws NoBaseException {
        String query = String.format("SELECT MAX(idConcept) FROM ipri_onto_con_cate_wiki WHERE idRessource=2;", new Object[0]);
        ResultSet rs = this.theDB.executeSelection(query);
        int res = 0;
        try {
            if (rs.next()) {
                res = rs.getInt(1);
            }
        }
        catch (SQLException e) {
            System.out.println("error on get last linked concept " + e.toString());
        }
        catch (NullPointerException npe) {
            // empty catch block
        }
        return res;
    }

    public void resetOptimisationConcepts() throws NoBaseException {
        String query = "DELETE FROM ipri_onto_con_cate_onto;";
        this.theDB.executeDeletion(query);
        query = "DELETE FROM ipri_onto_con_cate_wiki;";
        this.theDB.executeDeletion(query);
    }

    public int getLastLemmatizedConcept() throws NoBaseException {
        String query = String.format("SELECT MAX(l.concept) FROM onto_concepts c, onto_lemmesfr l WHERE c.id=l.concept AND c.ontologie=1;", new Object[0]);
        ResultSet rs = this.theDB.executeSelection(query);
        int res = 0;
        try {
            if (rs.next()) {
                res = rs.getInt(1);
            }
        }
        catch (SQLException e) {
            System.out.println("error on get last lemmatized concept " + e.toString());
        }
        catch (NullPointerException npe) {
            // empty catch block
        }
        return res;
    }

    public void lemmatiseConcept(int id) throws NoBaseException {
        String query = "SELECT titreFR, descriptionFR FROM onto_concepts WHERE id=" + id + " AND ontologie=1;";
        ResultSet rs = this.theDB.executeSelection(query);
        String label = "";
        String desc = "";
        try {
            if (rs.next()) {
                label = Codecs.desEscapeHTML(rs.getString("titreFR"));
                desc = Codecs.desEscapeHTML(rs.getString("descriptionFR"));
            }
        }
        catch (SQLException e) {
            System.out.println("error on get count " + e.toString());
        }
        LemmaVector lemmasLabel = this.tt.processText(label);
        LemmaVector lemmasDesc = this.tt.processText(desc);
        this.storeLemmasConcept(id, lemmasLabel, lemmasDesc);
    }

    public int getCategoriesCount() throws NoBaseException {
        String query = String.format("SELECT MAX(idCategorie) FROM ipri_onto_cate_labels WHERE idRessource=2", new Object[0]);
        ResultSet rs = this.theDB.executeSelection(query);
        int res = 0;
        try {
            if (rs.next()) {
                res = rs.getInt(1);
            }
        }
        catch (SQLException e) {
            System.out.println("error on get count " + e.toString());
        }
        return res;
    }

    public int getLastLemmatizedCategorie() throws NoBaseException {
        String query = String.format("SELECT MAX(l.idCategorie) FROM ipri_onto_cate_labels c, ipri_onto_cate_lemmes_en l WHERE c.idCategorie=l.idCategorie AND c.idRessource=2;", new Object[0]);
        ResultSet rs = this.theDB.executeSelection(query);
        int res = 0;
        try {
            if (rs.next()) {
                res = rs.getInt(1);
            }
        }
        catch (SQLException e) {
            System.out.println("error on get last lemmatized concept " + e.toString());
        }
        catch (NullPointerException npe) {
            // empty catch block
        }
        return res;
    }

    public void lemmatiseCategorie(int id) throws NoBaseException {
        String query = String.format("SELECT idRessource, CategorieLabel FROM ipri_onto_cate_labels WHERE idCategorie=" + id, new Object[0]);
        ResultSet rs = this.theDB.executeSelection(query);
        int res = 0;
        String label = "";
        try {
            if (rs.next()) {
                res = rs.getInt("idRessource");
                label = Codecs.desEscapeHTML(rs.getString("CategorieLabel"));
            }
        }
        catch (SQLException e) {
            System.out.println("error on get count " + e.toString());
        }
        if (res != 2) {
            return;
        }
        LemmaVector lemmasLabel = this.tt2.processText(label);
        this.storeLemmasCategorie(id, lemmasLabel);
    }

    public void resetCategories() throws NoBaseException {
        String query = "DELETE FROM ipri_onto_categories;";
        this.theDB.executeDeletion(query);
    }

    public int storeCategorie(String concept, String categorie) throws NoBaseException {
        String query = "INSERT INTO ipri_onto_categories(ConceptName, CategorieName) VALUES('" + Codecs.escapeHTML(concept) + "', '" + Codecs.escapeHTML(categorie) + "');";
        return this.theDB.executeInsertOrUpdate(query);
    }

    public void resetCategories2() throws NoBaseException {
        String query = "DELETE FROM ipri_onto_categories2;";
        this.theDB.executeDeletion(query);
        this.resetOptimisationConcepts();
    }

    public int storeCategorie2(String concept, String categorie) throws NoBaseException {
        String query = "INSERT INTO ipri_onto_categories2(ConceptName, CategorieName) VALUES('" + Codecs.escapeHTML(concept) + "', '" + Codecs.escapeHTML(categorie) + "');";
        return this.theDB.executeInsertOrUpdate(query);
    }

    public void resetLabelsCategories() throws NoBaseException {
        String query = "DELETE FROM ipri_onto_cate_labels WHERE idRessource=2;";
        this.theDB.executeDeletion(query);
        this.resetOptimisationConcepts();
    }

    public int storeLabelCategorie(String concept, String categorie) throws NoBaseException {
        String query = "INSERT INTO ipri_onto_cate_labels(CategorieName, CategorieLabel, idRessource) VALUES('" + Codecs.escapeHTML(concept) + "', '" + Codecs.escapeHTML(categorie) + "', 2);";
        return this.theDB.executeInsertOrUpdate(query);
    }

    public void resetOntologie() throws NoBaseException {
        String query = "DELETE FROM ipri_onto_lemmes_en WHERE idConcept IN (SELECT id FROM ipri_ontologie WHERE ressourceId=2);";
        this.theDB.executeDeletion(query);
        String query2 = "DELETE FROM ipri_relation WHERE idSemantic_ressources=2;";
        this.theDB.executeDeletion(query2);
        String query3 = "DELETE FROM ipri_ontologie WHERE ressourceId=2;";
        this.theDB.executeDeletion(query3);
        this.resetOptimisationConcepts();
    }

    public void storeClasse(String classe, String label) throws NoBaseException {
        String query1 = "INSERT INTO ipri_ontologie(ressource, nom, ressourceId) VALUES ('" + Codecs.escapeHTML(classe) + "', '" + Codecs.escapeHTML(label) + "', 2);";
        this.theDB.executeInsertOrUpdate(query1);
        String queryConcept = "SELECT id FROM ipri_ontologie WHERE ressource='" + Codecs.escapeHTML(classe) + "';";
        ResultSet rsCon = this.theDB.executeSelection(queryConcept);
        int idConcept = -1;
        try {
            if (rsCon.next()) {
                idConcept = rsCon.getInt("id");
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        LemmaVector lemmas = this.tte.processText(label);
        Vector<LemmaInfos> liste = lemmas.getLemmas();
        LinkedHashMap<LemmaInfos, Integer> lemmasCount = lemmas.toLemmasCount();
        for (int i = 0; i < liste.size(); ++i) {
            String lemma = liste.elementAt(i).get_lemma();
            String lex = liste.elementAt(i).get_lex();
            if (this.unwantedLemma(lemma)) continue;
            String queryLemma = "INSERT INTO ipri_onto_lemmes_en(idConcept, lemme, countTitle, countDesc, Lex) VALUES(" + idConcept + ", '" + Codecs.escapeHTML(lemma) + "', " + lemmasCount.get(liste.elementAt(i)) + ", " + 0 + ", '" + lex + "');";
            this.theDB.executeInsertOrUpdate(queryLemma);
        }
    }

    public void storeRelation(String classe, String categorie) throws NoBaseException {
        String queryConcept = "SELECT id FROM ipri_ontologie WHERE ressource='" + Codecs.escapeHTML(classe) + "';";
        ResultSet rsCon = this.theDB.executeSelection(queryConcept);
        int idConcept = -1;
        try {
            if (rsCon.next()) {
                idConcept = rsCon.getInt("id");
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        if (idConcept == -1) {
            return;
        }
        String queryCategorie = "SELECT id FROM ipri_ontologie WHERE ressource='" + Codecs.escapeHTML(categorie) + "';";
        ResultSet rsCat = this.theDB.executeSelection(queryCategorie);
        int idCategorie = -1;
        try {
            if (rsCat.next()) {
                idCategorie = rsCat.getInt("id");
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        if (idCategorie == -1) {
            String queryInsCat = "INSERT INTO ipri_ontologie(ressource, nom, ressourceId) VALUES('" + Codecs.escapeHTML(categorie) + "', '', 2);";
            this.theDB.executeInsertOrUpdate(queryInsCat);
        }
        ResultSet rsCat2 = this.theDB.executeSelection(queryCategorie);
        try {
            if (rsCat2.next()) {
                idCategorie = rsCat2.getInt("id");
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        if (idCategorie == -1) {
            return;
        }
        String query = "INSERT INTO ipri_relation(ConceptID1, RelationType, ConceptID2, idSemantic_ressources) VALUES (" + idCategorie + ", 'generalise', " + idConcept + ", 2);";
        this.theDB.executeInsertOrUpdate(query);
    }

    private void storeLemmasConcept(int itemId, LemmaVector title, LemmaVector desc) {
        String lex;
        String lemma;
        int i;
        LinkedHashMap<LemmaInfos, Integer> lemmasCountTitle = title.toLemmasCount();
        LinkedHashMap<LemmaInfos, Integer> lemmasCountDesc = desc.toLemmasCount();
        Vector<LemmaInfos> liste = title.getLemmas();
        for (i = 0; i < liste.size(); ++i) {
            lemma = liste.elementAt(i).get_lemma();
            lex = liste.elementAt(i).get_lex();
            if (lemmasCountDesc.containsKey(liste.elementAt(i))) {
                try {
                    this.insertLemmaConcept(itemId, lemma, (Integer)lemmasCountTitle.get(liste.elementAt(i)), (Integer)lemmasCountDesc.get(liste.elementAt(i)), lex);
                }
                catch (Exception ex) {
                    System.out.println(String.format("Lemme title+desc insert problem :" + ex.getMessage(), new Object[0]));
                }
                continue;
            }
            try {
                this.insertLemmaConcept(itemId, lemma, (Integer)lemmasCountTitle.get(liste.elementAt(i)), 0, lex);
                continue;
            }
            catch (Exception ex) {
                System.out.println(String.format("Lemme title insert problem :" + ex.getMessage(), new Object[0]));
            }
        }
        liste = desc.getLemmas();
        for (i = 0; i < liste.size(); ++i) {
            lemma = liste.elementAt(i).get_lemma();
            lex = liste.elementAt(i).get_lex();
            if (lemmasCountTitle.containsKey(liste.elementAt(i))) continue;
            try {
                this.insertLemmaConcept(itemId, lemma, 0, (Integer)lemmasCountDesc.get(liste.elementAt(i)), lex);
                continue;
            }
            catch (Exception ex) {
                System.out.println(String.format("Lemme desc insert problem :" + ex.getMessage(), new Object[0]));
            }
        }
    }

    private void storeLemmasCategorie(int itemId, LemmaVector label) {
        LinkedHashMap<LemmaInfos, Integer> lemmasCountLabel = label.toLemmasCount();
        Vector<LemmaInfos> liste = label.getLemmas();
        for (int i = 0; i < liste.size(); ++i) {
            String lemma = liste.elementAt(i).get_lemma();
            String lex = liste.elementAt(i).get_lex();
            try {
                this.insertLemmaCategorie(itemId, lemma, (Integer)lemmasCountLabel.get(liste.elementAt(i)), lex);
                continue;
            }
            catch (Exception ex) {
                System.out.println(String.format("Lemme title insert problem :" + ex.getMessage(), new Object[0]));
            }
        }
    }

    private void insertLemmaConcept(int id, String lemma, int a, int b, String lex) throws NoBaseException {
        if (!this.unwantedLemma(lemma)) {
            String queryLemma = "INSERT INTO onto_lemmesfr(concept, lemme, occuTitre, occuDesc, nature) VALUES(" + id + ", '" + Codecs.escapeHTML(lemma) + "', " + a + ", " + b + ", '" + Codecs.escapeHTML(lex) + "');";
            this.theDB.executeInsertOrUpdate(queryLemma);
        }
    }

    private void insertLemmaCategorie(int id, String lemma, int a, String lex) throws NoBaseException {
        if (!this.unwantedLemma(lemma)) {
            String queryLemma = "INSERT INTO onto_lemmesen(concept, lemme, occuTitre, occuDesc, nature) VALUES(" + id + ", '" + Codecs.escapeHTML(lemma) + "', " + a + ", 0, '" + Codecs.escapeHTML(lex) + "');";
            this.theDB.executeInsertOrUpdate(queryLemma);
        }
    }

    private boolean unwantedLemma(String lemma) {
        return false;
    }
}

