/*
 * Decompiled with CFR 0.152.
 */
package arq.cmdline;

import arq.cmdline.ArgDecl;
import arq.cmdline.ArgModuleGeneral;
import arq.cmdline.CmdArgModule;
import arq.cmdline.CmdGeneral;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.Syntax;
import com.hp.hpl.jena.sparql.util.IndentedWriter;
import com.hp.hpl.jena.sparql.util.PrintUtils;
import java.io.OutputStream;

public class ModQueryOut
implements ArgModuleGeneral {
    protected final ArgDecl queryOutputSyntaxDecl = new ArgDecl(true, "out", "format");
    protected final ArgDecl queryNumberDecl = new ArgDecl(false, "num", "number");
    private Syntax outputSyntax = Syntax.syntaxSPARQL;
    private boolean lineNumbers = false;

    public void registerWith(CmdGeneral cmdLine) {
        cmdLine.getUsage().startCategory("Output");
        cmdLine.add(this.queryOutputSyntaxDecl, "--out, --format", "Output syntax");
        cmdLine.add(this.queryNumberDecl, "--num", "Print line numbers");
    }

    public void processArgs(CmdArgModule cmdline) throws IllegalArgumentException {
        if (cmdline.contains(this.queryOutputSyntaxDecl)) {
            String s = cmdline.getValue(this.queryOutputSyntaxDecl);
            Syntax syn = Syntax.lookup((String)s);
            if (syn == null) {
                cmdline.cmdError("Unrecognized syntax: " + s);
            }
            this.outputSyntax = syn;
        }
        this.lineNumbers = cmdline.contains(this.queryNumberDecl);
    }

    public Syntax getOutputSyntax() {
        return this.outputSyntax;
    }

    public void output(Query query2) {
        this.output(this.out(), query2);
    }

    public void output(IndentedWriter out, Query query2) {
        PrintUtils.printQuery((IndentedWriter)out, (Query)query2, (Syntax)this.outputSyntax);
    }

    public void outputOp(Query query2, boolean printOptimized) {
        this.outputOp(this.out(), query2, printOptimized);
    }

    public void outputOp(IndentedWriter out, Query query2, boolean printOptimized) {
        PrintUtils.printOp((IndentedWriter)out, (Query)query2, (boolean)printOptimized);
    }

    public void outputQuad(Query query2, boolean printOptimized) {
        this.outputQuad(this.out(), query2, printOptimized);
    }

    public void outputQuad(IndentedWriter out, Query query2, boolean printOptimized) {
        PrintUtils.printQuad((IndentedWriter)out, (Query)query2, (boolean)printOptimized);
    }

    private IndentedWriter out() {
        return new IndentedWriter((OutputStream)System.out, this.lineNumbers);
    }
}

