/*
 * Decompiled with CFR 0.152.
 */
package org.annolab.tt4j;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Util {
    private Util() {
    }

    public static List<String> getSearchPaths(List<String> aAdditionalPaths, String aSubPath) {
        ArrayList<String> paths = new ArrayList<String>();
        paths.addAll(aAdditionalPaths);
        if (System.getProperty("treetagger.home") != null) {
            paths.add(System.getProperty("treetagger.home") + File.separator + aSubPath);
        }
        if (System.getenv("TREETAGGER_HOME") != null) {
            paths.add(System.getenv("TREETAGGER_HOME") + File.separator + aSubPath);
        }
        if (System.getenv("TAGDIR") != null) {
            paths.add(System.getenv("TAGDIR") + File.separator + aSubPath);
        }
        return paths;
    }

    public static String join(String[] aStrings, String aSeparator) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < aStrings.length; ++i) {
            sb.append(aStrings[i]);
            if (i >= aStrings.length - 1) continue;
            sb.append(aSeparator);
        }
        return sb.toString();
    }

    public static String join(Collection<String> aStrings, String aSeparator) {
        StringBuilder sb = new StringBuilder();
        Iterator<String> i = aStrings.iterator();
        while (i.hasNext()) {
            sb.append(i.next());
            if (!i.hasNext()) continue;
            sb.append(aSeparator);
        }
        return sb.toString();
    }

    public static void close(Closeable aClosable) {
        if (aClosable != null) {
            try {
                aClosable.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

