/*
 * Decompiled with CFR 0.152.
 */
package org.annolab.tt4j;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Locale;
import java.util.regex.Pattern;
import org.annolab.tt4j.DefaultExecutableResolver;
import org.annolab.tt4j.DefaultModelResolver;
import org.annolab.tt4j.ExecutableResolver;
import org.annolab.tt4j.Model;
import org.annolab.tt4j.ModelResolver;
import org.annolab.tt4j.PlatformDetector;
import org.annolab.tt4j.TokenAdapter;
import org.annolab.tt4j.TokenHandler;
import org.annolab.tt4j.TreeTaggerException;
import org.annolab.tt4j.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TreeTaggerWrapper<O> {
    public static boolean TRACE = false;
    private static final Pattern RE_TAB = Pattern.compile("[\\t]");
    private static final Pattern RE_WHITESPACE = Pattern.compile("[\\p{Zs}\\p{C}]");
    private static final String STARTOFTEXT = "<This-is-the-start-of-the-text />";
    private static final String ENDOFTEXT = "<This-is-the-end-of-the-text />";
    private Model _model = null;
    private Process _proc = null;
    private String _procCmd = null;
    private TokenHandler<O> _handler = null;
    private TokenAdapter<O> _adapter = null;
    private PlatformDetector _platform = null;
    private ModelResolver _modelResolver = null;
    private ExecutableResolver _exeResolver = null;
    private Double _epsilon = null;
    private boolean _hyphenHeuristics = false;
    private String[] _ttArgs = new String[]{"-quiet", "-no-unknown", "-sgml", "-token", "-lemma"};
    private int _numTokens = 0;
    private int _tokensWritten = 0;
    private O _lastTokenWritten;
    private int _tokensRead = 0;
    private O _lastTokenRead;
    private String _lastTokenReadTT;
    private int _restartCount = 0;
    private boolean _performanceMode = false;

    public TreeTaggerWrapper() {
        this._modelResolver = new DefaultModelResolver();
        this._exeResolver = new DefaultExecutableResolver();
        this.setPlatformDetector(new PlatformDetector());
        if (!"false".equals(System.getProperty(this.getClass().getName() + ".TRACE", "false"))) {
            TRACE = true;
        }
    }

    public void setPerformanceMode(boolean performanceMode) {
        this._performanceMode = performanceMode;
    }

    public void setArguments(String[] aArgs) {
        this._ttArgs = aArgs;
        this.stopTaggerProcess();
    }

    public String[] getArguments() {
        return this._ttArgs;
    }

    public void setEpsilon(Double aEpsilon) {
        this._epsilon = aEpsilon;
        this.stopTaggerProcess();
    }

    public void setHyphenHeuristics(boolean hyphenHeuristics) {
        this._hyphenHeuristics = hyphenHeuristics;
        this.stopTaggerProcess();
    }

    public void setModelProvider(ModelResolver aModelProvider) {
        this._modelResolver = aModelProvider;
        this._modelResolver.setPlatformDetector(this._platform);
    }

    public void setExecutableProvider(ExecutableResolver aExeProvider) {
        this._exeResolver = aExeProvider;
        this._exeResolver.setPlatformDetector(this._platform);
    }

    public void setHandler(TokenHandler<O> aHandler) {
        this._handler = aHandler;
    }

    public void setAdapter(TokenAdapter<O> aAdapter) {
        this._adapter = aAdapter;
    }

    public void setPlatformDetector(PlatformDetector aPlatform) {
        this._platform = aPlatform;
        if (this._modelResolver != null) {
            this._modelResolver.setPlatformDetector(aPlatform);
        }
        if (this._exeResolver != null) {
            this._exeResolver.setPlatformDetector(aPlatform);
        }
    }

    public PlatformDetector getPlatformDetector() {
        return this._platform;
    }

    public void setModel(String modelName) throws IOException {
        if (this._model != null && this._model.getName().equals(modelName)) {
            return;
        }
        this.stopTaggerProcess();
        if (this._model != null) {
            this._model.destroy();
        }
        this._model = modelName != null ? this._modelResolver.getModel(modelName) : null;
    }

    public Model getModel() {
        return this._model;
    }

    public void destroy() {
        try {
            this.setModel(null);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (this._exeResolver != null) {
            this._exeResolver.destroy();
        }
    }

    protected void finalize() throws Throwable {
        this.destroy();
        super.finalize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(Collection<O> aTokenList) throws IOException, TreeTaggerException {
        Collection<O> aTokens = !this._performanceMode ? this.removeProblematicTokens(aTokenList) : aTokenList;
        this._numTokens = aTokens.size();
        this._tokensRead = 0;
        this._tokensWritten = 0;
        this._lastTokenRead = null;
        this._lastTokenReadTT = null;
        this._lastTokenWritten = null;
        Process taggerProc = this.getTaggerProcess();
        Reader reader = new Reader(taggerProc.getInputStream(), aTokens.iterator());
        Thread readerThread = new Thread(reader);
        readerThread.start();
        StreamGobbler gob = new StreamGobbler(taggerProc.getErrorStream());
        new Thread(gob).start();
        Writer writer = new Writer(aTokens.iterator());
        new Thread(writer).start();
        try {
            if (writer.getException() != null) {
                this.destroy();
                throw new TreeTaggerException(writer.getException());
            }
            if (reader.getException() != null) {
                this.destroy();
                throw new TreeTaggerException(reader.getException());
            }
            Reader reader2 = reader;
            synchronized (reader2) {
                while (readerThread.getState() != Thread.State.TERMINATED) {
                    try {
                        reader.wait(20L);
                    }
                    catch (InterruptedException e) {}
                }
            }
        }
        finally {
            gob.done();
        }
    }

    protected Collection<O> removeProblematicTokens(Collection<O> aTokenList) {
        ArrayList<O> filtered = new ArrayList<O>(aTokenList.size());
        Iterator<O> i = aTokenList.iterator();
        boolean skipped = true;
        String text = null;
        block9: while (i.hasNext()) {
            if (TRACE && skipped && text != null) {
                System.err.println("[" + this + "|TRACE] Skipping illegal token [" + text + "]");
            }
            skipped = true;
            O token = i.next();
            text = this.getText(token);
            if (text == null) continue;
            boolean onlyWhitespace = true;
            for (int n = 0; n < text.length(); ++n) {
                char c = text.charAt(n);
                switch (c) {
                    case '\n': {
                        continue block9;
                    }
                    case '\r': {
                        continue block9;
                    }
                    case '\t': {
                        continue block9;
                    }
                    case '\u200e': {
                        continue block9;
                    }
                    case '\u200f': {
                        continue block9;
                    }
                    case '\u2028': {
                        continue block9;
                    }
                    case '\u2029': {
                        continue block9;
                    }
                }
                if (!onlyWhitespace) continue;
                onlyWhitespace &= Character.isWhitespace(c);
            }
            if (onlyWhitespace) continue;
            filtered.add(token);
            skipped = false;
        }
        return filtered;
    }

    private Process getTaggerProcess() throws IOException {
        if (this._proc == null) {
            this._model.install();
            ArrayList<String> cmd = new ArrayList<String>();
            cmd.add(this._exeResolver.getExecutable());
            for (String arg : this._ttArgs) {
                cmd.add(arg);
            }
            if (this._epsilon != null) {
                cmd.add("-eps");
                cmd.add(String.format(Locale.US, "%.12f", this._epsilon));
            }
            if (this._hyphenHeuristics) {
                cmd.add("-hyphen-heuristics");
            }
            cmd.add(this._model.getFile().getAbsolutePath());
            this._procCmd = Util.join(cmd, " ");
            ProcessBuilder pb = new ProcessBuilder(new String[0]);
            pb.command(cmd);
            this._proc = pb.start();
            ++this._restartCount;
        }
        return this._proc;
    }

    private void stopTaggerProcess() {
        if (this._proc != null) {
            this._proc.destroy();
            this._proc = null;
            this._procCmd = null;
        }
    }

    private String getText(O o) {
        if (this._adapter == null) {
            return o.toString();
        }
        return this._adapter.getText(o);
    }

    public String getStatus() {
        StringBuilder sb = new StringBuilder();
        sb.append("Last token read (#").append(this._tokensRead).append("): ");
        if (this._lastTokenRead != null) {
            sb.append("[").append(this.getText(this._lastTokenRead)).append("]");
            sb.append(" - (").append(this._lastTokenReadTT + ")");
        } else {
            sb.append("none");
        }
        sb.append("\n");
        sb.append("Last token written (#").append(this._tokensWritten).append("): ");
        if (this._lastTokenWritten != null) {
            sb.append("[").append(this.getText(this._lastTokenWritten)).append("]");
        } else {
            sb.append("none");
        }
        sb.append("\n");
        sb.append("Tokens originally recieved: ").append(this._numTokens).append("\n");
        sb.append("Tokens written            : ").append(this._tokensWritten).append("\n");
        sb.append("Tokens read               : ").append(this._tokensRead).append("\n");
        return sb.toString();
    }

    public int getRestartCount() {
        return this._restartCount;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Writer
    implements Runnable {
        private final Iterator<O> tokenIterator;
        private Exception _exception;
        private PrintWriter _pw;

        public Writer(Iterator<O> aTokenIterator) {
            this.tokenIterator = aTokenIterator;
        }

        @Override
        public void run() {
            try {
                OutputStream os = TreeTaggerWrapper.this._proc.getOutputStream();
                this._pw = new PrintWriter(new BufferedWriter(new OutputStreamWriter(os, TreeTaggerWrapper.this._model.getEncoding())));
                this.send(TreeTaggerWrapper.STARTOFTEXT);
                while (this.tokenIterator.hasNext()) {
                    Object token = this.tokenIterator.next();
                    this.send(TreeTaggerWrapper.this.getText(token));
                    TreeTaggerWrapper.this._lastTokenWritten = token;
                    TreeTaggerWrapper.this._tokensWritten++;
                }
                this.send(TreeTaggerWrapper.ENDOFTEXT);
                this.send("\n.\n" + TreeTaggerWrapper.this._model.getFlushSequence() + ".\n.\n.\n.\n");
            }
            catch (Exception e) {
                this._exception = e;
            }
        }

        private void send(String line) {
            this._pw.println(line);
            this._pw.flush();
        }

        public Exception getException() {
            return this._exception;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Reader
    implements Runnable {
        private final Iterator<O> tokenIterator;
        private final BufferedReader in;
        private final InputStream ins;
        private Exception _exception;

        public Reader(InputStream aIn, Iterator<O> aTokenIterator) throws UnsupportedEncodingException {
            this.ins = aIn;
            this.in = new BufferedReader(new InputStreamReader(this.ins, TreeTaggerWrapper.this._model.getEncoding()));
            this.tokenIterator = aTokenIterator;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block13: {
                try {
                    String s;
                    boolean inText = false;
                    while (true) {
                        if ((s = this.in.readLine()) == null) {
                            throw new IOException("TreeTagger has died. Make sure the following comand (in parentheses) works when running it from the command line: [echo \"test\" | " + TreeTaggerWrapper.this._procCmd + "]");
                        }
                        if (TreeTaggerWrapper.STARTOFTEXT.equals(s = s.trim())) {
                            inText = true;
                            if (!TRACE) continue;
                            System.err.println("[" + TreeTaggerWrapper.this + "|TRACE] (" + TreeTaggerWrapper.this._tokensRead + ") START [" + s + "]");
                            continue;
                        }
                        if (TreeTaggerWrapper.ENDOFTEXT.equals(s)) {
                            if (TRACE) {
                                System.err.println("[" + TreeTaggerWrapper.this + "|TRACE] (" + TreeTaggerWrapper.this._tokensRead + ") COMPLETE [" + s + "]");
                            }
                            break block13;
                        }
                        if (!inText) continue;
                        String posTag = null;
                        String lemma = null;
                        String[] fields1 = RE_TAB.split(s, 2);
                        if (fields1.length == 2) {
                            String tags = fields1[1];
                            String[] fields2 = RE_WHITESPACE.split(tags, 3);
                            if (fields2.length >= 2) {
                                posTag = fields2[0].trim().intern();
                                lemma = fields2[1].trim();
                            }
                        }
                        if (!this.tokenIterator.hasNext()) break;
                        Object token = this.tokenIterator.next();
                        TreeTaggerWrapper.this._tokensRead++;
                        TreeTaggerWrapper.this._lastTokenRead = token;
                        TreeTaggerWrapper.this._lastTokenReadTT = s;
                        if (TRACE) {
                            System.err.println("[" + TreeTaggerWrapper.this + "|TRACE] (" + TreeTaggerWrapper.this._tokensRead + ") IN [" + TreeTaggerWrapper.this.getText(token) + "] -- OUT: [" + s + "] -- POS: [" + posTag + "] -- LEMMA: [" + lemma + "]");
                        }
                        if (TreeTaggerWrapper.this._handler == null) continue;
                        TreeTaggerWrapper.this._handler.token(token, posTag, lemma);
                    }
                    throw new IllegalStateException("[" + TreeTaggerWrapper.this + "] Have not seen ENDOFTEXT-marker but no more " + "tokens are available.\n" + "TT returned: [" + s + "]\n" + TreeTaggerWrapper.this.getStatus());
                }
                catch (Exception e) {
                    this._exception = e;
                }
            }
            Reader reader = this;
            synchronized (reader) {
                this.notifyAll();
            }
        }

        public Exception getException() {
            return this._exception;
        }
    }

    private class StreamGobbler
    implements Runnable {
        private final InputStream in;
        private boolean done = false;

        public StreamGobbler(InputStream aIn) {
            this.in = aIn;
        }

        public void done() {
            this.done = true;
        }

        public void run() {
            try {
                while (!this.done) {
                    this.in.skip(this.in.available());
                    this.in.wait(100L);
                }
            }
            catch (Exception e) {
                this.done = true;
            }
        }
    }
}

