/*
 * Decompiled with CFR 0.152.
 */
package org.annolab.tt4j;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.annolab.tt4j.DefaultModel;
import org.annolab.tt4j.Model;
import org.annolab.tt4j.ModelResolver;
import org.annolab.tt4j.PlatformDetector;
import org.annolab.tt4j.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultModelResolver
implements ModelResolver {
    protected PlatformDetector _platform;
    protected List<String> _additionalPaths = new ArrayList<String>();
    boolean _checkExistence = true;

    public void setAdditionalPaths(List<String> aAdditionalPaths) {
        this._additionalPaths.clear();
        this._additionalPaths.addAll(aAdditionalPaths);
    }

    public PlatformDetector getPlatformDetector() {
        return this._platform;
    }

    @Override
    public Model getModel(String aModelName) throws IOException {
        String _name;
        String _encoding;
        int lastColon = aModelName.lastIndexOf(58);
        if (aModelName.length() > lastColon + 1) {
            char ch = aModelName.charAt(lastColon + 1);
            if (ch == '/' || ch == '\\') {
                lastColon = -1;
            }
            _encoding = lastColon != -1 ? aModelName.substring(lastColon + 1) : "UTF-8";
            _name = lastColon != -1 ? aModelName.substring(0, lastColon) : aModelName;
        } else {
            _encoding = "UTF-8";
            _name = aModelName.substring(0, aModelName.length() - 1);
        }
        return this.getModel(aModelName, _name, _encoding);
    }

    public Model getModel(String aModelName, String aLocation, String aEncoding) throws IOException {
        File _file = new File(aLocation);
        if (this._checkExistence && !_file.exists()) {
            boolean found = false;
            for (String p : Util.getSearchPaths(this._additionalPaths, "models")) {
                if (p == null || !(_file = new File(p + File.separator + aLocation)).exists()) continue;
                found = true;
                break;
            }
            if (!found) {
                throw new IOException("Unable to locate model [" + aLocation + "]");
            }
        }
        return new DefaultModel(aModelName, _file, aEncoding);
    }

    @Override
    public void setPlatformDetector(PlatformDetector aPlatform) {
        this._platform = aPlatform;
    }
}

