/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.suites;

import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryFactory;
import com.hp.hpl.jena.shared.PrefixMapping;
import com.hp.hpl.jena.shared.impl.PrefixMappingImpl;
import com.hp.hpl.jena.sparql.algebra.Op;
import com.hp.hpl.jena.sparql.algebra.OpAsQuery;
import com.hp.hpl.jena.sparql.sse.SSE;
import com.hp.hpl.jena.sparql.util.FmtUtils;
import com.hp.hpl.jena.sparql.util.Utils;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TestSerialization
extends TestCase {
    PrefixMapping pmap1 = new PrefixMappingImpl();

    public TestSerialization() {
        this.pmap1.setNsPrefix("", "http://default/");
        this.pmap1.setNsPrefix("ex", "http://example/x#");
        this.pmap1.setNsPrefix("x", "x:");
    }

    public static TestSuite suite() {
        TestSuite ts = new TestSuite(TestSerialization.class);
        ts.setName(Utils.classShortName(TestSerialization.class));
        return ts;
    }

    public void test_URI_1() {
        this.fmtURI_Prefix("http://elsewhere/", "<http://elsewhere/>", this.pmap1);
    }

    public void test_URI_2() {
        this.fmtURI_Prefix("http://example/", "<http://example/>", this.pmap1);
    }

    public void test_URI_3() {
        this.fmtURI_Prefix("http://default/", "<http://default/>", null);
    }

    public void test_URI_4() {
        this.fmtURI_Base("http://example/", null, "<http://example/>");
    }

    public void test_URI_5() {
        this.fmtURI_Base("http://example/x", "http://example/", "<x>");
    }

    public void test_URI_6() {
        this.fmtURI_Base("http://example/x", "http://example/ns#", "<x>");
    }

    public void test_URI_7() {
        this.fmtURI_Base("http://example/ns#x", "http://example/ns#", "<#x>");
    }

    public void test_URI_8() {
        this.fmtURI_Base("http://example/ns#x", "http://example/ns", "<#x>");
    }

    public void test_URI_9() {
        this.fmtURI_Base("http://example/x/y", "http://example/x/", "<y>");
    }

    public void test_URI_10() {
        this.fmtURI_Base("http://example/x/y", "http://example/x", "<x/y>");
    }

    public void test_URI_11() {
        this.fmtURI_Base("http://example/x/y", "http://example/", "<x/y>");
    }

    public void test_PName_1() {
        this.fmtURI_Prefix("http://example/x#abc", "ex:abc", this.pmap1);
    }

    public void test_PName_2() {
        this.fmtURI_Prefix("http://example/x#", "ex:", this.pmap1);
    }

    public void test_PName_3() {
        this.fmtURI_Prefix("http://default/x", ":x", this.pmap1);
    }

    public void test_PName_4() {
        this.fmtURI_Prefix("http://default/", ":", this.pmap1);
    }

    public void test_PName_5() {
        this.fmtURI_Prefix("http://default/0", ":0", this.pmap1);
    }

    public void test_PName_6() {
        this.fmtURI_Prefix("http://example/x#x-1", "ex:x-1", this.pmap1);
    }

    public void test_PName_Bad_1() {
        this.fmtURI_Prefix("http://other/x", "<http://other/x>", this.pmap1);
    }

    public void test_PName_Bad_2() {
        this.fmtURI_Prefix("http://other/x#a", "<http://other/x#a>", this.pmap1);
    }

    public void test_PName_Bad_3() {
        this.fmtURI_Prefix("http://example/x##", "<http://example/x##>", this.pmap1);
    }

    public void test_PName_Bad_4() {
        this.fmtURI_Prefix("http://default/x#a", "<http://default/x#a>", this.pmap1);
    }

    public void test_PName_Bad_5() {
        this.fmtURI_Prefix("http://default/#a", "<http://default/#a>", this.pmap1);
    }

    public void test_PName_Bad_6() {
        this.fmtURI_Prefix("http://example/x/a", "<http://example/x/a>", this.pmap1);
    }

    public void test_PName_Bad_7() {
        this.fmtURI_Prefix("http://example/x.", "<http://example/x.>", this.pmap1);
    }

    public void test_Dots_1() {
        this.fmtURI_Prefix("http://example/x#a.b", "ex:a.b", this.pmap1);
    }

    public void test_Dots_2() {
        this.fmtURI_Prefix("http://example/x#a.b.", "<http://example/x#a.b.>", this.pmap1);
    }

    public void test_Dots_3() {
        this.fmtURI_Prefix("http://example/x#.b", "<http://example/x#.b>", this.pmap1);
    }

    public void testQueryPattern1() {
        this.test("SELECT * { ?s ?p ?o }", "SELECT * { ?s ?p ?o }", true);
    }

    public void testQueryPattern2() {
        this.test("SELECT * { ?s ?p ?o }", "SELECT *       { ?s ?p ?o }", true);
    }

    public void testQueryComment1() {
        this.test("SELECT * { ?s ?p ?o }", "SELECT *  # Comment\n { ?s ?p ?o }", true);
    }

    public void testQuery1() {
        this.test("SELECT * { ?s ?p ?o . [] ?p ?o }", "SELECT ?x { ?s ?p ?o . [] ?p ?o }", false);
    }

    public void testQueryExpr1() {
        this.test("SELECT * { ?s ?p ?o . FILTER (?o)}", "SELECT * { ?s ?p ?o   FILTER (?o)}", true);
    }

    public void testQueryExpr2() {
        this.test("SELECT * { FILTER (?x = 3)}", "SELECT * { FILTER (?x = 3)}", true);
    }

    public void testQueryExpr3() {
        this.test("SELECT * { FILTER (?x != 3)}", "SELECT * { FILTER (?x = 3)}", false);
    }

    public void testQueryExpr4() {
        this.test("SELECT * { FILTER (?z && ?x != 3)}", "SELECT * { FILTER (?z && ?x = 3)}", false);
    }

    public void testOpToSyntax_1() {
        this.testOpToSyntax("(bgp (triple ?s ?p ?o))", "SELECT * {?s ?p ?o}");
    }

    public void testOpToSyntax_2() {
        this.testOpToSyntax("(bgp (triple ?s ?p ?o) (<urn:x> <urn:p> <urn:z>) )", "SELECT * {?s ?p ?o . <urn:x> <urn:p> <urn:z> }");
    }

    public void testOpToSyntax_3() {
        this.testOpToSyntax("(table unit)", "SELECT * {}");
    }

    public void testOpToSyntax_4() {
        this.testOpToSyntax("(leftjoin (bgp (triple ?s ?p ?o)) (bgp (triple ?a ?b ?c)))", "SELECT * { ?s ?p ?o OPTIONAL { ?a ?b ?c }}");
    }

    public void testOpToSyntax_5() {
        this.testOpToSyntax("(leftjoin (bgp (triple ?s ?p ?o)) (bgp (triple ?a ?b ?c)) (> ?z 5))", "SELECT * { ?s ?p ?o OPTIONAL { ?a ?b ?c FILTER(?z > 5) }}");
    }

    private void testOpToSyntax(String opStr, String queryString) {
        Op op = SSE.parseOp((String)opStr);
        Query queryConverted = OpAsQuery.asQuery((Op)op);
        Query queryExpected = QueryFactory.create((String)queryString);
        TestSerialization.assertEquals((Object)queryExpected, (Object)queryConverted);
    }

    private void test(String qs1, String qs2, boolean result) {
        Query q1 = null;
        Query q2 = null;
        try {
            q1 = QueryFactory.create((String)qs1);
        }
        catch (Exception ex) {
            TestSerialization.fail((String)"Building query 1");
        }
        try {
            q2 = QueryFactory.create((String)qs2);
        }
        catch (Exception ex) {
            TestSerialization.fail((String)"Building query 2");
        }
        boolean b = false;
        try {
            b = q1.equals((Object)q2);
        }
        catch (Exception ex) {
            ex.printStackTrace(System.err);
            TestSerialization.fail((String)"Evaluating .equals");
        }
        if (result) {
            TestSerialization.assertTrue((boolean)b);
        } else {
            TestSerialization.assertFalse((boolean)b);
        }
    }

    private void fmtURI_Prefix(String uriStr, String expected, PrefixMapping pmap) {
        String actual = FmtUtils.stringForURI((String)uriStr, (PrefixMapping)pmap);
        if (!expected.equals(actual)) {
            TestSerialization.fail((String)(expected + " => " + actual));
        }
    }

    private void fmtURI_Base(String uriStr, String base, String expected) {
        String actual = FmtUtils.stringForURI((String)uriStr, (String)base, null);
        if (!expected.equals(actual)) {
            TestSerialization.fail((String)(uriStr + "[" + base + "] => Got: " + actual + " Expected: " + expected));
        }
    }
}

