/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.util.iterator.test;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.util.ResourceUtils;
import com.hp.hpl.jena.vocabulary.RDFS;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import junit.framework.TestCase;

public class TestResourceUtils
extends TestCase {
    public static final String NS = "http://jena.hp.com/test#";

    public TestResourceUtils(String name) {
        super(name);
    }

    public void testMaximalLowerElements() {
        Model m = ModelFactory.createDefaultModel();
        Resource a = m.createResource("http://jena.hp.com/test#a");
        Resource b = m.createResource("http://jena.hp.com/test#b");
        Resource c = m.createResource("http://jena.hp.com/test#c");
        Resource d = m.createResource("http://jena.hp.com/test#d");
        b.addProperty(RDFS.subClassOf, (RDFNode)a);
        c.addProperty(RDFS.subClassOf, (RDFNode)a);
        d.addProperty(RDFS.subClassOf, (RDFNode)c);
        d.addProperty(RDFS.subClassOf, (RDFNode)a);
        List<Resource> abcd = Arrays.asList(a, b, c, d);
        List<Resource> bcd = Arrays.asList(b, c, d);
        List<Resource> cd = Arrays.asList(c, d);
        TestResourceUtils.assertEquals((String)"Wrong number of remaining resources", (int)1, (int)ResourceUtils.maximalLowerElements(abcd, (Property)RDFS.subClassOf, (boolean)true).size());
        TestResourceUtils.assertEquals((String)"Result should be a", (Object)a, ResourceUtils.maximalLowerElements(abcd, (Property)RDFS.subClassOf, (boolean)true).iterator().next());
        TestResourceUtils.assertEquals((String)"Wrong number of remaining resources", (int)2, (int)ResourceUtils.maximalLowerElements(bcd, (Property)RDFS.subClassOf, (boolean)true).size());
        TestResourceUtils.assertEquals((String)"Wrong number of remaining resources", (int)1, (int)ResourceUtils.maximalLowerElements(cd, (Property)RDFS.subClassOf, (boolean)true).size());
        TestResourceUtils.assertEquals((String)"Result should be a", (Object)c, ResourceUtils.maximalLowerElements(cd, (Property)RDFS.subClassOf, (boolean)true).iterator().next());
    }

    public void testRenameResource() {
        Model m = ModelFactory.createDefaultModel();
        Resource a = m.createResource("http://jena.hp.com/test#a");
        Resource b = m.createResource("http://jena.hp.com/test#b");
        Resource c = m.createResource("http://jena.hp.com/test#c");
        Resource d = m.createResource("http://jena.hp.com/test#d");
        Property p = m.createProperty(NS, "p");
        Property q = m.createProperty(NS, "q");
        a.addProperty(p, (RDFNode)b);
        a.addProperty(q, (RDFNode)c);
        d.addProperty(p, (RDFNode)a);
        d.addProperty(p, (RDFNode)b);
        Resource e = ResourceUtils.renameResource((Resource)a, (String)"http://jena.hp.com/test#e");
        TestResourceUtils.assertTrue((String)"should be no properties of a", (!a.listProperties().hasNext() ? 1 : 0) != 0);
        TestResourceUtils.assertEquals((String)"uri of a", (String)"http://jena.hp.com/test#a", (String)a.getURI());
        TestResourceUtils.assertEquals((String)"uri of e", (String)"http://jena.hp.com/test#e", (String)e.getURI());
        TestResourceUtils.assertTrue((String)"d should not have p a", (!d.hasProperty(p, (RDFNode)a) ? 1 : 0) != 0);
        TestResourceUtils.assertTrue((String)"d should have p e", (boolean)d.hasProperty(p, (RDFNode)e));
        TestResourceUtils.assertTrue((String)"e should have p b", (boolean)e.hasProperty(p, (RDFNode)b));
        TestResourceUtils.assertTrue((String)"e should have q c", (boolean)e.hasProperty(q, (RDFNode)c));
        TestResourceUtils.assertTrue((String)"d p b should be unchanged", (boolean)d.hasProperty(p, (RDFNode)b));
        Resource anon = ResourceUtils.renameResource((Resource)e, null);
        TestResourceUtils.assertTrue((String)"should be no properties of e", (!e.listProperties().hasNext() ? 1 : 0) != 0);
        TestResourceUtils.assertEquals((String)"uri of e", (String)"http://jena.hp.com/test#e", (String)e.getURI());
        TestResourceUtils.assertTrue((String)"anon", (boolean)anon.isAnon());
        TestResourceUtils.assertTrue((String)"d should not have p e", (!d.hasProperty(p, (RDFNode)e) ? 1 : 0) != 0);
        TestResourceUtils.assertTrue((String)"d should have p anon", (boolean)d.hasProperty(p, (RDFNode)anon));
        TestResourceUtils.assertTrue((String)"anon should have p b", (boolean)anon.hasProperty(p, (RDFNode)b));
        TestResourceUtils.assertTrue((String)"anon should have q c", (boolean)anon.hasProperty(q, (RDFNode)c));
        TestResourceUtils.assertTrue((String)"d p b should be unchanged", (boolean)d.hasProperty(p, (RDFNode)b));
        Resource f = m.createResource("http://jena.hp.com/test#f");
        f.addProperty(p, (RDFNode)f);
        Resource f1 = ResourceUtils.renameResource((Resource)f, (String)"http://jena.hp.com/test#f1");
        TestResourceUtils.assertFalse((String)"Should be no f statements", (boolean)m.listStatements(f, null, (RDFNode)null).hasNext());
        TestResourceUtils.assertTrue((String)"f1 has p f1", (boolean)f1.hasProperty(p, (RDFNode)f1));
    }

    public void testReachableGraphClosure() {
        Model m0 = ModelFactory.createDefaultModel();
        Resource a = m0.createResource("a");
        Resource b = m0.createResource("b");
        Resource c = m0.createResource("c");
        Resource d = m0.createResource("d");
        Property p = m0.createProperty("p");
        m0.add(a, p, (RDFNode)b);
        m0.add(a, p, (RDFNode)c);
        m0.add(b, p, (RDFNode)b);
        m0.add(b, p, (RDFNode)a);
        m0.add(d, p, (RDFNode)a);
        Model m1 = ModelFactory.createDefaultModel();
        m1.add(a, p, (RDFNode)b);
        m1.add(a, p, (RDFNode)c);
        m1.add(b, p, (RDFNode)b);
        m1.add(b, p, (RDFNode)a);
        TestResourceUtils.assertTrue((String)"m1 should be isomorphic with the reachable sub-graph from a", (boolean)m1.isIsomorphicWith(ResourceUtils.reachableClosure((Resource)a)));
    }

    public void testRemoveEquiv() {
        Model m = ModelFactory.createDefaultModel();
        Resource a = m.createResource("http://jena.hp.com/test#a");
        Resource b = m.createResource("http://jena.hp.com/test#b");
        Resource c = m.createResource("http://jena.hp.com/test#c");
        Resource d = m.createResource("http://jena.hp.com/test#d");
        Resource e = m.createResource("http://jena.hp.com/test#e");
        b.addProperty(RDFS.subClassOf, (RDFNode)a);
        a.addProperty(RDFS.subClassOf, (RDFNode)b);
        d.addProperty(RDFS.subClassOf, (RDFNode)e);
        e.addProperty(RDFS.subClassOf, (RDFNode)d);
        a.addProperty(RDFS.subClassOf, (RDFNode)a);
        b.addProperty(RDFS.subClassOf, (RDFNode)b);
        c.addProperty(RDFS.subClassOf, (RDFNode)c);
        d.addProperty(RDFS.subClassOf, (RDFNode)d);
        e.addProperty(RDFS.subClassOf, (RDFNode)e);
        List<Resource> abcde = Arrays.asList(a, b, c, d, e);
        List<Resource> ab = Arrays.asList(a, b);
        List<Resource> cde = Arrays.asList(c, d, e);
        List<Resource> abde = Arrays.asList(a, b, d, e);
        List<Resource> de = Arrays.asList(d, e);
        ArrayList<Resource> in = new ArrayList<Resource>();
        in.addAll(abcde);
        List out = null;
        TestResourceUtils.assertTrue((boolean)((Object)in).equals(abcde));
        TestResourceUtils.assertFalse((boolean)((Object)in).equals(cde));
        TestResourceUtils.assertNull(out);
        out = ResourceUtils.removeEquiv(in, (Property)RDFS.subClassOf, (Resource)a);
        TestResourceUtils.assertFalse((boolean)((Object)in).equals(abcde));
        TestResourceUtils.assertTrue((boolean)((Object)in).equals(cde));
        TestResourceUtils.assertNotNull((Object)out);
        TestResourceUtils.assertEquals((Object)out, ab);
        out = ResourceUtils.removeEquiv(in, (Property)RDFS.subClassOf, (Resource)e);
        TestResourceUtils.assertFalse((boolean)((Object)in).equals(abcde));
        TestResourceUtils.assertTrue((boolean)((Object)in).equals(Collections.singletonList(c)));
        TestResourceUtils.assertNotNull((Object)out);
        TestResourceUtils.assertEquals((Object)out, de);
    }

    public void testPartition() {
        Model m = ModelFactory.createDefaultModel();
        Resource a = m.createResource("http://jena.hp.com/test#a");
        Resource b = m.createResource("http://jena.hp.com/test#b");
        Resource c = m.createResource("http://jena.hp.com/test#c");
        Resource d = m.createResource("http://jena.hp.com/test#d");
        Resource e = m.createResource("http://jena.hp.com/test#e");
        b.addProperty(RDFS.subClassOf, (RDFNode)a);
        a.addProperty(RDFS.subClassOf, (RDFNode)b);
        d.addProperty(RDFS.subClassOf, (RDFNode)e);
        e.addProperty(RDFS.subClassOf, (RDFNode)d);
        a.addProperty(RDFS.subClassOf, (RDFNode)a);
        b.addProperty(RDFS.subClassOf, (RDFNode)b);
        c.addProperty(RDFS.subClassOf, (RDFNode)c);
        d.addProperty(RDFS.subClassOf, (RDFNode)d);
        e.addProperty(RDFS.subClassOf, (RDFNode)e);
        List<Resource> abcde = Arrays.asList(a, b, c, d, e);
        List<Resource> ab = Arrays.asList(b, a);
        List<Resource> cc = Arrays.asList(c);
        List<Resource> de = Arrays.asList(e, d);
        List partition = ResourceUtils.partition(abcde, (Property)RDFS.subClassOf);
        TestResourceUtils.assertEquals((String)"Should be 3 partitions", (int)3, (int)partition.size());
        TestResourceUtils.assertEquals((String)"First parition should be (a,b)", ab, partition.get(0));
        TestResourceUtils.assertEquals((String)"First parition should be (c)", cc, partition.get(1));
        TestResourceUtils.assertEquals((String)"First parition should be (d,e)", de, partition.get(2));
    }
}

