/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.reasoner.rulesys.test;

import com.hp.hpl.jena.graph.Factory;
import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.reasoner.FGraph;
import com.hp.hpl.jena.reasoner.Finder;
import com.hp.hpl.jena.reasoner.InfGraph;
import com.hp.hpl.jena.reasoner.Reasoner;
import com.hp.hpl.jena.reasoner.TriplePattern;
import com.hp.hpl.jena.reasoner.rulesys.BasicForwardRuleInfGraph;
import com.hp.hpl.jena.reasoner.rulesys.ForwardRuleInfGraphI;
import com.hp.hpl.jena.reasoner.rulesys.Functor;
import com.hp.hpl.jena.reasoner.rulesys.GenericRuleReasoner;
import com.hp.hpl.jena.reasoner.rulesys.Node_RuleVariable;
import com.hp.hpl.jena.reasoner.rulesys.Rule;
import com.hp.hpl.jena.reasoner.rulesys.Util;
import com.hp.hpl.jena.reasoner.rulesys.impl.BindingVector;
import com.hp.hpl.jena.reasoner.rulesys.impl.RETEClauseFilter;
import com.hp.hpl.jena.reasoner.rulesys.impl.RETEEngine;
import com.hp.hpl.jena.reasoner.rulesys.impl.RETENode;
import com.hp.hpl.jena.reasoner.rulesys.impl.RETERuleContext;
import com.hp.hpl.jena.reasoner.rulesys.impl.RETESinkNode;
import com.hp.hpl.jena.reasoner.test.TestUtil;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TestRETE
extends TestCase {
    Node_RuleVariable x = new Node_RuleVariable("x", 0);
    Node_RuleVariable y = new Node_RuleVariable("y", 1);
    Node_RuleVariable z = new Node_RuleVariable("z", 2);
    Node p = Node.createURI((String)"p");
    Node q = Node.createURI((String)"q");
    Node a = Node.createURI((String)"a");
    Node b = Node.createURI((String)"b");
    Node c = Node.createURI((String)"c");
    Node d = Node.createURI((String)"d");
    Node e = Node.createURI((String)"e");
    Node r = Node.createURI((String)"r");
    Node s = Node.createURI((String)"s");
    Node n1 = Node.createURI((String)"n1");
    Node n2 = Node.createURI((String)"n2");
    Node n3 = Node.createURI((String)"n3");
    Node n4 = Node.createURI((String)"n4");
    Node res = Node.createURI((String)"res");

    public TestRETE(String name) {
        super(name);
    }

    public static TestSuite suite() {
        return new TestSuite(TestRETE.class);
    }

    public void testClauseFilter() {
        this.doTestClauseFilter(new TriplePattern(this.a, this.p, (Node)this.x), new Triple(this.a, this.p, this.b), new Node[]{this.b, null, null});
        this.doTestClauseFilter(new TriplePattern((Node)this.x, this.p, this.b), new Triple(this.a, this.p, this.b), new Node[]{this.a, null, null});
        this.doTestClauseFilter(new TriplePattern(this.a, this.p, (Node)this.x), new Triple(this.b, this.p, this.a), null);
        this.doTestClauseFilter(new TriplePattern(this.a, this.p, (Node)this.x), new Triple(this.a, this.q, this.a), null);
        this.doTestClauseFilter(new TriplePattern((Node)this.x, this.p, (Node)this.x), new Triple(this.a, this.p, this.a), new Node[]{this.a, null, null});
        this.doTestClauseFilter(new TriplePattern((Node)this.x, this.p, (Node)this.x), new Triple(this.a, this.p, this.b), null);
        this.doTestClauseFilter(new TriplePattern(this.a, this.p, Functor.makeFunctorNode((String)"f", (Node[])new Node[]{this.x, this.c})), new Triple(this.a, this.p, this.a), null);
        this.doTestClauseFilter(new TriplePattern(this.a, this.p, (Node)this.x), new Triple(this.a, this.p, Functor.makeFunctorNode((String)"f", (Node[])new Node[]{this.b, this.c})), new Node[]{Functor.makeFunctorNode((String)"f", (Node[])new Node[]{this.b, this.c}), null, null});
        this.doTestClauseFilter(new TriplePattern(this.a, this.p, Functor.makeFunctorNode((String)"g", (Node[])new Node[]{this.x, this.c})), new Triple(this.a, this.p, Functor.makeFunctorNode((String)"f", (Node[])new Node[]{this.b, this.c})), null);
        this.doTestClauseFilter(new TriplePattern(this.a, this.p, Functor.makeFunctorNode((String)"f", (Node[])new Node[]{this.x, this.c})), new Triple(this.a, this.p, Functor.makeFunctorNode((String)"f", (Node[])new Node[]{this.b, this.c})), new Node[]{this.b, null, null});
        this.doTestClauseFilter(new TriplePattern((Node)this.x, this.p, Functor.makeFunctorNode((String)"f", (Node[])new Node[]{this.x, this.c})), new Triple(this.a, this.p, Functor.makeFunctorNode((String)"f", (Node[])new Node[]{this.a, this.c})), new Node[]{this.a, null, null});
        this.doTestClauseFilter(new TriplePattern((Node)this.x, this.p, Functor.makeFunctorNode((String)"f", (Node[])new Node[]{this.x, this.c})), new Triple(this.a, this.p, Functor.makeFunctorNode((String)"f", (Node[])new Node[]{this.b, this.c})), null);
    }

    private void doTestClauseFilter(TriplePattern pattern, Triple test, Node[] expected) {
        RETETestNode tnode = new RETETestNode();
        RETEClauseFilter cf = RETEClauseFilter.compile((TriplePattern)pattern, (int)3, new LinkedList());
        cf.setContinuation((RETESinkNode)tnode);
        cf.fire(test, true);
        if (expected == null) {
            TestRETE.assertTrue((tnode.firings == 0 ? 1 : 0) != 0);
        } else {
            TestRETE.assertTrue((tnode.firings == 1 ? 1 : 0) != 0);
            TestRETE.assertTrue((boolean)tnode.isAdd);
            TestRETE.assertEquals((Object)new BindingVector(expected), (Object)tnode.env);
        }
    }

    public void testRuleMatcher() {
        this.doRuleTest("[r1: (?a p ?b), (?b q ?c) -> (?a, q, ?c)][r2: (?a p ?b), (?b p ?c) -> (?a, p, ?c)][r3: (?a p ?a), (n1 p ?c), (n1, p, ?a) -> (?a, p, ?c)][r4: (n4 ?p ?a) -> (n4, ?a, ?p)]", new Triple[]{new Triple(this.n1, this.p, this.n2), new Triple(this.n2, this.p, this.n3), new Triple(this.n2, this.q, this.n3), new Triple(this.n4, this.p, this.n4)}, new Triple[]{new Triple(this.n1, this.p, this.n2), new Triple(this.n2, this.p, this.n3), new Triple(this.n2, this.q, this.n3), new Triple(this.n4, this.p, this.n4), new Triple(this.n1, this.p, this.n3), new Triple(this.n1, this.q, this.n3), new Triple(this.n4, this.n4, this.p)});
        this.doRuleTest("[testRule1: (n1 p ?a) -> (n2, p, ?a)][testRule2: (n1 q ?a) -> (n2, q, ?a)][testRule3: (n2 p ?a), (n2 q ?a) -> (res p ?a)][axiom1: -> (n1 p n3)]", new Triple[0], new Triple[]{new Triple(this.n1, this.p, this.n3), new Triple(this.n2, this.p, this.n3)});
        this.doRuleTest("[testRule1: (n1 p ?a) -> (n2, p, ?a)][testRule2: (n1 q ?a) -> (n2, q, ?a)][testRule3: (n2 p ?a), (n2 q ?a) -> (res p ?a)][axiom1: -> (n1 p n3)]", new Triple[]{new Triple(this.n1, this.q, this.n4), new Triple(this.n1, this.q, this.n3)}, new Triple[]{new Triple(this.n1, this.p, this.n3), new Triple(this.n2, this.p, this.n3), new Triple(this.n1, this.q, this.n4), new Triple(this.n2, this.q, this.n4), new Triple(this.n1, this.q, this.n3), new Triple(this.n2, this.q, this.n3), new Triple(this.res, this.p, this.n3)});
        this.doRuleTest("[rule1: (?x p ?y), (?x q ?y) -> remove(0)]", new Triple[]{new Triple(this.n1, this.p, Util.makeIntNode((int)1)), new Triple(this.n1, this.p, Util.makeIntNode((int)2)), new Triple(this.n1, this.q, Util.makeIntNode((int)2))}, new Triple[]{new Triple(this.n1, this.p, Util.makeIntNode((int)1)), new Triple(this.n1, this.q, Util.makeIntNode((int)2))});
    }

    private void doRuleTest(String rules, Triple[] adds, Triple[] expected) {
        List ruleList = Rule.parseRules((String)rules);
        BasicForwardRuleInfGraph infgraph = new BasicForwardRuleInfGraph(null, new ArrayList(), null, Factory.createGraphMem());
        RETEEngine engine = new RETEEngine((ForwardRuleInfGraphI)infgraph, ruleList);
        infgraph.prepare();
        engine.init(true, (Finder)new FGraph(Factory.createGraphMem()));
        for (int i = 0; i < adds.length; ++i) {
            engine.addTriple(adds[i], true);
        }
        engine.runAll();
        TestUtil.assertIteratorValues(this, infgraph.find(null, null, null), expected);
    }

    public void testRuleClone() {
        String rules = "[testRule1: (a p ?x) (b p ?x) -> (n1 p ?x) ][testRule2: (?x q ?y) -> (?x p ?y)]";
        List ruleList = Rule.parseRules((String)rules);
        Graph schema = Factory.createGraphMem();
        schema.add(new Triple(this.a, this.q, this.c));
        schema.add(new Triple(this.a, this.q, this.d));
        Graph data1 = Factory.createGraphMem();
        data1.add(new Triple(this.b, this.q, this.c));
        Graph data2 = Factory.createGraphMem();
        data2.add(new Triple(this.b, this.q, this.d));
        GenericRuleReasoner reasoner = new GenericRuleReasoner(ruleList);
        reasoner.setMode(GenericRuleReasoner.FORWARD_RETE);
        Reasoner boundReasoner = reasoner.bindSchema(schema);
        InfGraph infgraph1 = boundReasoner.bind(data1);
        InfGraph infgraph2 = boundReasoner.bind(data2);
        TestUtil.assertIteratorValues(this, infgraph1.find(null, this.p, null), new Triple[]{new Triple(this.a, this.p, this.c), new Triple(this.a, this.p, this.d), new Triple(this.b, this.p, this.c), new Triple(this.n1, this.p, this.c)});
        TestUtil.assertIteratorValues(this, infgraph2.find(null, this.p, null), new Triple[]{new Triple(this.a, this.p, this.c), new Triple(this.a, this.p, this.d), new Triple(this.b, this.p, this.d), new Triple(this.n1, this.p, this.d)});
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class RETETestNode
    implements RETESinkNode {
        BindingVector env;
        boolean isAdd;
        int firings = 0;

        protected RETETestNode() {
        }

        public void fire(BindingVector env, boolean isAdd) {
            ++this.firings;
            this.env = env;
            this.isAdd = isAdd;
        }

        public RETENode clone(Map<RETENode, RETENode> netCopy, RETERuleContext context) {
            return this;
        }
    }
}

