/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdf.arp.test;

import com.hp.hpl.jena.rdf.arp.ARPErrorNumbers;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.RDFErrorHandler;
import com.hp.hpl.jena.rdf.model.RDFReader;
import com.hp.hpl.jena.rdf.model.impl.RDFDefaultErrorHandler;
import com.hp.hpl.jena.shared.JenaException;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class ExceptionTests
extends TestCase
implements RDFErrorHandler,
ARPErrorNumbers {
    public static Test suite() {
        TestSuite suite = new TestSuite("ARP Exceptions");
        suite.addTest((Test)new ExceptionTests("testDefaultFatal"));
        suite.addTest((Test)new ExceptionTests("testDefaultError"));
        suite.addTest((Test)new ExceptionTests("testDefaultWarning"));
        suite.addTest((Test)new ExceptionTests("testDefaultDemotedFatal"));
        suite.addTest((Test)new ExceptionTests("testDefaultPromotedError"));
        suite.addTest((Test)new ExceptionTests("testDefaultPromotedWarning"));
        suite.addTest((Test)new ExceptionTests("testNonExceptionFatal"));
        suite.addTest((Test)new ExceptionTests("testExceptionError"));
        suite.addTest((Test)new ExceptionTests("testExceptionWarning"));
        return suite;
    }

    ExceptionTests(String s) {
        super(s);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDefaultFatal() {
        RDFDefaultErrorHandler.silent = true;
        try {
            Model m = ModelFactory.createDefaultModel();
            m.read("file:testing/arp/error-msgs/test06.rdf");
            ExceptionTests.fail((String)"Fatal error did not throw exception");
        }
        catch (JenaException jenaException) {
        }
        finally {
            RDFDefaultErrorHandler.silent = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDefaultError() {
        RDFDefaultErrorHandler.silent = true;
        try {
            Model m = ModelFactory.createDefaultModel();
            m.read("file:testing/wg/rdfms-abouteach/error002.rdf");
        }
        catch (JenaException e) {
            ExceptionTests.fail((String)"Error threw exception");
        }
        finally {
            RDFDefaultErrorHandler.silent = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDefaultWarning() {
        RDFDefaultErrorHandler.silent = true;
        try {
            Model m = ModelFactory.createDefaultModel();
            m.read("file:testing/arp/qname-in-ID/bug74_0.rdf");
        }
        catch (JenaException e) {
            ExceptionTests.fail((String)"Warning threw exception");
        }
        finally {
            RDFDefaultErrorHandler.silent = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDefaultDemotedFatal() {
        RDFDefaultErrorHandler.silent = true;
        try {
            Model m = ModelFactory.createDefaultModel();
            RDFReader rdr = m.getReader();
            rdr.setProperty("ERR_SAX_FATAL_ERROR", (Object)"EM_ERROR");
            rdr.read(m, "file:testing/arp/error-msgs/test06.rdf");
        }
        catch (JenaException e) {
            System.err.println(e.getMessage());
            e.printStackTrace();
            ExceptionTests.fail((String)"Demoted.error error threw an exception");
        }
        finally {
            RDFDefaultErrorHandler.silent = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDefaultPromotedError() {
        RDFDefaultErrorHandler.silent = true;
        try {
            Model m = ModelFactory.createDefaultModel();
            RDFReader rdr = m.getReader();
            rdr.setProperty("ERR_BAD_RDF_ATTRIBUTE", (Object)"EM_FATAL");
            rdr.read(m, "file:testing/wg/rdfms-abouteach/error002.rdf");
            ExceptionTests.fail((String)"Promoted error did not throw exception");
        }
        catch (JenaException jenaException) {
        }
        finally {
            RDFDefaultErrorHandler.silent = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDefaultPromotedWarning() {
        RDFDefaultErrorHandler.silent = true;
        try {
            Model m = ModelFactory.createDefaultModel();
            RDFReader rdr = m.getReader();
            rdr.setProperty("WARN_BAD_NAME", (Object)"EM_FATAL");
            rdr.read(m, "file:testing/arp/qname-in-ID/bug74_0.rdf");
            ExceptionTests.fail((String)"Promoted warning did not throw exception");
        }
        catch (JenaException jenaException) {
        }
        finally {
            RDFDefaultErrorHandler.silent = false;
        }
    }

    public void testNonExceptionFatal() {
        try {
            Model m = ModelFactory.createDefaultModel();
            RDFReader rdr = m.getReader();
            rdr.setErrorHandler((RDFErrorHandler)this);
            rdr.read(m, "file:testing/arp/error-msgs/test06.rdf");
        }
        catch (JenaException e) {
            ExceptionTests.fail((String)"Fatal error threw an exception with non-exception handler");
        }
    }

    public void testExceptionError() {
        try {
            Model m = ModelFactory.createDefaultModel();
            RDFReader rdr = m.getReader();
            rdr.setErrorHandler((RDFErrorHandler)this);
            rdr.read(m, "file:testing/wg/rdfms-abouteach/error002.rdf");
            ExceptionTests.fail((String)"Error did not throw exception with non-standard handler");
        }
        catch (JenaException jenaException) {
            // empty catch block
        }
    }

    public void testExceptionWarning() {
        try {
            Model m = ModelFactory.createDefaultModel();
            RDFReader rdr = m.getReader();
            rdr.setErrorHandler((RDFErrorHandler)this);
            rdr.read(m, "file:testing/arp/qname-in-ID/bug74_0.rdf");
            ExceptionTests.fail((String)"Warning did not throw exception with non-standard handler");
        }
        catch (JenaException jenaException) {
            // empty catch block
        }
    }

    public void warning(Exception e) {
        throw new JenaException((Throwable)e);
    }

    public void error(Exception e) {
        throw new JenaException((Throwable)e);
    }

    public void fatalError(Exception e) {
    }
}

