/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.ontology.impl.test;

import com.hp.hpl.jena.ontology.AllDifferent;
import com.hp.hpl.jena.ontology.AnnotationProperty;
import com.hp.hpl.jena.ontology.DataRange;
import com.hp.hpl.jena.ontology.DatatypeProperty;
import com.hp.hpl.jena.ontology.Individual;
import com.hp.hpl.jena.ontology.ObjectProperty;
import com.hp.hpl.jena.ontology.OntClass;
import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.OntProperty;
import com.hp.hpl.jena.ontology.OntResource;
import com.hp.hpl.jena.ontology.Ontology;
import com.hp.hpl.jena.ontology.Profile;
import com.hp.hpl.jena.ontology.ProfileException;
import com.hp.hpl.jena.ontology.impl.test.OntTestBase;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.NodeIterator;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.vocabulary.RDF;
import java.util.Iterator;
import junit.framework.TestSuite;

public class TestResource
extends OntTestBase {
    public static TestSuite suite() {
        return new TestResource("TestResource");
    }

    public TestResource(String name) {
        super(name);
    }

    public OntTestBase.OntTestCase[] getTests() {
        return new OntTestBase.OntTestCase[]{new OntTestBase.OntTestCase("OntResource.sameAs", true, false, true, false){

            public void ontTest(OntModel m) throws Exception {
                Profile prof = m.getProfile();
                OntResource a = (OntResource)m.getResource("http://jena.hpl.hp.com/testing/ontology#a").as(OntResource.class);
                OntResource b = (OntResource)m.getResource("http://jena.hpl.hp.com/testing/ontology#b").as(OntResource.class);
                OntResource c = (OntResource)m.getResource("http://jena.hpl.hp.com/testing/ontology#c").as(OntResource.class);
                a.addSameAs((Resource)b);
                1.assertEquals((String)"Cardinality should be 1", (int)1, (int)a.getCardinality(prof.SAME_AS()));
                1.assertEquals((String)"a should be sameAs b", (Object)b, (Object)a.getSameAs());
                a.addSameAs((Resource)c);
                1.assertEquals((String)"Cardinality should be 2", (int)2, (int)a.getCardinality(prof.SAME_AS()));
                this.iteratorTest((Iterator<?>)a.listSameAs(), new Object[]{b, c});
                1.assertTrue((String)"a should be the same as b", (boolean)a.isSameAs((Resource)b));
                1.assertTrue((String)"a should be the same as c", (boolean)a.isSameAs((Resource)c));
                a.setSameAs((Resource)b);
                1.assertEquals((String)"Cardinality should be 1", (int)1, (int)a.getCardinality(prof.SAME_AS()));
                1.assertEquals((String)"a should be sameAs b", (Object)b, (Object)a.getSameAs());
                a.removeSameAs((Resource)c);
                1.assertEquals((String)"Cardinality should be 1", (int)1, (int)a.getCardinality(prof.SAME_AS()));
                a.removeSameAs((Resource)b);
                1.assertEquals((String)"Cardinality should be 0", (int)0, (int)a.getCardinality(prof.SAME_AS()));
            }
        }, new OntTestBase.OntTestCase("OntResource.differentFrom", true, true, true, false){

            public void ontTest(OntModel m) throws Exception {
                Profile prof = m.getProfile();
                OntResource a = (OntResource)m.getResource("http://jena.hpl.hp.com/testing/ontology#a").as(OntResource.class);
                OntResource b = (OntResource)m.getResource("http://jena.hpl.hp.com/testing/ontology#b").as(OntResource.class);
                OntResource c = (OntResource)m.getResource("http://jena.hpl.hp.com/testing/ontology#c").as(OntResource.class);
                a.addDifferentFrom((Resource)b);
                2.assertEquals((String)"Cardinality should be 1", (int)1, (int)a.getCardinality(prof.DIFFERENT_FROM()));
                2.assertEquals((String)"a should be differentFrom b", (Object)b, (Object)a.getDifferentFrom());
                a.addDifferentFrom((Resource)c);
                2.assertEquals((String)"Cardinality should be 2", (int)2, (int)a.getCardinality(prof.DIFFERENT_FROM()));
                this.iteratorTest((Iterator<?>)a.listDifferentFrom(), new Object[]{b, c});
                2.assertTrue((String)"a should be diff from b", (boolean)a.isDifferentFrom((Resource)b));
                2.assertTrue((String)"a should be diff from c", (boolean)a.isDifferentFrom((Resource)c));
                a.setDifferentFrom((Resource)b);
                2.assertEquals((String)"Cardinality should be 1", (int)1, (int)a.getCardinality(prof.DIFFERENT_FROM()));
                2.assertEquals((String)"a should be differentFrom b", (Object)b, (Object)a.getDifferentFrom());
                a.removeDifferentFrom((Resource)c);
                2.assertEquals((String)"Cardinality should be 1", (int)1, (int)a.getCardinality(prof.DIFFERENT_FROM()));
                a.removeDifferentFrom((Resource)b);
                2.assertEquals((String)"Cardinality should be 0", (int)0, (int)a.getCardinality(prof.DIFFERENT_FROM()));
            }
        }, new OntTestBase.OntTestCase("OntResource.seeAlso", true, true, true, true){

            public void ontTest(OntModel m) throws Exception {
                Profile prof = m.getProfile();
                OntResource a = (OntResource)m.getResource("http://jena.hpl.hp.com/testing/ontology#a").as(OntResource.class);
                OntResource b = (OntResource)m.getResource("http://jena.hpl.hp.com/testing/ontology#b").as(OntResource.class);
                OntResource c = (OntResource)m.getResource("http://jena.hpl.hp.com/testing/ontology#c").as(OntResource.class);
                a.addSeeAlso((Resource)b);
                3.assertEquals((String)"Cardinality should be 1", (int)1, (int)a.getCardinality(prof.SEE_ALSO()));
                3.assertEquals((String)"a should be seeAlso b", (Object)b, (Object)a.getSeeAlso());
                a.addSeeAlso((Resource)c);
                3.assertEquals((String)"Cardinality should be 2", (int)2, (int)a.getCardinality(prof.SEE_ALSO()));
                this.iteratorTest((Iterator<?>)a.listSeeAlso(), new Object[]{b, c});
                3.assertTrue((String)"a should have seeAlso b", (boolean)a.hasSeeAlso((Resource)b));
                3.assertTrue((String)"a should have seeAlso c", (boolean)a.hasSeeAlso((Resource)c));
                a.setSeeAlso((Resource)b);
                3.assertEquals((String)"Cardinality should be 1", (int)1, (int)a.getCardinality(prof.SEE_ALSO()));
                3.assertEquals((String)"a should be seeAlso b", (Object)b, (Object)a.getSeeAlso());
                a.removeSeeAlso((Resource)c);
                3.assertEquals((String)"Cardinality should be 1", (int)1, (int)a.getCardinality(prof.SEE_ALSO()));
                a.removeSeeAlso((Resource)b);
                3.assertEquals((String)"Cardinality should be 0", (int)0, (int)a.getCardinality(prof.SEE_ALSO()));
            }
        }, new OntTestBase.OntTestCase("OntResource.isDefinedBy", true, true, true, true){

            public void ontTest(OntModel m) throws Exception {
                Profile prof = m.getProfile();
                OntResource a = (OntResource)m.getResource("http://jena.hpl.hp.com/testing/ontology#a").as(OntResource.class);
                OntResource b = (OntResource)m.getResource("http://jena.hpl.hp.com/testing/ontology#b").as(OntResource.class);
                OntResource c = (OntResource)m.getResource("http://jena.hpl.hp.com/testing/ontology#c").as(OntResource.class);
                a.addIsDefinedBy((Resource)b);
                4.assertEquals((String)"Cardinality should be 1", (int)1, (int)a.getCardinality(prof.IS_DEFINED_BY()));
                4.assertEquals((String)"a should be isDefinedBy b", (Object)b, (Object)a.getIsDefinedBy());
                a.addIsDefinedBy((Resource)c);
                4.assertEquals((String)"Cardinality should be 2", (int)2, (int)a.getCardinality(prof.IS_DEFINED_BY()));
                this.iteratorTest((Iterator<?>)a.listIsDefinedBy(), new Object[]{b, c});
                4.assertTrue((String)"a should be defined by b", (boolean)a.isDefinedBy((Resource)b));
                4.assertTrue((String)"a should be defined by c", (boolean)a.isDefinedBy((Resource)c));
                a.setIsDefinedBy((Resource)b);
                4.assertEquals((String)"Cardinality should be 1", (int)1, (int)a.getCardinality(prof.IS_DEFINED_BY()));
                4.assertEquals((String)"a should be isDefinedBy b", (Object)b, (Object)a.getIsDefinedBy());
                a.removeDefinedBy((Resource)c);
                4.assertEquals((String)"Cardinality should be 1", (int)1, (int)a.getCardinality(prof.IS_DEFINED_BY()));
                a.removeDefinedBy((Resource)b);
                4.assertEquals((String)"Cardinality should be 0", (int)0, (int)a.getCardinality(prof.IS_DEFINED_BY()));
            }
        }, new OntTestBase.OntTestCase("OntResource.versionInfo", true, true, true, false){

            public void ontTest(OntModel m) throws Exception {
                Profile prof = m.getProfile();
                OntResource a = (OntResource)m.getResource("http://jena.hpl.hp.com/testing/ontology#a").as(OntResource.class);
                a.addVersionInfo("some info");
                5.assertEquals((String)"Cardinality should be 1", (int)1, (int)a.getCardinality(prof.VERSION_INFO()));
                5.assertEquals((String)"a has wrong version info", (String)"some info", (String)a.getVersionInfo());
                a.addVersionInfo("more info");
                5.assertEquals((String)"Cardinality should be 2", (int)2, (int)a.getCardinality(prof.VERSION_INFO()));
                this.iteratorTest((Iterator<?>)a.listVersionInfo(), new Object[]{"some info", "more info"});
                5.assertTrue((String)"a should have some info", (boolean)a.hasVersionInfo("some info"));
                5.assertTrue((String)"a should have more info", (boolean)a.hasVersionInfo("more info"));
                a.setVersionInfo("new info");
                5.assertEquals((String)"Cardinality should be 1", (int)1, (int)a.getCardinality(prof.VERSION_INFO()));
                5.assertEquals((String)"a has wrong version info", (String)"new info", (String)a.getVersionInfo());
                a.removeVersionInfo("old info");
                5.assertEquals((String)"Cardinality should be 1", (int)1, (int)a.getCardinality(prof.VERSION_INFO()));
                a.removeVersionInfo("new info");
                5.assertEquals((String)"Cardinality should be 0", (int)0, (int)a.getCardinality(prof.VERSION_INFO()));
            }
        }, new OntTestBase.OntTestCase("OntResource.label.nolang", true, true, true, true){

            public void ontTest(OntModel m) throws Exception {
                Profile prof = m.getProfile();
                OntResource a = (OntResource)m.getResource("http://jena.hpl.hp.com/testing/ontology#a").as(OntResource.class);
                a.addLabel("some info", null);
                6.assertEquals((String)"Cardinality should be 1", (int)1, (int)a.getCardinality(prof.LABEL()));
                6.assertEquals((String)"a has wrong label", (String)"some info", (String)a.getLabel(null));
                a.addLabel("more info", null);
                6.assertEquals((String)"Cardinality should be 2", (int)2, (int)a.getCardinality(prof.LABEL()));
                this.iteratorTest((Iterator<?>)a.listLabels(null), new Object[]{m.createLiteral("some info"), m.createLiteral("more info")});
                6.assertTrue((String)"a should have label some info", (boolean)a.hasLabel("some info", null));
                6.assertTrue((String)"a should have label more info", (boolean)a.hasLabel("more info", null));
                a.setLabel("new info", null);
                6.assertEquals((String)"Cardinality should be 1", (int)1, (int)a.getCardinality(prof.LABEL()));
                6.assertEquals((String)"a has wrong label", (String)"new info", (String)a.getLabel(null));
                a.removeLabel("foo", null);
                6.assertEquals((String)"Cardinality should be 1", (int)1, (int)a.getCardinality(prof.LABEL()));
                a.removeLabel("new info", null);
                6.assertEquals((String)"Cardinality should be 0", (int)0, (int)a.getCardinality(prof.LABEL()));
            }
        }, new OntTestBase.OntTestCase("OntResource.label.lang", true, true, true, true){

            public void ontTest(OntModel m) throws Exception {
                OntResource a = (OntResource)m.getResource("http://jena.hpl.hp.com/testing/ontology#a").as(OntResource.class);
                a.addLabel("good", "EN");
                7.assertEquals((String)"wrong label", (String)"good", (String)a.getLabel(null));
                a.addLabel("bon", "FR");
                7.assertEquals((String)"wrong label", (String)"good", (String)a.getLabel("EN"));
                7.assertEquals((String)"wrong label", null, (String)a.getLabel("EN-GB"));
                7.assertEquals((String)"wrong label", (String)"bon", (String)a.getLabel("FR"));
                7.assertTrue((String)"a should have label good", (boolean)a.hasLabel("good", "EN"));
                7.assertTrue((String)"a should have label bon", (boolean)a.hasLabel("bon", "FR"));
                7.assertTrue((String)"a should note have label good (DE)", (!a.hasLabel("good", "DE") ? 1 : 0) != 0);
                a.addLabel("spiffing", "EN-GB");
                a.addLabel("duude", "EN-US");
                7.assertEquals((String)"wrong label", (String)"spiffing", (String)a.getLabel("EN-GB"));
                7.assertEquals((String)"wrong label", (String)"duude", (String)a.getLabel("EN-US"));
                7.assertEquals((String)"wrong label", null, (String)a.getLabel("DE"));
                a.addLabel("abcdef", "AB-CD");
                7.assertEquals((String)"wrong label", (String)"abcdef", (String)a.getLabel("AB"));
                7.assertEquals((String)"wrong label", null, (String)a.getLabel("AB-XY"));
                a.removeLabel("abcde", "AB-CD");
                7.assertEquals((String)"Cardinality should be 5", (int)5, (int)a.getCardinality(a.getProfile().LABEL()));
                a.removeLabel("abcdef", "AB-CD");
                7.assertEquals((String)"Cardinality should be 4", (int)4, (int)a.getCardinality(a.getProfile().LABEL()));
            }
        }, new OntTestBase.OntTestCase("OntResource.comment.nolang", true, true, true, true){

            public void ontTest(OntModel m) throws Exception {
                Profile prof = m.getProfile();
                OntResource a = (OntResource)m.getResource("http://jena.hpl.hp.com/testing/ontology#a").as(OntResource.class);
                a.addComment("some info", null);
                8.assertEquals((String)"Cardinality should be 1", (int)1, (int)a.getCardinality(prof.COMMENT()));
                8.assertEquals((String)"a has wrong comment", (String)"some info", (String)a.getComment(null));
                a.addComment("more info", null);
                8.assertEquals((String)"Cardinality should be 2", (int)2, (int)a.getCardinality(prof.COMMENT()));
                this.iteratorTest((Iterator<?>)a.listComments(null), new Object[]{m.createLiteral("some info"), m.createLiteral("more info")});
                8.assertTrue((String)"a should have comment some info", (boolean)a.hasComment("some info", null));
                8.assertTrue((String)"a should have comment more info", (boolean)a.hasComment("more info", null));
                a.setComment("new info", null);
                8.assertEquals((String)"Cardinality should be 1", (int)1, (int)a.getCardinality(prof.COMMENT()));
                8.assertEquals((String)"a has wrong comment", (String)"new info", (String)a.getComment(null));
                a.removeComment("foo", null);
                8.assertEquals((String)"Cardinality should be 1", (int)1, (int)a.getCardinality(prof.COMMENT()));
                a.removeComment("new info", null);
                8.assertEquals((String)"Cardinality should be 0", (int)0, (int)a.getCardinality(prof.COMMENT()));
            }
        }, new OntTestBase.OntTestCase("OntResource.comment.lang", true, true, true, true){

            public void ontTest(OntModel m) throws Exception {
                OntResource a = (OntResource)m.getResource("http://jena.hpl.hp.com/testing/ontology#a").as(OntResource.class);
                a.addComment("good", "EN");
                9.assertEquals((String)"wrong comment", (String)"good", (String)a.getComment(null));
                a.addComment("bon", "FR");
                9.assertEquals((String)"wrong comment", (String)"good", (String)a.getComment("EN"));
                9.assertEquals((String)"wrong comment", null, (String)a.getComment("EN-GB"));
                9.assertEquals((String)"wrong comment", (String)"bon", (String)a.getComment("FR"));
                9.assertTrue((String)"a should have label good", (boolean)a.hasComment("good", "EN"));
                9.assertTrue((String)"a should have label bon", (boolean)a.hasComment("bon", "FR"));
                9.assertTrue((String)"a should note have label good (DE)", (!a.hasComment("good", "DE") ? 1 : 0) != 0);
                a.addComment("spiffing", "EN-GB");
                a.addComment("duude", "EN-US");
                9.assertEquals((String)"wrong comment", (String)"spiffing", (String)a.getComment("EN-GB"));
                9.assertEquals((String)"wrong comment", (String)"duude", (String)a.getComment("EN-US"));
                9.assertEquals((String)"wrong comment", null, (String)a.getComment("DE"));
                a.addComment("abcdef", "AB-CD");
                9.assertEquals((String)"wrong comment", (String)"abcdef", (String)a.getComment("AB"));
                9.assertEquals((String)"wrong comment", null, (String)a.getComment("AB-XY"));
                a.removeComment("abcde", "AB-CD");
                9.assertEquals((String)"Cardinality should be 5", (int)5, (int)a.getCardinality(a.getProfile().COMMENT()));
                a.removeComment("abcdef", "AB-CD");
                9.assertEquals((String)"Cardinality should be 4", (int)4, (int)a.getCardinality(a.getProfile().COMMENT()));
            }
        }, new OntTestBase.OntTestCase("OntResource.type (no inference)", true, true, true, true){

            public void ontTest(OntModel m) throws Exception {
                OntClass A = m.createClass("http://jena.hpl.hp.com/testing/ontology#A");
                OntClass B = m.createClass("http://jena.hpl.hp.com/testing/ontology#B");
                A.addSubClass((Resource)B);
                OntResource a = (OntResource)m.getResource("http://jena.hpl.hp.com/testing/ontology#a").as(OntResource.class);
                10.assertEquals((String)"Cardinality of rdf:type is wrong", (int)0, (int)a.getCardinality(RDF.type));
                a.addRDFType((Resource)B);
                10.assertEquals((String)"rdf:type of a is wrong", (Object)B, (Object)a.getRDFType());
                10.assertEquals((String)"rdf:type of a is wrong", (Object)B, (Object)a.getRDFType(false));
                this.iteratorTest((Iterator<?>)a.listRDFTypes(false), new Object[]{B});
                this.iteratorTest((Iterator<?>)a.listRDFTypes(true), new Object[]{B});
                a.addRDFType((Resource)A);
                this.iteratorTest((Iterator<?>)a.listRDFTypes(false), new Object[]{A, B});
                this.iteratorTest((Iterator<?>)a.listRDFTypes(true), new Object[]{B});
                10.assertTrue((String)"a should not be of class A direct", (!a.hasRDFType((Resource)A, true) ? 1 : 0) != 0);
                10.assertTrue((String)"a should not be of class B direct", (boolean)a.hasRDFType((Resource)B, true));
                OntClass C = m.createClass("http://jena.hpl.hp.com/testing/ontology#C");
                a.setRDFType((Resource)C);
                10.assertTrue((String)"a should be of class C", (boolean)a.hasRDFType((Resource)C, false));
                10.assertTrue((String)"a should not be of class A", (!a.hasRDFType((Resource)A, false) ? 1 : 0) != 0);
                10.assertTrue((String)"a should not be of class B", (!a.hasRDFType((Resource)B, false) ? 1 : 0) != 0);
                a.removeRDFType((Resource)B);
                10.assertEquals((String)"Cardinality should be 1", (int)1, (int)a.getCardinality(RDF.type));
                a.removeRDFType((Resource)C);
                10.assertEquals((String)"Cardinality should be 0", (int)0, (int)a.getCardinality(RDF.type));
            }
        }, new OntTestBase.OntTestCase("OntResource.remove", true, true, true, true){

            public void ontTest(OntModel m) throws Exception {
                OntClass A = m.createClass("http://jena.hpl.hp.com/testing/ontology#A");
                OntClass B = m.createClass("http://jena.hpl.hp.com/testing/ontology#B");
                OntClass C = m.createClass("http://jena.hpl.hp.com/testing/ontology#C");
                OntClass D = m.createClass("http://jena.hpl.hp.com/testing/ontology#D");
                OntClass E = m.createClass("http://jena.hpl.hp.com/testing/ontology#E");
                A.addSubClass((Resource)B);
                A.addSubClass((Resource)C);
                C.addSubClass((Resource)D);
                C.addSubClass((Resource)E);
                11.assertTrue((String)"super-class of E", (boolean)E.hasSuperClass((Resource)C, false));
                this.iteratorTest((Iterator<?>)A.listSubClasses(), new Object[]{B, C});
                C.remove();
                11.assertTrue((String)"super-class of D", (!D.hasSuperClass((Resource)C, false) ? 1 : 0) != 0);
                11.assertTrue((String)"super-class of E", (!E.hasSuperClass((Resource)C, false) ? 1 : 0) != 0);
                this.iteratorTest((Iterator<?>)A.listSubClasses(), new Object[]{B});
            }
        }, new OntTestBase.OntTestCase("OntResource.asClass", true, true, true, true){

            public void ontTest(OntModel m) throws Exception {
                Resource r = m.createResource();
                r.addProperty(RDF.type, (RDFNode)m.getProfile().CLASS());
                OntResource or = (OntResource)r.as(OntResource.class);
                12.assertFalse((String)"should not be annotation prop", (boolean)or.isAnnotationProperty());
                12.assertFalse((String)"should not be all different", (boolean)or.isAllDifferent());
                12.assertTrue((String)"should be class", (boolean)or.isClass());
                12.assertFalse((String)"should not be property", (boolean)or.isProperty());
                12.assertFalse((String)"should not be object property", (boolean)or.isObjectProperty());
                12.assertFalse((String)"should not be datatype property", (boolean)or.isDatatypeProperty());
                12.assertTrue((String)"should not be individual", (this.owlFull() || !or.isIndividual() ? 1 : 0) != 0);
                12.assertFalse((String)"should not be data range", (boolean)or.isDataRange());
                12.assertFalse((String)"should not be ontology", (boolean)or.isOntology());
                OntClass n = or.asClass();
                12.assertTrue((String)"Should be OntClass", (boolean)(n instanceof OntClass));
            }
        }, new OntTestBase.OntTestCase("OntResource.asAnnotationProperty", true, true, false, false){

            public void ontTest(OntModel m) throws Exception {
                if (m.getProfile().ANNOTATION_PROPERTY() == null) {
                    throw new ProfileException(null, null);
                }
                Resource r = m.createResource();
                r.addProperty(RDF.type, (RDFNode)m.getProfile().ANNOTATION_PROPERTY());
                OntResource or = (OntResource)r.as(OntResource.class);
                13.assertTrue((String)"should be annotation prop", (boolean)or.isAnnotationProperty());
                13.assertFalse((String)"should not be all different", (boolean)or.isAllDifferent());
                13.assertFalse((String)"should not be class", (boolean)or.isClass());
                13.assertTrue((String)"should be property", (boolean)or.isProperty());
                13.assertFalse((String)"should not be object property", (boolean)or.isObjectProperty());
                13.assertFalse((String)"should not be datatype property", (boolean)or.isDatatypeProperty());
                13.assertFalse((String)"should not be individual", (boolean)or.isIndividual());
                13.assertFalse((String)"should not be data range", (boolean)or.isDataRange());
                13.assertFalse((String)"should not be ontology", (boolean)or.isOntology());
                AnnotationProperty n = or.asAnnotationProperty();
                13.assertTrue((String)"Should be AnnotationProperty", (boolean)(n instanceof AnnotationProperty));
            }
        }, new OntTestBase.OntTestCase("OntResource.asObjectProperty", true, true, true, false){

            public void ontTest(OntModel m) throws Exception {
                if (m.getProfile().OBJECT_PROPERTY() == null) {
                    throw new ProfileException(null, null);
                }
                Resource r = m.createResource();
                r.addProperty(RDF.type, (RDFNode)m.getProfile().OBJECT_PROPERTY());
                OntResource or = (OntResource)r.as(OntResource.class);
                14.assertFalse((String)"should not be annotation prop", (boolean)or.isAnnotationProperty());
                14.assertFalse((String)"should not be all different", (boolean)or.isAllDifferent());
                14.assertFalse((String)"should not be class", (boolean)or.isClass());
                14.assertTrue((String)"should be property", (boolean)or.isProperty());
                14.assertTrue((String)"should be object property", (boolean)or.isObjectProperty());
                14.assertFalse((String)"should not be datatype property", (boolean)or.isDatatypeProperty());
                14.assertFalse((String)"should not be individual", (boolean)or.isIndividual());
                14.assertFalse((String)"should not be data range", (boolean)or.isDataRange());
                14.assertFalse((String)"should not be ontology", (boolean)or.isOntology());
                ObjectProperty n = or.asObjectProperty();
                14.assertTrue((String)"Should be ObjectProperty", (boolean)(n instanceof ObjectProperty));
            }
        }, new OntTestBase.OntTestCase("OntResource.asDatatypeProperty", true, true, true, false){

            public void ontTest(OntModel m) throws Exception {
                if (m.getProfile().DATATYPE_PROPERTY() == null) {
                    throw new ProfileException(null, null);
                }
                Resource r = m.createResource();
                r.addProperty(RDF.type, (RDFNode)m.getProfile().DATATYPE_PROPERTY());
                OntResource or = (OntResource)r.as(OntResource.class);
                15.assertFalse((String)"should not be annotation prop", (boolean)or.isAnnotationProperty());
                15.assertFalse((String)"should not be all different", (boolean)or.isAllDifferent());
                15.assertFalse((String)"should not be class", (boolean)or.isClass());
                15.assertTrue((String)"should be property", (boolean)or.isProperty());
                15.assertFalse((String)"should not be object property", (boolean)or.isObjectProperty());
                15.assertTrue((String)"should be datatype property", (boolean)or.isDatatypeProperty());
                15.assertFalse((String)"should not be individual", (boolean)or.isIndividual());
                15.assertFalse((String)"should not be data range", (boolean)or.isDataRange());
                15.assertFalse((String)"should not be ontology", (boolean)or.isOntology());
                DatatypeProperty n = or.asDatatypeProperty();
                15.assertTrue((String)"Should be DatatypeProperty", (boolean)(n instanceof DatatypeProperty));
            }
        }, new OntTestBase.OntTestCase("OntResource.asAllDifferent", true, true, false, false){

            public void ontTest(OntModel m) throws Exception {
                if (m.getProfile().ALL_DIFFERENT() == null) {
                    throw new ProfileException(null, null);
                }
                Resource r = m.createResource();
                r.addProperty(RDF.type, (RDFNode)m.getProfile().ALL_DIFFERENT());
                OntResource or = (OntResource)r.as(OntResource.class);
                16.assertFalse((String)"should not be annotation prop", (boolean)or.isAnnotationProperty());
                16.assertTrue((String)"should be all different", (boolean)or.isAllDifferent());
                16.assertFalse((String)"should not be class", (boolean)or.isClass());
                16.assertFalse((String)"should not be property", (boolean)or.isProperty());
                16.assertFalse((String)"should not be object property", (boolean)or.isObjectProperty());
                16.assertFalse((String)"should not be datatype property", (boolean)or.isDatatypeProperty());
                16.assertFalse((String)"should not be individual", (boolean)or.isIndividual());
                16.assertFalse((String)"should not be data range", (boolean)or.isDataRange());
                16.assertFalse((String)"should not be ontology", (boolean)or.isOntology());
                AllDifferent n = or.asAllDifferent();
                16.assertTrue((String)"Should be AnnotationProperty", (boolean)(n instanceof AllDifferent));
            }
        }, new OntTestBase.OntTestCase("OntResource.asProperty", true, true, true, true){

            public void ontTest(OntModel m) throws Exception {
                Resource r = m.createResource();
                r.addProperty(RDF.type, (RDFNode)m.getProfile().PROPERTY());
                OntResource or = (OntResource)r.as(OntResource.class);
                17.assertFalse((String)"should not be annotation prop", (boolean)or.isAnnotationProperty());
                17.assertFalse((String)"should not be all different", (boolean)or.isAllDifferent());
                17.assertFalse((String)"should not be class", (boolean)or.isClass());
                17.assertTrue((String)"should be property", (boolean)or.isProperty());
                17.assertFalse((String)"should not be object property", (boolean)or.isObjectProperty());
                17.assertFalse((String)"should not be datatype property", (boolean)or.isDatatypeProperty());
                17.assertFalse((String)"should not be individual", (boolean)or.isIndividual());
                17.assertFalse((String)"should not be data range", (boolean)or.isDataRange());
                17.assertFalse((String)"should not be ontology", (boolean)or.isOntology());
                OntProperty n = or.asProperty();
                17.assertTrue((String)"Should be OntProperty", (boolean)(n instanceof OntProperty));
            }
        }, new OntTestBase.OntTestCase("OntResource.asIndividual", true, true, true, true){

            public void ontTest(OntModel m) throws Exception {
                Resource r = m.createResource();
                Resource s = m.createResource();
                s.addProperty(RDF.type, (RDFNode)m.getProfile().CLASS());
                r.addProperty(RDF.type, (RDFNode)s);
                OntResource or = (OntResource)r.as(OntResource.class);
                18.assertFalse((String)"should not be annotation prop", (boolean)or.isAnnotationProperty());
                18.assertFalse((String)"should not be all different", (boolean)or.isAllDifferent());
                18.assertFalse((String)"should not be class", (boolean)or.isClass());
                18.assertFalse((String)"should not be property", (boolean)or.isProperty());
                18.assertFalse((String)"should not be object property", (boolean)or.isObjectProperty());
                18.assertFalse((String)"should not be datatype property", (boolean)or.isDatatypeProperty());
                18.assertTrue((String)"should be individual", (boolean)or.isIndividual());
                18.assertFalse((String)"should not be data range", (boolean)or.isDataRange());
                18.assertFalse((String)"should not be ontology", (boolean)or.isOntology());
                Individual n = or.asIndividual();
                18.assertTrue((String)"Should be individual", (boolean)(n instanceof Individual));
            }
        }, new OntTestBase.OntTestCase("OntResource.asDataRange", true, false, false, false){

            public void ontTest(OntModel m) throws Exception {
                if (m.getProfile().DATARANGE() == null) {
                    throw new ProfileException(null, null);
                }
                Resource r = m.createResource();
                r.addProperty(RDF.type, (RDFNode)m.getProfile().DATARANGE());
                OntResource or = (OntResource)r.as(OntResource.class);
                19.assertFalse((String)"should not be annotation prop", (boolean)or.isAnnotationProperty());
                19.assertFalse((String)"should not be all different", (boolean)or.isAllDifferent());
                19.assertFalse((String)"should not be class", (boolean)or.isClass());
                19.assertFalse((String)"should not be property", (boolean)or.isProperty());
                19.assertFalse((String)"should not be object property", (boolean)or.isObjectProperty());
                19.assertFalse((String)"should not be datatype property", (boolean)or.isDatatypeProperty());
                19.assertFalse((String)"should not be individual", (boolean)or.isIndividual());
                19.assertTrue((String)"should be data range", (boolean)or.isDataRange());
                19.assertFalse((String)"should not be ontology", (boolean)or.isOntology());
                DataRange n = or.asDataRange();
                19.assertTrue((String)"Should be DataRange", (boolean)(n instanceof DataRange));
            }
        }, new OntTestBase.OntTestCase("OntResource.asOntology", true, true, true, false){

            public void ontTest(OntModel m) throws Exception {
                if (m.getProfile().ONTOLOGY() == null) {
                    throw new ProfileException(null, null);
                }
                Resource r = m.createResource();
                r.addProperty(RDF.type, (RDFNode)m.getProfile().ONTOLOGY());
                OntResource or = (OntResource)r.as(OntResource.class);
                20.assertFalse((String)"should not be annotation prop", (boolean)or.isAnnotationProperty());
                20.assertFalse((String)"should not be all different", (boolean)or.isAllDifferent());
                20.assertFalse((String)"should not be class", (boolean)or.isClass());
                20.assertFalse((String)"should not be property", (boolean)or.isProperty());
                20.assertFalse((String)"should not be object property", (boolean)or.isObjectProperty());
                20.assertFalse((String)"should not be datatype property", (boolean)or.isDatatypeProperty());
                20.assertFalse((String)"should not be individual", (boolean)or.isIndividual());
                20.assertFalse((String)"should not be data range", (boolean)or.isDataRange());
                20.assertTrue((String)"should be ontology", (boolean)or.isOntology());
                Ontology n = or.asOntology();
                20.assertTrue((String)"Should be Ontology", (boolean)(n instanceof Ontology));
            }
        }, new OntTestBase.OntTestCase("OntResource.isLanguageTerm", true, true, true, true){

            public void ontTest(OntModel m) throws Exception {
                OntResource or = (OntResource)m.getProfile().CLASS().inModel((Model)m).as(OntResource.class);
                21.assertTrue((String)"should be a lang term", (boolean)or.isOntLanguageTerm());
                or = m.createOntResource("http://foo/bar");
                21.assertFalse((String)"should not be a lang term", (boolean)or.isOntLanguageTerm());
            }
        }, new OntTestBase.OntTestCase("OntResource.getOntModel", true, true, true, true){

            public void ontTest(OntModel m) throws Exception {
                OntResource or = m.createOntResource("http://foo/bar");
                OntModel m0 = or.getOntModel();
                22.assertEquals((Object)m, (Object)m0);
            }
        }, new OntTestBase.OntTestCase("OntResource.getPropertyValue - object prop", true, true, true, true){

            public void ontTest(OntModel m) throws Exception {
                OntResource a = m.createOntResource("http://foo/bar#a");
                Resource b = m.createResource("http://foo/bar#b");
                OntProperty p = m.createOntProperty("http://foo/bar#p");
                m.add((Resource)a, (Property)p, (RDFNode)b);
                RDFNode bb = a.getPropertyValue((Property)p);
                23.assertEquals((Object)b, (Object)bb);
                23.assertTrue((String)"Return value should be an OntResource", (boolean)(bb instanceof OntResource));
            }
        }, new OntTestBase.OntTestCase("OntResource.getPropertyValue - missing prop", true, true, true, true){

            public void ontTest(OntModel m) throws Exception {
                OntResource a = m.createOntResource("http://foo/bar#a");
                Resource b = m.createResource("http://foo/bar#b");
                OntProperty p = m.createOntProperty("http://foo/bar#p");
                OntProperty q = m.createOntProperty("http://foo/bar#q");
                m.add((Resource)a, (Property)p, (RDFNode)b);
                RDFNode bb = a.getPropertyValue((Property)q);
                24.assertNull((Object)bb);
            }
        }, new OntTestBase.OntTestCase("OntResource.listPropertyValues - object prop", true, true, true, true){

            public void ontTest(OntModel m) throws Exception {
                OntResource a = m.createOntResource("http://foo/bar#a");
                Resource b = m.createResource("http://foo/bar#b");
                OntProperty p = m.createOntProperty("http://foo/bar#p");
                Literal l = m.createTypedLiteral(false);
                m.add((Resource)a, (Property)p, (RDFNode)b);
                m.add((Resource)a, (Property)p, (RDFNode)l);
                NodeIterator ni = a.listPropertyValues((Property)p);
                while (ni.hasNext()) {
                    RDFNode n = ni.nextNode();
                    if (!n.isResource()) continue;
                    25.assertEquals((Object)b, (Object)n);
                    25.assertTrue((String)"Return value should be an OntResource", (boolean)(n instanceof OntResource));
                }
            }
        }};
    }
}

