/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.mem.test;

import com.hp.hpl.jena.graph.Factory;
import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.test.GraphTestBase;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;

public class TestStoreSpeed
extends GraphTestBase {
    private long began;
    static final int COUNT = 100000;

    public TestStoreSpeed(String name) {
        super(name);
    }

    public static void main(String[] args) {
        new TestStoreSpeed("vladimir taltos").gonzales("subject StoreMem", Factory.createGraphMem());
        new TestStoreSpeed("vladimir taltos").gonzales("normal StoreMem", Factory.createGraphMem());
        new TestStoreSpeed("vladimir taltos").gonzales("GraphMem", Factory.createGraphMem());
        new TestStoreSpeed("vladimir taltos").gonzales("subject StoreMem", Factory.createGraphMem());
        new TestStoreSpeed("vladimir taltos").gonzales("normal StoreMem", Factory.createGraphMem());
        new TestStoreSpeed("vladimir taltos").gonzales("GraphMem", Factory.createGraphMem());
        new TestStoreSpeed("vladimir taltos").gonzales("subject StoreMem", Factory.createGraphMem());
        new TestStoreSpeed("vladimir taltos").gonzales("normal StoreMem", Factory.createGraphMem());
        new TestStoreSpeed("vladimir taltos").gonzales("GraphMem", Factory.createGraphMem());
    }

    private void mark() {
        this.began = System.currentTimeMillis();
    }

    private Triple newt(int i) {
        return new Triple(TestStoreSpeed.node("s" + i % 1000), TestStoreSpeed.node("p" + (i + 11) % 20), TestStoreSpeed.node("s" + (i + 131) % 1001));
    }

    private void makeTriples() {
        for (int i = 0; i < 100000; ++i) {
            this.newt(i);
        }
    }

    private void fillGraph(Graph g) {
        for (int i = 0; i < 100000; ++i) {
            g.add(this.newt(i));
        }
    }

    private long ticktock(String title) {
        long ticks = System.currentTimeMillis() - this.began;
        System.err.println("+ " + title + " took: " + ticks + "ms.");
        this.mark();
        return ticks;
    }

    private void consumeAll(Graph g) {
        int count = 0;
        ExtendedIterator it = g.find(TestStoreSpeed.node("s500"), null, null);
        while (it.hasNext()) {
            it.next();
            ++count;
        }
    }

    private void gonzales(String title, Graph g) {
        System.err.println("");
        System.err.println("| gonzales: " + title);
        this.mark();
        this.makeTriples();
        this.ticktock("generating triples");
        this.makeTriples();
        this.ticktock("generating triples again");
        this.makeTriples();
        long gen = this.ticktock("generating triples yet again");
        this.fillGraph(g);
        long fill = this.ticktock("filling graph");
        System.err.println("> insertion time: " + (fill - gen));
        this.fillGraph(g);
        this.ticktock("adding the same triples again");
        this.consumeAll(g);
        this.ticktock("counting s500 triples");
        this.consumeAll(g);
        this.ticktock("counting s500 triples again");
        this.consumeAll(g);
        this.ticktock("counting s500 triples yet again");
    }
}

